package com.js.pay.service.chinapnr.example.pay;

import com.js.common.constant.CommonConstant;
import com.js.common.model.req.ChinaPNRSubstituteDetails;
import com.js.common.model.req.ChinaPNRSubstituteQueryReq;
import com.js.common.model.req.ChinaPNRSubstituteReq;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import com.js.pay.service.chinapnr.example.ChinaPnrConfigure;
import com.js.pay.service.chinapnr.example.DateUtils;
import com.js.pay.service.chinapnr.example.utils.SignatureUtil;
import com.js.pay.service.chinapnr.example.utils.XMLSecurityProcess;
import com.js.pay.service.chinapnr.example.utils.XMLUtil;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import common.util.httpclient.HttpRequestContext;
import common.util.httpclient.HttpSendResult;
import common.util.httpclient.impl.HttpClientServiceImpl;
import common.util.httpclient.impl.SimpleHttpsClientImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 汇付国际旧版本的代发功能 - 完成 提现 汇差 还款服务费功能
 */
@Slf4j
@Component
public class ChinaPNROldSubstitute {

    /**
     * 汇付配置文件
     */
     @Autowired
     private ChinaPnrConfigure chinaPnrConfigure ;
    /**
     * 代发
     * @param req
     * @return
     */
    public Map<String,String> substitute(ChinaPNRSubstituteReq req){

        Map<String , String>  resMap = new HashMap<>();
        Map<String , String>  parameter = ChinaPNRCommons.getTable(chinaPnrConfigure);
        parameter.put("TRXTYPE",chinaPnrConfigure.getTrxtypeDf()); //交易类别

        parameter.put("BATCH_NO",req.getBatchNo());
        parameter.put("REQTIME", DateUtils.LONG_DATE_FORMAT_SSS.format(new Date()));
        parameter.put("PAY_CUR",req.getPayCur());
        parameter.put("PAY_TCNT", req.getPayTCnt() + "");
        parameter.put("PAY_TAMT",req.getPayTAmt().toPlainString());

        parameter.put("PURPOSE","代发");
        parameter.put("EXT1","EXT1");
        parameter.put("EXT2","EXT1");
        parameter.put("RESULT_URL", chinaPnrConfigure.getOldResultUrl());

        StringBuilder detailsStr = new StringBuilder();
        List<ChinaPNRSubstituteDetails> detailsList = req.getDetailsList();
        int detailSize = detailsList.size(); //大小
        //明细
        for(int i = 0 ; i < detailSize ; i++){

            ChinaPNRSubstituteDetails details = detailsList.get(i);
            detailsStr.append(details.getSubstituteDetailId())
                    .append("|")
                    .append(details.getSubstituteDetailAmt())
                    .append("|")
                    .append(details.getReceivablesBankCode())
                    .append("|")
                    .append(details.getReceivablesAccType())
                    .append("|")
                    .append(details.getAccountNumbe())
                    .append("|")
                    .append(details.getAccountName())
                    .append("|")
                    .append(details.getDocumentType())
                    .append("|")
                    .append(details.getIdentificationNumber())
                    .append("|")
                    .append(details.getProvince())
                    .append("|")
                    .append(details.getRegion())
                    .append("|")
                    .append(details.getBranchName())
                    .append("|")
                    .append(details.getPurpose())
                    .append("|")
                    .append("T" + chinaPnrConfigure.getTrxtypeDfcx())
                    .append("|")
                    .append("ext1")
                    .append("|")
                    .append("ext2");
            if(detailSize > i + 1){
                detailsStr.append("\r\n");
            }

        }
        parameter.put("DETAILS",detailsStr.toString());

        HttpSendResult result = ChinaPNRCommons.getSubstituteXml(parameter,chinaPnrConfigure.getPosturl(),chinaPnrConfigure.getTrxtypeDf(),chinaPnrConfigure);
        //0001失败0004成功
        if (null ==  result) {
            resMap.put("code", CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","网关系统异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","网关系统异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }
        String respTxt = result.getResponseBody();
        //返回验签
        Document resDoc = null;
        boolean veryfyResult = false;
        try{
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(respTxt.getBytes("UTF-8"))));
            // 解析XML文档
            resDoc = parser.getDocument();
            log.info("旧版代发返回验签结果:");
            veryfyResult = XMLSecurityProcess.veryfySignature(resDoc,chinaPnrConfigure.getChinapnrCer());


        }catch (Exception e){
            log.error("汇付旧版代发返回信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付旧版代发返回信息验签异常");
            return resMap;
        }

        if(!veryfyResult){
            log.info("汇付旧版代发返回信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付旧版代发返回信息验签失败");
            return resMap;
        }

        resMap.put("reqText",parameter.toString());
        resMap.put("resText",respTxt);
        //Document resDoc = ChinaPNRCommons.StringTOXml(respTxt);
        String nodePath = "/RESPONSE/PARAMS/STATUS";
        String nodeValue = ChinaPNRCommons.getNodeValue(resDoc, nodePath);
        if(!nodeValue.equals("1")){
            String msgNodePath = "/RESPONSE/PARAMS/ERRERMSG";
            String msgNodeValue = ChinaPNRCommons.getNodeValue(resDoc, msgNodePath);
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg",msgNodeValue);
            return resMap;
        }
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        resMap.put("msg","成功");
        return resMap;
    }

    /**
     * 代发单笔交易查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    public Map<String,String> substituteQuery(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq){

        Map<String , String>  resMap = new HashMap<>();
        Map<String , String>  parameter = ChinaPNRCommons.getTable(chinaPnrConfigure);
        parameter.put("TRXTYPE", chinaPnrConfigure.getTrxtypeDfcx()); //交易类别
        parameter.put("BATCH_NO",chinaPNRSubstituteQueryReq.getBatchNo());
        parameter.put("REMIT_REQ_ID",chinaPNRSubstituteQueryReq.getRemitNo());
        parameter.put("APPLY_DATE",chinaPNRSubstituteQueryReq.getApplyDate());

        HttpSendResult result = ChinaPNRCommons.getSubstituteXml(parameter,
                chinaPnrConfigure.getQueryurl(),
                chinaPnrConfigure.getTrxtypeDfcx(),chinaPnrConfigure);
        //0001失败0004成功
        if (result == null) {
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","查询-网关系统异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","查询-网关系统异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }
        String respTxt = result.getResponseBody();

        //返回验签
        Document resDoc = null;
        boolean veryfyResult = false;
        try{
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(respTxt.getBytes("UTF-8"))));
            // 解析XML文档
            resDoc = parser.getDocument();
            veryfyResult = XMLSecurityProcess.veryfySignature(resDoc,chinaPnrConfigure.getChinapnrCer());

        }catch (Exception e){
            log.error("查询汇付旧版代发返回信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","查询汇付旧版代发返回信息验签异常");
            return resMap;
        }

        if(!veryfyResult){
            log.info("查询汇付旧版代发返回信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","查询汇付旧版代发返回信息验签失败");
            return resMap;
        }

        String nodePath = "/RESPONSE/PARAMS/STATUS";
        String nodeValue = ChinaPNRCommons.getNodeValue(resDoc, nodePath);
        String codeNodePath = "/RESPONSE/PARAMS/ERRERCODE";
        //String codeNodeValue = ChinaPNRCommons.getNodeValue(resDoc, codeNodePath);
        String msgNodePath = "/RESPONSE/PARAMS/ERRERMSG";
        String msgNodeValue = ChinaPNRCommons.getNodeValue(resDoc, msgNodePath);
        String amtNodePath = "/RESPONSE/PARAMS/AMT";
        String amtNodeValue = ChinaPNRCommons.getNodeValue(resDoc, amtNodePath);
        resMap.put("status",nodeValue);
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        resMap.put("msg",msgNodeValue);
        resMap.put("amt",amtNodeValue);
        return resMap;
    }

    /**
     * 代发回调
     * @return
     */
    public Map<String,String> substituteCallback(String wholeStr){

        Map<String , String>  resMap = new HashMap<>();
        boolean veryfyResult = false;
        Document resDoc = null;
        try{
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(wholeStr.getBytes("UTF-8"))));
            // 解析XML文档
            resDoc = parser.getDocument();
            veryfyResult = XMLSecurityProcess.veryfySignature(resDoc,chinaPnrConfigure.getChinapnrCer());
        }catch (Exception e){
            log.error("回调汇付旧版代发返回信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","回调汇付旧版代发返回信息验签异常");
            return resMap;
        }

        if(!veryfyResult){
            log.info("回调汇付旧版代发返回信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","回调汇付旧版代发返回信息验签失败");
            return resMap;
        }
        String nodePath = "/NOTIFY/PARAMS/STATUS";
        String nodeValue = ChinaPNRCommons.getNodeValue(resDoc, nodePath);
        String nodePathBatchNo = "/NOTIFY/PARAMS/BATCH_NO";
        String nodeValueBatchNo = ChinaPNRCommons.getNodeValue(resDoc, nodePathBatchNo);
        String nodePathDetails = "/NOTIFY/PARAMS/DETAILS";
        String nodeValueDetails = ChinaPNRCommons.getNodeValue(resDoc, nodePathDetails);
        resMap.put("status",nodeValue);
        resMap.put("resText",wholeStr);
        resMap.put("batchNo",nodeValueBatchNo);
        resMap.put("details",nodeValueDetails);
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        resMap.put("msg","汇付旧版回调代发成功");
        return resMap;
    }
}
