package com.js.pay.service.chinapnr.example;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.js.pay.service.chinapnr.example.otherutils.ServletUtils;
import com.js.pay.service.chinapnr.example.otherutils.XMLSecurityProcess;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * Servlet implementation class ReceiveNotifyServlet
 */
public class BgNotifyServlet extends HttpServlet {
	
	
	private static final long serialVersionUID = 1L;

	private static String chinapnrPfxUrl = "d:/fct/";
	private static String chinapnrPfx = "d:/fct/10006050001.pfx";
	private static String chinapnrCer = "D:/fct/ChinaPnR.rsa.cer";
	
	public static final String SIGNATUREPARAMS = "merchantAcctId,terminalId,version,payType,bankId,"
			+ "orderId,orderTime,orderCurrency,orderAmount,dealId,bankDealId,dealTime,"
			+ "ext1,ext2,payResult,errCode";
    private static String RESP_MSG ="<result>1</result>";
	/**
     * @see HttpServlet#HttpServlet()
     */
    public BgNotifyServlet() {
        super();
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doPost(request, response);
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		Map<String,Object> map = ServletUtils.getRequestParameters(request);
		System.out.println("==================================================");
		
		System.out.println("bg params:" + request.getRequestURI());
				
		
		String dataReceived = "";
		List<String> keyList = new ArrayList<String>();
		Set<String> set = map.keySet();
		for(String key:set){
			if(SIGNATUREPARAMS.indexOf(key)>=0 && map.get(key)!= null && !StringUtils.isEmpty((String)map.get(key))){
				keyList.add(key);
			}
		}
		Collections.sort(keyList);
		for(String key:keyList){
			dataReceived = appendParam(dataReceived,key,(String)map.get(key));
		}
		System.out.println("bg dataReceived:"+dataReceived);
		String signMsg = (String)
				map.get("signMsg");
		System.err.println("signMsg==="+signMsg);
		boolean veryfyResult=false;
		try {
			//BG通知未转义，需要先转义
			veryfyResult = XMLSecurityProcess.veryfySignature(dataReceived, URLDecoder.decode(signMsg),chinapnrCer);
			//veryfyResult = XMLSecurityProcess.veryfySignature(dataReceived, signMsg);
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println(veryfyResult);
		if (veryfyResult) {
			response.getWriter().print(RESP_MSG);
		}
	}
	
	public String appendParam(String returns, String paramId, String paramValue) {
		if (returns != "") {
			if (paramValue != "") {

				returns += "&" + paramId + "=" + paramValue;
			}

		} else {

			if (paramValue != "") {
				returns = paramId + "=" + paramValue;
			}
		}

		return returns;
	}

	public static void main(String [] args){

        //异步
        String test = "merchantAcctId=1000605000101&platformUserId=223456762&requestId=F123010121111362&requestTime=20190627114334&result=00&signType=4&userId=30000129&version=1&signMsg=jax0nELNTVlqkPOr+6VlRZz7oTdCsDwmRpc1UKvYYMLnKmUnGM60MUA1JK7VEic/MPevGIOswQg4jpElXMZOSTZruQwSL7cY5++Nq/Bdi4JTKjoTAHJPoQ+GwN+7LwDXh5idarSpN/drEnPsHBMTNCte+MtbPOaX8Par4eQkkpg=";

        //同步
       // String test = "merchantAcctId=1000605000101&platformUserId=923456713&requestId=M023010121111295&requestTime=20190614155601&result=01&signMsg=ISSkDcvzP%2FlhaNNq2YPHGAZhAGeyp%2F3S0meGjHQdKUy2CrUxfs1NeyleSRVuA4ollkLCn7FkDLGjHlG%2BRqqB4CEDseM7ynNdnPyY2iLu%2BUUH8byInuhCFzPWzf7iG6MLzTyMuxah10MBY09ZFO5HnPDDOYVp%2BXfmgLXwdvisEPM%3D&signType=4&userId=30000121&version=1";

//        Map<String,String> callbackMap = ChinaPNRCommons.getCallbackMap(test);
//        System.out.println("callbackMap = "  + callbackMap);
//
//        //验签
        String callbackSignMsgVal ="merchantAcctId=1000605000101&platformUserId=223456780&requestId=F12301012111134480&requestTime=20190701104607&result=00&signType=4&userId=30000132&version=1";
        System.out.println("个人开户回调参数验签=" + callbackSignMsgVal);
        String callbackSignMsg = "vIKj/eoyT+YSsDbn3Xx0FGLKr4JE5cy1BzPX6LsmjaOLGAhQzn6im9S6KOoJQcp4IUij3odGNucZ7GQbnjkRPyl6Tx0jzG6iKZMuGEC7UmN26qeCen2oNn6HU2jWsIKkTHWErnyWnD4aprfQzuv+brDSKWdg7eMF9he9Zec+r1A=";
        System.out.println("个人开户回调签名=" + callbackSignMsg);

        boolean veryfyResult=false;

        try {
            //BG通知未转义，需要先转义
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, callbackSignMsg,chinapnrCer);
        } catch (Exception e) {
             e.printStackTrace();
        }

        System.out.println("veryfyResult = " + veryfyResult);

    }
	
}
