package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiJsTradeService;
import com.js.common.constant.Constant;
import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.JsTradeVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsTradeMapper;
import com.js.dal.dao.model.ChinaPnrTransactionDetail;
import com.js.dal.dao.model.JsTrade;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiJsTradeServiceImpl extends IBaseServiceImpl<JsTrade> implements ApiJsTradeService {

//    @Autowired
//    private JsTradeMapper jsTradeMapper;

    @Override
    public ResponseMessage addTradeRecord(JsTradeVO jsTradeVO) {
        JsTrade jsTrade = new JsTrade();
        try {
            BeanUtils.copyProperties(jsTradeVO,jsTrade);
            jsTrade.setCreateId(jsTradeVO.getKycNaturalId());
            insertSelective(jsTrade);
        }catch (Exception e){
            e.printStackTrace();
            log.error(e.getMessage());
            return ResultUtil.error(ResultEnum.UPDATE_ERROR );
        }
        return ResultUtil.success(jsTrade.getId());
    }

    @Override
    public ResponseMessage updateTradeRecord( List<String> ids,String status) {
        JsTrade jsTrade = new JsTrade();
        try {
            Example example = new Example(JsTrade.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andIn("tradeNo", ids);
            jsTrade.setProcessStatus(status);
            updateByExampleSelective(jsTrade, example);
        }catch (Exception e){
            e.printStackTrace();
            log.error(e.getMessage());
            return ResultUtil.error(ResultEnum.UPDATE_ERROR );
        }
        return  ResultUtil.success(ResultEnum.UPDATE_SUCCESS);
    }
}
