package com.js.pay.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiJsSystemHolidaysService;
import com.js.common.constant.Constant;
import com.js.common.enums.HolType;
import com.js.common.model.req.JsSystemHolidayReq;
import com.js.common.model.vo.JsSystemHolidayVO;
import com.js.dal.dao.model.JsSystemHoliday;
import com.js.dal.dao.plugin.PageModel;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiJsSystemHolidaysServiceImpl extends IBaseServiceImpl<JsSystemHoliday> implements ApiJsSystemHolidaysService {

    @Override
    public int addJsSystemHolidays(JsSystemHolidayReq jsSystemHolidayReq) {
        JsSystemHoliday jsSystemHoliday = new JsSystemHoliday();
        BeanUtils.copyProperties(jsSystemHolidayReq,jsSystemHoliday);
        jsSystemHoliday.setId(IdUtil.simpleUUID());
        jsSystemHoliday.setCreateId("SYSTEM");
        jsSystemHoliday.setCreateName("后台系统");
        int insertCount = iBaseMapper.insertSelective(jsSystemHoliday);
        log.info("插入数据条数：{}",insertCount);
        return insertCount;
    }

    @Override
    public String getJsSystemHolidayList(JsSystemHolidayReq jsSystemHolidayReq) {
        PageModel pageModel = new PageModel();
        Example example = new Example(JsSystemHoliday.class);
        example.setOrderByClause("hol_date");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        if (null != jsSystemHolidayReq.getHolDate()) {
            criteria.andEqualTo("holDate", jsSystemHolidayReq.getHolDate());
        }
        if (null != jsSystemHolidayReq.getHolType()) {
            criteria.andEqualTo("holType", jsSystemHolidayReq.getHolType());
        }
        PageHelper.startPage(jsSystemHolidayReq.getPageIndex(), jsSystemHolidayReq.getPageSize());
        List<JsSystemHoliday> jsSystemHolidayList = iBaseMapper.selectByExample(example);
        PageInfo<JsSystemHoliday> pageInfo = new PageInfo<>(jsSystemHolidayList);
        long count = pageInfo.getTotal();
        if(count <= 0) {
            pageModel.setMsg("暂无数据");
            return JSON.toJSONString(pageModel);
        }
        if(!ObjectUtil.isEmpty(jsSystemHolidayList)) {
            List<JsSystemHolidayVO> jsSystemHolidayVOS = new ArrayList<>();
            jsSystemHolidayList.stream().forEach(jsSystemHoliday -> {
                JsSystemHolidayVO jsSystemHolidayVO = new JsSystemHolidayVO();
                BeanUtils.copyProperties(jsSystemHoliday,jsSystemHolidayVO);
                jsSystemHolidayVO.setHolDateStr(DateUtil.format(jsSystemHoliday.getHolDate(), "yyyy-MM-dd"));
                jsSystemHolidayVO.setCreateDtsStr(DateUtil.format(jsSystemHoliday.getCreateDts(), "yyyy-MM-dd HH:mm:ss"));
                jsSystemHolidayVO.setUpdateDtsStr(DateUtil.format(jsSystemHoliday.getUpdateDts(), "yyyy-MM-dd HH:mm:ss"));
                jsSystemHolidayVO.setHolTypeDesc(jsSystemHoliday.getHolType().getDesc());
                jsSystemHolidayVOS.add(jsSystemHolidayVO);
            });
            pageModel.setList(jsSystemHolidayVOS);
        }
        pageModel.setCount(new Integer((int)count));
        pageModel.setMsg("ok");
        pageModel.setRel(true);
        return JSON.toJSONString(pageModel);
    }

    @Override
    public JsSystemHolidayVO getLastHoliday() {
        Example example = new Example(JsSystemHoliday.class);
        example.setOrderByClause("hol_date desc");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        PageHelper.startPage(0, 1);
        List<JsSystemHoliday> jsSystemHolidayList = iBaseMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(jsSystemHolidayList)) {
            return null;
        }
        JsSystemHoliday jsSystemHoliday = jsSystemHolidayList.get(0);
        JsSystemHolidayVO jsSystemHolidayVO = new JsSystemHolidayVO();
        BeanUtils.copyProperties(jsSystemHoliday,jsSystemHolidayVO);
        jsSystemHolidayVO.setHolDateStr(DateUtil.format(jsSystemHoliday.getHolDate(), "yyyy-MM-dd"));
        jsSystemHolidayVO.setCreateDtsStr(DateUtil.format(jsSystemHoliday.getCreateDts(), "yyyy-MM-dd HH:mm:ss"));
        jsSystemHolidayVO.setUpdateDtsStr(DateUtil.format(jsSystemHoliday.getUpdateDts(), "yyyy-MM-dd HH:mm:ss"));
        jsSystemHolidayVO.setHolTypeDesc(jsSystemHoliday.getHolType().getDesc());
        return jsSystemHolidayVO;
    }

    @Override
    public int changeHolType(JsSystemHolidayReq jsSystemHolidayReq) {
        JsSystemHoliday jsSystemHoliday = iBaseMapper.selectByPrimaryKey(jsSystemHolidayReq.getId());
        if(null == jsSystemHoliday){
            return 0;
        }
        jsSystemHoliday.setHolType(jsSystemHolidayReq.getHolType());
        jsSystemHoliday.setHolDesc(jsSystemHolidayReq.getHolDesc());
        jsSystemHoliday.setUpdateDts(new Date());
        int updateCount = iBaseMapper.updateByPrimaryKeySelective(jsSystemHoliday);
        log.info("更新数据条数：{}",updateCount);
        return updateCount;
    }

    @Override
    public boolean dealFlag() {
        JsSystemHoliday jsSystemHolidaySel = new JsSystemHoliday();
        Date date = new Date();
        String dateStr = DateUtil.format(date,"yyyy-MM-dd");
        jsSystemHolidaySel.setHolDate(DateUtil.parseDate(dateStr));
        JsSystemHoliday jsSystemHoliday = iBaseMapper.selectOne(jsSystemHolidaySel);
        log.info("查询到节假日信息:{}",jsSystemHoliday);
        if(null == jsSystemHoliday){
            log.error("未查询到节假日信息:{}",date);
            return false;
        }
        if(HolType.HOLIDAYS.equals(jsSystemHoliday.getHolType())){
            return false;
        }
        String dateStrStart = DateUtil.format(date,"yyyy-MM-dd 09:30:00");
        String dateStrEnd = DateUtil.format(date,"yyyy-MM-dd 16:30:00");
        Date startDate = DateUtil.parse(dateStrStart);
        Date endDate = DateUtil.parse(dateStrEnd);
        boolean dealFlag = DateUtil.isIn(date,startDate,endDate);
        log.info("当前时间是否可以交易：{}",dealFlag);
        return dealFlag;
    }

}
