package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.*;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.GenerateFileRecordReq;
import com.js.common.model.vo.FileVo;
import com.js.common.model.vo.GenerateFileRecordVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ReqNoUtil;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.*;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.JsFileForOSSSerivce;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Description: 文件生成记录接口具体实现
 * @Author: liuh
 * @Create: 2019-07-15
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiGenerateFileRecordServiceImpl extends IBaseServiceImpl<GenerateFileRecord> implements ApiGenerateFileRecordService {
    @Autowired
    JsFileForOSSSerivce jsFileForOSSSerivce;

    @Override
    public ResponseMessage generateFileRecordList(GenerateFileType generateFileType,KycNaturalVO kycNaturalVO) {
        Example example = new Example(GenerateFileRecord.class);
        example.setOrderByClause("create_dts desc");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        criteria.andEqualTo("generateType", generateFileType);
        criteria.andEqualTo("kycNaturalId", kycNaturalVO.getId());
        List<GenerateFileRecord> generateFileRecordList = iBaseMapper.selectByExample(example);
        List<GenerateFileRecordVO> generateFileRecordVOList = new ArrayList<>();
        generateFileRecordList.stream().forEach(generateFileRecord -> {
            GenerateFileRecordVO generateFileRecordVO = new GenerateFileRecordVO();
            BeanUtils.copyProperties(generateFileRecord,generateFileRecordVO);
            if(StringUtils.isNotBlank(generateFileRecord.getTradeType())){
                TradeTypeEnum tradeType = TradeTypeEnum.valueOf(generateFileRecord.getTradeType());
                generateFileRecordVO.setTradeTypeDesc(tradeType.getDesc());
            }
            if(null != generateFileRecord.getLanguageType()){
                generateFileRecordVO.setLanguageTypeDesc(generateFileRecord.getLanguageType().getDesc());
            }
            if(null != generateFileRecord.getFileType()){
                generateFileRecordVO.setFileTypeDesc(generateFileRecord.getFileType().getEnumName());
            }
            generateFileRecordVOList.add(generateFileRecordVO);
        });
        return ResultUtil.success(generateFileRecordVOList);
    }

    @Override
    public ResponseMessage generateFileRecordAdd(GenerateFileRecordReq generateFileRecordReq, KycNaturalVO kycNaturalVO) {
        Example example = new Example(GenerateFileRecord.class);
        example.setOrderByClause("create_dts desc");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        criteria.andEqualTo("generateType", generateFileRecordReq.getGenerateType());
        criteria.andEqualTo("kycNaturalId", kycNaturalVO.getId());
        List<GenerateFileRecord> generateFileRecordList = iBaseMapper.selectByExample(example);
        for(int i = 0 ; i < generateFileRecordList.size(); i ++){
            GenerateFileRecord generateFileRecord = generateFileRecordList.get(i);
            if(i > 3){
                generateFileRecord.setDelFlag(true);
                iBaseMapper.updateByPrimaryKeySelective(generateFileRecord);
                log.info("已将编号{}记录修改为不可见",generateFileRecord.getGenerateNo());
                if(ProcessStatusEnum.TRADE_PROCESSED.equals(generateFileRecord.getProcessStatus()) && StringUtils.isNotBlank(generateFileRecord.getFileSavePath())){
                    jsFileForOSSSerivce.deleteFile(generateFileRecord.getFileSavePath());
                    log.info("删除文件成功：{}",generateFileRecord.getFileSavePath());
                }
            }
        }
        GenerateFileRecord generateFileRecord = new GenerateFileRecord();
        BeanUtils.copyProperties(generateFileRecordReq,generateFileRecord);
        if(null != generateFileRecordReq.getTradeType()){
            generateFileRecord.setTradeType(generateFileRecordReq.getTradeType().name());
        }
        if(null != generateFileRecordReq.getStorePlateform()){
            generateFileRecord.setStorePlateformCode(generateFileRecordReq.getStorePlateform().name());
        }
        generateFileRecord.setId(IdUtil.simpleUUID());
        generateFileRecord.setKycNaturalId(kycNaturalVO.getId());
        generateFileRecord.setGenerateNo(ReqNoUtil.getReqNo());
        generateFileRecord.setCreateId(kycNaturalVO.getId());
        generateFileRecord.setCreateName(kycNaturalVO.getCertificationName());
        generateFileRecord.setCreateDts(new Date());
        int insertCount = iBaseMapper.insertSelective(generateFileRecord);
        log.info("插入生成记录表条数：{}",insertCount);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage generateFileRecordUpdate(FileVo fileVo, GenerateFileRecordVO generateFileRecordVO, KycNaturalVO kycNaturalVO) {
        GenerateFileRecord generateFileRecord = new GenerateFileRecord();
        generateFileRecord.setId(generateFileRecordVO.getId());
        generateFileRecord.setCommFileId(fileVo.getId());
        generateFileRecord.setFileSavePath(fileVo.getFileSavePath());
        generateFileRecord.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
        int updateCount = iBaseMapper.updateByPrimaryKeySelective(generateFileRecord);
        log.info("更新生成文件记录表完成共:{}条",updateCount);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public GenerateFileRecordVO findGenerateFileRecordById(GenerateFileRecordReq generateFileRecordReq) {
        GenerateFileRecord generateFileRecordQuery = new GenerateFileRecord();
        generateFileRecordQuery.setId(generateFileRecordReq.getId());
        generateFileRecordQuery.setGenerateType(generateFileRecordReq.getGenerateType());
        generateFileRecordQuery.setDelFlag(false);
        GenerateFileRecord generateFileRecord = iBaseMapper.selectOne(generateFileRecordQuery);
        if(null == generateFileRecord){
            return null;
        }
        GenerateFileRecordVO generateFileRecordVO = new GenerateFileRecordVO();
        BeanUtils.copyProperties(generateFileRecord,generateFileRecordVO);
        if(StringUtils.isNotBlank(generateFileRecord.getTradeType())){
            generateFileRecordVO.setTradeType(TradeTypeEnum.valueOf(generateFileRecord.getTradeType()));
        }
        return generateFileRecordVO;
    }
}
