package com.js.pay.service.chinapnr.impl;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.js.api.jspay.service.ApiJsPaySunrateTradeLockPriceService;
import com.js.api.jspay.service.ApiKycBankService;
import com.js.api.jspay.service.chinapnr.ChinaPNRTransactionDetailsService;
import com.js.common.constant.Constant;
import com.js.common.enums.AmazonEndpointEnum;
import com.js.common.enums.ChinaPNRTransEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.ChinaPNRTransactionDetailsReq;
import com.js.common.model.req.ChinaPNRTransactionReq;
import com.js.common.model.vo.KycBankVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.*;
import com.js.dal.dao.model.*;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import com.js.pay.service.chinapnr.example.ChinaPnrConfigure;
import com.js.pay.service.chinapnr.example.hack.HttpClientServiceImpl;
import com.js.pay.service.chinapnr.example.hack.SimpleHttpsClientImpl;
import com.js.pay.service.chinapnr.example.utils.SignatureUtil;
import com.js.pay.service.chinapnr.example.utils.XMLUtil;
import common.util.httpclient.HttpRequestContext;
import common.util.httpclient.HttpSendResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import tk.mybatis.mapper.entity.Example;

import javax.xml.xpath.XPathConstants;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 汇付天下交易明细备案
 *
 * @author: liutianyu
 **/
@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ChinaPNRTransactionDetailsServiceImpl implements ChinaPNRTransactionDetailsService {
    @Autowired
    JsSyncAmazonSettlementReportMapper jsSyncAmazonSettlementReportMapper;
    @Autowired
    ChinaPnrTransactionDetailMapper chinaPnrTransactionDetailMapper;
    @Autowired
    ChinaPNRTransactionMapper chinaPNRTransactionMapper;
    @Autowired
    private JsSyncAmazonFinancialEventGroupMapper jsSyncAmazonFinancialEventGroupMapper;
    @Autowired
    private ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Value("${js.xuhui.dispatcherDates}")
    private String dispatcherDates;
    @Autowired
    private ApiKycBankService apiKycBankService;
    /**
     * 汇付配置文件
     */
    @Autowired
    private ChinaPnrConfigure chinaPnrConfigure ;
    @Autowired
    KycSunrateStoreMapper kycSunrateStoreMapper;


    @Override
    public ResponseMessage saveChinaPNRTransactionDetail(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq){
        log.info("预处理订单还原操作开始:{}", JSON.toJSONString(chinaPNRTransactionDetailsReq));
        List<ChinaPnrTransactionDetail> insertDetailList = new ArrayList<>();
        // 计算订单明细
        BigDecimal result = calTransactionDetails2(chinaPNRTransactionDetailsReq,insertDetailList);
        if(result == null){
            log.error("订单还原预处理失败，报告无记录，暂无可使用资金。");
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_REPORT_ERROR );
        }
        if (result.compareTo(new BigDecimal("0")) != 0) {
            log.error("订单还原预处理添加失败");
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_CONTRAST_ERROR );
        }
        log.error("订单还原预处理添加成功");
        return ResultUtil.success(ResultEnum.CHINA_PNR_TRANSACTION_CONTRAST_SUCCESS);
    }

    /**
     * 定时任务（14:30） 备案明细发到汇付
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage submitTransactionDetails() throws Exception {
        Date end = null;
        Date start = null;
        int amount = -1;
        try {
            // 处理昨天14点30分—今天14点30分的交易明细
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String date = sdf.format(new Date())+" " + dispatcherDates;
            SimpleDateFormat smf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            end = smf.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(end);
            calendar.add(Calendar.DATE, amount);
            start = calendar.getTime();
            log.info("start= {}——end= {}",smf.format(start) ,date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        int count = getChinaPnrDetailsCountByDate(start,end);
        if(count == 0 ){
            log.info("总批次号为0,没有交易记录。");
            return ResultUtil.success();
        }
        if (count > 45000) {
            log.error("订单还原明细记录超过接口最大支持45000，明细总数量：{}", count );
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR );
        }
        // 锁汇到寻汇 总金额
        ResponseMessage responseMessage = apiJsPaySunrateTradeLockPriceService.getLockPriceByDate(start,end,true);
        String total = responseMessage.getData().toString();
        BigDecimal totalAmt = new BigDecimal(total);

//        int  size =  insertDetailList.size();
//        int batchLength = ( size - 1 ) / 45000 +1 ;
//        for( int j = 0 ; j < batchLength; j++ ){

            // 根据汇付要求，大于 5000 需要分批进行备案
            int batchNum = 5000;
            // 计算需要的批次
            int sumbatch = ( count - 1 ) / batchNum + 1;
            // 当前批次
            int batch = 1;
            int sendStatus = 1;
            String batchNo = IdUtil.simpleUUID();
            log.info("订单还原发汇付交易批次号：{}，start：",batchNo );
            ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq = new ChinaPNRTransactionDetailsReq();
            chinaPNRTransactionDetailsReq.setBatchNo(batchNo);
            chinaPNRTransactionDetailsReq.setTargetAmount(totalAmt);
            chinaPNRTransactionDetailsReq.setCurrencyCode("CNY");

            for (int i = 1; i <= count; i++) {
                if (i % batchNum == 0) {
//                    List<ChinaPnrTransactionDetail> partDetails = insertDetailList.subList(i - batchNum, i);
                    List<ChinaPnrTransactionDetail> partDetails = getChinaPnrTransactionDetailsByDate(start,end,i - batchNum, i);
                    sendStatus = sentDetailsRestoreReqeust(chinaPNRTransactionDetailsReq,start,end, count, sumbatch, batch, partDetails);
                    batch++;
                }
                // 代表这是最后一批，直接把剩下的全发出去。
                if (sumbatch == batch ) {
//                    List<ChinaPnrTransactionDetail> details = insertDetailList.subList((sumbatch - 1) * batchNum, count);
                    List<ChinaPnrTransactionDetail> details = getChinaPnrTransactionDetailsByDate(start,end,(sumbatch - 1) * batchNum, count);
                    sendStatus = sentDetailsRestoreReqeust(chinaPNRTransactionDetailsReq,start,end, count, sumbatch, batch, details);
                }
                if (sendStatus == 0) {
                    break;
                }
            }
            // 如果全部发送成功或有部分已经发送成功,则保存。部分未成功的需要人工重推。
            if (batch > 2 || sendStatus == 1) {
                log.info("明细备案成功，批次号：{}, 明细备案成功比例: {}", chinaPNRTransactionDetailsReq.getBatchNo(), batch + "/" + sumbatch);
                return ResultUtil.success(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_SUCCESS );
            } else {
                log.error("明细备案失败，批次号：{}", chinaPNRTransactionDetailsReq.getBatchNo());
                return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR );
            }
//        }
//        return null;
    }

    /**
     *  对于订单还原有明细记录的，发汇付处理某一天的订单明细
     * @param dateStr  yyyyMMdd格式
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage reSubmitTransactionDetailsForDate(String dateStr) throws Exception {
        Date end = null;
        Date start = null;
        try {
            String date = dateStr + " " + dispatcherDates;
            SimpleDateFormat smf = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            end = smf.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(end);
            calendar.add(Calendar.DATE, -1);
            start = calendar.getTime();
            log.info("start= {}——end= {}",smf.format(start) ,date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        int count = getChinaPnrDetailsCountByDate(start,end);
        if(count == 0 ){
            log.info("总批次号为0,没有交易记录。");
            return ResultUtil.success();
        }
        if (count > 45000) {
            log.error("订单还原明细记录超过接口最大支持45000，明细总数量：{}", count );
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR );
        }
        // 锁汇到寻汇 总金额
        ResponseMessage responseMessage = apiJsPaySunrateTradeLockPriceService.getLockPriceByDate(start,end,true);
        String total = responseMessage.getData().toString();
        BigDecimal totalAmt = new BigDecimal(total);
        // 根据汇付要求，大于 5000 需要分批进行备案
        int batchNum = 5000;
        // 计算需要的批次
        int sumbatch = ( count - 1 ) / batchNum + 1;
        // 当前批次
        int batch = 1;
        int sendStatus = 1;
        String batchNo = IdUtil.simpleUUID();
        log.info("订单还原发汇付交易批次号：{}，start：",batchNo );
        ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq = new ChinaPNRTransactionDetailsReq();
        chinaPNRTransactionDetailsReq.setBatchNo(batchNo);
        chinaPNRTransactionDetailsReq.setTargetAmount(totalAmt);
        chinaPNRTransactionDetailsReq.setCurrencyCode("CNY");

        for (int i = 1; i <= count; i++) {
            if (i % batchNum == 0) {
                List<ChinaPnrTransactionDetail> partDetails = getChinaPnrTransactionDetailsByDate(start,end,i - batchNum, i);
                sendStatus = sentDetailsRestoreReqeust(chinaPNRTransactionDetailsReq,start,end, count, sumbatch, batch, partDetails);
                batch++;
            }
            // 代表这是最后一批，直接把剩下的全发出去。
            if (sumbatch == batch ) {
                List<ChinaPnrTransactionDetail> details = getChinaPnrTransactionDetailsByDate(start,end,(sumbatch - 1) * batchNum, count);
                sendStatus = sentDetailsRestoreReqeust(chinaPNRTransactionDetailsReq,start,end, count, sumbatch, batch, details);
            }
            if (sendStatus == 0) {
                break;
            }
        }
        // 如果全部发送成功或有部分已经发送成功,则保存。部分未成功的需要人工重推。
        if (batch > 2 || sendStatus == 1) {
            log.info("明细备案成功，批次号：{}, 明细备案成功比例: {}", chinaPNRTransactionDetailsReq.getBatchNo(), batch + "/" + sumbatch);
            return ResultUtil.success(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_SUCCESS );
        } else {
            log.error("明细备案失败，批次号：{}", chinaPNRTransactionDetailsReq.getBatchNo());
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR );
        }
    }

    /**
     * 根据批次号发送明细到汇付（后台管理人员页面手工操作，处理）
     * @param transactionId  china_pnr_transaction 主键Id
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage reSubmitDetailsByTransactionId(String transactionId) throws Exception {
        List<ChinaPnrTransactionDetail> chinaPnrDetailList = getChinaPnrDetailsByTransactionId(transactionId);
        ChinaPNRTransaction chinaPNRTransaction =chinaPNRTransactionMapper.selectByPrimaryKey(transactionId);

        int sendStatus = sentDetailReqeustByTransactionId(chinaPNRTransaction, chinaPnrDetailList);
        if (sendStatus == 0) {
            ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR );
        }
        return ResultUtil.success(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_SUCCESS );
    }

    /**
     * 成功直接返回本次成功的批次号，失败的话返回 0
     *
     * @param chinaPNRTransaction
     * @param details 本批次要使用的明细
     * @return
     */
    private int sentDetailReqeustByTransactionId(ChinaPNRTransaction chinaPNRTransaction, List<ChinaPnrTransactionDetail> details) throws Exception {
        Map<String , Object> parameter = new HashMap<>();
        initParameterHeader(parameter);
//        List<ChinaPnrTransactionDetail> details2 = details;
        Date tradeDate = new Date();
        Map<String,ChinaPnrTransactionDetail> map = getDetailLength(details);
        parameter.put("RECEIPT_ID", "");
        parameter.put("BATCH_NO", chinaPNRTransaction.getBatchNo());
        parameter.put("ORD_NUM", chinaPNRTransaction.getOrdNum());
        parameter.put("REQTIME", DateUtil.format(tradeDate, "yyyyMMddHHmmss"));
        parameter.put("PAY_CUR", "CNY");
        parameter.put("SUM_CNT", map.size() + "");
        parameter.put("SUM_AMT", chinaPNRTransaction.getSumAmt());
        parameter.put("PAY_TCNT",map.size() + "");
        parameter.put("PAY_TAMT",(chinaPNRTransaction.getPayTamt()));
        parameter.put("REVIEW_URL", chinaPnrConfigure.getTransactionDetailResultUrl());
        // 已废弃，随便传一个值即可。
        parameter.put("RESULT_URL", "xxxxxxx");
        StringBuilder detailsStr = getDetailStr(details);
        parameter.put("DETAILS", detailsStr.toString());

        HttpResult httpResult = new HttpResult(parameter).invoke();
        String requestXml = httpResult.getRequestXml();
        HttpSendResult result = httpResult.getResult();

        if (null == result) {
            log.info("网关系统异常------");
            return 0;
        } else {
            if (result.getStatus() == 200) {
                String respTxt = result.getResponseBody();
                Document document = XmlUtil.parseXml(respTxt);
                Node params = (Node) XmlUtil.getByXPath("/RESPONSE/PARAMS", document, XPathConstants.NODE);
                String status = (String) XmlUtil.getByXPath("STATUS", params, XPathConstants.STRING);
                chinaPNRTransaction.setRequestMessage(requestXml);
                chinaPNRTransaction.setResponseMessage(respTxt);
                // 生成备案明细对象
                if (status.equals("1")) {
                    // 备案成功直接返回本次的批次号
                    chinaPNRTransaction.setStatus(ChinaPNRTransEnum.REQUESET_SUCCESS.ordinal());
                    chinaPNRTransactionMapper.updateByPrimaryKeySelective(chinaPNRTransaction);
                    chinaPnrTransactionDetailMapper.updateCHNPnrTransactionDtlSttToOver(chinaPNRTransaction.getId());
                    log.info("明细备案批次号{}，进度{} 响应成功；",chinaPNRTransaction.getBatchNo(), chinaPNRTransaction.getOrdNum() );
                    return 1;
                } else {
                    chinaPNRTransaction.setStatus(ChinaPNRTransEnum.REQEUSET_FAILURE.ordinal());
                    chinaPNRTransactionMapper.updateByPrimaryKeySelective(chinaPNRTransaction);
                    log.info("明细备案批次号{}，进度{} 响应失败；",chinaPNRTransaction.getBatchNo(), chinaPNRTransaction.getOrdNum() );
                    log.error(respTxt);
                    return 0;
                }
            } else {
                log.info("网关系统异常,状态码[" + result.getStatus() + "]");
                return 0;
            }
        }
    }


    private int updateByExampleSelective(Date start ,Date end,String batchNo,String transcationId,Long timeSeq){
        Example example = new Example(ChinaPnrTransactionDetail.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status", "TODO");
        criteria.andEqualTo("delFlag", false);
        criteria.andGreaterThanOrEqualTo("tradeDate",start);
        criteria.andLessThan("tradeDate", end);
        criteria.andGreaterThanOrEqualTo("timeSeq", timeSeq);
        ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
        chinaPnrTransactionDetail.setStatus("OVER");
        chinaPnrTransactionDetail.setBatchNo(batchNo);
        chinaPnrTransactionDetail.setTransactionId(transcationId);
        int i = chinaPnrTransactionDetailMapper.updateByExampleSelective(chinaPnrTransactionDetail, example);
        return i;
    }

    private int updateReportByExampleSelective(Date start ,Date end,String kycNaturalId,String orderItemCode,String marketplaceName){
        Example example = new Example(JsSyncAmazonSettlementReport.class);
        example.setOrderByClause("order_item_code");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status", false);
        criteria.andEqualTo("kycNaturalId", kycNaturalId);
        criteria.andEqualTo("marketplaceName", marketplaceName);
        criteria.andGreaterThanOrEqualTo("createDts",start);
        criteria.andLessThan("createDts", end);
        criteria.andLessThanOrEqualTo("orderItemCode", orderItemCode);
        JsSyncAmazonSettlementReport jsSyncAmazonSettlementReport = new JsSyncAmazonSettlementReport();
        jsSyncAmazonSettlementReport.setStatus(true);
        int i = jsSyncAmazonSettlementReportMapper.updateByExampleSelective(jsSyncAmazonSettlementReport, example);
        return i;
    }

//    private int updateChinaPnrDetailByBatchNo(String batchNo){
//        Example example = new Example(ChinaPnrTransactionDetail.class);
//        Example.Criteria criteria = example.createCriteria();
//        criteria.andEqualTo("batchNo", batchNo);
//        criteria.andEqualTo("delFlag", false);
//        ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
//        chinaPnrTransactionDetail.setStatus("OVER");
//        int i = chinaPnrTransactionDetailMapper.updateByExampleSelective(chinaPnrTransactionDetail, example);
//        return i;
//    }

    /**
     * 重推结汇明细(根据锁汇后saveChinaPNRTransactionDetail() 方法 失败没有入订单还原明细表的数据 )
     * @param dateStr  yyyyMMdd格式
     * @return
     */
    @Override
    public ResponseMessage reSaveTransactionDetailAndSumbit(String dateStr) throws Exception {
        Date end = null;
        Date start = null;
        try {
            String date = dateStr + " " + dispatcherDates;
            SimpleDateFormat smf = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            end = smf.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(end);
            calendar.add(Calendar.DATE, -1);
            start = calendar.getTime();
            log.info("start= {}——end= {}",smf.format(start) ,date);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        ResponseMessage responseMessage = apiJsPaySunrateTradeLockPriceService.getLockPriceByDate(start,end,false);
        List<JsPaySunrateTradeLockPrice> jsPaySunrateTradeLockPricelist = (List<JsPaySunrateTradeLockPrice>) responseMessage.getData();
        int i = 0;
        for(JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPrice : jsPaySunrateTradeLockPricelist){
            ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq = new ChinaPNRTransactionDetailsReq();
            chinaPNRTransactionDetailsReq.setKycNaturalId(jsPaySunrateTradeLockPrice.getKycNaturalId());
            chinaPNRTransactionDetailsReq.setDispaterDate(jsPaySunrateTradeLockPrice.getTxnDatetime());
            chinaPNRTransactionDetailsReq.setCurrencyCode(jsPaySunrateTradeLockPrice.getBuyCur());
            chinaPNRTransactionDetailsReq.setTargetAmount(jsPaySunrateTradeLockPrice.getBuyAmt());
            chinaPNRTransactionDetailsReq.setKycBankId(jsPaySunrateTradeLockPrice.getKycBankId());
            chinaPNRTransactionDetailsReq.setExchangeRate(jsPaySunrateTradeLockPrice.getFinRate());
            KycSunrateStore kycSunrateStore = kycSunrateStoreMapper.selectByPrimaryKey(jsPaySunrateTradeLockPrice.getKycSunrateStoreId());
            chinaPNRTransactionDetailsReq.setAmazonEndpointEnum(kycSunrateStore.getStoreTheSite().getAmazonEndpointEnum());
            responseMessage = saveChinaPNRTransactionDetail(chinaPNRTransactionDetailsReq);
            i++;
            if(!responseMessage.isSuccess()){
                log.error("重推结汇明细reSaveTransactionDetailAndSumbit, 当前进度为：{}", i +"/" + jsPaySunrateTradeLockPricelist.size());
                break;
            }
        }
        if(!responseMessage.isSuccess()){
            log.error("重推结汇明细reSaveTransactionDetailAndSumbit, responseMessage：{}",responseMessage.getCode() + "-" + responseMessage.getMsg());
            return responseMessage;
        }
        // 发汇付 订单还原明细数据
       return reSubmitTransactionDetailsForDate(dateStr);
    }

    @Override
    public ResponseMessage transactionDetailsCallback(String responseStr) {
        Document document = XmlUtil.parseXml(responseStr);
        // 1、成功 2、失败
        String status = (String) XmlUtil.getByXPath("/NOTIFY/PARAMS/STATUS", document, XPathConstants.STRING);
        String code = (String) XmlUtil.getByXPath("/NOTIFY/PARAMS/ERRERCODE", document, XPathConstants.STRING);
        String msg = (String) XmlUtil.getByXPath("/NOTIFY/PARAMS/ERRERMSG2", document, XPathConstants.STRING);
        // 更新响应报文
        String batchNo = (String) XmlUtil.getByXPath("/NOTIFY/PARAMS/BATCH_NO", document, XPathConstants.STRING);
        String ordNum = (String) XmlUtil.getByXPath("/NOTIFY/PARAMS/ORD_NUM", document, XPathConstants.STRING);
        Example example = new Example(ChinaPNRTransaction.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("batchNo", batchNo);
        criteria.andEqualTo("ordNum", ordNum);
        criteria.andEqualTo("delFlag", false);
        // 只更新最后一个的报告，因为分批备案的情况下回调也只会回调一次，显示的序号是最后一个次的
        List<ChinaPNRTransaction> chinaPNRTransactions = chinaPNRTransactionMapper.selectByExample(example);
        ChinaPNRTransaction chinaPNRTransaction;
        if (chinaPNRTransactions.size() == 1) {
            chinaPNRTransaction = chinaPNRTransactions.get(0);
            chinaPNRTransaction.setResponseMessage(responseStr);
            chinaPNRTransaction.setUpdateId("sys");
            chinaPNRTransaction.setUpdateName("sys");
            chinaPNRTransaction.setUpdateDts(new Date());
        } else {
            log.error("交易明细备案数据错误 批次号: {}, 序号：{}", batchNo, ordNum);
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_CALLBACK_ERROR);
        }

        if ("1".equals(status)) {
            chinaPNRTransaction.setStatus(ChinaPNRTransEnum.RECEIVE_SUCCESS.ordinal());
            chinaPNRTransactionMapper.updateByPrimaryKeySelective(chinaPNRTransaction);

            // 回调成功
            Map<String , Object> parameter = new HashMap<>();
            initParameterHeader(parameter);
            // 回调成功
            parameter.put("RESULT", "000000");
            String requestXml = ChinaPNRCommons.transferToXML(parameter, chinaPnrConfigure.getTrxtypeBa(),chinaPnrConfigure.getChinapnrrXml());
            return ResultUtil.success(requestXml, ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_CALLBACK_SUCCESS);
        } else {
            // 回调失败
            chinaPNRTransaction.setStatus(ChinaPNRTransEnum.REQEUSET_FAILURE.ordinal());
            chinaPNRTransactionMapper.updateByPrimaryKeySelective(chinaPNRTransaction);
            log.error("交易明细备案，汇付回调审核失败。code: {}, msg: {}", code, msg);
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_CALLBACK_ERROR);
        }
    }

    private void initParameterHeader(Map<String, Object> parameter) {
        //商户号
        parameter.put("MERCHANTID", chinaPnrConfigure.getMerchantid());
        //终端号
        parameter.put("TERMINALID",chinaPnrConfigure.getTerminalid());
        //交易类别
        parameter.put("TRXTYPE", chinaPnrConfigure.getTrxtypeBa());
        //产品类型
        parameter.put("PRODUCTTYPE", chinaPnrConfigure.getProducttype());
        //接口版本
        parameter.put("VERSION",chinaPnrConfigure.getVersion());
    }

    private BigDecimal getAmazonExchangeRate(String settlementId) {
        Example example = new Example(JsSyncAmazonSettlementReport.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("settlementId", settlementId);
        criteria.andIsNotNull("totalAmount");
        criteria.andEqualTo("delFlag", false);
        JsSyncAmazonSettlementReport settlementReport = jsSyncAmazonSettlementReportMapper.selectOneByExample(example);

        Example example1 = new Example(JsSyncAmazonFinancialEventGroup.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("storeId", settlementReport.getStoreId());
        criteria1.andEqualTo("originalTotal", settlementReport.getTotalAmount());
        criteria1.andEqualTo("originalTotalCode", settlementReport.getCurrency());
        criteria1.andEqualTo("financialEventGroupStart", settlementReport.getSettlementStartDate());
        criteria.andEqualTo("delFlag", false);
        JsSyncAmazonFinancialEventGroup jsSyncAmazonFinancialEventGroup = jsSyncAmazonFinancialEventGroupMapper.selectOneByExample(example1);
        BigDecimal convertedTotal = jsSyncAmazonFinancialEventGroup.getConvertedTotal();
        if (convertedTotal == null) {
            return BigDecimal.ONE;
        } else {
            return convertedTotal.divide(jsSyncAmazonFinancialEventGroup.getOriginalTotal(), 4, RoundingMode.HALF_UP);
        }
    }

    private BigDecimal calTransactionDetails2(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq, List<ChinaPnrTransactionDetail> insertDetailList) {
        Date nowDate = new Date();
        Date tradeDate = chinaPNRTransactionDetailsReq.getDispaterDate();
        SimpleDateFormat smf = new SimpleDateFormat("ddHHmmssSSS");
        Long timeSeq = Long.valueOf(smf.format(tradeDate)+"10000");
        // 外币对比人民币 汇率
        BigDecimal exchangeRate = chinaPNRTransactionDetailsReq.getExchangeRate();
        // 通过汇率转换成源币种，为了足额还原，除不尽会向上取一位。
        BigDecimal targetAmount = chinaPNRTransactionDetailsReq.getTargetAmount();
//                .divide(chinaPNRTransactionDetailsReq.getExchangeRate(), 2, RoundingMode.UP);
        ZonedDateTime end = ZonedDateTime.ofInstant(nowDate.toInstant(), ZoneId.systemDefault());
        ZonedDateTime start = end.minusMonths(3);
        String marketplaceName = chinaPNRTransactionDetailsReq.getAmazonEndpointEnum().getMarketplaceName();

        Date startDate = Date.from(start.toInstant());
        Date endDate = Date.from(end.toInstant());
        SimpleDateFormat smf2 = new SimpleDateFormat("yyyy-MM-dd");
        ChinaPNRTransactionReq chinaPNRTransactionReq = new ChinaPNRTransactionReq();
        chinaPNRTransactionReq.setKycNaturalId(chinaPNRTransactionDetailsReq.getKycNaturalId());
        chinaPNRTransactionReq.setMarketplaceName(marketplaceName);
        chinaPNRTransactionReq.setStart(smf2.format(startDate));
        chinaPNRTransactionReq.setEnd(smf2.format(endDate));
        List<JsSyncAmazonSettlementReport> settlementDatas = getSettlementDatas(chinaPNRTransactionReq);
        if(settlementDatas == null || settlementDatas.size()==0){
            return null;
        }
        JsSyncAmazonSettlementReport report = orderRestoration(settlementDatas,insertDetailList,exchangeRate,targetAmount,chinaPNRTransactionDetailsReq,tradeDate,timeSeq);

        // 订单还原完成，执行明细批量插入china_pnr_transaction_detail表
        chinaPnrTransactionDetailMapper.insertListWithKey(insertDetailList);
        // 订单还原完成，明细批量插入完成，更新结算报告已用报告状态
        updateReportByExampleSelective(startDate,endDate,chinaPNRTransactionDetailsReq.getKycNaturalId(), report.getOrderItemCode(), marketplaceName);

        return new BigDecimal(0);
    }

    private JsSyncAmazonSettlementReport orderRestoration(List<JsSyncAmazonSettlementReport> settlementDatas,List<ChinaPnrTransactionDetail> insertDetailList,BigDecimal exchangeRate,
                                 BigDecimal targetAmount,ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,Date tradeDate,Long timeSeq){
//        JsSyncAmazonSettlementReport reportData : settlementDatas
        int size = settlementDatas.size();
        log.info("settlementDatas.size()="+size+"==================");
        int i = 1;
        for(JsSyncAmazonSettlementReport reportData : settlementDatas){
            BigDecimal itemCodeCNYAmt = null;
            /////////////////////  加拿大站点，针对加元直换美元，汇差计算 getAmazonExchangeRate
            if(AmazonEndpointEnum.CANADA.getMarketplaceName().equals(chinaPNRTransactionDetailsReq.getAmazonEndpointEnum().getMarketplaceName()) ){
                String settlementId = reportData.getSettlementId();
                BigDecimal lastTransactionDetailExchangeRate = getAmazonExchangeRate(settlementId).multiply(exchangeRate);
                itemCodeCNYAmt = reportData.getPriceAmount().multiply(lastTransactionDetailExchangeRate).setScale(2,BigDecimal.ROUND_DOWN);
            }
            ////////////////////
            else{
                itemCodeCNYAmt = reportData.getPriceAmount().multiply(exchangeRate).setScale(2,BigDecimal.ROUND_DOWN);
            }

            log.info("itemCodeCNYAmt.()="+itemCodeCNYAmt+"==================");
            if(itemCodeCNYAmt.compareTo(targetAmount) >= 0 || i == size){
                log.info("itemCodeCNYAmt.compareTo(targetAmount) >= 0 :"+targetAmount+"==================");
                ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
                setChinaPnrTransactionDetailProperties(chinaPnrTransactionDetail,chinaPNRTransactionDetailsReq, reportData, tradeDate);
                chinaPnrTransactionDetail.setSplitSourceAmount(targetAmount.divide(exchangeRate,2,RoundingMode.UP));
                chinaPnrTransactionDetail.setSplitAmount(targetAmount);
                chinaPnrTransactionDetail.setTimeseq(timeSeq++);
                insertDetailList.add(chinaPnrTransactionDetail);
                return reportData;
            }else{
                log.info("itemCodeCNYAmt.compareTo(targetAmount) < 0 :"+targetAmount+"==================");
                targetAmount = targetAmount.subtract(itemCodeCNYAmt);
                ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
                setChinaPnrTransactionDetailProperties(chinaPnrTransactionDetail,chinaPNRTransactionDetailsReq, reportData, tradeDate);
                chinaPnrTransactionDetail.setSplitSourceAmount(itemCodeCNYAmt.divide(exchangeRate,2,RoundingMode.UP));
                chinaPnrTransactionDetail.setSplitAmount(itemCodeCNYAmt);
                chinaPnrTransactionDetail.setTimeseq(timeSeq++);
                insertDetailList.add(chinaPnrTransactionDetail);
            }
            i++;
        }
        return null;
    }

    /**
     * 如果返回值是 0 证明还原成功。
     *
     * @param chinaPNRTransactionDetailsReq
     * @param insertDetailList
     * @return
     */
    private BigDecimal calTransactionDetails(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq, List<ChinaPnrTransactionDetail> insertDetailList) {
        Date nowDate = new Date();
        Date tradeDate = chinaPNRTransactionDetailsReq.getDispaterDate();
        SimpleDateFormat smf = new SimpleDateFormat("ddHHmmssSSS");
        Long timeSeq = Long.valueOf(smf.format(tradeDate)+"10000");
        // 通过汇率转换成源币种，为了足额还原，除不尽会向上取一位。
        BigDecimal targetSourceAmount = chinaPNRTransactionDetailsReq.getTargetAmount()
                .divide(chinaPNRTransactionDetailsReq.getExchangeRate(), 2, RoundingMode.UP);
        ZonedDateTime end = ZonedDateTime.ofInstant(nowDate.toInstant(), ZoneId.systemDefault());
        ZonedDateTime start = end.minusMonths(3);
        String marketplaceName = chinaPNRTransactionDetailsReq.getAmazonEndpointEnum().getMarketplaceName();

        List<JsSyncAmazonSettlementReport> settlementDatas = null;//getSettlementDatas(chinaPNRTransactionDetailsReq.getKycNaturalId(),marketplaceName, start, end);
        if(settlementDatas == null || settlementDatas.size()==0){
            return null;
        }
        List<String> settlementDataIds = settlementDatas.stream()
                .map(JsSyncAmazonSettlementReport::getSettlementId)
                .collect(Collectors.toList());
        // 取订单还原记录
        List<ChinaPnrTransactionDetail> transactionDetails = getChinaPnrTransactionDetails(chinaPNRTransactionDetailsReq.getKycNaturalId(), start, end);
        // 计算已经使用过的订单
        List<String> usedSettlementIds = transactionDetails.stream()
                .map(ChinaPnrTransactionDetail::getSettlementId)
                .distinct()
                .collect(Collectors.toList());
        // 计算出完全没有使用过的结算报告
        List<String> canUseSettlementIds = settlementDataIds.stream()
                .filter(e -> !usedSettlementIds.contains(e))
                .collect(Collectors.toList());
        // 计算出上次没用完的订单明细
        ChinaPnrTransactionDetail lastTransactionDetail = getLastTransactionDetails(transactionDetails, start);

        // 获取全部可用的结算报告
        List<JsSyncAmazonSettlementReport> canUseSettlementReports =
                getCanUseSettlementReports(chinaPNRTransactionDetailsReq.getKycNaturalId(), canUseSettlementIds,
                        lastTransactionDetail == null ? null : lastTransactionDetail.getSettlementId());

        // 以订单明细进行分组。总金额单分一组。没有订单明细的分到 other 组
        Map<String, Map<String, List<JsSyncAmazonSettlementReport>>> groupMap = canUseSettlementReports.stream()
                .collect(Collectors.groupingBy(JsSyncAmazonSettlementReport::getSettlementId,
                        Collectors.groupingBy(e -> {
                            if (e.getTotalAmount() != null) {
                                return "settlementData";
                            } else if (e.getOrderItemCode() == null || e.getOrderItemCode().equals("")) {
                                return "other";
                            } else {
                                return e.getOrderItemCode();
                            }
                        })));
        // 如果存在上次的还原记录，则接续上次的
        if (lastTransactionDetail != null) {
            // 计算上次结尾的结算报告用了哪些订单
            List<ChinaPnrTransactionDetail> chinaPnrTransactionDetails = transactionDetails.stream()
                    .filter(e -> e.getSettlementId().equals(lastTransactionDetail.getSettlementId()))
                    .collect(Collectors.toList());
            // 优先使用上次未用完的订单进行还原
            Map<String, List<JsSyncAmazonSettlementReport>> lastSettlementReport = groupMap.get(lastTransactionDetail.getSettlementId());
            // 将结算报告的数据进行整合。
            List<JsSyncAmazonSettlementReport> sumReportList = getSumReportList(lastSettlementReport);
            // 先加上上次尾订单剩下的钱，因为存在一笔订单多次拆分，所以需要遍历计算
            BigDecimal usedTotal = transactionDetails.stream()
                    .filter(e -> e.getSettlementId().equals(lastTransactionDetail.getSettlementId()))
                    .filter(e -> e.getOrderItemCode().equals(lastTransactionDetail.getOrderItemCode()))
                    .filter(ChinaPnrTransactionDetail::getSplitFlag)
                    .map(ChinaPnrTransactionDetail::getSplitSourceAmount)
                    .reduce(new BigDecimal(0), BigDecimal::add);
            // 计算当前订单还剩多少钱
            BigDecimal remain = lastTransactionDetail.getOrderPriceTotal().subtract(usedTotal);
            ///////////////////// TODO 针对加元直换美元，汇差计算 getAmazonExchangeRate
            if(AmazonEndpointEnum.CANADA.getMarketplaceName().equals(chinaPNRTransactionDetailsReq.getAmazonEndpointEnum().getMarketplaceName()) ){
                String settlementId = lastTransactionDetail.getSettlementId();
                BigDecimal lastTransactionDetailExchangeRate = getAmazonExchangeRate(settlementId);
                targetSourceAmount = targetSourceAmount.divide(lastTransactionDetailExchangeRate,2, RoundingMode.UP);
                BigDecimal reqExchangeRate= chinaPNRTransactionDetailsReq.getExchangeRate().divide(lastTransactionDetailExchangeRate,2, RoundingMode.UP);
                chinaPNRTransactionDetailsReq.setExchangeRate(reqExchangeRate);
            }
            ////////////////////
//           转成目标币种对应的金额，只留两位小数，四舍五入
//            BigDecimal convertRemain = remain.multiply(chinaPNRTransactionDetailsReq.getExchangeRate()).setScale(2, RoundingMode.HALF_UP);
            if (targetSourceAmount.compareTo(remain) > 0) {
                // 还不足目标金额，需继续计算
                // 先记录本条记录
                useOldDetailRestore(lastTransactionDetail, remain, chinaPNRTransactionDetailsReq, tradeDate, insertDetailList ,timeSeq);
                // 更新还需要的目标金额
                targetSourceAmount = targetSourceAmount.subtract(remain);
                // 查看当前结算报告还有没有可以使用的商品明细
                List<String> usedItemCode = chinaPnrTransactionDetails.stream()
                        .map(ChinaPnrTransactionDetail::getOrderItemCode)
                        .collect(Collectors.toList());
                List<JsSyncAmazonSettlementReport> remainItem = sumReportList.stream()
                        .filter(e -> !usedItemCode.contains(e.getOrderItemCode()))
                        .collect(Collectors.toList());
                if (remainItem.size() > 0) {
                    // 继续使用该结算报告进行订单还原。
                    targetSourceAmount = orderRestoration(chinaPNRTransactionDetailsReq, targetSourceAmount, tradeDate, remainItem, insertDetailList,timeSeq);
                }
            } else {
                // 已经达到目标金额，拆分订单
                useOldDetailRestore(lastTransactionDetail, targetSourceAmount, chinaPNRTransactionDetailsReq, tradeDate, insertDetailList,timeSeq);
                targetSourceAmount = new BigDecimal(0);
            }
        }



        if (targetSourceAmount.compareTo(new BigDecimal(0)) > 0) {
            return useNewSettlementReportRestore(chinaPNRTransactionDetailsReq, targetSourceAmount, tradeDate, settlementDatas, canUseSettlementIds, groupMap, insertDetailList,timeSeq);
        } else {
            return targetSourceAmount;
        }
    }

    /**
     * 把源币种通过汇率真转换成目标币种。保留两位小数，四舍五入。
     *
     * @param source
     * @param exchangeRate
     * @return
     */
    private BigDecimal convertToTargetCurrency(BigDecimal source, BigDecimal exchangeRate) {
        return source.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
    }

    /**
     * 使用上次没完的订单进行订单还原并记录。
     * @param lastTransactionDetail
     * @param remain 订单上还剩的钱。为源币种。
     * @param chinaPNRTransactionDetailsReq
     * @param tradeDate
     * @param insertDetailList
     */
    private void useOldDetailRestore(ChinaPnrTransactionDetail lastTransactionDetail, BigDecimal remain, ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,
                                     Date tradeDate, List<ChinaPnrTransactionDetail> insertDetailList,Long timeSeq) {
        ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
        BeanUtil.copyProperties(lastTransactionDetail, chinaPnrTransactionDetail);
        chinaPnrTransactionDetail.setId(IdUtil.simpleUUID());
        chinaPnrTransactionDetail.setKycNaturalId(chinaPNRTransactionDetailsReq.getKycNaturalId());
        chinaPnrTransactionDetail.setBatchNo(chinaPNRTransactionDetailsReq.getBatchNo());
        chinaPnrTransactionDetail.setExchangeRate(chinaPNRTransactionDetailsReq.getExchangeRate());
        chinaPnrTransactionDetail.setSplitSourceAmount(remain);
        chinaPnrTransactionDetail.setSplitAmount(convertToTargetCurrency(remain, chinaPNRTransactionDetailsReq.getExchangeRate()));
        chinaPnrTransactionDetail.setSplitFlag(true);
        chinaPnrTransactionDetail.setTimeseq(timeSeq++);
        chinaPnrTransactionDetail.setTradeDate(tradeDate);
        chinaPnrTransactionDetail.setStatus("TODO");
        chinaPnrTransactionDetail.setCreateId("sys");
        chinaPnrTransactionDetail.setCreateName("sys");
        chinaPnrTransactionDetail.setCreateDts(new Date());
        insertDetailList.add(chinaPnrTransactionDetail);
    }

    /**
     * 成功直接返回本次成功的批次号，失败的话返回 0
     *
     * @param chinaPNRTransactionDetailsReq
     * @param sumbatch 总批次
     * @param batch 当前批次
     * @param details 本批次要使用的明细
     * @return
     */
    private int sentDetailsRestoreReqeust(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq, Date start ,Date end,
                                          int detailsCount, int sumbatch, int batch, List<ChinaPnrTransactionDetail> details) throws Exception {
        Map<String , Object> parameter = new HashMap<>();
        initParameterHeader(parameter);
        BigDecimal reduce = details.stream().map(ChinaPnrTransactionDetail::getSplitAmount)
                .reduce(new BigDecimal(0), BigDecimal::add);
        Long timeSeq = details.get(details.size()-1).getTimeseq();


//        List<ChinaPnrTransactionDetail> details2 = details;
        Date tradeDate = new Date();
//        Map<String,ChinaPnrTransactionDetail> map = getDetailLength(details);
        parameter.put("RECEIPT_ID", "");
        parameter.put("BATCH_NO", chinaPNRTransactionDetailsReq.getBatchNo());
        parameter.put("ORD_NUM", batch + "/" + sumbatch);
        parameter.put("REQTIME", DateUtil.format(tradeDate, "yyyyMMddHHmmss"));
        parameter.put("PAY_CUR", "CNY");
        parameter.put("SUM_CNT", details.size() + "");
        parameter.put("SUM_AMT", (chinaPNRTransactionDetailsReq.getTargetAmount().multiply(new BigDecimal(100))).intValue() + "");
        parameter.put("PAY_TCNT",details.size() + "");
        parameter.put("PAY_TAMT",(reduce.multiply(new BigDecimal(100))).intValue() + "");
        parameter.put("REVIEW_URL", chinaPnrConfigure.getTransactionDetailResultUrl());
        log.info("REVIEW_URL:" + chinaPnrConfigure.getTransactionDetailResultUrl() );

        // 已废弃，随便传一个值即可。
        parameter.put("RESULT_URL", "xxxxxxx");
        StringBuilder detailsStr = getDetailStr(details);
        parameter.put("DETAILS", detailsStr.toString());

        log.info("<requst-DETAILS>:" + detailsStr.toString());

        HttpResult httpResult = new HttpResult(parameter).invoke();
        String requestXml = httpResult.getRequestXml();
        HttpSendResult result = httpResult.getResult();

        if (null == result) {
            log.info("网关系统异常------");
            return 0;
        } else {
            if (result.getStatus() == 200) {
                String respTxt = result.getResponseBody();
                // JSONObject jsonObject = JSONUtil.parseFromXml(respTxt);
                Document document = XmlUtil.parseXml(respTxt);
                //XmlUtil.getElement(document.getDocumentElement(), "STATUS");
                Node params = (Node) XmlUtil.getByXPath("/RESPONSE/PARAMS", document, XPathConstants.NODE);
                String status = (String) XmlUtil.getByXPath("STATUS", params, XPathConstants.STRING);
                // 生成备案明细对象
                String id = IdUtil.simpleUUID();
                ChinaPNRTransaction chinaPNRTransaction = new ChinaPNRTransaction();
                chinaPNRTransaction.setId(id);
                chinaPNRTransaction.setBatchNo(chinaPNRTransactionDetailsReq.getBatchNo());
                chinaPNRTransaction.setOrdNum(batch + "/" + sumbatch);
                chinaPNRTransaction.setReqtime(tradeDate);
                chinaPNRTransaction.setPayCur(chinaPNRTransactionDetailsReq.getCurrencyCode());
                chinaPNRTransaction.setSumCnt(new BigDecimal(detailsCount));
                chinaPNRTransaction.setSumAmt(chinaPNRTransactionDetailsReq.getTargetAmount().multiply(new BigDecimal(100)));
                chinaPNRTransaction.setPayTcnt(new BigDecimal(details.size()));
                chinaPNRTransaction.setPayTamt(reduce.multiply(new BigDecimal(100)));
                chinaPNRTransaction.setExt1("");
                chinaPNRTransaction.setExt2("");
                chinaPNRTransaction.setResultUrl("");
                chinaPNRTransaction.setResultUrl("");
                chinaPNRTransaction.setRequestMessage(requestXml);
                chinaPNRTransaction.setResponseMessage(respTxt);
                chinaPNRTransaction.setCreateId("sys");
                chinaPNRTransaction.setCreateName("sys");
                chinaPNRTransaction.setCreateDts(new Date());
                chinaPNRTransaction.setDelFlag(false);
                chinaPNRTransaction.setJsRemark("");
                if (status.equals("1")) {
                    // 备案成功直接返回本次的批次号
                    chinaPNRTransaction.setStatus(ChinaPNRTransEnum.REQUESET_SUCCESS.ordinal());
                    chinaPNRTransactionMapper.insertSelective(chinaPNRTransaction);
                    updateByExampleSelective(start,end, chinaPNRTransactionDetailsReq.getBatchNo(),id ,timeSeq);
                    log.info("明细备案批次号{}，进度{} 响应成功；",chinaPNRTransactionDetailsReq.getBatchNo(), batch + "/" + sumbatch );
                    return batch;
                } else {
                    chinaPNRTransaction.setStatus(ChinaPNRTransEnum.REQEUSET_FAILURE.ordinal());
                    chinaPNRTransactionMapper.insertSelective(chinaPNRTransaction);
                    updateByExampleSelective(start,end, chinaPNRTransactionDetailsReq.getBatchNo(),id ,timeSeq);
                    log.info("明细备案批次号{}，进度{} 响应失败；",chinaPNRTransactionDetailsReq.getBatchNo(), batch + "/" + sumbatch );
                    log.error(respTxt);
                    return 0;
                }
            } else {
                log.info("网关系统异常,状态码[" + result.getStatus() + "]");
                return 0;
            }
        }
    }

    /**
     * 使用新的结算报告进行还原
     *
     * @param chinaPNRTransactionDetailsReq
     * @param targetSourceAmount
     * @param tradeDate
     * @param settlementDatas
     * @param canUseSettlementIds
     * @param groupMap
     * @param insertDetailList
     */
    private BigDecimal useNewSettlementReportRestore(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,
                                                     BigDecimal targetSourceAmount,
                                                     Date tradeDate, List<JsSyncAmazonSettlementReport> settlementDatas,
                                                     List<String> canUseSettlementIds,
                                                     Map<String, Map<String, List<JsSyncAmazonSettlementReport>>> groupMap,
                                                     List<ChinaPnrTransactionDetail> insertDetailList,Long timeSeq) {
        // 按时间升序排列，优先使用较早的订单
        List<String> newCanUseSettlementIds = settlementDatas.stream()
                .filter(e -> canUseSettlementIds.contains(e.getSettlementId()))
                .sorted((a, b) -> {
                    if (a.getDepositDate().getTime() > b.getDepositDate().getTime()) {
                        return 1;
                    } else if (a.getDepositDate().getTime() == b.getDepositDate().getTime()) {
                        return 0;
                    } else {
                        return -1;
                    }
                }).map(JsSyncAmazonSettlementReport::getSettlementId)
                .collect(Collectors.toList());
        return calOrderRestoration(chinaPNRTransactionDetailsReq, targetSourceAmount, tradeDate, groupMap, insertDetailList, newCanUseSettlementIds,timeSeq);
    }

    /**
     * 递归计算订单还原
     *
     * @param chinaPNRTransactionDetailsReq
     * @param targetSourceAmount
     * @param tradeDate
     * @param groupMap
     * @param insertDetailList
     * @param newCanUseSettlementIds
     */
    private BigDecimal calOrderRestoration(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,
                                           BigDecimal targetSourceAmount, Date tradeDate,
                                           Map<String, Map<String, List<JsSyncAmazonSettlementReport>>> groupMap,
                                           List<ChinaPnrTransactionDetail> insertDetailList, List<String> newCanUseSettlementIds,Long timeSeq) {
        if (newCanUseSettlementIds.size() > 0) {
            // 还有可以使用的新结算报告，继续计算
            String settlementId = newCanUseSettlementIds.remove(0);
            ///////////////////// TODO 针对加元直换美元，汇差计算 getAmazonExchangeRate
            if(AmazonEndpointEnum.CANADA.getMarketplaceName().equals(chinaPNRTransactionDetailsReq.getAmazonEndpointEnum().getMarketplaceName()) ){
                BigDecimal lastTransactionDetailExchangeRate = getAmazonExchangeRate(settlementId);
                targetSourceAmount = targetSourceAmount.divide(lastTransactionDetailExchangeRate,2, RoundingMode.UP);
                BigDecimal reqExchangeRate= chinaPNRTransactionDetailsReq.getExchangeRate().divide(lastTransactionDetailExchangeRate,2, RoundingMode.UP);
                chinaPNRTransactionDetailsReq.setExchangeRate(reqExchangeRate);
            }
            ////////////////////
            Map<String, List<JsSyncAmazonSettlementReport>> stringListMap = groupMap.get(settlementId);
            List<JsSyncAmazonSettlementReport> sumReportList1 = getSumReportList(stringListMap);
            List<JsSyncAmazonSettlementReport> items = sumReportList1.stream()
                    .filter(e -> e.getTotalAmount() == null)
                    .collect(Collectors.toList());
            targetSourceAmount = orderRestoration(chinaPNRTransactionDetailsReq, targetSourceAmount, tradeDate, items, insertDetailList,timeSeq);
            if (targetSourceAmount.compareTo(new BigDecimal(0)) == 0) {
                // 结束本次计算
                log.info("订单还原计算成功");
                return targetSourceAmount;
            } else {
                // 递归，使用一个新的结算报告
                return calOrderRestoration(chinaPNRTransactionDetailsReq, targetSourceAmount, tradeDate, groupMap, insertDetailList, newCanUseSettlementIds,timeSeq);
            }
        } else {
            // 剩下的结算报告不够了。打印日志，抛异常
            log.error("结算报告不足以进行订单还原。当前用户: {}", chinaPNRTransactionDetailsReq.getKycNaturalId());
            insertDetailList.clear();
            return targetSourceAmount;
        }
    }

    private BigDecimal orderRestoration(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,
                                        BigDecimal targetSourceAmount, Date tradeDate,
                                        List<JsSyncAmazonSettlementReport> remainItem, List<ChinaPnrTransactionDetail> insertDetailList,Long timeSeq) {
        // 排序，负值在前正值在后,防止还原订单时金额超出订单总金额
        remainItem = remainItem.stream()
                .sorted(Comparator.comparing(JsSyncAmazonSettlementReport::getPriceAmount))
                .collect(Collectors.toList());
        BigDecimal targetSourceAmountTemp ;
        for (JsSyncAmazonSettlementReport settlementReport : remainItem) {
            if(targetSourceAmount.compareTo(settlementReport.getPriceAmount()) > 0) {
                // 订单金额不足目标金额
                targetSourceAmount = targetSourceAmount.subtract(settlementReport.getPriceAmount());
                ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
                setChinaPnrTransactionDetailProperties(chinaPnrTransactionDetail,
                        chinaPNRTransactionDetailsReq, settlementReport, tradeDate);
                chinaPnrTransactionDetail.setTimeseq(timeSeq++);
                chinaPnrTransactionDetail.setSplitFlag(false);
                chinaPnrTransactionDetail.setStatus("TODO");
                chinaPnrTransactionDetail.setSplitSourceAmount(settlementReport.getPriceAmount());
                chinaPnrTransactionDetail.setSplitAmount(convertToTargetCurrency(settlementReport.getPriceAmount(),
                        chinaPNRTransactionDetailsReq.getExchangeRate()));
                insertDetailList.add(chinaPnrTransactionDetail);
            } else {
                // 订单金额足够，开始拆分账单
                ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
                setChinaPnrTransactionDetailProperties(chinaPnrTransactionDetail,
                        chinaPNRTransactionDetailsReq, settlementReport, tradeDate);
                chinaPnrTransactionDetail.setSplitFlag(true);
                chinaPnrTransactionDetail.setTimeseq(timeSeq++);
                chinaPnrTransactionDetail.setStatus("TODO");
                chinaPnrTransactionDetail.setSplitSourceAmount(targetSourceAmount);
                chinaPnrTransactionDetail.setSplitAmount(convertToTargetCurrency(targetSourceAmount,
                        chinaPNRTransactionDetailsReq.getExchangeRate()));
                targetSourceAmount = new BigDecimal(0);
                insertDetailList.add(chinaPnrTransactionDetail);
                return targetSourceAmount;
            }
        }
        return targetSourceAmount;
    }

    private void setChinaPnrTransactionDetailProperties(ChinaPnrTransactionDetail chinaPnrTransactionDetail,
                                                        ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,
                                                        JsSyncAmazonSettlementReport settlementReport, Date tradeDate) {
        chinaPnrTransactionDetail.setId(IdUtil.simpleUUID());
        chinaPnrTransactionDetail.setKycNaturalId(chinaPNRTransactionDetailsReq.getKycNaturalId());
        chinaPnrTransactionDetail.setStoreId(settlementReport.getStoreId());
        chinaPnrTransactionDetail.setKycBankId(chinaPNRTransactionDetailsReq.getKycBankId());
        chinaPnrTransactionDetail.setBatchNo(chinaPNRTransactionDetailsReq.getBatchNo());
        chinaPnrTransactionDetail.setSku(settlementReport.getSku());
        chinaPnrTransactionDetail.setTransactionType(settlementReport.getTransactionType());
        chinaPnrTransactionDetail.setSettlementId(settlementReport.getSettlementId());
        chinaPnrTransactionDetail.setOrderItemCode(settlementReport.getOrderItemCode());
        chinaPnrTransactionDetail.setCurrencyCode(chinaPNRTransactionDetailsReq.getAmazonEndpointEnum().getCurrencyCode());
        chinaPnrTransactionDetail.setOrderPriceTotal(settlementReport.getPriceAmount());
        chinaPnrTransactionDetail.setExchangeRate(chinaPNRTransactionDetailsReq.getExchangeRate());
        chinaPnrTransactionDetail.setPostedDate(settlementReport.getPostedDate());
        chinaPnrTransactionDetail.setTradeDate(tradeDate);
        chinaPnrTransactionDetail.setStatus("TODO");
        chinaPnrTransactionDetail.setSplitFlag(false);
        chinaPnrTransactionDetail.setCreateId("sys");
        chinaPnrTransactionDetail.setCreateName("sys");
        chinaPnrTransactionDetail.setCreateDts(new Date());
        chinaPnrTransactionDetail.setDelFlag(false);
    }

    private List<JsSyncAmazonSettlementReport> getSumReportList(Map<String, List<JsSyncAmazonSettlementReport>> lastSettlementReport) {
        List<JsSyncAmazonSettlementReport> sumReportList = new ArrayList<>();
        for (Map.Entry<String, List<JsSyncAmazonSettlementReport>> stringListEntry : lastSettlementReport.entrySet()) {
            if (!stringListEntry.getKey().equals("settlementData")) {
                List<JsSyncAmazonSettlementReport> value = stringListEntry.getValue();
                JsSyncAmazonSettlementReport sumReport = getSumReport(value);
                if (stringListEntry.getKey().equals("other")) {
                    sumReport.setOrderItemCode("other");
                    sumReport.setTransactionType("other");
                    sumReport.setSku("other");
                }
                sumReportList.add(sumReport);
            }
        }
        return sumReportList;
    }

    private List<JsSyncAmazonSettlementReport> getCanUseSettlementReports(String kycNaturalId, List<String> canUseSettlementIds, String lastSettlementId) {
        Example example = new Example(JsSyncAmazonSettlementReport.class);
        Example.Criteria criteria = example.createCriteria();
        List<String> condition = new ArrayList<>();
        condition.addAll(canUseSettlementIds);
        if (lastSettlementId != null) {
            condition.add(lastSettlementId);
        }
        criteria.andIn("settlementId", condition);
        criteria.andEqualTo("kycNaturalId", kycNaturalId);
        criteria.andEqualTo("delFlag", false);
        return jsSyncAmazonSettlementReportMapper.selectByExample(example);
    }

    private List<ChinaPnrTransactionDetail> getChinaPnrTransactionDetails(String kycNaturalId, ZonedDateTime start, ZonedDateTime end) {
        Example example = new Example(ChinaPnrTransactionDetail.class);
        example.setOrderByClause("trade_date desc");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId", kycNaturalId);
        criteria.andGreaterThanOrEqualTo("tradeDate", Date.from(start.toInstant()));
        criteria.andLessThanOrEqualTo("tradeDate", Date.from(end.toInstant()));
        criteria.andEqualTo("delFlag", false);
        return chinaPnrTransactionDetailMapper.selectByExample(example);
    }

    private int getChinaPnrDetailsCountByDate(Date start, Date end) {
        Example example = new Example(ChinaPnrTransactionDetail.class);
        example.setCountProperty("id");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status", "TODO");
        criteria.andEqualTo("delFlag", false);
        criteria.andGreaterThanOrEqualTo("tradeDate",start);
        criteria.andLessThan("tradeDate", end);
        int count = chinaPnrTransactionDetailMapper.selectCountByExample(example);
        return count;
    }

    private List<ChinaPnrTransactionDetail> getChinaPnrTransactionDetailsByDate(Date start, Date end,int pageNum,int pageSize) {
        Example example = new Example(ChinaPnrTransactionDetail.class);
        example.setOrderByClause("timeSeq ");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status", "TODO");
        criteria.andEqualTo("delFlag", false);
        criteria.andGreaterThanOrEqualTo("tradeDate",start);
        criteria.andLessThan("tradeDate", end);
        PageHelper.startPage(pageNum, pageSize);
        List<ChinaPnrTransactionDetail> list = chinaPnrTransactionDetailMapper.selectByExample(example);
        return list;
    }

    private List<ChinaPnrTransactionDetail> getChinaPnrDetailsByTransactionId(String transactionId) {
        Example example = new Example(ChinaPnrTransactionDetail.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("transactionId", transactionId);
        criteria.andEqualTo("delFlag", false);
        return chinaPnrTransactionDetailMapper.selectByExample(example);
    }

    private List<JsSyncAmazonSettlementReport> getSettlementDatas(ChinaPNRTransactionReq chinaPNRTransactionReq) {
        // 查询出用户结算报告还未使用的，金额为正数的报告
        return jsSyncAmazonSettlementReportMapper.getAmazonSettlementReportList(chinaPNRTransactionReq);
    }

    /**
     * 计算上次订单还原后还未用完的明细 code
     *
     * @param transactionDetails 订单还原明细
     * @param start 订单还原明细开始时间
     * @return
     */
    private ChinaPnrTransactionDetail getLastTransactionDetails(List<ChinaPnrTransactionDetail> transactionDetails, ZonedDateTime start) {
        // 获取全部被拆分的明细,按时间降序排列
        List<ChinaPnrTransactionDetail> detailList = transactionDetails.stream()
                .filter(ChinaPnrTransactionDetail::getSplitFlag)
                .sorted((a, b) -> {
                    if (a.getTradeDate().getTime() - b.getTradeDate().getTime() > 0) {
                        return -1;
                    } else if (a.getTradeDate().getTime() - b.getTradeDate().getTime() == 0) {
                        return 0;
                    } else {
                        return 1;
                    }
                })
                .collect(Collectors.toList());
        if (detailList.size() == 0) {
            // 没有订单还原过，或者间两次还原间隔时间超过三个月了。。
            return null;
        } else {
            return detailList.get(0);
        }
    }

    private Map<String,ChinaPnrTransactionDetail> getDetailLength(List<ChinaPnrTransactionDetail> details) {
        Map<String,ChinaPnrTransactionDetail> map = new HashMap<>();
        for (ChinaPnrTransactionDetail detail : details) {
            if (map.containsKey(detail.getOrderItemCode())) {
                detail.setSplitAmount(map.get(detail.getOrderItemCode()).getSplitAmount().add(detail.getSplitAmount()));
                map.put(detail.getOrderItemCode(),detail);
            }else{
                map.put(detail.getOrderItemCode(),detail);
            }
        }
        return map;
    }
    private StringBuilder getDetailStr(List<ChinaPnrTransactionDetail> details) throws Exception {
        StringBuilder detailsStr = new StringBuilder();
        Map<String, KycBankVO> kycMap = new HashMap<>();
        for (ChinaPnrTransactionDetail detail : details) {
            KycBankVO kycBankVO = null;
            if(kycMap.containsKey(detail.getKycBankId())){
                kycBankVO = kycMap.get(detail.getKycBankId());
            }else{
                ResponseMessage responseMessage = apiKycBankService.getBankCard(detail.getKycBankId());
                if(responseMessage.isSuccess()){
                    kycBankVO = (KycBankVO)responseMessage.getData();
                    kycMap.put(detail.getKycBankId(),kycBankVO);
                }else{
                    log.error("KYC用户银行ID查询失败");
                    throw new Exception("KYC用户银行ID查询失败");
                }
            }
            // 明细流水号
            detailsStr.append(detail.getId()).append("|");
            // 订单编号
            detailsStr.append(detail.getOrderItemCode()).append("|");
            // 业务日期
            detailsStr.append(DateUtil.format(detail.getPostedDate(), "yyyyMMddHHmmss")).append("|");
            // 收款方类型
            detailsStr.append("P").append("|"); // 硬编码
            // 收款人证件类别
            detailsStr.append("00").append("|"); // 硬编码
            // 收款人证件号
            detailsStr.append(kycBankVO.getIdNo()).append("|"); // TODO 需要拿用户身份证号
            // 收款人名称
            detailsStr.append(kycBankVO.getAccountName()).append("|");
            // 收款人帐号
            detailsStr.append(kycBankVO.getAccountNo()).append("|");
            // 收款银行代码或名称
            detailsStr.append(kycBankVO.getBankCode()).append("|");
            // 付款币种
            detailsStr.append("CNY").append("|");
            // 付款金额
            detailsStr.append(detail.getSplitAmount().multiply(new BigDecimal(100)).intValue()).append("|");
            // 商品描述
            detailsStr.append(detail.getSku()).append("|");
            // 备注
            detailsStr.append("note").append("\n");
        }
        if (detailsStr.length() > 0) {
            detailsStr.deleteCharAt(detailsStr.length()-1);
        }
        return detailsStr;
    }

    private StringBuilder rsGetDetailStr(List<ChinaPnrTransactionDetail> details, ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq) throws Exception {
        StringBuilder detailsStr = new StringBuilder();
        Map<String, KycBankVO> kycMap = new HashMap<>();
        for (ChinaPnrTransactionDetail detail : details) {
            KycBankVO kycBankVO = null;
            if(kycMap.containsKey(detail.getKycBankId())){
                kycBankVO = kycMap.get(detail.getKycBankId());
            }else{
                ResponseMessage responseMessage = apiKycBankService.getBankCard(detail.getKycBankId());
                if(responseMessage.isSuccess()){
                    kycBankVO = (KycBankVO)responseMessage.getData();
                    kycMap.put(detail.getKycBankId(),kycBankVO);
                }else{
                    log.error("KYC用户银行ID查询失败");
                    throw new Exception("KYC用户银行ID查询失败");
                }
            }
            // 明细流水号
            detailsStr.append(detail.getId()).append("|");
            // 订单编号
            detailsStr.append(detail.getOrderItemCode()).append("|");
            // 业务日期
            detailsStr.append(DateUtil.format(detail.getPostedDate(), "yyyyMMddHHmmss")).append("|");
            // 收款方类型
            detailsStr.append("P").append("|"); // 硬编码
            // 收款人证件类别
            detailsStr.append("01").append("|"); // 硬编码
            // 收款人证件号
            detailsStr.append(kycBankVO.getIdNo()).append("|"); // TODO 需要拿用户身份证号
            // 收款人名称
            detailsStr.append(kycBankVO.getAccountName()).append("|");
            // 收款人帐号
            detailsStr.append(kycBankVO.getAccountNo()).append("|");
            // 收款银行代码或名称
            detailsStr.append(kycBankVO.getBankCode()).append("|");
            // 付款币种
            detailsStr.append(chinaPNRTransactionDetailsReq.getCurrencyCode()).append("|");
            // 付款金额
            detailsStr.append((detail.getSplitAmount().multiply(new BigDecimal(100)).intValue())).append("|");
            // 商品描述
            detailsStr.append(detail.getSku()).append("|");
            // 备注
            detailsStr.append("note").append("\n");
        }
        if (detailsStr.length() > 0) {
            detailsStr.deleteCharAt(detailsStr.length()-1);
        }
        return detailsStr;
    }

    private JsSyncAmazonSettlementReport getSumReport(List<JsSyncAmazonSettlementReport> value) {
        // 合并商品对象。将所有价格统一到 priceAmount 字段上。
        JsSyncAmazonSettlementReport sumReport = new JsSyncAmazonSettlementReport();
        sumReport.setPriceAmount(new BigDecimal(0));
        for (JsSyncAmazonSettlementReport settlementReport : value) {
            sumReport.setId(settlementReport.getId());
            sumReport.setOrderItemCode(settlementReport.getOrderItemCode());
            sumReport.setReportId(settlementReport.getReportId());
            sumReport.setSettlementId(settlementReport.getSettlementId());
            sumReport.setMarketplaceName(settlementReport.getMarketplaceName());
            sumReport.setTransactionType(settlementReport.getTransactionType());
            sumReport.setSku(settlementReport.getSku());
            sumReport.setPostedDate(settlementReport.getPostedDate());
            if (ObjectUtil.isNotEmpty(settlementReport.getShipmentFeeAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getShipmentFeeAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getOrderFeeAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getOrderFeeAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getPriceAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getPriceAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getItemRelatedFeeAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getItemRelatedFeeAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getMiscFeeAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getMiscFeeAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getOtherFeeAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getOtherFeeAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getDirectPaymentAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getDirectPaymentAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getOtherAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getOtherAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getPromotionAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getPromotionAmount()));
            }
        }
        return sumReport;
    }

    private class HttpResult {
        private Map<String, Object> parameter;
        private String requestXml;
        private HttpSendResult result;

        public HttpResult(Map<String, Object> parameter) {
            this.parameter = parameter;
        }

        public String getRequestXml() {
            return requestXml;
        }

        public HttpSendResult getResult() {
            return result;
        }

        public HttpResult invoke() {
            HttpClientServiceImpl httpClient = new HttpClientServiceImpl();
            SimpleHttpsClientImpl shci = new SimpleHttpsClientImpl();
            httpClient.setHttpsClient(shci);

            requestXml = ChinaPNRCommons.transferToXML(parameter,chinaPnrConfigure.getTrxtypeBa(),chinaPnrConfigure.getChinapnrrXml());

            Document doc = XMLUtil.str2Doc(requestXml,"utf-8");
            try {
                SignatureUtil.xmlSignature(doc,
                        chinaPnrConfigure.getEnvtype(),
                        chinaPnrConfigure.getMerchantid()
                                .substring(0, chinaPnrConfigure.getMerchantid().length()-2),
                        chinaPnrConfigure.getPassword(),
                        chinaPnrConfigure.getAliasname(),chinaPnrConfigure.getChinapnrPfxUrl(),chinaPnrConfigure.getChinapnrPfx());
            } catch (Exception e) {
                e.printStackTrace();
            }
            requestXml = XMLUtil.doc2Str(doc,"utf-8");
            String postUrl = chinaPnrConfigure.getPosturl();
            HttpRequestContext context = new HttpRequestContext();
            context.setUrl(postUrl);
            context.setHttpMethod(HttpRequestContext.POST_METHOD);
            context.setResponseCharset("utf-8");
            context.setRequestCharset("utf-8");
            context.setXml(requestXml);

            result = null;
            try {
                result = httpClient.sendRequest(context);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }
    }


    /////////////////////////////////////////////////
    // 本地单元测试用
//    @Override
//    public ResponseMessage submitTransactionDetailsTest2() {
//        Example example = new Example(ChinaPnrTransactionDetail.class);
//        example.setOrderByClause("trade_date desc");
//        Example.Criteria criteria = example.createCriteria();
//        criteria.andEqualTo("status", "TODO");
//        criteria.andEqualTo("delFlag", false);
//        PageHelper.startPage(0, 10);
//        List<ChinaPnrTransactionDetail> list = chinaPnrTransactionDetailMapper.selectByExample(example);
//        ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
//        chinaPnrTransactionDetail.setStatus("LOCK");
//        chinaPnrTransactionDetailMapper.updateByExampleSelective(chinaPnrTransactionDetail, example);
//        chinaPnrTransactionDetailMapper.updateCHNPnrTransactionDtlSttToLock();
//        List<ChinaPNRTransactionDetailsReq> chinaDetailsReqlist = new ArrayList<>();
//        list.stream().forEach(ChinaPnrTransactionDetail -> {
//            ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq = new ChinaPNRTransactionDetailsReq();
//            BeanUtils.copyProperties(ChinaPnrTransactionDetail,chinaPNRTransactionDetailsReq);
//            chinaDetailsReqlist.add(chinaPNRTransactionDetailsReq);
//        });
//        return ResultUtil.success(chinaDetailsReqlist);
//    }



}
