package com.js.pay.service.chinapnr.example.utils;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import common.util.SysLog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.xml.crypto.dsig.*;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.xpath.*;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class XMLSecurityUtils {
	private static final SysLog logger = SysLog
			.getLogger(XMLSecurityUtils.class);

	static {
		org.apache.xml.security.Init.init();
	}

	/**
	 * 
	 * @param doc
	 * @param privateKey
	 * @return
	 * @throws Exception
	 */
	public static Document XMLSignature(Document doc, Key privateKey)
			throws Exception {
		XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");

		// Create a Reference to the enveloped document (in this case we are
		// signing the whole document, so a URI of "" signifies that) and
		// also specify the SHA1 digest algorithm and the ENVELOPED Transform.
		Reference ref = fac.newReference("", fac.newDigestMethod(
				DigestMethod.SHA1, null), Collections.singletonList(fac
				.newTransform(Transform.ENVELOPED,
						(TransformParameterSpec) null)), null, null);

		// Create the SignedInfo
		SignedInfo si = fac
				.newSignedInfo(fac.newCanonicalizationMethod(
						CanonicalizationMethod.INCLUSIVE_WITH_COMMENTS,
						(C14NMethodParameterSpec) null), fac
						.newSignatureMethod(SignatureMethod.RSA_SHA1, null),
						Collections.singletonList(ref));

		// Create a DOMSignContext and specify the DSA PrivateKey and
		// location of the resulting XMLSignature's parent element
		DOMSignContext dsc = new DOMSignContext(privateKey,
				doc.getDocumentElement());

		// Create the XMLSignature (but don't sign it yet)
		XMLSignature signature = fac.newXMLSignature(si, null);

		// Marshal, generate (and sign) the enveloped signature
		signature.sign(dsc);

		// output the resulting document
		return doc;

	}

	public static List<Node> getNodes1(Document xml, String[] nodesXPath)
			throws XPathExpressionException {
		List<Node> nodes = new ArrayList<Node>();
		if (nodesXPath.length == 0) {
			nodes.add(xml.getDocumentElement());
			return nodes;
		}

		XPathFactory factory = XPathFactory.newInstance();
		XPath xpath = factory.newXPath();
		for (String path : nodesXPath) {
			XPathExpression expr = xpath.compile(path);
			Object result = expr.evaluate(xml, XPathConstants.NODESET);
			if (result != null) {
				NodeList nodeList = (NodeList) result;
				for (int i = 0, n = nodeList.getLength(); i < n; i++) {
					nodes.add(nodeList.item(i));
				}
			}
		}

		return nodes;
	}

	public static List<Node> getNodes(Document xml, String[] nodesXPath)
			throws XPathExpressionException {
		List<Node> nodes = new ArrayList<Node>();
		if (nodesXPath.length == 0) {
			nodes.add(xml.getDocumentElement());
			return nodes;
		}

		for (String xPath : nodesXPath) {
			NodeList nd = xml.getElementsByTagName(xPath);
			nodes.add(nd.item(0));
		}

		return nodes;
	}

	public static boolean veryfySignature(Document doc, Key publicKey)
			throws Exception {

		NodeList nl = doc.getElementsByTagNameNS(
				XMLSignature.XMLNS,
				"Signature");
		if (nl.getLength() == 0) {
			throw new RuntimeException("Cannot find Signature element");
		}

		XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");

		DOMValidateContext valContext = new DOMValidateContext(publicKey,
				nl.item(0));
		XMLSignature signature = fac.unmarshalXMLSignature(valContext);
		boolean coreValidity = signature.validate(valContext);

		// Check core validation status
		if (coreValidity == false) {
			logger.logInfo("Signature failed core validation");
			boolean sv = signature.getSignatureValue().validate(valContext);
			logger.logInfo("signature validation status: " + sv);
			// check the validation status of each Reference
			Iterator i = signature.getSignedInfo().getReferences().iterator();
			for (int j = 0; i.hasNext(); j++) {
				boolean refValid = ((Reference) i.next()).validate(valContext);
				logger.logInfo("ref[" + j + "] validity status: " + refValid);
			}
		} else {
			logger.logInfo("Signature passed core validation");
		}
		return coreValidity;

	}

	public void test(){
		String requestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"+
"<request>"+
	"<si:Signature xmlns:si=\"http://www.w3.org/2000/09/xmldsig#\">"+
		"<si:SignatureValue>cD0In0aWAuD9LsrsNlk3qSYdUso46osmseIiQkvsokSdSNzh3HHFQSPOEhhNR2iW/uWhHTayZgKE"+
			"PEADQXWJzcZelv7xB5iUqWupt2Zc+QzOk2tkXyWN79WKrTotf7fb5uysyXoYOi4XH8ShYBhD+n3j"+
			"o9sEr67bW7SKFZ2gutw=</si:SignatureValue>"+
	"</si:Signature>"+
"</request>";
		

		try {
			DOMParser parser = new DOMParser();
			parser.parse(new InputSource(new ByteArrayInputStream(requestXml.getBytes("UTF-8"))));
			// 解析XML文档
			Document doc = parser.getDocument();
			NodeList nl = doc.getElementsByTagNameNS(XMLSignature.XMLNS,
					"Signature");

			if(nl.getLength() == 0){
				System.out.println("Not found Signature.");
			}
			Node signature = nl.item(0);
			System.out.println(signature.getLocalName());
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
