//package com.js.service.chinapnr;
//
//
//import cn.hutool.core.bean.BeanUtil;
//import cn.hutool.core.date.DateUtil;
//import cn.hutool.core.util.IdUtil;
//import cn.hutool.core.util.ObjectUtil;
//import cn.hutool.core.util.XmlUtil;
//import com.js.common.JsException.LogicException;
//import com.js.common.enums.ResultEnum;
//import com.js.dal.dao.mapper.ChinaPNRTransactionMapper;
//import com.js.dal.dao.mapper.ChinaPnrTransactionDetailMapper;
//import com.js.dal.dao.mapper.JsSyncAmazonSettlementReportMapper;
//import com.js.dal.dao.model.ChinaPNRTransaction;
//import com.js.dal.dao.model.ChinaPnrTransactionDetail;
//import com.js.dal.dao.model.JsSyncAmazonSettlementReport;
//import com.js.pay.JsPayServiceAppliaction;
//import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
//import com.js.pay.service.chinapnr.example.hack.HttpClientServiceImpl;
//import com.js.pay.service.chinapnr.example.hack.SimpleHttpsClientImpl;
//import com.js.pay.service.chinapnr.example.utils.SignatureUtil;
//import com.js.pay.service.chinapnr.example.utils.XMLUtil;
//import common.util.httpclient.HttpRequestContext;
//import common.util.httpclient.HttpSendResult;
//import lombok.extern.slf4j.Slf4j;
//import org.junit.Test;
//import org.junit.runner.RunWith;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.boot.test.context.SpringBootTest;
//import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
//import org.w3c.dom.Document;
//import org.w3c.dom.Node;
//import tk.mybatis.mapper.entity.Example;
//
//import javax.xml.xpath.XPathConstants;
//import java.math.BigDecimal;
//import java.time.ZoneId;
//import java.time.ZonedDateTime;
//import java.util.*;
//import java.util.stream.Collectors;
//
//@Slf4j
//@RunWith(SpringJUnit4ClassRunner.class)
//@SpringBootTest(classes= JsPayServiceAppliaction.class)
//public class ChinaPNRTransactionDetailsServiceTest {
//
//    @Autowired
//    JsSyncAmazonSettlementReportMapper jsSyncAmazonSettlementReportMapper;
//    @Autowired
//    ChinaPnrTransactionDetailMapper chinaPnrTransactionDetailMapper;
//    @Autowired
//    ChinaPNRTransactionMapper chinaPNRTransactionMapper;
//
//    @Test
//    public void process() {
//        submitTransactionDetails("ed1a79a3d200496f93fae409f56c8414","12312313r2r543yh45",
//                new BigDecimal("500"), "USD", new BigDecimal(6), new Date());
//    }
//
//    /**
//     *
//     * @param kycNaturalId
//     * @param batchNo 批次号 同一笔汇款，批次号应该唯一
//     * @param targetAmount 还原金额，这个是源币种的金额
//     * @param currencyCode 币种代码
//     * @param exchangeRate 使用汇率
//     * @param tradeDate
//     */
//    public void submitTransactionDetails(String kycNaturalId, String batchNo, BigDecimal targetAmount, String currencyCode,
//                                         BigDecimal exchangeRate, Date tradeDate) {
//        // 取结算报告,从交易时间起向前取三个月
//        if (ObjectUtil.isNull(tradeDate)) {
//            return;
//        }
//        List<ChinaPnrTransactionDetail> insertDetailList = new ArrayList<>();
//        List<ChinaPNRTransaction> insertTransactionList = new ArrayList<>();
//        // 计算订单明细
//        BigDecimal result = calTransactionDetails(kycNaturalId, targetAmount, exchangeRate, tradeDate, batchNo, insertDetailList);
//        if (result.compareTo(result) != 0) {
//            log.error("订单还原失败");
//            return;
//        }
//
//        Map<String , Object> parameter = new HashMap<>();
//
//        parameter.put("MERCHANTID", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_MERCHANTID"));//商户号
//        parameter.put("TERMINALID", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TERMINALID")); //终端号
//        parameter.put("PRODUCTTYPE", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_PRODUCTTYPE"));//产品类型
//        parameter.put("VERSION", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_VERSION"));//接口版本
//        parameter.put("TRXTYPE", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TRXTYPE_BA")); //交易类别
//
//        // 根据汇付要求，大于 5000 需要分批进行备案
//        int batchNum = 5000;
//        // 计算需要的批次
//        int sumbatch = insertDetailList.size() / batchNum + 1;
//        if (sumbatch > 9) {
//            log.error("总批次号大于 9，超过接口最大支持。明细总数量：{}", insertDetailList.size());
//            return;
//        }
//        // 当前批次
//        int batch = 1;
//        for (int i = 1; i <= insertDetailList.size(); i++) {
//            if (i % batchNum == 0) {
//                List<ChinaPnrTransactionDetail> partDetails = insertDetailList.subList(i - batchNum, i);
//                batch = sentReqeust(kycNaturalId, batchNo, targetAmount, currencyCode, tradeDate,
//                        insertTransactionList, insertDetailList, parameter, sumbatch, batch, partDetails);
//            }
//            // 代表这是最后一批，直接把剩下的全发出去。
//            if (sumbatch == batch ) {
//                List<ChinaPnrTransactionDetail> details = insertDetailList.subList((sumbatch - 1) * batchNum, insertDetailList.size());
//                batch = sentReqeust(kycNaturalId, batchNo, targetAmount, currencyCode, tradeDate, insertTransactionList,
//                        insertDetailList, parameter, sumbatch, batch, details);
//            }
//            if (batch == 0) {
//                log.error("备案明细出错，批次号：{}", batchNo);
//                break;
//            }
//        }
//        if (batch > 0) {
//            chinaPNRTransactionMapper.insertListWithKey(insertTransactionList);
//            chinaPnrTransactionDetailMapper.insertListWithKey(insertDetailList);
//            log.info("明细备案成功，备案数量：{}, 明细数量: {}", insertTransactionList.size(), insertDetailList.size());
//            return;
//        } else {
//            log.error("明细备案失败，批次号：{}", batchNo);
//            return;
//        }
//    }
//
//    /**
//     * 如果返回值是 0 证明还原成功。
//     *
//     * @param kycNaturalId
//     * @param targetAmount
//     * @param exchangeRate
//     * @param tradeDate
//     * @param batchNo
//     * @param insertDetailList
//     * @return
//     */
//    private BigDecimal calTransactionDetails(String kycNaturalId, BigDecimal targetAmount, BigDecimal exchangeRate,
//                                             Date tradeDate, String batchNo, List<ChinaPnrTransactionDetail> insertDetailList) {
//        ZonedDateTime end = ZonedDateTime.ofInstant(tradeDate.toInstant(), ZoneId.systemDefault());
//        ZonedDateTime start = end.minusMonths(3);
//        List<JsSyncAmazonSettlementReport> settlementDatas = getSettlementDatas(kycNaturalId, start, end);
//        List<String> settlementDataIds = settlementDatas.stream()
//                .map(JsSyncAmazonSettlementReport::getSettlementId)
//                .collect(Collectors.toList());
//
//        // 取订单还原记录
//        List<ChinaPnrTransactionDetail> transactionDetails = getChinaPnrTransactionDetails(kycNaturalId, start, end);
//        // 计算已经使用过的订单
//        List<String> usedSettlementIds = transactionDetails.stream()
//                .map(ChinaPnrTransactionDetail::getSettlementId)
//                .distinct()
//                .collect(Collectors.toList());
//        // 计算出完全没有使用过的结算报告
//        List<String> canUseSettlementIds = settlementDataIds.stream()
//                .filter(e -> !usedSettlementIds.contains(e))
//                .collect(Collectors.toList());
//        // 计算出上次没用完的订单明细
//        ChinaPnrTransactionDetail lastTransactionDetail = getLastTransactionDetails(transactionDetails, start);
//
//        // 获取全部可用的结算报告
//        List<JsSyncAmazonSettlementReport> canUseSettlementReports = getCanUseSettlementReports(kycNaturalId, canUseSettlementIds,
//                lastTransactionDetail == null ? null : lastTransactionDetail.getSettlementId());
//
//        // 以订单明细进行分组。总金额单分一组。没有订单明细的分到 other 组
//        Map<String, Map<String, List<JsSyncAmazonSettlementReport>>> groupMap = canUseSettlementReports.stream()
//                .collect(Collectors.groupingBy(JsSyncAmazonSettlementReport::getSettlementId,
//                        Collectors.groupingBy(e -> {
//                            if (e.getTotalAmount() != null) {
//                                return "settlementData";
//                            } else if (e.getOrderItemCode() == null || e.getOrderItemCode().equals("")) {
//                                return "other";
//                            } else {
//                                return e.getOrderItemCode();
//                            }
//                        })));
//        // 如果存在上次的还原记录，则接续上次的
//        if (lastTransactionDetail != null) {
//            // 计算上次结尾的结算报告用了哪些订单
//            List<ChinaPnrTransactionDetail> chinaPnrTransactionDetails = transactionDetails.stream()
//                    .filter(e -> e.getSettlementId().equals(lastTransactionDetail.getSettlementId()))
//                    .collect(Collectors.toList());
//            // 优先使用上次未用完的订单进行还原
//            Map<String, List<JsSyncAmazonSettlementReport>> lastSettlementReport = groupMap.get(lastTransactionDetail.getSettlementId());
//            // 将结算报告的数据进行整合。
//            List<JsSyncAmazonSettlementReport> sumReportList = getSumReportList(lastSettlementReport);
//
//            // 已经累加出来的订单价格
//            //BigDecimal sumTotal = new BigDecimal(0);
//            // 先加上上次尾订单剩下的钱，因为存在一笔订单多次拆分，所以需要遍历计算
//            BigDecimal usedTotal = transactionDetails.stream()
//                    .filter(e -> e.getSettlementId().equals(lastTransactionDetail.getSettlementId()))
//                    .filter(e -> e.getOrderItemCode().equals(lastTransactionDetail.getOrderItemCode()))
//                    .filter(ChinaPnrTransactionDetail::getSplitFlag)
//                    .map(ChinaPnrTransactionDetail::getSplitSourceAmount)
//                    .reduce(new BigDecimal(0), BigDecimal::add);
//            // 计算当前订单还剩多少钱
//            BigDecimal remain = lastTransactionDetail.getOrderPriceTotal().subtract(usedTotal);
//            if (targetAmount.compareTo(remain) > 0) {
//                // 还不足目标金额，需继续计算
//                // 先记录本条记录
//                ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
//                BeanUtil.copyProperties(lastTransactionDetail, chinaPnrTransactionDetail);
//                chinaPnrTransactionDetail.setId(IdUtil.simpleUUID());
//                chinaPnrTransactionDetail.setKycNaturalId(kycNaturalId);
//                chinaPnrTransactionDetail.setBatchNo(batchNo);
//                chinaPnrTransactionDetail.setExchangeRate(exchangeRate);
//                chinaPnrTransactionDetail.setSplitSourceAmount(remain);
//                chinaPnrTransactionDetail.setSplitAmount(remain.multiply(exchangeRate));
//                chinaPnrTransactionDetail.setSplitFlag(true);
//                chinaPnrTransactionDetail.setTradeDate(tradeDate);
//                chinaPnrTransactionDetail.setCreateId("sys");
//                chinaPnrTransactionDetail.setCreateName("sys");
//                chinaPnrTransactionDetail.setCreateDts(new Date());
//                insertDetailList.add(chinaPnrTransactionDetail);
//                // 更新还需要的目标金额
//                targetAmount = targetAmount.subtract(remain);
//                // 查看当前结算报告还有没有可以使用的商品明细
//                List<String> usedItemCode = chinaPnrTransactionDetails.stream()
//                        .map(ChinaPnrTransactionDetail::getOrderItemCode)
//                        .collect(Collectors.toList());
//                List<JsSyncAmazonSettlementReport> remainItem = sumReportList.stream()
//                        .filter(e -> !usedItemCode.contains(e.getOrderItemCode()))
//                        .collect(Collectors.toList());
//                if (remainItem.size() > 0) {
//                    // 继续使用该结算报告进行订单还原。
//                    targetAmount = orderRestoration(batchNo, kycNaturalId, targetAmount, exchangeRate, tradeDate, remainItem, insertDetailList);
//                }
//            } else {
//                // TODO 一会儿需要考虑一下等于零的情况
//                // 已经达到目标金额，拆分订单
//                ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
//                BeanUtil.copyProperties(lastTransactionDetail, chinaPnrTransactionDetail);
//                chinaPnrTransactionDetail.setId(IdUtil.simpleUUID());
//                chinaPnrTransactionDetail.setKycNaturalId(kycNaturalId);
//                chinaPnrTransactionDetail.setBatchNo(batchNo);
//                chinaPnrTransactionDetail.setExchangeRate(exchangeRate);
//                chinaPnrTransactionDetail.setSplitSourceAmount(targetAmount);
//                chinaPnrTransactionDetail.setSplitAmount(targetAmount.multiply(exchangeRate));
//                chinaPnrTransactionDetail.setSplitFlag(true);
//                chinaPnrTransactionDetail.setTradeDate(tradeDate);
//                chinaPnrTransactionDetail.setCreateId("sys");
//                chinaPnrTransactionDetail.setCreateName("sys");
//                chinaPnrTransactionDetail.setCreateDts(new Date());
//                insertDetailList.add(chinaPnrTransactionDetail);
//                targetAmount = new BigDecimal(0);
//            }
//        }
//        if (targetAmount.compareTo(new BigDecimal(0)) > 0) {
//             return useNewSettlementReportRestore(batchNo, kycNaturalId, targetAmount, exchangeRate, tradeDate, settlementDatas, canUseSettlementIds, groupMap, insertDetailList);
//        } else {
//            return targetAmount;
//        }
//    }
//
//    /**
//     * 成功直接返回本次成功的批次号，失败的话返回 0
//     *
//     * @param targetAmount 总需要还原的订单
//     * @param currencyCode
//     * @param tradeDate
//     * @param insertTransactionList 本次交易备案
//     * @param insertDetailList 全部订单明细
//     * @param parameter
//     * @param sumbatch 总批次
//     * @param batch 当前批次
//     * @param details 本批次要使用的明细
//     * @return
//     */
//    private int sentReqeust(String kycNaturalId, String batchNo, BigDecimal targetAmount, String currencyCode, Date tradeDate,
//                            List<ChinaPNRTransaction> insertTransactionList,
//                            List<ChinaPnrTransactionDetail> insertDetailList, Map<String, Object> parameter,
//                            int sumbatch, int batch, List<ChinaPnrTransactionDetail> details) {
//        parameter.put("RECEIPT_ID", "");
//        parameter.put("BATCH_NO", batchNo); // TODO 需要从别的地方拿
//        parameter.put("ORD_NUM", batch + "/" + sumbatch);
//        batch++;
//        parameter.put("REQTIME", DateUtil.format(tradeDate, "yyyyMMddHHmmss"));
//        parameter.put("PAY_CUR", currencyCode);
//        parameter.put("SUM_CNT", insertDetailList.size() + "");
//        parameter.put("SUM_AMT", (targetAmount.multiply(new BigDecimal(100))).intValue() + "");
//        BigDecimal reduce = details.stream()
//                .map(ChinaPnrTransactionDetail::getSplitSourceAmount)
//                .reduce(new BigDecimal(0), BigDecimal::add);
//        parameter.put("PAY_TCNT",details.size() + "");
//        parameter.put("PAY_TAMT",(reduce.multiply(new BigDecimal(100))).intValue() + "");
////        parameter.put("EXT1",);
////        parameter.put("EXT2",);
//        parameter.put("REVIEW_URL", "需要本地映射一个。");
//        // 已废弃，随便传一个值即可。
//        parameter.put("RESULT_URL", "xxxxxxx");
//        StringBuilder detailsStr = getDetailStr(details, currencyCode);
//        parameter.put("DETAILS", detailsStr.toString());   // TODO 大于 5000 需要分批
//
//        HttpClientServiceImpl httpClient = new HttpClientServiceImpl();
//        SimpleHttpsClientImpl shci = new SimpleHttpsClientImpl();
//        httpClient.setHttpsClient(shci);
//
//        String requestXml = ChinaPNRCommons.transferToXML(parameter, ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TRXTYPE_BA"));
//
//        Document doc = XMLUtil.str2Doc(requestXml,"utf-8");
//        try {
//            SignatureUtil.xmlSignature(doc,
//                    ChinaPNRCommons.getPropertiesParam("CHINA_PNR_ENVTYPE"),
//                    ChinaPNRCommons.getPropertiesParam("CHINA_PNR_MERCHANTID")
//                            .substring(0, ChinaPNRCommons.getPropertiesParam("CHINA_PNR_MERCHANTID").length()-2),
//                    ChinaPNRCommons.getPropertiesParam("CHINA_PNR_PASSWORD"),
//                    ChinaPNRCommons.getPropertiesParam("CHINA_PNR_ALIASNAME"));
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        requestXml = XMLUtil.doc2Str(doc,"utf-8");
//        String postUrl = ChinaPNRCommons.getPropertiesParam("CHINA_PNR_POSTURL");
//        HttpRequestContext context = new HttpRequestContext();
//        context.setUrl(postUrl);
//        context.setHttpMethod(HttpRequestContext.POST_METHOD);
//        context.setResponseCharset("utf-8");
//        context.setRequestCharset("utf-8");
//        context.setXml(requestXml);
//
//        HttpSendResult result = null;
//        try {
//            result = httpClient.sendRequest(context);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        if (null == result) {
//            log.info("网关系统异常------");
//            return 0;
//        } else {
//            if (result.getStatus() == 200) {
//                String respTxt = result.getResponseBody();
//                // JSONObject jsonObject = JSONUtil.parseFromXml(respTxt);
//                Document document = XmlUtil.parseXml(respTxt);
//                XmlUtil.getElement(document.getDocumentElement(), "STATUS");
//                Node params = (Node) XmlUtil.getByXPath("/RESPONSE/PARAMS", document, XPathConstants.NODE);
//                String status = (String) XmlUtil.getByXPath("STATUS", params, XPathConstants.STRING);
//                // String code = (String) XmlUtil.getByXPath("ERRERCODE", params, XPathConstants.STRING);
//                // String msg = (String) XmlUtil.getByXPath("ERRERMSG", params, XPathConstants.STRING);
//                if (status.equals("1")) {
//                    // 备案成，生成备案明细对象
//                    ChinaPNRTransaction chinaPNRTransaction = new ChinaPNRTransaction();
//                    chinaPNRTransaction.setId(IdUtil.simpleUUID());
//                    chinaPNRTransaction.setKycNaturalId(kycNaturalId);
//                    // TODO
//                    // chinaPNRTransaction.setReceiptId("");
//                    chinaPNRTransaction.setBatchNo(batchNo);
//                    chinaPNRTransaction.setOrdNum((batch - 1) + "/" + sumbatch);
//                    chinaPNRTransaction.setReqtime(tradeDate);
//                    chinaPNRTransaction.setPayCur(currencyCode);
//                    chinaPNRTransaction.setSumCnt(new BigDecimal(insertDetailList.size()));
//                    chinaPNRTransaction.setSumAmt(targetAmount.multiply(new BigDecimal(100)));
//                    chinaPNRTransaction.setPayTcnt(new BigDecimal(details.size()));
//                    chinaPNRTransaction.setPayTamt(reduce.multiply(new BigDecimal(100)));
//                    chinaPNRTransaction.setExt1("");
//                    chinaPNRTransaction.setExt2("");
//                    chinaPNRTransaction.setResultUrl("");
//                    chinaPNRTransaction.setResultUrl("");
//                    chinaPNRTransaction.setRequestMessage(requestXml);
//                    chinaPNRTransaction.setResponseMessage(respTxt);
//                    chinaPNRTransaction.setCreateId("sys");
//                    chinaPNRTransaction.setCreateName("sys");
//                    chinaPNRTransaction.setCreateDts(new Date());
//                    chinaPNRTransaction.setDelFlag(false);
//                    chinaPNRTransaction.setJsRemark("");
//                    insertTransactionList.add(chinaPNRTransaction);
//                    // 给相关的明细增加关联
//                    for (ChinaPnrTransactionDetail detail : details) {
//                        detail.setTransactionId(chinaPNRTransaction.getId());
//                    }
//                    // 备案成功直接返回本次的批次号
//                    return batch;
//                } else {
//                    log.error(respTxt);
//                    return 0;
//                }
//            } else {
//                log.info("网关系统异常,状态码[" + result.getStatus() + "]");
//                return 0;
//            }
//        }
//    }
//
//    /**
//     * 使用新的结算报告进行还原
//     *
//     * @param batchNo
//     * @param kycNaturalId
//     * @param targetAmount
//     * @param exchangeRate
//     * @param tradeDate
//     * @param settlementDatas
//     * @param canUseSettlementIds
//     * @param groupMap
//     * @param insertDetailList
//     */
//    private BigDecimal useNewSettlementReportRestore(String batchNo, String kycNaturalId, BigDecimal targetAmount, BigDecimal exchangeRate,
//                                               Date tradeDate, List<JsSyncAmazonSettlementReport> settlementDatas,
//                                               List<String> canUseSettlementIds,
//                                               Map<String, Map<String, List<JsSyncAmazonSettlementReport>>> groupMap,
//                                               List<ChinaPnrTransactionDetail> insertDetailList) {
//            // 按时间升序排列，优先使用较早的订单
//        List<String> newCanUseSettlementIds = settlementDatas.stream()
//                .filter(e -> canUseSettlementIds.contains(e.getSettlementId()))
//                .sorted((a, b) -> {
//                    if (a.getDepositDate().getTime() > b.getDepositDate().getTime()) {
//                        return 1;
//                    } else if (a.getDepositDate().getTime() == b.getDepositDate().getTime()) {
//                        return 0;
//                    } else {
//                        return -1;
//                    }
//                }).map(JsSyncAmazonSettlementReport::getSettlementId)
//                .collect(Collectors.toList());
//        return calOrderRestoration(batchNo, kycNaturalId, targetAmount, exchangeRate, tradeDate, groupMap, insertDetailList, newCanUseSettlementIds);
//    }
//
//    /**
//     * 递归计算订单还原
//     *
//     * @param kycNaturalId
//     * @param targetAmount
//     * @param exchangeRate
//     * @param tradeDate
//     * @param groupMap
//     * @param insertDetailList
//     * @param newCanUseSettlementIds
//     */
//    private BigDecimal calOrderRestoration(String batchNo,  String kycNaturalId, BigDecimal targetAmount, BigDecimal exchangeRate, Date tradeDate,
//                                     Map<String, Map<String, List<JsSyncAmazonSettlementReport>>> groupMap,
//                                     List<ChinaPnrTransactionDetail> insertDetailList, List<String> newCanUseSettlementIds) {
//        if (newCanUseSettlementIds.size() > 0) {
//            // 还有可以使用的新结算报告，继续计算
//            String settlementId = newCanUseSettlementIds.remove(0);
//            Map<String, List<JsSyncAmazonSettlementReport>> stringListMap = groupMap.get(settlementId);
//            List<JsSyncAmazonSettlementReport> sumReportList1 = getSumReportList(stringListMap);
//            List<JsSyncAmazonSettlementReport> items = sumReportList1.stream()
//                    .filter(e -> e.getTotalAmount() == null)
//                    .collect(Collectors.toList());
//            targetAmount = orderRestoration(batchNo, kycNaturalId, targetAmount, exchangeRate, tradeDate, items, insertDetailList);
//            if (targetAmount.compareTo(new BigDecimal(0)) == 0) {
//                // 结束本次计算
//                log.info("订单还原计算成功");
//                return targetAmount;
//            } else {
//                // 递归，使用一个新的结算报告
//                return calOrderRestoration(batchNo, kycNaturalId, targetAmount, exchangeRate, tradeDate, groupMap, insertDetailList, newCanUseSettlementIds);
//            }
//        } else {
//            // 剩下的结算报告不够了。打印日志，抛异常
//            log.error("结算报告不足以进行订单还原。当前用户: {}", kycNaturalId);
//            insertDetailList.clear();
//            LogicException.le(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR);
//            return targetAmount;
//        }
//    }
//
//    private BigDecimal orderRestoration(String batchNo, String kycNaturalId, BigDecimal targetAmount, BigDecimal exchangeRate, Date tradeDate,
//                                  List<JsSyncAmazonSettlementReport> remainItem, List<ChinaPnrTransactionDetail> insertDetailList) {
//        // 排序，负值在前正值在后,防止还原订单时金额超出订单总金额
//        remainItem = remainItem.stream()
//                .sorted(Comparator.comparing(JsSyncAmazonSettlementReport::getPriceAmount))
//                .collect(Collectors.toList());
//        for (JsSyncAmazonSettlementReport settlementReport : remainItem) {
//            if(targetAmount.compareTo(settlementReport.getPriceAmount()) > 0) {
//                // 订单金额不足目标金额
//                targetAmount = targetAmount.subtract(settlementReport.getPriceAmount());
//                ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
//                chinaPnrTransactionDetail.setId(IdUtil.simpleUUID());
//                chinaPnrTransactionDetail.setKycNaturalId(kycNaturalId);
//                chinaPnrTransactionDetail.setStoreId(settlementReport.getStoreId());
//                chinaPnrTransactionDetail.setBatchNo(batchNo);
//                chinaPnrTransactionDetail.setSku(settlementReport.getSku());
//                chinaPnrTransactionDetail.setTransactionType(settlementReport.getTransactionType());
//                chinaPnrTransactionDetail.setSettlementId(settlementReport.getSettlementId());
//                chinaPnrTransactionDetail.setOrderItemCode(settlementReport.getOrderItemCode());
//                chinaPnrTransactionDetail.setCurrencyCode("USD");
//                chinaPnrTransactionDetail.setOrderPriceTotal(settlementReport.getPriceAmount());
//                chinaPnrTransactionDetail.setExchangeRate(exchangeRate);
//                chinaPnrTransactionDetail.setSplitSourceAmount(settlementReport.getPriceAmount());
//                chinaPnrTransactionDetail.setSplitAmount(settlementReport.getPriceAmount().multiply(exchangeRate));
//                chinaPnrTransactionDetail.setSplitFlag(false);
//                chinaPnrTransactionDetail.setPostedDate(settlementReport.getPostedDate());
//                chinaPnrTransactionDetail.setTradeDate(tradeDate);
//                chinaPnrTransactionDetail.setCreateId("sys");
//                chinaPnrTransactionDetail.setCreateName("sys");
//                chinaPnrTransactionDetail.setCreateDts(new Date());
//                chinaPnrTransactionDetail.setDelFlag(false);
//                insertDetailList.add(chinaPnrTransactionDetail);
//            } else {
//                // 订单金额足够，开始拆分账单
//                ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
//                chinaPnrTransactionDetail.setId(IdUtil.simpleUUID());
//                chinaPnrTransactionDetail.setKycNaturalId(kycNaturalId);
//                chinaPnrTransactionDetail.setStoreId(settlementReport.getStoreId());
//                chinaPnrTransactionDetail.setBatchNo(batchNo);
//                chinaPnrTransactionDetail.setSku(settlementReport.getSku());
//                chinaPnrTransactionDetail.setTransactionType(settlementReport.getTransactionType());
//                chinaPnrTransactionDetail.setSettlementId(settlementReport.getSettlementId());
//                chinaPnrTransactionDetail.setOrderItemCode(settlementReport.getOrderItemCode());
//                chinaPnrTransactionDetail.setCurrencyCode("USD");
//                chinaPnrTransactionDetail.setOrderPriceTotal(settlementReport.getPriceAmount());
//                chinaPnrTransactionDetail.setExchangeRate(exchangeRate);
//                chinaPnrTransactionDetail.setSplitSourceAmount(targetAmount);
//                chinaPnrTransactionDetail.setSplitAmount(targetAmount.multiply(exchangeRate));
//                chinaPnrTransactionDetail.setSplitFlag(true);
//                chinaPnrTransactionDetail.setPostedDate(settlementReport.getPostedDate());
//                chinaPnrTransactionDetail.setTradeDate(tradeDate);
//                chinaPnrTransactionDetail.setCreateId("sys");
//                chinaPnrTransactionDetail.setCreateName("sys");
//                chinaPnrTransactionDetail.setCreateDts(new Date());
//                chinaPnrTransactionDetail.setDelFlag(false);
//                targetAmount = new BigDecimal(0);
//                insertDetailList.add(chinaPnrTransactionDetail);
//                return targetAmount;
//            }
//        }
//        return targetAmount;
//    }
//
//    private List<JsSyncAmazonSettlementReport> getSumReportList(Map<String, List<JsSyncAmazonSettlementReport>> lastSettlementReport) {
//        List<JsSyncAmazonSettlementReport> sumReportList = new ArrayList<>();
//        for (Map.Entry<String, List<JsSyncAmazonSettlementReport>> stringListEntry : lastSettlementReport.entrySet()) {
//            if (!stringListEntry.getKey().equals("settlementData")) {
//                List<JsSyncAmazonSettlementReport> value = stringListEntry.getValue();
//                JsSyncAmazonSettlementReport sumReport = getSumReport(value);
//                if (stringListEntry.getKey().equals("other")) {
//                    sumReport.setOrderItemCode("other");
//                    sumReport.setTransactionType("other");
//                    sumReport.setSku("other");
//                }
//                sumReportList.add(sumReport);
//            }
//        }
//        return sumReportList;
//    }
//
//    private List<JsSyncAmazonSettlementReport> getCanUseSettlementReports(String kycNaturalId, List<String> canUseSettlementIds, String lastSettlementId) {
//        Example example = new Example(JsSyncAmazonSettlementReport.class);
//        Example.Criteria criteria = example.createCriteria();
//        List<String> condition = new ArrayList<>();
//        condition.addAll(canUseSettlementIds);
//        if (lastSettlementId != null) {
//            condition.add(lastSettlementId);
//        }
//        criteria.andIn("settlementId", condition);
//        criteria.andEqualTo("kycNaturalId", kycNaturalId);
//        return jsSyncAmazonSettlementReportMapper.selectByExample(example);
//    }
//
//    private List<ChinaPnrTransactionDetail> getChinaPnrTransactionDetails(String kycNaturalId, ZonedDateTime start, ZonedDateTime end) {
//        Example example = new Example(ChinaPnrTransactionDetail.class);
//        example.setOrderByClause("trade_date desc");
//        Example.Criteria criteria = example.createCriteria();
//        criteria.andEqualTo("kycNaturalId", kycNaturalId);
//        criteria.andGreaterThanOrEqualTo("tradeDate", Date.from(start.toInstant()));
//        criteria.andLessThanOrEqualTo("tradeDate", Date.from(end.toInstant()));
//        return chinaPnrTransactionDetailMapper.selectByExample(example);
//    }
//
//    private List<JsSyncAmazonSettlementReport> getSettlementDatas(String kycNaturalId, ZonedDateTime start, ZonedDateTime end) {
//        Example example = new Example(JsSyncAmazonSettlementReport.class);
//        Example.Criteria criteria = example.createCriteria();
//        criteria.andEqualTo("kycNaturalId", kycNaturalId);
//        criteria.andGreaterThanOrEqualTo("depositDate", Date.from(start.toInstant()));
//        criteria.andLessThanOrEqualTo("depositDate", Date.from(end.toInstant()));
//        // 这个查出来的应该都是结算汇总的那条记录。
//        return jsSyncAmazonSettlementReportMapper.selectByExample(example);
//    }
//
//    /**
//     * 计算上次订单还原后还未用完的明细 code
//     *
//     * @param transactionDetails 订单还原明细
//     * @param start 订单还原明细开始时间
//     * @return
//     */
//    private ChinaPnrTransactionDetail getLastTransactionDetails(List<ChinaPnrTransactionDetail> transactionDetails, ZonedDateTime start) {
//        // 获取全部被拆分的明细,按时间降序排列
//        List<ChinaPnrTransactionDetail> detailList = transactionDetails.stream()
//                .filter(ChinaPnrTransactionDetail::getSplitFlag)
//                .sorted((a, b) -> {
//                    if (a.getTradeDate().getTime() - b.getTradeDate().getTime() > 0) {
//                        return -1;
//                    } else if (a.getTradeDate().getTime() - b.getTradeDate().getTime() == 0) {
//                        return 0;
//                    } else {
//                        return 1;
//                    }
//                })
//                .collect(Collectors.toList());
//        if (detailList.size() == 0) {
//            // 没有订单还原过，或者间两次还原间隔时间超过三个月了。。
//            return null;
//        } else {
//            return detailList.get(0);
//        }
//    }
//
//    private void filterUsedSettlementId(Map<String, List<ChinaPnrTransactionDetail>> listMap, ZonedDateTime start) {
//        Example example = new Example(ChinaPnrTransactionDetail.class);
//        Example.Criteria criteria = example.createCriteria();
//        criteria.andLessThan("tradeDate", Date.from(start.toInstant()));
//        ArrayList ids = new ArrayList(listMap.keySet());
//        criteria.andIn("settlementId", ids);
//        List<ChinaPnrTransactionDetail> chinaPnrTransactionDetails = chinaPnrTransactionDetailMapper.selectByExample(example);
//        for (ChinaPnrTransactionDetail chinaPnrTransactionDetail : chinaPnrTransactionDetails) {
//            if(ids.contains(chinaPnrTransactionDetail.getSettlementId())) {
//                listMap.remove(ids);
//            }
//        }
//    }
//
//    private StringBuilder getDetailStr(List<ChinaPnrTransactionDetail> details, String currencyCode) {
//        StringBuilder detailsStr = new StringBuilder();
//        for (ChinaPnrTransactionDetail detail : details) {
//            // 明细流水号
//            detailsStr.append(detail.getId()).append("|");
//            // 订单编号
//            detailsStr.append(detail.getOrderItemCode()).append("|");
//            // 业务日期
//            detailsStr.append(DateUtil.format(detail.getPostedDate(), "yyyyMMddHHmmss")).append("|");
//            // 收款方类型
//            detailsStr.append("P").append("|"); // 硬编码
//            // 收款人证件类别
//            detailsStr.append("00").append("|"); // 硬编码
//            // 收款人证件号
//            detailsStr.append("342501198706287630").append("|"); // TODO 需要拿用户身份证号
//            // 收款人名称
//            detailsStr.append("张三").append("|");
//            // 收款人帐号
//            detailsStr.append("6465767887999").append("|");
//            // 收款银行代码或名称
//            detailsStr.append("CMB").append("|");
//            // 付款币种
//            detailsStr.append(currencyCode).append("|");
//            // 付款金额
//            detailsStr.append((detail.getSplitSourceAmount().multiply(new BigDecimal(100)).intValue())).append("|");
//            // 商品描述
//            detailsStr.append(detail.getSku()).append("|");
//            // 备注
//            detailsStr.append("note").append("\n");
//        }
//        if (detailsStr.length() > 0) {
//            detailsStr.deleteCharAt(detailsStr.length()-1);
//        }
//        return detailsStr;
//    }
//
//    private JsSyncAmazonSettlementReport getSumReport(List<JsSyncAmazonSettlementReport> value) {
//        // 合并商品对象。将所有价格统一到 priceAmount 字段上。
//        JsSyncAmazonSettlementReport sumReport = new JsSyncAmazonSettlementReport();
//        sumReport.setPriceAmount(new BigDecimal(0));
//        for (JsSyncAmazonSettlementReport settlementReport : value) {
//            sumReport.setOrderItemCode(settlementReport.getOrderItemCode());
//            sumReport.setReportId(settlementReport.getReportId());
//            sumReport.setSettlementId(settlementReport.getSettlementId());
//            sumReport.setMarketplaceName(settlementReport.getMarketplaceName());
//            sumReport.setTransactionType(settlementReport.getTransactionType());
//            sumReport.setSku(settlementReport.getSku());
//            sumReport.setPostedDate(settlementReport.getPostedDate());
//            if (ObjectUtil.isNotEmpty(settlementReport.getShipmentFeeAmount())) {
//                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getShipmentFeeAmount()));
//            }
//            if (ObjectUtil.isNotEmpty(settlementReport.getOrderFeeAmount())) {
//                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getOrderFeeAmount()));
//            }
//            if (ObjectUtil.isNotEmpty(settlementReport.getPriceAmount())) {
//                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getPriceAmount()));
//            }
//            if (ObjectUtil.isNotEmpty(settlementReport.getItemRelatedFeeAmount())) {
//                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getItemRelatedFeeAmount()));
//            }
//            if (ObjectUtil.isNotEmpty(settlementReport.getMiscFeeAmount())) {
//                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getMiscFeeAmount()));
//            }
//            if (ObjectUtil.isNotEmpty(settlementReport.getOtherFeeAmount())) {
//                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getOtherFeeAmount()));
//            }
//            if (ObjectUtil.isNotEmpty(settlementReport.getDirectPaymentAmount())) {
//                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getDirectPaymentAmount()));
//            }
//            if (ObjectUtil.isNotEmpty(settlementReport.getOtherAmount())) {
//                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getOtherAmount()));
//            }
//            if (ObjectUtil.isNotEmpty(settlementReport.getPromotionAmount())) {
//                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getPromotionAmount()));
//            }
//        }
//        return sumReport;
//    }
//}
