package com.js.pay.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiKycDictionaryService;
import com.js.common.constant.Constant;
import com.js.common.model.req.KycDictionaryReq;
import com.js.common.model.vo.KycDictionaryVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.KycDictionaryMapper;
import com.js.dal.dao.model.KycDictionary;
import com.js.dal.dao.plugin.PageModel;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName: ApiKycDictionaryServiceImpl
 * @Description: 字典表具体实现
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiKycDictionaryServiceImpl extends IBaseServiceImpl<KycDictionary> implements ApiKycDictionaryService {
    @Override
    public ResponseMessage findDictionary(String type,String code) {
        log.info("查詢字典表入參type ：{},字典编码：{}",type,code);
        Example example = new Example(KycDictionary.class);
        Example.Criteria criteria = example.createCriteria();
        if(StringUtils.isNotBlank(type)){
            criteria.andEqualTo("type",type);
        }
        if(StringUtils.isNotBlank(code)){
            criteria.andEqualTo("code",code);
        }
        criteria.andEqualTo("availableFlag", true);
        criteria.andEqualTo("delFlag", false);
        example.setOrderByClause("type,sort");
        List<KycDictionary> kycDictionaries = iBaseMapper.selectByExample(example);
        log.info("字典表根据条件查找到信息条数：{}" , kycDictionaries.size());
        return ResultUtil.success(kycDictionaries);
    }

    @Override
    public String getKycDictionaryRootList(KycDictionaryReq kycDictionaryReq){
        PageModel pageModel = new PageModel();
        Example example = new Example(KycDictionary.class);
        example.setOrderByClause("type,sort");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        if (ObjectUtil.isNotEmpty(kycDictionaryReq.getType())) {
            criteria.andEqualTo("type", kycDictionaryReq.getType());
        }
        if (ObjectUtil.isNotEmpty(kycDictionaryReq.getName())) {
            criteria.andLike("name", "%" + kycDictionaryReq.getName() + "%");
        }
        if (ObjectUtil.isNotEmpty(kycDictionaryReq.getAvailableFlag())) {
            criteria.andEqualTo("availableFlag", kycDictionaryReq.getAvailableFlag());
        }
        PageHelper.startPage(kycDictionaryReq.getPageIndex(), kycDictionaryReq.getPageSize());
        List<KycDictionary> kycDictionaries = iBaseMapper.selectByExample(example);
        PageInfo<KycDictionary> pageInfo = new PageInfo<>(kycDictionaries);
        long count = pageInfo.getTotal();
        if(count <= 0) {
            pageModel.setMsg("暂无数据");
            return JSON.toJSONString(pageModel);
        }
        if(!ObjectUtil.isEmpty(kycDictionaries)) {
            List<KycDictionaryVO> kycDictionaryVOS = new ArrayList<>();
            kycDictionaries.stream().forEach(kycDictionary -> {
                KycDictionaryVO kycDictionaryVO = new KycDictionaryVO();
                BeanUtils.copyProperties(kycDictionary,kycDictionaryVO);
                kycDictionaryVO.setCreateDtsStr(DateUtil.format(kycDictionary.getCreateDts(), "yyyy-MM-dd HH:mm:ss"));
                kycDictionaryVO.setUpdateDtsStr(DateUtil.format(kycDictionary.getUpdateDts(), "yyyy-MM-dd HH:mm:ss"));
                kycDictionaryVOS.add(kycDictionaryVO);
            });
            pageModel.setList(kycDictionaryVOS);
        }
        pageModel.setCount(new Integer((int)count));
        pageModel.setMsg("ok");
        pageModel.setRel(true);
        return JSON.toJSONString(pageModel);
    }

    @Override
    public int addKycDictionary(KycDictionaryReq kycDictionaryReq) {
        KycDictionary kycDictionary = new KycDictionary();
        BeanUtils.copyProperties(kycDictionaryReq,kycDictionary);
        kycDictionary.setId(IdUtil.simpleUUID());
        kycDictionary.setCreateId("SYSTEM");
        kycDictionary.setCreateName("系统");
        int insertCount = iBaseMapper.insertSelective(kycDictionary);
        log.info("新增字典表条数：{}",insertCount);
        return insertCount;
    }

    @Override
    public int updateKycDictionary(KycDictionaryReq kycDictionaryReq) {
        if(StringUtils.isBlank(kycDictionaryReq.getId())){
            log.error("主键ID为空，不可以走编辑方法");
            return 0;
        }
        KycDictionary kycDictionary = new KycDictionary();
        BeanUtils.copyProperties(kycDictionaryReq,kycDictionary);
        kycDictionary.setUpdateId("SYSTEM");
        kycDictionary.setUpdateName("系统");
        int updateCount = iBaseMapper.updateByPrimaryKeySelective(kycDictionary);
        log.info("更新字典表条数：{}",updateCount);
        return updateCount;
    }

    @Override
    public KycDictionaryVO getDictionary(String id) {
        KycDictionary kycDictionary = iBaseMapper.selectByPrimaryKey(id);
        if(null == kycDictionary){
            return new KycDictionaryVO();
        }
        KycDictionaryVO kycDictionaryVO = new KycDictionaryVO();
        BeanUtils.copyProperties(kycDictionary,kycDictionaryVO);
        return kycDictionaryVO;
    }
}
