package com.js.pay.service.chinapnr.impl;

import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.ChinaPNREnterpriseOpenAccountReq;
import com.js.common.model.req.ChinaPNRPersonalOpenAccountReq;
import com.js.common.model.req.ChinaPNRQueryOpenAccountReq;
import com.js.common.model.vo.ChinaPNROpenAccountVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.FileMngForOSSUtil;
import com.js.common.util.RedisUtil;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.ChinaPNROpenAccountMapper;
import com.js.dal.dao.mapper.ChinaPNRTradingFlowMapper;
import com.js.dal.dao.model.ChinaPNROpenAccount;
import com.js.dal.dao.model.ChinaPNRTradingFlow;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.JsFileForOSSSerivce;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;
import java.util.UUID;

/**
 * @Description:汇付天下开户
 * @Author: zhouyongsheng
 * @Create: 2019-06-10
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ChinaPNRPayOpenAccountServiceImpl extends IBaseServiceImpl<ChinaPNROpenAccount> implements ChinaPNRPayOpenAccountService {

    @Autowired
    private ChinaPNROpenAccountMapper chinaPNROpenAccountMapper;

    @Autowired
    private ChinaPNRTradingFlowMapper chinaPNRTradingFlowMapper;

    @Autowired
    JsFileForOSSSerivce jsFileForOSSSerivce;

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount chinaPNROpenAccount;

    /**
     * 个人开户
     * @param chinaPNRPersonalOpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage personalOpenAccount(ChinaPNRPersonalOpenAccountReq chinaPNRPersonalOpenAccountReq) {

        //获取汇付银行代码
        String bankCode = redisUtil.get(Constant.REDIS_JS_PAY_BANCK + chinaPNRPersonalOpenAccountReq.getBankCode() +"_010");
        if(null == bankCode || "".equals(bankCode)){
            log.info("个人开户汇付银行代码获取失败,请核实");
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getCode(),"汇付银行代码获取失败,请核实");
        }else{
            chinaPNRPersonalOpenAccountReq.setBankCode(bankCode);
        }

        //个人开户
        log.info("汇付个人信息开户 执行 " + chinaPNRPersonalOpenAccountReq.toString()) ;

        if(StringUtils.isNotBlank(chinaPNRPersonalOpenAccountReq.getCertPhotoCopyF())){
            chinaPNRPersonalOpenAccountReq.setCertPhotoCopyF(FileMngForOSSUtil.findFileBase64(jsFileForOSSSerivce.findFile(chinaPNRPersonalOpenAccountReq.getCertPhotoCopyF())));
        }
        if(StringUtils.isNotBlank(chinaPNRPersonalOpenAccountReq.getCertPhotoCopyB())){
            chinaPNRPersonalOpenAccountReq.setCertPhotoCopyB(FileMngForOSSUtil.findFileBase64(jsFileForOSSSerivce.findFile(chinaPNRPersonalOpenAccountReq.getCertPhotoCopyB())));
        }
        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccountSel = new ChinaPNROpenAccount();
        chinaPNROpenAccountSel.setKycNaturalId(chinaPNRPersonalOpenAccountReq.getKycNaturalId());
        chinaPNROpenAccountSel.setOpenAccountType(CommonConstant.CHINA_OPEN_ACCOUNT_TYPE_PERSONAL);
        chinaPNROpenAccountSel = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccountSel);

        if(null != chinaPNROpenAccountSel){
            //判断是否是审核中和开户成功状态
            if(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING.equals(chinaPNROpenAccountSel.getResult())
                    || CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS.equals(chinaPNROpenAccountSel.getResult())){
                return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
            }else{
                return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getCode(),"该用户开户信息已经存在,该用户开户失败,请核实");
            }
        }
        //请求开户
        Map<String,String> payMap = chinaPNROpenAccount.personalOpenAccount(chinaPNRPersonalOpenAccountReq);
        log.info("个人开户返回结果 payMap:{}" ,payMap);
        //创建开户流水信息和开户信息
        ChinaPNRTradingFlow chinaPNRTradingFlow = new ChinaPNRTradingFlow();
        chinaPNRTradingFlow.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        chinaPNRTradingFlow.setJsTradingFlowId(chinaPNRPersonalOpenAccountReq.getRequestId());
        chinaPNRTradingFlow.setKycNaturalId(chinaPNRPersonalOpenAccountReq.getKycNaturalId());
        chinaPNRTradingFlow.setTransactionType("0"); //0添加
        chinaPNRTradingFlow.setTransactionTime(new Date());
        if(!payMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            chinaPNRTradingFlow.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
        }else{
            chinaPNRTradingFlow.setResult(payMap.get("result"));
        }
        chinaPNRTradingFlow.setRequestMessage(payMap.get("reqText"));
        chinaPNRTradingFlow.setCreateDts(new Date());
        chinaPNRTradingFlow.setUpdateDts(new Date());
        chinaPNRTradingFlow.setResponseMessage(payMap.get("resText"));
        chinaPNRTradingFlowMapper.insertSelective(chinaPNRTradingFlow);

        ChinaPNROpenAccount newChinaPNROpenAccount = new ChinaPNROpenAccount();
        newChinaPNROpenAccount.setCertId(UUID.randomUUID().toString().replaceAll("-", ""));
        newChinaPNROpenAccount.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        newChinaPNROpenAccount.setJsOpenAccountNo(chinaPNRPersonalOpenAccountReq.getJsOpenAccountNo());
        newChinaPNROpenAccount.setKycNaturalId(chinaPNRPersonalOpenAccountReq.getKycNaturalId());
        newChinaPNROpenAccount.setName(chinaPNRPersonalOpenAccountReq.getName());
        newChinaPNROpenAccount.setCertType(chinaPNRPersonalOpenAccountReq.getCertType());
        newChinaPNROpenAccount.setCertId(chinaPNRPersonalOpenAccountReq.getCertId());
        newChinaPNROpenAccount.setCertExpDateEnd(chinaPNRPersonalOpenAccountReq.getCertExpDateEnd());
        newChinaPNROpenAccount.setMobileNumber(chinaPNRPersonalOpenAccountReq.getMobileNumber());
        newChinaPNROpenAccount.setEmail(chinaPNRPersonalOpenAccountReq.getEmail());
        newChinaPNROpenAccount.setBankCode(chinaPNRPersonalOpenAccountReq.getBankCode());
        newChinaPNROpenAccount.setAcctType("2"); //2对私
        newChinaPNROpenAccount.setBankAcct(chinaPNRPersonalOpenAccountReq.getBankAcct());
        newChinaPNROpenAccount.setAcctName(chinaPNRPersonalOpenAccountReq.getAcctName());
        newChinaPNROpenAccount.setAddress(chinaPNRPersonalOpenAccountReq.getAddress());
        if(payMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            //开户成功或审核中
            if(payMap.get("result").equals(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS)
                    || payMap.get("result").equals(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING)){
                newChinaPNROpenAccount.setChinaPnrOpenAccountNo(payMap.get("chinaPNRUserId"));
            }else{
                newChinaPNROpenAccount.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            }
        }else{
            newChinaPNROpenAccount.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
        }
        newChinaPNROpenAccount.setOpenAccountType(CommonConstant.CHINA_OPEN_ACCOUNT_TYPE_PERSONAL);
        newChinaPNROpenAccount.setOpenAccountDate(new Date());
        newChinaPNROpenAccount.setUpdateDts(new Date());
        chinaPNROpenAccountMapper.insertSelective(newChinaPNROpenAccount);
        if(!payMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        if(payMap.get("result").equals(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR)){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }else{
            return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
        }
    }

    /**
     * 企业开户
     * @param chinaPNROpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage enterpriseOpenAccount(ChinaPNREnterpriseOpenAccountReq chinaPNROpenAccountReq) {
        //个人开户
        log.info("汇付企业信息开户 执行  " + chinaPNROpenAccountReq.toString()) ;

        //获取汇付银行代码
        String bankCode = redisUtil.get(Constant.REDIS_JS_PAY_BANCK + chinaPNROpenAccountReq.getBankCode() +"_010");
        if(null == bankCode || "".equals(bankCode)){
            log.info("企业开户汇付银行代码获取失败,请核实");
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getCode(),"汇付银行代码获取失败,请核实");
        }else{
            chinaPNROpenAccountReq.setBankCode(bankCode);
        }

        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccountSel = new ChinaPNROpenAccount();
        chinaPNROpenAccountSel.setKycNaturalId(chinaPNROpenAccountReq.getKycNaturalId());
        chinaPNROpenAccountSel.setOpenAccountType(CommonConstant.CHINA_OPEN_ACCOUNT_TYPE_ENTERPRISE);
        chinaPNROpenAccountSel = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccountSel);

        //图片转换BASE64
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getLegalCertPhotoCopyF())){
            chinaPNROpenAccountReq.setLegalCertPhotoCopyF(FileMngForOSSUtil.findFileBase64(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getLegalCertPhotoCopyF())));
        }
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getLegalCertPhotoCopyB())){
            chinaPNROpenAccountReq.setLegalCertPhotoCopyB(FileMngForOSSUtil.findFileBase64(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getLegalCertPhotoCopyB())));
        }
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getBizLicensePhotoCopy())){
            chinaPNROpenAccountReq.setBizLicensePhotoCopy(FileMngForOSSUtil.findFileBase64(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getBizLicensePhotoCopy())));
        }
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getOrgPhotoCopy())){
            chinaPNROpenAccountReq.setOrgPhotoCopy(FileMngForOSSUtil.findFileBase64(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getOrgPhotoCopy())));
        }
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getTaxRegPhotoCopy())){
            chinaPNROpenAccountReq.setTaxRegPhotoCopy(FileMngForOSSUtil.findFileBase64(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getTaxRegPhotoCopy())));
        }
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getOpenLicensePhotoCopy())){
            chinaPNROpenAccountReq.setOpenLicensePhotoCopy(FileMngForOSSUtil.findFileBase64(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getOpenLicensePhotoCopy())));
        }
        if(null != chinaPNROpenAccountSel){
            //开户成功或开户审核中
            if(chinaPNROpenAccountSel.getResult().equals(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS)
                    || chinaPNROpenAccountSel.getResult().equals(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING)){
                return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
            }else{
                return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getCode(),"该用户开户信息已经存在,该用户开户失败,请核实");
            }
        }
        //请求开户
        Map<String,String>  payMap = chinaPNROpenAccount.enterpriseOpenAccount(chinaPNROpenAccountReq);
        //创建开户流水信息和开户信息
        ChinaPNRTradingFlow chinaPNRTradingFlow = new ChinaPNRTradingFlow();
        chinaPNRTradingFlow.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        chinaPNRTradingFlow.setKycNaturalId(chinaPNROpenAccountReq.getKycNaturalId());
        chinaPNRTradingFlow.setTransactionType("0"); //添加开户
        chinaPNRTradingFlow.setRequestMessage(payMap.get("reqText"));
        chinaPNRTradingFlow.setJsTradingFlowId(chinaPNROpenAccountReq.getRequestId());
        chinaPNRTradingFlow.setTransactionTime(new Date());
        chinaPNRTradingFlow.setResponseMessage(payMap.get("resText"));
        if(!payMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            chinaPNRTradingFlow.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
        }else{
            chinaPNRTradingFlow.setResult(payMap.get("result"));
        }
        chinaPNRTradingFlow.setCreateDts(new Date());
        chinaPNRTradingFlow.setUpdateDts(new Date());
        chinaPNRTradingFlowMapper.insertSelective(chinaPNRTradingFlow);

        ChinaPNROpenAccount newChinaPNROpenAccount = new ChinaPNROpenAccount();
        newChinaPNROpenAccount.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        newChinaPNROpenAccount.setKycNaturalId(chinaPNROpenAccountReq.getKycNaturalId());
        newChinaPNROpenAccount.setJsOpenAccountNo(chinaPNROpenAccountReq.getJsOpenAccountNo());
        newChinaPNROpenAccount.setName(chinaPNROpenAccountReq.getName());
        newChinaPNROpenAccount.setCertType(chinaPNROpenAccountReq.getLegalCertType());
        newChinaPNROpenAccount.setCertId(chinaPNROpenAccountReq.getLegalCertId());
        newChinaPNROpenAccount.setCertExpDateEnd(chinaPNROpenAccountReq.getLegalCertExpDateEnd());
        newChinaPNROpenAccount.setMobileNumber(chinaPNROpenAccountReq.getPhone());
        newChinaPNROpenAccount.setEmail("");
        newChinaPNROpenAccount.setOpenAccountType(CommonConstant.CHINA_OPEN_ACCOUNT_TYPE_ENTERPRISE);
        newChinaPNROpenAccount.setAcctType(chinaPNROpenAccountReq.getAcctType());
        newChinaPNROpenAccount.setBankAcct(chinaPNROpenAccountReq.getBankAcct());
        newChinaPNROpenAccount.setBankCode(chinaPNROpenAccountReq.getBankCode());
        newChinaPNROpenAccount.setAcctName(chinaPNROpenAccountReq.getAcctName());
        if(payMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            //开户成功或审核中
            if(payMap.get("result").equals(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS)
                     || CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING.equals(payMap.get("result"))){
                newChinaPNROpenAccount.setChinaPnrOpenAccountNo(payMap.get("chinaPNRUserId"));
            }else{
                newChinaPNROpenAccount.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            }
        }else{
            newChinaPNROpenAccount.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
        }
        newChinaPNROpenAccount.setAddress(chinaPNROpenAccountReq.getAddress());
        newChinaPNROpenAccount.setResult(payMap.get("result"));
        newChinaPNROpenAccount.setOpenAccountDate(new Date());
        newChinaPNROpenAccount.setUpdateDts(new Date());
        chinaPNROpenAccountMapper.insertSelective(newChinaPNROpenAccount);
        if(!CommonConstant.CHINA_RESULT_SUCCESS.equals(payMap.get("code"))){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        if(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR.equals(payMap.get("result"))){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }else{
            return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
        }
    }

    /**
     * 个人开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage personalUpdateOpenAccount(ChinaPNRPersonalOpenAccountReq chinaPNROpenAccountReq) {
        return null;
    }

    /**
     * 企业开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage enterpriseUpdateOpenAccount(ChinaPNREnterpriseOpenAccountReq chinaPNROpenAccountReq) {
        return null;
    }

    /**
     * 个人开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage personalQueryOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq) {
        //个人开户
        log.info("汇付个人信息开户查询 执行 userid = " + chinaPNRQueryOpenAccountReq.getKycNaturalId() + "RequestId = " + chinaPNRQueryOpenAccountReq.getRequestId()) ;

        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccountSel = new ChinaPNROpenAccount();
        chinaPNROpenAccountSel.setKycNaturalId(chinaPNRQueryOpenAccountReq.getKycNaturalId());
        chinaPNROpenAccountSel.setOpenAccountType(CommonConstant.CHINA_OPEN_ACCOUNT_TYPE_PERSONAL);
        chinaPNROpenAccountSel.setJsOpenAccountNo(chinaPNRQueryOpenAccountReq.getJsOpenAccountNo());
        chinaPNROpenAccountSel = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccountSel);

        if(null == chinaPNROpenAccountSel){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getCode(),"未查询到个人开户信息");
        }else{
            if(chinaPNROpenAccountSel.getResult().equals(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS)){
                return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
            }
        }
        Map<String,String> resMap = chinaPNROpenAccount.queryPersonalOpenAccount(chinaPNRQueryOpenAccountReq);
        if(!resMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        if(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS.equals(resMap.get("result"))){ //成功
            chinaPNROpenAccountSel.setChinaPnrOpenAccountNo(resMap.get("chinaPNRUserId"));
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS);
        }else if(resMap.get("result").equals(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING)){//审核中
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING);
        }else{
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR); //失败
        }
        chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccountSel);
        return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
    }

    /**
     * 企业开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage enterpriseQueryOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq) {
        //企业开户查询
        log.info("汇付企业信息开户查询 执行 userid = " + chinaPNRQueryOpenAccountReq.getKycNaturalId() + "RequestId = " + chinaPNRQueryOpenAccountReq.getRequestId()) ;

        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccountSel = new ChinaPNROpenAccount();
        chinaPNROpenAccountSel.setKycNaturalId(chinaPNRQueryOpenAccountReq.getKycNaturalId());
        chinaPNROpenAccountSel.setOpenAccountType(CommonConstant.CHINA_OPEN_ACCOUNT_TYPE_ENTERPRISE);
        chinaPNROpenAccountSel.setJsOpenAccountNo(chinaPNRQueryOpenAccountReq.getJsOpenAccountNo());
        chinaPNROpenAccountSel = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccountSel);
        if(null == chinaPNROpenAccountSel){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getCode(),"未查询到企业开户信息");
        }else{
            if(chinaPNROpenAccountSel.getResult().equals(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS)){
                return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
            }
        }
        Map<String,String> resMap = chinaPNROpenAccount.queryEnterpriseOpenAccount(chinaPNRQueryOpenAccountReq);
        if(!CommonConstant.CHINA_RESULT_SUCCESS.equals(resMap.get("code"))){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        if(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS.equals(resMap.get("result"))){ //成功
            chinaPNROpenAccountSel.setChinaPnrOpenAccountNo(resMap.get("chinaPNRUserId"));
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS);
        }else if(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING.equals(resMap.get("result"))){//审核中
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING);
        }else{
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR); //失败
        }
        chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccountSel);
        return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
    }

    /**
     * 企业开户信息回调
     * @param map
     * @return
     */
    @Override
    public ResponseMessage enterpriseCallbackOpenAccount(Map<String, String> map) {

        log.info(" 企业开户信息回调 map:{}" , map) ;
        //验签
        Map<String,String> resMap = chinaPNROpenAccount.callbackEnterpriseOpenAccount(map);

        log.info("企业开户回调返回结果 resMap:{}" ,resMap);
        if(!CommonConstant.CHINA_RESULT_SUCCESS.equals(resMap.get("code"))){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        //查询开户信息
        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccountSel = new ChinaPNROpenAccount();
        chinaPNROpenAccountSel.setOpenAccountType(CommonConstant.CHINA_OPEN_ACCOUNT_TYPE_ENTERPRISE);
        chinaPNROpenAccountSel.setJsOpenAccountNo(map.get("platformUserId"));
        chinaPNROpenAccountSel = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccountSel);
        if(null == chinaPNROpenAccount){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        if(resMap.get("result").equals(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS)){ //成功
            chinaPNROpenAccountSel.setChinaPnrOpenAccountNo(resMap.get("chinaPNRUserId"));
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS);
        }else if(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING.equals(resMap.get("result"))){//审核中
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING);
        }else{
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR); //失败
        }
        log.info("企业回调成功 result= " + resMap.get("result"));
        chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccountSel);

        //更新请求流水结果
        //创建开户流水信息和开户信息
        ChinaPNRTradingFlow chinaPNRTradingFlow = new ChinaPNRTradingFlow();
        chinaPNRTradingFlow.setJsTradingFlowId(map.get("requestId"));
        chinaPNRTradingFlow = chinaPNRTradingFlowMapper.selectOne(chinaPNRTradingFlow);
        if(null != chinaPNRTradingFlow){
            chinaPNRTradingFlow.setResponseMessage(resMap.get("resText"));
            chinaPNRTradingFlow.setResult(resMap.get("result"));
            chinaPNRTradingFlowMapper.updateByPrimaryKey(chinaPNRTradingFlow);
        }
        return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
    }

    /**
     * 个人开户信息回调
     * @param map
     * @return
     */
    @Override
    public ResponseMessage personalCallbackOpenAccount(Map<String, String> map) {
        log.info(" 个人开户信息回调  map = " + map.toString()) ;
        //验签
        Map<String,String> resMap = chinaPNROpenAccount.callbackPersonalOpenAccount(map);
        log.info("开户回调resMap解析结果=" + resMap.toString());

        if(!resMap.get("code").equals(CommonConstant.CHINA_RESULT_SUCCESS)){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccountSel = new ChinaPNROpenAccount();
        chinaPNROpenAccountSel.setJsOpenAccountNo(map.get("platformUserId"));
        chinaPNROpenAccountSel.setOpenAccountType(CommonConstant.CHINA_OPEN_ACCOUNT_TYPE_PERSONAL);
        chinaPNROpenAccountSel = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccountSel);
        log.info("chinaPNROpenAccount查询结果是：{}" ,chinaPNROpenAccount);
        if(null == chinaPNROpenAccount){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        if(resMap.get("result").equals(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS)){ //成功
            chinaPNROpenAccountSel.setChinaPnrOpenAccountNo(resMap.get("chinaPNRUserId"));
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS);
        }else if(resMap.get("result").equals(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING)){//审核中
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING);
        }else{
            chinaPNROpenAccountSel.setResult(CommonConstant.CHINA_ACCOUNT_STATUS_ERROR); //失败
        }
        log.info("个人回调成功 result= " + resMap.get("result"));
        log.info("chinaPNROpenAccount更新结果是：{}" ,chinaPNROpenAccountSel);
        chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccountSel);

        //更新请求流水结果
        //创建开户流水信息和开户信息
        ChinaPNRTradingFlow chinaPNRTradingFlow = new ChinaPNRTradingFlow();
        chinaPNRTradingFlow.setJsTradingFlowId(map.get("requestId"));
        chinaPNRTradingFlow = chinaPNRTradingFlowMapper.selectOne(chinaPNRTradingFlow);
        log.info("chinaPNRTradingFlow查询结果是：{}" ,chinaPNRTradingFlow);
        if(null!= chinaPNRTradingFlow){
            chinaPNRTradingFlow.setResult(resMap.get("result"));
            chinaPNRTradingFlow.setResponseMessage(resMap.get("resText"));
            log.info("chinaPNRTradingFlow更新结果是：{}" ,chinaPNRTradingFlow);
            chinaPNRTradingFlowMapper.updateByPrimaryKey(chinaPNRTradingFlow);
        }
        return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);

    }

    @Override
    public ResponseMessage queryOpenAccount(String kycNautralId,String result,String openAccountType) {
        log.info("js方开户查询 执行 userid = {}" , kycNautralId) ;

        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccountQuery = new ChinaPNROpenAccount();
        chinaPNROpenAccountQuery.setKycNaturalId(kycNautralId);
        chinaPNROpenAccountQuery.setResult(result);
        chinaPNROpenAccountQuery.setOpenAccountType(openAccountType);
        ChinaPNROpenAccount chinaPNROpenAccount = iBaseMapper.selectOne(chinaPNROpenAccountQuery);
        if(null == chinaPNROpenAccount){
            log.error("未查询到汇付开户信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        log.info("查询到汇付开户信息：{}", JSON.toJSONString(chinaPNROpenAccount));
        ChinaPNROpenAccountVO chinaPNROpenAccountVO = new ChinaPNROpenAccountVO();
        BeanUtils.copyProperties(chinaPNROpenAccount,chinaPNROpenAccountVO);
        return ResultUtil.success(chinaPNROpenAccountVO);
    }
}
