package com.js.pay.service.amazon;

import cn.hutool.core.util.ObjectUtil;
import com.js.dal.dao.mapper.JsSyncAmazonFinancialEventGroupMapper;
import com.js.dal.dao.model.JsSyncAmazonFinancialEventGroup;
import com.js.pay.service.AmazonService;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.List;

@Service
public class AmazonServiceImpl implements AmazonService {

    @Autowired
    JsSyncAmazonFinancialEventGroupMapper jsSyncAmazonFinancialEventGroupMapper;

    @Override
    public boolean balanceAccount(String kycStoreId, BigDecimal sunRateAmount) {
        if (ObjectUtil.isEmpty(kycStoreId) || ObjectUtil.isNull(sunRateAmount)) {
            return false;
        }
        // TODO 需要确认一下中间态的数据状态是什么样的，才能确定最终使用哪条。现在先使用带时间的最后一条。 by liuty
        Example example = new Example(JsSyncAmazonFinancialEventGroup.class);
        example.setOrderByClause("financial_event_group_end desc");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("storeId", kycStoreId);
        List<JsSyncAmazonFinancialEventGroup> groups = jsSyncAmazonFinancialEventGroupMapper.selectByExampleAndRowBounds(example, new RowBounds(0, 1));
        if (groups.size() > 0) {
            JsSyncAmazonFinancialEventGroup eventGroup = groups.get(0);
            if (ObjectUtil.isNotNull(eventGroup.getConvertedTotal())) {
                return eventGroup.getConvertedTotal().compareTo(sunRateAmount) == 0;
            } else {
                return eventGroup.getOriginalTotal().compareTo(sunRateAmount) == 0;
            }
        } else {
            return false;
        }
    }
}
