package com.js.pay.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiKycCertiLinkFileService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.common.constant.Constant;
import com.js.common.enums.FileResourceType;
import com.js.common.enums.FileType;
import com.js.common.enums.RegisterType;
import com.js.common.model.req.*;
import com.js.common.model.vo.FileVo;
import com.js.common.model.vo.KycCertiLinkFileVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ReqNoUtil;
import com.js.dal.dao.mapper.KycStoreMapper;
import com.js.dal.dao.model.*;
import com.js.pay.service.JsFileForOSSSerivce;
import com.js.pay.service.KycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * @Description: 与寻汇询价交互具体实现
 * @Author: liuh
 * @Create: 2019-05-29
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiSunrateTradePriceServiceImpl implements ApiSunrateTradePriceService {
    @Autowired
    KycSunrateService kycSunrateService;
    @Autowired
    KycStoreMapper kycStoreMapper;
    @Autowired
    ApiKycCertiMainLandPersonalServiceImpl apiKycCertiMainLandPersonalServiceimpl;
    @Autowired
    ApiKycCertiMainLandCompanyServiceImpl apiKycCertiMainLandCompanyServiceimpl;
    @Autowired
    ApiKycCertiHKPersonalServiceImpl apiKycCertiHKPersonalServiceimpl;
    @Autowired
    ApiKycCertiHKCompanyServiceImpl apiKycCertiHKCompanyServiceimpl;
    @Autowired
    ApiKycCertiLinkFileService apiKycCertiLinkFileService;
    @Autowired
    JsFileForOSSSerivce jsFileForOSSSerivce;
    @Autowired
    ApiJsCommFileResourceServiceImpl apiJsCommFileResourceServiceImpl;
    @Autowired
    ApiKycNaturalService apiKycNaturalService;

    /**
     * @Description: 寻汇-询价
     */
    public ResponseMessage xhTradeQueryPrice(SunrateTradePriceReq sunrateTradePriceReq){
        sunrateTradePriceReq.setQueryNo("quantg" + ReqNoUtil.getReqNo());
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(sunrateTradePriceReq));
        jsonObjectReq.remove("browserIP");
        Map<String,String> mapParams = (Map)jsonObjectReq;
        return kycSunrateService.sendInfoToXh(sunrateTradePriceReq.getBrowserIP(),"trade.queryPrice","trade/queryPrice/",mapParams);
    }

    @Override
    public List<Map> findSiteByNaturalId(String kycNaturalId) {
        return kycStoreMapper.findSiteByNaturalId(kycNaturalId);
    }

    @Override
    public String findOrgCode(String kycNaturalId,RegisterType registerType){
        String orgCode = "";
        if(registerType == RegisterType.MAINLAND_PERSONAL){
            KycCertiMainLandPersonal kycCertiMainLandPersonalQuery = new KycCertiMainLandPersonal();
            kycCertiMainLandPersonalQuery.setKycNaturalId(kycNaturalId);
            KycCertiMainLandPersonal kycCertiMainLandPersonal = apiKycCertiMainLandPersonalServiceimpl.getiBaseMapper().selectOne(kycCertiMainLandPersonalQuery);
            orgCode = kycCertiMainLandPersonal.getIdNo();
        }else if(registerType == RegisterType.MAINLAND_COMPANY){
            KycCertiMainLandCompany kycCertiMainLandCompanyQuery = new KycCertiMainLandCompany();
            kycCertiMainLandCompanyQuery.setKycNaturalId(kycNaturalId);
            KycCertiMainLandCompany kycCertiMainLandCompany = apiKycCertiMainLandCompanyServiceimpl.getiBaseMapper().selectOne(kycCertiMainLandCompanyQuery);
            orgCode = kycCertiMainLandCompany.getUnifiedSocialCreditCode();
        }else if(registerType == RegisterType.HK_PERSONAL){
            KycCertiHKPersonal kycCertiHKPersonalQuery = new KycCertiHKPersonal();
            kycCertiHKPersonalQuery.setKycNaturalId(kycNaturalId);
            KycCertiHKPersonal kycCertiHKPersonal = apiKycCertiHKPersonalServiceimpl.getiBaseMapper().selectOne(kycCertiHKPersonalQuery);
            orgCode = kycCertiHKPersonal.getCertificateNo();
        }else if(registerType == RegisterType.HK_COMPANY){
            KycCertiHKCompany kycCertiHKCompanyQuery = new KycCertiHKCompany();
            kycCertiHKCompanyQuery.setKycNaturalId(kycNaturalId);
            KycCertiHKCompany kycCertiHKCompany = apiKycCertiHKCompanyServiceimpl.getiBaseMapper().selectOne(kycCertiHKCompanyQuery);
            orgCode = kycCertiHKCompany.getCompanyRegisteredCertificateNo();
        }
        return orgCode;
    }

    @Override
    public JSONObject findCertiInfo(String kycNaturalId,RegisterType registerType){
        Object object = null;
        if(registerType == RegisterType.MAINLAND_PERSONAL){
            KycCertiMainLandPersonal kycCertiMainLandPersonalQuery = new KycCertiMainLandPersonal();
            kycCertiMainLandPersonalQuery.setKycNaturalId(kycNaturalId);
            object = apiKycCertiMainLandPersonalServiceimpl.getiBaseMapper().selectOne(kycCertiMainLandPersonalQuery);
        }else if(registerType == RegisterType.MAINLAND_COMPANY){
            KycCertiMainLandCompany kycCertiMainLandCompanyQuery = new KycCertiMainLandCompany();
            kycCertiMainLandCompanyQuery.setKycNaturalId(kycNaturalId);
            object = apiKycCertiMainLandCompanyServiceimpl.getiBaseMapper().selectOne(kycCertiMainLandCompanyQuery);
        }else if(registerType == RegisterType.HK_PERSONAL){
            KycCertiHKPersonal kycCertiHKPersonalQuery = new KycCertiHKPersonal();
            kycCertiHKPersonalQuery.setKycNaturalId(kycNaturalId);
            object = apiKycCertiHKPersonalServiceimpl.getiBaseMapper().selectOne(kycCertiHKPersonalQuery);
        }else if(registerType == RegisterType.HK_COMPANY){
            KycCertiHKCompany kycCertiHKCompanyQuery = new KycCertiHKCompany();
            kycCertiHKCompanyQuery.setKycNaturalId(kycNaturalId);
            object = apiKycCertiHKCompanyServiceimpl.getiBaseMapper().selectOne(kycCertiHKCompanyQuery);
        }
        if(ObjectUtil.isEmpty(object)){
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(object));
        KycCertiLinkFileReq kycCertiLinkFileReq = new KycCertiLinkFileReq();
        kycCertiLinkFileReq.setPriId(jsonObject.getString("id"));
        List<KycCertiLinkFileVO> certiFileList = apiKycCertiLinkFileService.findCertiFileList(kycCertiLinkFileReq);
        List<FileVo> fileVos = new ArrayList<>();
        certiFileList.stream().forEach(kycCertiLinkFileVO -> {
            if(StringUtils.isNotBlank(kycCertiLinkFileVO.getContactsId())){
                return;
            }
            jsonObject.put(kycCertiLinkFileVO.getFileType().name(), kycCertiLinkFileVO.getFileSavePath());
            JsCommFileResource jsCommFileResource = apiJsCommFileResourceServiceImpl.getiBaseMapper().selectByPrimaryKey(kycCertiLinkFileVO.getCommFileId());
            FileVo fileVo = new FileVo();
            fileVo.setFileSavePath(jsCommFileResource.getFileSavePath());
            fileVo.setFileSaveName(jsCommFileResource.getFileSaveName());
            fileVo.setFileShowPath(jsCommFileResource.getFileShowPath());
            fileVo.setFileShowName(jsCommFileResource.getFileShowName());
            fileVo.setId(kycCertiLinkFileVO.getCommFileId());
            fileVo.setFileExt(jsCommFileResource.getFileExt());
            fileVo.setFileSize(jsCommFileResource.getFileSize());
            fileVo.setFileResourceType(FileResourceType.getFileResourceTypeByIndex(jsCommFileResource.getFileResourceType()));
            fileVo.setFileType(FileType.getFileTypeByIndex(jsCommFileResource.getFileType()));
            fileVo.setCertiFileType(kycCertiLinkFileVO.getFileType());
            fileVos.add(fileVo);
        });
        KycNaturalVO kycNaturalVO = apiKycNaturalService.getKycNaturaById(kycNaturalId);
        jsonObject.put("kycNaturalId",kycNaturalId);
        jsonObject.put("registerType",registerType);
        jsonObject.put("jsRemark",kycNaturalVO.getJsRemark());
        jsonObject.put("kycCertiLinkFileReqList",fileVos);
        return jsonObject;
    }
}
