package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiJsPaySupplierBatService;

import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPaySupplierBatReq;
import com.js.common.model.vo.JsPayVatSubAcctInfoVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySupplierBatMapper;
import com.js.dal.dao.model.JsPaySupplierBat;
import com.js.dal.dao.model.JsPayVatPaymentInfo;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPaySupplierBatServiceImpl extends IBaseServiceImpl<JsPaySupplierBat> implements ApiJsPaySupplierBatService {
//    @Autowired
//    JsPaySupplierBatMapper jsPaySupplierBatMapper;

    @Override
    public ResponseMessage addPaySupplierBat(JsPaySupplierBatReq jsPaySupplierBatReq) {
        JsPaySupplierBat jsPaySupplierBat = new JsPaySupplierBat();
        BeanUtils.copyProperties(jsPaySupplierBatReq,jsPaySupplierBat);
        jsPaySupplierBat.setStoreInfos(JSON.toJSONString(jsPaySupplierBatReq.getSubAcctNoInfoList()));
        jsPaySupplierBat.setId(jsPaySupplierBatReq.getId());
        iBaseMapper.insertSelective(jsPaySupplierBat);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage updatePaySupplierBatStatus(String batchId, String status) {
        JsPaySupplierBat jsPaySupplierBat = new JsPaySupplierBat();
        Example example = new Example(JsPaySupplierBat.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", batchId);
        jsPaySupplierBat.setBatchStatus(status);
        log.info("更新供应商批次信息状态结束:{}");
        updateByExampleSelective(jsPaySupplierBat, example);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage updatePaySupplierBatInfo() {

        return null;
    }

    public static void main(String[] args) {
        JsPayVatSubAcctInfoVO sf = new JsPayVatSubAcctInfoVO();
        sf.setStoreId("1234567890");
        sf.setPayCur("RMB");
        sf.setPayAmt(new BigDecimal("123.45"));
        sf.setSubAcctNo("456321");
        JsPayVatSubAcctInfoVO sf2 = new JsPayVatSubAcctInfoVO();
        sf2.setStoreId("assdfsgfg");
        sf2.setPayCur("CNY");
        sf2.setPayAmt(new BigDecimal("99.45"));
        sf2.setSubAcctNo("a6sdf55");

        List<JsPayVatSubAcctInfoVO> list = new ArrayList<JsPayVatSubAcctInfoVO>();
        list.add(sf);
        list.add(sf2);
        String json = JSON.toJSONString(list);
        System.out.printf(json);
        JSON.parse(json);
    }
}
