package com.js.pay.service.impl;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiJsPaySunrateTradeLockPriceService;
import com.js.api.jspay.service.ApiSunrateBeneficiaryService;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.api.jspay.service.chinapnr.ChinaPNRTransactionDetailsService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.constant.SunrateConstant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ReqNoUtil;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySunrateBankMapper;
import com.js.dal.dao.mapper.JsPaySunrateTradeLockPriceMapper;
import com.js.dal.dao.mapper.JsPaySunrateTradeQueryPriceMapper;
import com.js.dal.dao.mapper.KycSunrateStoreMapper;
import com.js.dal.dao.model.*;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;

/**
 * @Description: 锁汇成交接口具体实现
 * @Author: liuh
 * @Create: 2019-6-11
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPaySunrateTradeLockPriceServiceImpl extends IBaseServiceImpl<JsPaySunrateTradeLockPrice> implements ApiJsPaySunrateTradeLockPriceService {
    @Autowired
    KycSunrateService kycSunrateService;
    @Value("${sunrate.requestno.prefix}")
    private String requestNoPrefix;
    @Autowired
    KycSunrateStoreMapper kycSunrateStoreMapper;
    @Autowired
    JsPaySunrateBankMapper jsPaySunrateBankMapper;
    @Autowired
    JsPaySunrateTradeLockPriceMapper jsPaySunrateTradeLockPriceMapper;
    @Autowired
    ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Autowired
    JsPaySunrateTradeQueryPriceMapper jsPaySunrateTradeQueryPriceMapper;
    @Autowired
    ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;
    @Autowired
    ChinaPNRTransactionDetailsService chinaPNRTransactionDetailsService;

    @Override
    public ResponseMessage queryPriceTradeOrder(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq) {
        log.info("发送询价锁汇请求交易开始：{}",JSON.toJSONString(jsPaySunrateBankTradeInReq));
        JsPaySunrateTradeQueryPriceVo jsPaySunrateTradeQueryPriceVo = xhQueryPrice(jsPaySunrateBankTradeInReq.getTxnAmt(),jsPaySunrateBankTradeInReq.getTransinCur(), jsPaySunrateBankTradeInReq.getOrgCode());
        if(null ==jsPaySunrateTradeQueryPriceVo){
            log.error("询价失败");
            return ResultUtil.error(ResultEnum.QUERY_PRICE_FAILURE);
        }
        JsPaySunrateQueryPriceTradeCreateReq jsPaySunrateQueryPriceTradeCreateReq = ConvertToJsPaySunrateQueryPriceTradeCreateReq(jsPaySunrateBankTradeInReq,jsPaySunrateTradeQueryPriceVo);
        ResponseMessage responseMessage = sendQueryPriceTradeOrderToSunrate(jsPaySunrateQueryPriceTradeCreateReq);
        log.info("发送询价锁汇请求交易结束，结果{}，信息{}",responseMessage.getCode(),responseMessage.getMsg());
        JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPrice;
        log.info("保存询价锁汇请求信息-开始");
        if(responseMessage.isSuccess()){
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
            jsPaySunrateTradeLockPrice = jsonObject.toJavaObject(JsPaySunrateTradeLockPrice.class);
        }else{
            jsPaySunrateTradeLockPrice = new JsPaySunrateTradeLockPrice();
            jsPaySunrateTradeLockPrice.setTxnStatus(CommonConstant.SEND_SUNRATE_TXN_STATUS);
            jsPaySunrateTradeLockPrice.setRemark(responseMessage.getMsg());
        }
        KycSunrateStore kycSunrateStoreQuery = new KycSunrateStore();
        kycSunrateStoreQuery.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        kycSunrateStoreQuery.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        KycSunrateStore kycSunrateStore = kycSunrateStoreMapper.selectOne(kycSunrateStoreQuery);
        if(null == kycSunrateStore){
            log.error("未查询到寻汇店铺信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
        jsPaySunrateBankQuery.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        jsPaySunrateBankQuery.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        JsPaySunrateBank jsPaySunrateBank = jsPaySunrateBankMapper.selectOne(jsPaySunrateBankQuery);
        if(null == jsPaySunrateBank){
            log.error("未查询到寻汇虚拟银行账户信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        BeanUtils.copyProperties(jsPaySunrateQueryPriceTradeCreateReq,jsPaySunrateTradeLockPrice);
        jsPaySunrateTradeLockPrice.setId(IdUtil.simpleUUID());
        jsPaySunrateTradeLockPrice.setKycSunrateBankId(jsPaySunrateBank.getId());
        jsPaySunrateTradeLockPrice.setKycNaturalId(kycSunrateStore.getKycNaturalId());
        jsPaySunrateTradeLockPrice.setKycSunrateStoreId(kycSunrateStore.getId());//寻汇店铺表主键ID
        jsPaySunrateTradeLockPrice.setRequestType(LockPriceTypeEnum.TRADE_MARKET_ORDER);
        jsPaySunrateTradeLockPrice.setTradeType(TradeTypeEnum.TRADE_REPAYMENT);
        jsPaySunrateTradeLockPrice.setTradeSubType(TradeSubTypeEnum.REPAYMENT_AUTOMATIC);
        jsPaySunrateTradeLockPrice.setCreateId("jstransfer");
        jsPaySunrateTradeLockPrice.setCreateName("源奉方");
        int insertCount = super.insertSelective(jsPaySunrateTradeLockPrice);
        log.info("保存询价锁汇请求信息-结束:{}", insertCount);

        JsPaySunrateTradeQueryPrice jsPaySunrateTradeQueryPrice = new JsPaySunrateTradeQueryPrice();
        BeanUtils.copyProperties(jsPaySunrateTradeQueryPriceVo,jsPaySunrateTradeQueryPrice);
        jsPaySunrateTradeQueryPrice.setId(IdUtil.simpleUUID());
        jsPaySunrateTradeQueryPrice.setKycNaturalId(kycSunrateStore.getKycNaturalId());
        jsPaySunrateTradeQueryPrice.setKycSunrateBankId(jsPaySunrateBank.getId());
        jsPaySunrateTradeQueryPrice.setKycSunrateStoreId(kycSunrateStore.getId());
        jsPaySunrateTradeQueryPrice.setJsRemark("应用在询价锁汇接口的询价请求报文");
        jsPaySunrateTradeQueryPriceMapper.insertSelective(jsPaySunrateTradeQueryPrice);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private JsPaySunrateTradeQueryPriceVo xhQueryPrice(BigDecimal txnAmt,String transinCur, String orgCode){
        SunrateTradePriceReq sunrateTradePriceReq = new SunrateTradePriceReq();
        sunrateTradePriceReq.setOrgCode(orgCode);
        sunrateTradePriceReq.setBuyCur(CommonConstant.TRADE_CURRENCY_CNH);
        sunrateTradePriceReq.setSellCur(transinCur);
        sunrateTradePriceReq.setTxnMode(CommonConstant.TXN_MODE_BUY);
        sunrateTradePriceReq.setTxnAmt(txnAmt);
        sunrateTradePriceReq.setBrowserIP(NetUtil.getLocalhostStr());
        ResponseMessage responseMessage = apiSunrateTradePriceService.xhTradeQueryPrice(sunrateTradePriceReq);
        log.info("寻汇-询价结束-返回结果:{},描述信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
        if(responseMessage.isSuccess()){
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
            return jsonObject.toJavaObject(JsPaySunrateTradeQueryPriceVo.class);
        }
        log.info("询价结果未成功，返回空值");
        return null;
    }

    @Override
    public ResponseMessage withdrawList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO) {
        jsTradeListReq.setKycNaturalId(kycNaturalVO.getId());
        Page pages = PageHelper.startPage(jsTradeListReq.getStartPage(),jsTradeListReq.getPageSize());
        List<Map<String, Object>> mapList = jsPaySunrateTradeLockPriceMapper.selectBatchNo(jsTradeListReq);
        PageInfo<Object> objectPageInfo = new PageInfo<>();
        objectPageInfo.setList(new ArrayList<>());
        if(CollectionUtils.isEmpty(mapList)){
            return ResultUtil.success(objectPageInfo);
        }
        if(ProcessStatusEnum.TRADE_PROCESSED_FAILURE.equals(jsTradeListReq.getProcessStatusEnum())){
            log.info("查询处理状态为失败数据，不予展示");
            return ResultUtil.success(objectPageInfo);
        }
        List<String> batchNoList = new ArrayList<>();
        mapList.stream().forEach(map -> {
            batchNoList.add(map.get("batch_no").toString());
        });
        Map<String,Object> paramsMap = new HashMap<>();
        paramsMap.put("tradeSubType",jsTradeListReq.getTradeSubType());
        paramsMap.put("list",batchNoList);
        List<JsTradeListVO> jsTradeListVOList = jsPaySunrateTradeLockPriceMapper.selectTradeShowList(paramsMap);

        Map<String,Object> resultMap = new LinkedHashMap<>();
        for(JsTradeListVO jsTradeListVO : jsTradeListVOList){
            String batchNo = jsTradeListVO.getBatchNo();
            if(resultMap.containsKey(batchNo)){
                JsTradeListVO jsTradeListVOMap = (JsTradeListVO)resultMap.get(batchNo);
                if(null != jsTradeListVO.getAmt()){
                    jsTradeListVOMap.setAmt(jsTradeListVOMap.getAmt().add(jsTradeListVO.getAmt()));
                }
                if(null != jsTradeListVO.getActualAmt()){
                    jsTradeListVOMap.setActualAmt(jsTradeListVOMap.getActualAmt().add(jsTradeListVO.getActualAmt()));
                }
                if(!ProcessStatusEnum.TRADE_PROCESSED.equals(jsTradeListVO.getProcessStatus())){
                    jsTradeListVOMap.setProcessStatusDes("提现中");
                }
                resultMap.put(batchNo,jsTradeListVOMap);
            }else{
                if(ProcessStatusEnum.TRADE_PROCESSED.equals(jsTradeListVO.getProcessStatus())){
                    jsTradeListVO.setProcessStatusDes("提现成功");
                }else{
                    jsTradeListVO.setProcessStatusDes("提现中");
                }
                SiteEnum siteEnum = SiteEnum.getByCurrency(jsTradeListVO.getCurrency());
                if(null != siteEnum){
                    jsTradeListVO.setCurrencyDesc(siteEnum.getHyDesc());
                }
                jsTradeListVO.setBuyCurrencyDesc("人民币");
                if(null == jsTradeListVO.getActualAmt()){
                    jsTradeListVO.setActualAmt(new BigDecimal(0));
                }
                resultMap.put(batchNo,jsTradeListVO);
            }
        }
        List<JsTradeListVO> resultList = new ArrayList<>();
        resultMap.forEach((key,value) -> {
            resultList.add((JsTradeListVO)value);
        });
        PageInfo<JsTradeListVO> jsTradeListVOPageInfoBatchMap = pages.toPageInfo();
        PageInfo<JsTradeListVO> jsTradeListVOPageInfo = new PageInfo<>(resultList);
        jsTradeListVOPageInfo.setPageNum(jsTradeListVOPageInfoBatchMap.getPageNum());
        jsTradeListVOPageInfo.setTotal(jsTradeListVOPageInfoBatchMap.getTotal());
        jsTradeListVOPageInfo.setPages(jsTradeListVOPageInfoBatchMap.getPages());
        jsTradeListVOPageInfo.setHasNextPage(jsTradeListVOPageInfoBatchMap.isHasNextPage());
        jsTradeListVOPageInfo.setHasPreviousPage(jsTradeListVOPageInfoBatchMap.isHasPreviousPage());
        return ResultUtil.success(jsTradeListVOPageInfo);
    }

    @Override
    public ResponseMessage withdrawDetail(TradeTypeEnum tradeType,TradeSubTypeEnum tradeSubType,String batchNo) {
        List<String> batchNoList = new ArrayList<>();
        batchNoList.add(batchNo);
        Map<String,Object> paramsMap = new HashMap<>();
        paramsMap.put("tradeSubType",tradeSubType);
        paramsMap.put("list",batchNoList);
        List<JsTradeListVO> jsTradeListVOList = jsPaySunrateTradeLockPriceMapper.selectTradeShowList(paramsMap);
        if(CollectionUtils.isEmpty(jsTradeListVOList)){
            return ResultUtil.success(jsTradeListVOList);
        }
        JsTradeListVO resultVO = new JsTradeListVO();
        boolean isSuccess = true;
        for(int i = 0 ; i < jsTradeListVOList.size(); i ++){
            JsTradeListVO jsTradeListVO = jsTradeListVOList.get(i);
            if(i == 0){
                BeanUtils.copyProperties(jsTradeListVO,resultVO);
                if(!ProcessStatusEnum.TRADE_PROCESSED.equals(jsTradeListVO.getProcessStatus())){
                    resultVO.setWithdrawFee(new BigDecimal(0));//实收手续费
                    jsTradeListVO.setProcessStatusDes("提现中");
                }else{
                    resultVO.setWithdrawFee(jsTradeListVO.getAccountsReceivableFee());
                    jsTradeListVO.setWithdrawFee(jsTradeListVO.getAccountsReceivableFee());
                    jsTradeListVO.setProcessStatusDes("提现成功");
                }
            }
            if(!ProcessStatusEnum.TRADE_PROCESSED.equals(jsTradeListVO.getProcessStatus())){
                isSuccess = false;
            }
            if(i > 0){
                if(null != jsTradeListVO.getUseRate()){
                    resultVO.setUseRate(jsTradeListVO.getUseRate());
                }
                if(ProcessStatusEnum.TRADE_PROCESSED.equals(jsTradeListVO.getProcessStatus())){
                    jsTradeListVO.setProcessStatusDes("提现成功");
                    resultVO.setWithdrawFee(resultVO.getWithdrawFee().add(jsTradeListVO.getAccountsReceivableFee()));
                    jsTradeListVO.setWithdrawFee(jsTradeListVO.getAccountsReceivableFee());
                }else{
                    jsTradeListVO.setProcessStatusDes("提现中");
                }
                resultVO.setAccountsReceivableFee(resultVO.getAccountsReceivableFee().add(jsTradeListVO.getAccountsReceivableFee()));
                resultVO.setAmt(resultVO.getAmt().add(jsTradeListVO.getAmt()));
                resultVO.setActualAmt(resultVO.getActualAmt().add(jsTradeListVO.getActualAmt()));
            }
            if(null == jsTradeListVO.getWithdrawFee()){
                jsTradeListVO.setWithdrawFee(new BigDecimal(0));
            }
        }
        SiteEnum siteEnum = SiteEnum.getByCurrency(resultVO.getCurrency());
        if(null != siteEnum){
            resultVO.setCurrencyDesc(siteEnum.getHyDesc());
        }
        resultVO.setBuyCurrencyDesc("人民币");
        resultVO.setProcessStatusDes(isSuccess ? "提现成功" : "提现中");

        log.info("{}批次下已收手续费：{}",batchNo,resultVO.getWithdrawFee());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tradeDetail",resultVO);
        jsonObject.put("tradeList",jsTradeListVOList);
        return ResultUtil.success(jsonObject);
    }

    @Override
    public ResponseMessage withdrawAndRefundDetail(String tradeId) {
        return null;
    }

    @Override
    public JsPaySunrateTradeLockPriceVO findTradeLockInfo(JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq) {
        JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPriceQuery = new JsPaySunrateTradeLockPrice();
        jsPaySunrateTradeLockPriceQuery.setTxnNo(jsPaySunrateBankTradeOutReq.getTxnNo());
        jsPaySunrateTradeLockPriceQuery.setLockNo(jsPaySunrateBankTradeOutReq.getLockNo());
        jsPaySunrateTradeLockPriceQuery.setBeneficiaryId(jsPaySunrateBankTradeOutReq.getBeneficiaryId());
        jsPaySunrateTradeLockPriceQuery.setBuyCur(jsPaySunrateBankTradeOutReq.getPayCur());
        jsPaySunrateTradeLockPriceQuery.setDelFlag(false);
        JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPrice = iBaseMapper.selectOne(jsPaySunrateTradeLockPriceQuery);
        if(null == jsPaySunrateTradeLockPrice){
            log.error("未查询到锁汇信息:{}",jsPaySunrateTradeLockPriceQuery);
            return null;
        }
        JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO = new JsPaySunrateTradeLockPriceVO();
        BeanUtils.copyProperties(jsPaySunrateTradeLockPrice,jsPaySunrateTradeLockPriceVO);
        return jsPaySunrateTradeLockPriceVO;
    }

    /**
     * 发送询价锁汇请求到寻汇
     */
    private ResponseMessage sendQueryPriceTradeOrderToSunrate(JsPaySunrateQueryPriceTradeCreateReq jsPaySunrateQueryPriceTradeCreateReq){
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(jsPaySunrateQueryPriceTradeCreateReq));
        Map<String,String> mapParams = (Map)jsonObjectReq;
        return kycSunrateService.sendInfoToXh(NetUtil.getLocalhostStr(),"trade.create","trade/create/",mapParams);
    }

    private JsPaySunrateQueryPriceTradeCreateReq ConvertToJsPaySunrateQueryPriceTradeCreateReq(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq, JsPaySunrateTradeQueryPriceVo jsPaySunrateTradeQueryPriceVo){
        JsPaySunrateQueryPriceTradeCreateReq jsPaySunrateQueryPriceTradeCreateReq = new JsPaySunrateQueryPriceTradeCreateReq();
        jsPaySunrateQueryPriceTradeCreateReq.setLockNo(requestNoPrefix + ReqNoUtil.getReqNo());
        jsPaySunrateQueryPriceTradeCreateReq.setQueryNo(jsPaySunrateTradeQueryPriceVo.getQueryNo());
        jsPaySunrateQueryPriceTradeCreateReq.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        jsPaySunrateQueryPriceTradeCreateReq.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        jsPaySunrateQueryPriceTradeCreateReq.setSellAmt(jsPaySunrateTradeQueryPriceVo.getSellAmt());
        jsPaySunrateQueryPriceTradeCreateReq.setSellCur(jsPaySunrateTradeQueryPriceVo.getSellCur());
        jsPaySunrateQueryPriceTradeCreateReq.setBuyAmt(jsPaySunrateTradeQueryPriceVo.getBuyAmt());
        jsPaySunrateQueryPriceTradeCreateReq.setBuyCur(jsPaySunrateTradeQueryPriceVo.getBuyCur());
        jsPaySunrateQueryPriceTradeCreateReq.setFeeAmt(jsPaySunrateTradeQueryPriceVo.getFeeAmt());
        jsPaySunrateQueryPriceTradeCreateReq.setFeeCur(jsPaySunrateTradeQueryPriceVo.getFeeCur());
        jsPaySunrateQueryPriceTradeCreateReq.setPayAmt(jsPaySunrateTradeQueryPriceVo.getPayAmt());//支付总金额
        jsPaySunrateQueryPriceTradeCreateReq.setTxnMode(jsPaySunrateTradeQueryPriceVo.getTxnMode());
        jsPaySunrateQueryPriceTradeCreateReq.setQueryRate(jsPaySunrateTradeQueryPriceVo.getQueryRate());//询价汇率

        List<KycSunrateBeneficiaryVO> kycSunrateBeneficiaryVOList = apiSunrateBeneficiaryService.beneficiaryListByOrgCode(jsPaySunrateBankTradeInReq.getOrgCode(), BeneficiaryTypeEnum.PLATEFORM_SELF,jsPaySunrateTradeQueryPriceVo.getBuyCur());
        if(CollectionUtils.isNotEmpty(kycSunrateBeneficiaryVOList)){
            KycSunrateBeneficiaryVO kycSunrateBeneficiaryVO = kycSunrateBeneficiaryVOList.get(0);
            jsPaySunrateQueryPriceTradeCreateReq.setBeneficiaryId(kycSunrateBeneficiaryVO.getBeneficiaryId());
        }
        jsPaySunrateQueryPriceTradeCreateReq.setRemark("询价锁汇");
        return jsPaySunrateQueryPriceTradeCreateReq;
    }

    @Override
    public ResponseMessage tradeMarketOrder(JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq,String kycNaturalId,String kycSunrateStoreId,String kycSunrateBankId) {
        log.info("发送市价锁汇请求交易开始：{}",JSON.toJSONString(jsPaySunrateTradeMarketOrderReq));
        ResponseMessage responseMessage = sendTradeMarketOrderToSunrate(jsPaySunrateTradeMarketOrderReq);
        log.info("发送市价锁汇请求交易结束，返回信息：{}",responseMessage);
        if(!responseMessage.isSuccess()){
            return responseMessage;
        }
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
        JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPrice = jsonObject.toJavaObject(JsPaySunrateTradeLockPrice.class);
        BeanUtils.copyProperties(jsPaySunrateTradeMarketOrderReq,jsPaySunrateTradeLockPrice);
        if(null != jsPaySunrateTradeMarketOrderReq.getServiceCharge()){
            //当前客户使用汇率
            BigDecimal useRate = CommonConstant.TRADE_CURRENCY_CNH.equals(jsPaySunrateTradeLockPrice.getBuyCur()) ? jsPaySunrateTradeLockPrice.getFinRate() : jsPaySunrateTradeLockPrice.getFinRate().compareTo(jsPaySunrateTradeMarketOrderReq.getUseRate()) != 1 ? jsPaySunrateTradeMarketOrderReq.getUseRate() : jsPaySunrateTradeLockPrice.getFinRate();
            //单外币收取汇差值
            BigDecimal rate =  CommonConstant.TRADE_CURRENCY_CNH.equals(jsPaySunrateTradeLockPrice.getBuyCur()) ? new BigDecimal(0) : jsPaySunrateTradeLockPrice.getFinRate().compareTo(jsPaySunrateTradeMarketOrderReq.getUseRate()) != 1 ? useRate.subtract(jsPaySunrateTradeLockPrice.getFinRate()) : new BigDecimal(0);
            //手续费标准
            BigDecimal serviceCharge = jsPaySunrateTradeMarketOrderReq.getServiceCharge();
            //卖出外币金额
            BigDecimal sellAmt = jsPaySunrateTradeLockPrice.getSellAmt();
            //手续费金额
            BigDecimal serviceChargeAmt = jsPaySunrateTradeLockPrice.getTxnAmt().multiply(serviceCharge).setScale(2,BigDecimal.ROUND_HALF_UP);
            //汇差金额
            BigDecimal rateAmt = sellAmt.multiply(rate).setScale(2,BigDecimal.ROUND_HALF_UP);
            //买入币种-手续费金额
            BigDecimal serviceChargeAmtBuy = jsPaySunrateTradeLockPrice.getPayAmt().multiply(jsPaySunrateTradeLockPrice.getFinRate()).multiply(serviceCharge).setScale(2,BigDecimal.ROUND_HALF_UP);
            log.info("卖出外币金额:{},外币手续费金额：{}，手续费比例：{},单外币汇差值：{},当前客户使用汇差值：{}",sellAmt,serviceChargeAmt,serviceCharge,rate,useRate);
            jsPaySunrateTradeLockPrice.setChargeAmt(serviceChargeAmt);
            jsPaySunrateTradeLockPrice.setTakeRate(rate);
            jsPaySunrateTradeLockPrice.setRateAmt(rateAmt);
            jsPaySunrateTradeLockPrice.setChargeAmtBuy(serviceChargeAmtBuy);
        }
        jsPaySunrateTradeLockPrice.setId(IdUtil.simpleUUID());
        jsPaySunrateTradeLockPrice.setCreateId("jstransfer");
        jsPaySunrateTradeLockPrice.setCreateName("源奉方");
        jsPaySunrateTradeLockPrice.setRequestType(LockPriceTypeEnum.TRADE_MARKET_ORDER);
        jsPaySunrateTradeLockPrice.setKycNaturalId(kycNaturalId);
        jsPaySunrateTradeLockPrice.setKycSunrateBankId(kycSunrateBankId);
        jsPaySunrateTradeLockPrice.setKycSunrateStoreId(kycSunrateStoreId);
        jsPaySunrateTradeLockPrice.setProcessStatus(ProcessStatusEnum.TRADE_SUBMITTED);
        jsPaySunrateTradeLockPrice.setOrderRestoreFlag(true);
        if(CommonConstant.TRADE_CURRENCY_CNY.equals(jsPaySunrateTradeLockPrice.getBuyCur()) || CommonConstant.TRADE_CURRENCY_CNH.equals(jsPaySunrateTradeLockPrice.getBuyCur())) {
            try {
                ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq = new ChinaPNRTransactionDetailsReq();
                chinaPNRTransactionDetailsReq.setKycNaturalId(kycNaturalId);
                chinaPNRTransactionDetailsReq.setDispaterDate(jsPaySunrateTradeLockPrice.getTxnDatetime());
                chinaPNRTransactionDetailsReq.setCurrencyCode(jsPaySunrateTradeLockPrice.getBuyCur());
                chinaPNRTransactionDetailsReq.setTargetAmount(jsPaySunrateTradeLockPrice.getBuyAmt());
                chinaPNRTransactionDetailsReq.setKycBankId(jsPaySunrateTradeMarketOrderReq.getKycBankId());
                chinaPNRTransactionDetailsReq.setExchangeRate(jsPaySunrateTradeLockPrice.getFinRate());
                chinaPNRTransactionDetailsReq.setAmazonEndpointEnum(jsPaySunrateTradeMarketOrderReq.getStoreTheSite().getAmazonEndpointEnum());
                responseMessage = chinaPNRTransactionDetailsService.saveChinaPNRTransactionDetail(chinaPNRTransactionDetailsReq);
                if(!responseMessage.isSuccess()){
                    jsPaySunrateTradeLockPrice.setOrderRestoreFlag(false);
                }
            }catch (Exception ex){
                jsPaySunrateTradeLockPrice.setOrderRestoreFlag(false);
                log.error("调用订单还原接口异常",ex);
                responseMessage = ResultUtil.error(ResultEnum.ERROR.getCode(),"调用订单还原接口异常");
            }
        }
        int insertCount = super.insertSelective(jsPaySunrateTradeLockPrice);
        log.info("市价锁汇插入数据条数：{}",insertCount);
        return responseMessage;
    }

    @Override
    public ResponseMessage getLockPriceByDate( Date start, Date end ) {
        Example example = new Example(JsPaySunrateTradeLockPrice.class);
        example.setOrderByClause("txn_datetime");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        criteria.orEqualTo("buyAmt", CommonConstant.TRADE_CURRENCY_CNY);
        criteria.andEqualTo("orderRestoreFlag", 1 );
        criteria.andGreaterThanOrEqualTo("txnDatetime",start);
        criteria.andLessThan("txnDatetime", end);
        Example.Criteria criteria2 = example.createCriteria();
        criteria2.andEqualTo("delFlag", false);
        criteria2.andEqualTo("buyAmt", CommonConstant.TRADE_CURRENCY_CNH);
        criteria2.andEqualTo("orderRestoreFlag", 1 );
        criteria2.andGreaterThanOrEqualTo("txnDatetime",start);
        criteria2.andLessThan("txnDatetime", end);
        example.or(criteria2);
        List<JsPaySunrateTradeLockPrice> jsPaySunrateTradeLockPrices = iBaseMapper.selectByExample(example);

        BigDecimal totalAmt = jsPaySunrateTradeLockPrices.stream()
                // 将 JsPaySunrateTradeLockPriceVO 对象的 getBuyAmt 取出来map为Bigdecimal
                .map(JsPaySunrateTradeLockPrice::getBuyAmt)
                // 使用reduce聚合函数,实现累加器
                .reduce(BigDecimal.ZERO,BigDecimal::add);
//        List<JsPaySunrateTradeLockPriceVO> resultList = new ArrayList<>();
//        jsPaySunrateTradeLockPrices.stream().forEach(jsPaySunrateTradeLockPrice -> {
//            JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO = new JsPaySunrateTradeLockPriceVO();
//            BeanUtils.copyProperties(jsPaySunrateTradeLockPrice,jsPaySunrateTradeLockPriceVO);
//            resultList.add(jsPaySunrateTradeLockPriceVO);
//        });
        return  ResultUtil.success(totalAmt);
    }

    @Override
    public List<JsPaySunrateTradeLockPriceVO> getLockPriceForChinaPNR() {
        Example example = new Example(JsPaySunrateTradeLockPrice.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("orderRestoreFlag", 0 );

        List<JsPaySunrateTradeLockPrice> jsPaySunrateTradeLockPrices = iBaseMapper.selectByExample(example);

        List<JsPaySunrateTradeLockPriceVO> resultList = new ArrayList<>();
        jsPaySunrateTradeLockPrices.stream().forEach(jsPaySunrateTradeLockPrice -> {
            JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO = new JsPaySunrateTradeLockPriceVO();
            BeanUtils.copyProperties(jsPaySunrateTradeLockPrice,jsPaySunrateTradeLockPriceVO);
            resultList.add(jsPaySunrateTradeLockPriceVO);
        });

        return  resultList;
    }

    @Override
    public ResponseMessage fundDetailList(JsTradeFundReq jsTradeFundReq, KycNaturalVO kycNaturalVO) {
        jsTradeFundReq.setKycNaturalId(kycNaturalVO.getId());
        Page page = PageHelper.startPage(jsTradeFundReq.getStartPage(),jsTradeFundReq.getPageSize());
        List<JsTradeFundVO> mapList = jsPaySunrateTradeLockPriceMapper.fundDetailList(jsTradeFundReq);

        DecimalFormat df = new DecimalFormat("0.00%");
        mapList.stream().forEach(jsTradeFundVO -> {
            SiteEnum siteEnum = SiteEnum.getByCurrency(jsTradeFundVO.getCurrency());
            if(null != siteEnum){
                jsTradeFundVO.setCurrencyDesc(siteEnum.getHyDesc());
            }
            jsTradeFundVO.setTradeTypeDesc(jsTradeFundVO.getTradeSubType().getDesc());
            if(null != jsTradeFundVO.getServiceCharge() && jsTradeFundVO.getServiceCharge().compareTo(new BigDecimal(0)) > 0){
                //显示手续费
                jsTradeFundVO.setServiceChargeDesc(df.format(jsTradeFundVO.getServiceCharge()));
            }else{
                jsTradeFundVO.setServiceChargeDesc("0");
            }
            jsTradeFundVO.setProcessStatusDesc(ProcessStatusEnum.TRADE_PROCESSED.equals(jsTradeFundVO.getProcessStatus()) ? "已处理" : "处理中");
        });
        PageInfo<JsTradeFundVO> listPageInfo = page.toPageInfo();
        return ResultUtil.success(listPageInfo);
    }

    @Override
    public List<JsTradeFundVO> fundDetailListNoPage(JsTradeFundReq jsTradeFundReq, KycNaturalVO kycNaturalVO){
        jsTradeFundReq.setKycNaturalId(kycNaturalVO.getId());
        List<JsTradeFundVO> mapList = jsPaySunrateTradeLockPriceMapper.fundDetailList(jsTradeFundReq);

        DecimalFormat df = new DecimalFormat("0.00%");
        mapList.stream().forEach(jsTradeFundVO -> {
            SiteEnum siteEnum = SiteEnum.getByCurrency(jsTradeFundVO.getCurrency());
            if(null != siteEnum){
                jsTradeFundVO.setCurrencyDesc(siteEnum.getHyDesc());
            }
            jsTradeFundVO.setTradeTypeDesc(jsTradeFundVO.getTradeSubType().getDesc());
            if(null != jsTradeFundVO.getServiceCharge() && jsTradeFundVO.getServiceCharge().compareTo(new BigDecimal(0)) > 0){
                //显示手续费
                jsTradeFundVO.setServiceChargeDesc(df.format(jsTradeFundVO.getServiceCharge()));
            }
            jsTradeFundVO.setProcessStatusDesc(ProcessStatusEnum.TRADE_PROCESSED.equals(jsTradeFundVO.getProcessStatus()) ? "已处理" : "处理中");
        });
        return mapList;
    }

    @Override
    public ResponseMessage withdrawFundDetail(TradeTypeEnum tradeType, String id) {
        JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPrice = iBaseMapper.selectByPrimaryKey(id);
        if(null == jsPaySunrateTradeLockPrice){
            log.info("查询锁汇信息不存在；{}",id);
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        JsTradeFundVO jsTradeFundVO = new JsTradeFundVO();
        jsTradeFundVO.setTradeNo(jsPaySunrateTradeLockPrice.getLockNo());//交易单号
        jsTradeFundVO.setTradeTypeDesc("提现");
        jsTradeFundVO.setAccountsReceivableFee(jsPaySunrateTradeLockPrice.getChargeAmt());//应收手续费
        jsTradeFundVO.setUseRate(jsPaySunrateTradeLockPrice.getUseRate());//当前客户使用结汇汇率
        SiteEnum siteEnum = SiteEnum.getByCurrency(jsPaySunrateTradeLockPrice.getSellCur());
        if(null != siteEnum){
            jsTradeFundVO.setCurrencyDesc(siteEnum.getHyDesc());//提现原币种
        }
        jsTradeFundVO.setOutAmt(jsPaySunrateTradeLockPrice.getSellAmt());//提现金额
        if(ProcessStatusEnum.TRADE_PROCESSED.equals(jsPaySunrateTradeLockPrice.getProcessStatus())){
            jsTradeFundVO.setChargeAmt(jsPaySunrateTradeLockPrice.getChargeAmt());//处理完成后，应收==实收
        }else{
            jsTradeFundVO.setChargeAmt(new BigDecimal(0));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tradeDetail",jsTradeFundVO);
        return ResultUtil.success(jsonObject);
    }

    @Override
    public ResponseMessage generateWithdrawList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO) {
        jsTradeListReq.setKycNaturalId(kycNaturalVO.getId());
        List<Map<String, Object>> mapList = jsPaySunrateTradeLockPriceMapper.selectBatchNo(jsTradeListReq);
        if(CollectionUtils.isEmpty(mapList)){
            return ResultUtil.success(mapList);
        }
        List<String> batchNoList = new ArrayList<>();
        mapList.stream().forEach(map -> {
            batchNoList.add(map.get("batch_no").toString());
        });
        Map<String,Object> paramsMap = new HashMap<>();
        paramsMap.put("tradeSubType",jsTradeListReq.getTradeSubType());
        paramsMap.put("list",batchNoList);
        List<JsTradeListVO> jsTradeListVOList = jsPaySunrateTradeLockPriceMapper.selectTradeShowList(paramsMap);
        jsTradeListVOList.stream().forEach(jsTradeListVO -> {
            SiteEnum siteEnum = SiteEnum.getByCurrency(jsTradeListVO.getCurrency());
            if(null != siteEnum){
                jsTradeListVO.setCurrencyDesc(siteEnum.getHyDesc());
            }
            String buyCurrency = jsTradeListVO.getBuyCurrency();
            if(CommonConstant.TRADE_CURRENCY_CNH.equals(buyCurrency) || CommonConstant.TRADE_CURRENCY_CNY.equals(buyCurrency)){
                jsTradeListVO.setBuyCurrencyDesc("人民币");
            }else{
                SiteEnum buySite = SiteEnum.getByCurrency(buyCurrency);
                if(null != buySite){
                    jsTradeListVO.setBuyCurrencyDesc(buySite.getHyDesc());
                }
            }
            if(ProcessStatusEnum.TRADE_PROCESSED.equals(jsTradeListVO.getProcessStatus())){
                jsTradeListVO.setProcessStatusDes("提现成功");
                jsTradeListVO.setWithdrawFee(jsTradeListVO.getAccountsReceivableFee());
            }else{
                jsTradeListVO.setProcessStatusDes("提现中");
                jsTradeListVO.setWithdrawFee(new BigDecimal(0));
            }
        });
        return ResultUtil.success(jsTradeListVOList);
    }

    @Override
    public List<JsPaySunrateTradeLockPriceVO> getLockPriceList() {
        Example example = new Example(JsPaySunrateTradeLockPrice.class);
        example.setOrderByClause("create_dts");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        criteria.andEqualTo("txnStatus", SunrateConstant.TRADE_OUT_COMPLETE);
        criteria.andEqualTo("processStatus", ProcessStatusEnum.TRADE_UNPROCESSED);
        List<JsPaySunrateTradeLockPrice> jsPaySunrateTradeLockPrices = iBaseMapper.selectByExample(example);
        List<JsPaySunrateTradeLockPriceVO> resultList = new ArrayList<>();
        jsPaySunrateTradeLockPrices.stream().forEach(jsPaySunrateTradeLockPrice -> {
            JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO = new JsPaySunrateTradeLockPriceVO();
            BeanUtils.copyProperties(jsPaySunrateTradeLockPrice,jsPaySunrateTradeLockPriceVO);
            resultList.add(jsPaySunrateTradeLockPriceVO);
        });
        return resultList;
    }

    @Override
    public int updateLockPrice(JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO) {
        if(StringUtils.isNotBlank(jsPaySunrateTradeLockPriceVO.getId())){
            JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPrice = new JsPaySunrateTradeLockPrice();
            BeanUtils.copyProperties(jsPaySunrateTradeLockPriceVO,jsPaySunrateTradeLockPrice);
            return iBaseMapper.updateByPrimaryKeySelective(jsPaySunrateTradeLockPrice);
        }
        return 0;
    }

    /**
     * 发送市价锁汇请求到寻汇
     */
    private ResponseMessage sendTradeMarketOrderToSunrate(JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq){
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(jsPaySunrateTradeMarketOrderReq));
        jsonObjectReq.remove("tradeSubType");
        jsonObjectReq.remove("kycBankId");
        jsonObjectReq.remove("bankNo");
        jsonObjectReq.remove("sunrateBankAvailableAmt");
        jsonObjectReq.remove("batchNo");
        jsonObjectReq.remove("tradeType");
        jsonObjectReq.remove("useRate");
        jsonObjectReq.remove("takeRate");
        jsonObjectReq.remove("serviceCharge");
        jsonObjectReq.remove("chargeAmt");
        jsonObjectReq.remove("storeTheSite");
        Map<String,String> mapParams = (Map)jsonObjectReq;
        return kycSunrateService.sendInfoToXh(NetUtil.getLocalhostStr(),"trade.marketOrder","trade/marketOrder/",mapParams);
    }
}
