package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiMainLandCompanyService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SexEnum;
import com.js.common.model.req.CertiMainLandCompanyReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.KycCertiMainLandCompanyVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.KycCertiLinkFile;
import com.js.dal.dao.model.KycCertiMainLandCompany;
import com.js.dal.dao.model.KycSunrateRegister;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

/**
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiKycCertiMainLandCompanyServiceImpl extends IBaseServiceImpl<KycCertiMainLandCompany> implements ApiKycCertiMainLandCompanyService {
    @Autowired
    ApiKycNaturalService apiKycNaturalService;
    @Autowired
    ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    ApiSunrateRegisterServiceImpl apiSunrateRegisterServiceImpl;
    @Autowired
    ApiKycCertiLinkFilelServiceImpl apiKycCertiLinkFilelServiceImpl;

    @Override
    public ResponseMessage certiMainLandCompanyAdd(CertiMainLandCompanyReq certiMainLandCompanyReq, KycNaturalVO kycNaturalVO) {
        log.info("大陆企业-实名认证提交处理开始:{}", JSON.toJSONString(certiMainLandCompanyReq));
        KycCertiMainLandCompany kycCertiMainLandCompany = new KycCertiMainLandCompany();
        BeanUtils.copyProperties(certiMainLandCompanyReq,kycCertiMainLandCompany);
        kycCertiMainLandCompany.setId(IdUtil.simpleUUID());
        kycCertiMainLandCompany.setLegalRepresentativeIdType(certiMainLandCompanyReq.getCertiCardType().name());
        kycCertiMainLandCompany.setLegalRepresentativeIdTypeName(certiMainLandCompanyReq.getCertiCardType().getEnumName());
        kycCertiMainLandCompany.setKycNaturalId(kycNaturalVO.getId());
        kycCertiMainLandCompany.setCreateId(kycNaturalVO.getId());
        kycCertiMainLandCompany.setCreateName(kycNaturalVO.getCertificationName());

        super.insertSelective(kycCertiMainLandCompany);
        List<KycCertiLinkFile> kycCertiLinkFileList = apiKycCertiLinkFilelServiceImpl.ConvertToKycCertiLinkFile(kycCertiMainLandCompany.getId(), kycNaturalVO, certiMainLandCompanyReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-大陆企业实名认证信息完成");

        String idNo = certiMainLandCompanyReq.getLegalRepresentativeIdNo();
        String idNoSex = idNo.length() == 15 ? idNo.substring(14,15) : idNo.substring(16,17);
        Integer idNoSexNumber = Integer.parseInt(idNoSex);
        SexEnum sex = idNoSexNumber%2 != 0 ? SexEnum.MALE : SexEnum.FEMALE;

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setSex(sex);
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.KYC_INFO_SUBMIT);
        kycNaturalReq.setRegisterType(RegisterType.MAINLAND_COMPANY);
        kycNaturalReq.setCertificationName(certiMainLandCompanyReq.getCompanyName());
        kycNaturalReq.setIdNo(certiMainLandCompanyReq.getUnifiedSocialCreditCode());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);
        return ResultUtil.success(kycCertiMainLandCompany.getId());
    }

    @Override
    public boolean verifyCertiMainLandComapnyExists(String unifiedSocialCreditCode) {
        KycCertiMainLandCompany kycCertiMainLandCompanyQuery = new KycCertiMainLandCompany();
        kycCertiMainLandCompanyQuery.setUnifiedSocialCreditCode(unifiedSocialCreditCode);
        KycCertiMainLandCompany kycCertiMainLandCompany = iBaseMapper.selectOne(kycCertiMainLandCompanyQuery);
        boolean result = null == kycCertiMainLandCompany ? false : true;
        if(!result){
            KycSunrateRegister kycSunrateRegisterQuery = new KycSunrateRegister();
            kycSunrateRegisterQuery.setOrgCode(unifiedSocialCreditCode);
            KycSunrateRegister kycSunrateRegister = apiSunrateRegisterServiceImpl.getiBaseMapper().selectOne(kycSunrateRegisterQuery);
            result = null == kycSunrateRegister ? false : true;
        }
        return result;
    }

    @Override
    public ResponseMessage certiMainLandCompanyUpdate(CertiMainLandCompanyReq certiMainLandCompanyReq, KycNaturalVO kycNaturalVO) {
        log.info("大陆企业-实名认证编辑处理开始:{}", JSON.toJSONString(certiMainLandCompanyReq));
        KycCertiMainLandCompany kycCertiMainLandCompanySel = iBaseMapper.selectByPrimaryKey(certiMainLandCompanyReq.getId());
        if(null == kycCertiMainLandCompanySel){
            log.error("根据主键未查询到实名认证信息：{}",certiMainLandCompanyReq.getId());
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        BeanUtils.copyProperties(certiMainLandCompanyReq,kycCertiMainLandCompanySel);
        kycCertiMainLandCompanySel.setUpdateId(kycNaturalVO.getId());
        kycCertiMainLandCompanySel.setUpdateDts(new Date());
        kycCertiMainLandCompanySel.setUpdateName(kycNaturalVO.getCertificationName());
        int updateCertiCount = iBaseMapper.updateByPrimaryKeySelective(kycCertiMainLandCompanySel);
        log.info("更新certimainlandcompany表记录：{}条",updateCertiCount);
        KycCertiLinkFile kycCertiLinkFileDel = new KycCertiLinkFile();
        kycCertiLinkFileDel.setKycNaturalId(kycNaturalVO.getId());
        kycCertiLinkFileDel.setDelFlag(false);
        List<KycCertiLinkFile> selectList = apiKycCertiLinkFilelServiceImpl.getiBaseMapper().select(kycCertiLinkFileDel);
        selectList.stream().forEach(kycCertiLinkFile -> {
            if(StringUtils.isNotBlank(kycCertiLinkFile.getContactsId())){
                return;
            }
            kycCertiLinkFile.setDelFlag(true);
            kycCertiLinkFile.setUpdateDts(new Date());
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().updateByPrimaryKeySelective(kycCertiLinkFile);
        });
        List<KycCertiLinkFile> kycCertiLinkFileList = apiKycCertiLinkFilelServiceImpl.ConvertToKycCertiLinkFile(certiMainLandCompanyReq.getId(), kycNaturalVO, certiMainLandCompanyReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-大陆企业实名认证信息编辑完成");

        String idNo = certiMainLandCompanyReq.getLegalRepresentativeIdNo();
        String idNoSex = idNo.length() == 15 ? idNo.substring(14,15) : idNo.substring(16,17);
        Integer idNoSexNumber = Integer.parseInt(idNoSex);
        SexEnum sex = idNoSexNumber%2 != 0 ? SexEnum.MALE : SexEnum.FEMALE;

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setSex(sex);
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.KYC_INFO_SUBMIT);
        kycNaturalReq.setRegisterType(RegisterType.MAINLAND_COMPANY);
        kycNaturalReq.setCertificationName(certiMainLandCompanyReq.getCompanyName());
        kycNaturalReq.setIdNo(certiMainLandCompanyReq.getUnifiedSocialCreditCode());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);
        return ResultUtil.success(certiMainLandCompanyReq.getId());
    }

    @Override
    public ResponseMessage certiMainLandCompanySel(CertiMainLandCompanyReq certiMainLandCompanyReq, KycNaturalVO kycNaturalVO) {
        KycCertiMainLandCompany kycCertiMainLandCompanyQuery = new KycCertiMainLandCompany();
        kycCertiMainLandCompanyQuery.setDelFlag(false);
        kycCertiMainLandCompanyQuery.setKycNaturalId(kycNaturalVO.getId());
        KycCertiMainLandCompany kycCertiMainLandCompany = iBaseMapper.selectOne(kycCertiMainLandCompanyQuery);
        if(null == kycCertiMainLandCompany){
            log.info("未查询到实名认证信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        KycCertiMainLandCompanyVO kycCertiMainLandCompanyVO = new KycCertiMainLandCompanyVO();
        BeanUtils.copyProperties(kycCertiMainLandCompany,kycCertiMainLandCompanyVO);
        return ResultUtil.success(kycCertiMainLandCompanyVO);
    }
}
