package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiHKCompanyService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycCertiHKCompanyReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.*;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

/**
 * @Author: yjzhao
 * @Create: 2019-05-16  10:19
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiKycCertiHKCompanyServiceImpl extends IBaseServiceImpl<KycCertiHKCompany> implements ApiKycCertiHKCompanyService {
    @Autowired
    ApiKycNaturalService apiKycNaturalService;
    @Autowired
    ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    ApiSunrateRegisterServiceImpl apiSunrateRegisterServiceImpl;
    @Autowired
    ApiKycCertiLinkFilelServiceImpl apiKycCertiLinkFilelServiceImpl;

    @Override
    public ResponseMessage certiHKCompanyAdd(KycCertiHKCompanyReq kycCertiHKCompanyReq, KycNaturalVO kycNaturalVO) {
        log.info("香港企业-实名认证提交处理开始:{}", JSON.toJSONString(kycCertiHKCompanyReq));
        KycCertiHKCompany kycCertiHKCompany = new KycCertiHKCompany();
        BeanUtils.copyProperties(kycCertiHKCompanyReq,kycCertiHKCompany);
        kycCertiHKCompany.setId(IdUtil.simpleUUID());
        kycCertiHKCompany.setKycNaturalId(kycNaturalVO.getId());
        kycCertiHKCompany.setCreateId(kycNaturalVO.getId());
        kycCertiHKCompany.setDirectorIdType(kycCertiHKCompanyReq.getCertiCardType().name());
        kycCertiHKCompany.setDirectorIdTypeName(kycCertiHKCompanyReq.getCertiCardType().getEnumName());
        kycCertiHKCompany.setCreateName(kycNaturalVO.getCertificationName());
        super.insertSelective(kycCertiHKCompany);
        List<KycCertiLinkFile> kycCertiLinkFileList = apiKycCertiLinkFilelServiceImpl.ConvertToKycCertiLinkFile(kycCertiHKCompany.getId(), kycNaturalVO, kycCertiHKCompanyReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-香港企业实名认证信息完成");

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.KYC_INFO_SUBMIT);
        kycNaturalReq.setRegisterType(RegisterType.HK_COMPANY);
        kycNaturalReq.setCertificationName(kycCertiHKCompanyReq.getCompanyName());
        kycNaturalReq.setIdNo(kycCertiHKCompanyReq.getCompanyRegisteredCertificateNo());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);
        return ResultUtil.success(kycCertiHKCompany.getId());
    }

    @Override
    public boolean verifyCertiHKCompanyExists(String companyRegisteredCertificateNo) {
        KycCertiHKCompany kycCertiHKCompanyQuery = new KycCertiHKCompany();
        kycCertiHKCompanyQuery.setCompanyRegisteredCertificateNo(companyRegisteredCertificateNo);
        KycCertiHKCompany kycCertiHKCompany = iBaseMapper.selectOne(kycCertiHKCompanyQuery);
        boolean result = null == kycCertiHKCompany ? false : true;
        if(!result){
            KycSunrateRegister kycSunrateRegisterQuery = new KycSunrateRegister();
            kycSunrateRegisterQuery.setOrgCode(companyRegisteredCertificateNo);
            KycSunrateRegister kycSunrateRegister = apiSunrateRegisterServiceImpl.getiBaseMapper().selectOne(kycSunrateRegisterQuery);
            result = null == kycSunrateRegister ? false : true;
        }
        return result;
    }

    @Override
    public ResponseMessage certiHKCompanyUpdate(KycCertiHKCompanyReq kycCertiHKCompanyReq, KycNaturalVO kycNaturalVO) {
        log.info("香港企业-实名认证编辑处理开始:{}", JSON.toJSONString(kycCertiHKCompanyReq));
        KycCertiHKCompany kycCertiHKCompanySel = iBaseMapper.selectByPrimaryKey(kycCertiHKCompanyReq.getId());
        if(null == kycCertiHKCompanySel){
            log.error("根据主键未查询到实名认证信息：{}",kycCertiHKCompanyReq.getId());
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        BeanUtils.copyProperties(kycCertiHKCompanyReq,kycCertiHKCompanySel);
        kycCertiHKCompanySel.setUpdateId(kycNaturalVO.getId());
        kycCertiHKCompanySel.setUpdateName(kycNaturalVO.getCertificationName());
        kycCertiHKCompanySel.setUpdateDts(new Date());
        int updateCertiCount = iBaseMapper.updateByPrimaryKeySelective(kycCertiHKCompanySel);
        log.info("更新certihkcompany表记录：{}条",updateCertiCount);
        KycCertiLinkFile kycCertiLinkFileDel = new KycCertiLinkFile();
        kycCertiLinkFileDel.setKycNaturalId(kycNaturalVO.getId());
        kycCertiLinkFileDel.setDelFlag(false);
        List<KycCertiLinkFile> selectList = apiKycCertiLinkFilelServiceImpl.getiBaseMapper().select(kycCertiLinkFileDel);
        selectList.stream().forEach(kycCertiLinkFile -> {
            if(StringUtils.isNotBlank(kycCertiLinkFile.getContactsId())){
                return;
            }
            kycCertiLinkFile.setDelFlag(true);
            kycCertiLinkFile.setUpdateDts(new Date());
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().updateByPrimaryKeySelective(kycCertiLinkFile);
        });
        List<KycCertiLinkFile> kycCertiLinkFileList = apiKycCertiLinkFilelServiceImpl.ConvertToKycCertiLinkFile(kycCertiHKCompanyReq.getId(), kycNaturalVO, kycCertiHKCompanyReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-香港企业实名认证信息编辑完成");

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.KYC_INFO_SUBMIT);
        kycNaturalReq.setRegisterType(RegisterType.HK_COMPANY);
        kycNaturalReq.setCertificationName(kycCertiHKCompanyReq.getCompanyName());
        kycNaturalReq.setIdNo(kycCertiHKCompanyReq.getCompanyRegisteredCertificateNo());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);
        return ResultUtil.success(kycCertiHKCompanyReq.getId());
    }
}
