package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiContactsService;
import com.js.api.jspay.service.ApiKycCertiLinkFileService;
import com.js.common.constant.Constant;
import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycCertiContactsReq;
import com.js.common.model.req.KycCertiLinkFileReq;
import com.js.common.model.vo.KycCertiContactsVO;
import com.js.common.model.vo.KycCertiLinkFileVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.KycCertiContacts;
import com.js.dal.dao.model.KycCertiLinkFile;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Description: kyc联系人操作管理
 * @Author: liuh
 * @Create: 2019-08-15
 */
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiKycCertiContactsServiceImpl extends IBaseServiceImpl<KycCertiContacts> implements ApiKycCertiContactsService {
    @Autowired
    ApiKycCertiLinkFilelServiceImpl apiKycCertiLinkFilelServiceImpl;
    @Autowired
    ApiKycCertiLinkFileService apiKycCertiLinkFileService;

    @Override
    public ResponseMessage saveKycCertiContacts(KycCertiContactsReq kycCertiContactsReq, KycNaturalVO kycNaturalVO) {
        KycCertiContacts kycCertiContacts = new KycCertiContacts();
        BeanUtils.copyProperties(kycCertiContactsReq,kycCertiContacts);
        kycCertiContacts.setId(IdUtil.simpleUUID());
        kycCertiContacts.setKycNaturalId(kycNaturalVO.getId());
        kycCertiContacts.setContactType("KYC_BENEFICIARY");
        kycCertiContacts.setIdTypeName(kycCertiContacts.getIdType().getEnumName());
        kycCertiContacts.setCreateId(kycCertiContactsReq.getKycNaturalId());
        kycCertiContacts.setStatus(ProcessStatusEnum.TRADE_SUBMITTED);
        int insertCount = iBaseMapper.insertSelective(kycCertiContacts);
        log.info("{}-kyc插入联系人信息条数：{}",kycCertiContactsReq.getKycNaturalId(),insertCount);

        List<KycCertiLinkFile> kycCertiLinkFileList = apiKycCertiLinkFilelServiceImpl.ConvertToKycCertiLinkFile(kycCertiContactsReq.getKycCertiId(), kycNaturalVO, kycCertiContactsReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            kycCertiLinkFile.setContactsId(kycCertiContacts.getId());
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().insertSelective(kycCertiLinkFile);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage getKycCertiContacts(KycCertiContactsReq kycCertiContactsReq) {
        KycCertiContacts kycCertiContactsQuery = new KycCertiContacts();
        if(StringUtils.isNotBlank(kycCertiContactsReq.getId())){
            kycCertiContactsQuery.setId(kycCertiContactsReq.getId());
        }
        if(StringUtils.isNotBlank(kycCertiContactsReq.getKycNaturalId())){
            kycCertiContactsQuery.setKycNaturalId(kycCertiContactsReq.getKycNaturalId());
        }
        if(StringUtils.isNotBlank(kycCertiContactsReq.getKycCertiId())){
            kycCertiContactsQuery.setKycCertiId(kycCertiContactsReq.getKycCertiId());
        }
        kycCertiContactsQuery.setDelFlag(false);
        List<KycCertiContacts> kycCertiContactsList = iBaseMapper.select(kycCertiContactsQuery);
        List<KycCertiContactsVO> kycCertiContactsVOList = new ArrayList<>();
        kycCertiContactsList.stream().forEach(kycCertiContacts -> {
            KycCertiContactsVO kycCertiContactsVO = new KycCertiContactsVO();
            BeanUtils.copyProperties(kycCertiContacts,kycCertiContactsVO);
            KycCertiLinkFileReq kycCertiLinkFileReq = new KycCertiLinkFileReq();
            kycCertiLinkFileReq.setPriId(kycCertiContacts.getKycCertiId());
            kycCertiLinkFileReq.setContactsId(kycCertiContacts.getId());
            List<KycCertiLinkFileVO> certiFileList = apiKycCertiLinkFileService.findCertiFileList(kycCertiLinkFileReq);
            log.info("查找到附件条数：{}", CollectionUtils.isEmpty(certiFileList) ? 0 : certiFileList.size());
            kycCertiContactsVO.setKycCertiLinkFileReqList(certiFileList);
            kycCertiContactsVOList.add(kycCertiContactsVO);
        });
        return ResultUtil.success(kycCertiContactsVOList);
    }

    @Override
    public ResponseMessage updateKycCertiContacts(KycCertiContactsReq kycCertiContactsReq, KycNaturalVO kycNaturalVO) {
        log.info("编辑联系人信息提交处理开始:{}", JSON.toJSONString(kycCertiContactsReq));
        KycCertiContacts kycCertiContactsSel = iBaseMapper.selectByPrimaryKey(kycCertiContactsReq.getId());
        if(null == kycCertiContactsSel){
            log.error("根据主键未查询到联系人信息：{}",kycCertiContactsReq.getId());
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        BeanUtils.copyProperties(kycCertiContactsReq,kycCertiContactsSel);
        kycCertiContactsSel.setUpdateId(kycNaturalVO.getId());
        kycCertiContactsSel.setUpdateName(kycNaturalVO.getCertificationName());
        kycCertiContactsSel.setUpdateDts(new Date());
        int updateCount = iBaseMapper.updateByPrimaryKeySelective(kycCertiContactsSel);
        log.info("{}-更新kyc_certi_contacts表记录：{}条",kycCertiContactsReq.getKycNaturalId(),updateCount);

        KycCertiLinkFile kycCertiLinkFileDel = new KycCertiLinkFile();
        kycCertiLinkFileDel.setKycNaturalId(kycNaturalVO.getId());
        kycCertiLinkFileDel.setContactsId(kycCertiContactsReq.getId());
        kycCertiLinkFileDel.setDelFlag(false);
        List<KycCertiLinkFile> selectList = apiKycCertiLinkFilelServiceImpl.getiBaseMapper().select(kycCertiLinkFileDel);
        selectList.stream().forEach(kycCertiLinkFile -> {
            kycCertiLinkFile.setDelFlag(true);
            kycCertiLinkFile.setUpdateDts(new Date());
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().updateByPrimaryKeySelective(kycCertiLinkFile);
        });
        List<KycCertiLinkFile> kycCertiLinkFileList = apiKycCertiLinkFilelServiceImpl.ConvertToKycCertiLinkFile(kycCertiContactsReq.getKycCertiId(), kycNaturalVO, kycCertiContactsReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            kycCertiLinkFile.setContactsId(kycCertiContactsReq.getId());
            apiKycCertiLinkFilelServiceImpl.getiBaseMapper().insertSelective(kycCertiLinkFile);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
