package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.ApiJsPayUserAcctService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPayUserAcctReq;
import com.js.common.model.vo.JsPayUserAcctVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.JsPayUserAcct;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Description: 客户第三方账户表操作接口具体实现
 * @Author: liuh
 * @Create: 2019-06-30
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPayUserAcctServiceImpl extends IBaseServiceImpl<JsPayUserAcct> implements ApiJsPayUserAcctService {
    @Override
    public ResponseMessage addJsPayUserAcct(JsPayUserAcctReq jsPayUserAcctReq, KycNaturalVO kycNaturalVO){
        JsPayUserAcct jsPayUserAcct = new JsPayUserAcct();
        BeanUtils.copyProperties(jsPayUserAcctReq,jsPayUserAcct);
        jsPayUserAcct.setId(IdUtil.simpleUUID());
        jsPayUserAcct.setCreateId(kycNaturalVO.getId());
        jsPayUserAcct.setCreateName(kycNaturalVO.getCertificationName());
        jsPayUserAcct.setCreateDts(new Date());
        int insertCount = iBaseMapper.insertSelective(jsPayUserAcct);
        log.info("插入客户第三方开户数据条数：{}",insertCount);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public List<JsPayUserAcctVO> findJsPayUserAcct(JsPayUserAcctReq jsPayUserAcctReq) {
        JsPayUserAcct jsPayUserAcctQuery = new JsPayUserAcct();
        jsPayUserAcctQuery.setKycNaturalId(jsPayUserAcctReq.getKycNaturalId());
        if(null != jsPayUserAcctReq.getAcctType()){
            jsPayUserAcctQuery.setAcctType(jsPayUserAcctReq.getAcctType());
        }
        if(null != jsPayUserAcctReq.getAcctNo()){
            jsPayUserAcctQuery.setAcctNo(jsPayUserAcctReq.getAcctNo());
        }
        jsPayUserAcctQuery.setDelFlag(false);
        List<JsPayUserAcct> select = iBaseMapper.select(jsPayUserAcctQuery);
        List<JsPayUserAcctVO> resultList = new ArrayList<>();
        select.stream().forEach(jsPayUserAcct -> {
            JsPayUserAcctVO jsPayUserAcctVO = new JsPayUserAcctVO();
            BeanUtils.copyProperties(jsPayUserAcct,jsPayUserAcctVO);
            resultList.add(jsPayUserAcctVO);
        });
        return resultList;
    }
}
