package com.js.pay.service.chinapnr.example;

import com.js.pay.service.chinapnr.example.utils.SignatureUtil;
import com.js.pay.service.chinapnr.example.utils.XMLSecurityProcess;
import com.js.pay.service.chinapnr.example.utils.XMLUtil;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import common.util.httpclient.HttpRequestContext;
import common.util.httpclient.HttpSendResult;
import common.util.httpclient.impl.HttpClientServiceImpl;
import common.util.httpclient.impl.SimpleHttpsClientImpl;
import freemarker.template.Configuration;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;

public class QueryAccountAmt {

    private static String chinapnrPfxUrl = "d:/fct/";
    private static String chinapnrPfx = "d:/fct/10006050001.pfx";
    private static String chinapnrCer = "D:/fct/ChinaPnR.rsa.cer";

        /**
         * 模版文件配置
         */
        private static Configuration cfg = new Configuration();
        //测试环境
        private static String postUrl = "https://hfgj.chinapnr.com/pay/receivesell.htm";

        public static  void main(String [] args){

            Map<String, Object> parameter = new HashMap<>();

            //商户号
            parameter.put("MERCHANTID","1000605000101");
            //终端号
            parameter.put("TERMINALID","0010001");
            //交易类别
            parameter.put("TRXTYPE","200010");
            //产品类型
            parameter.put("PRODUCTTYPE","JH");
            //接口版本
            parameter.put("VERSION","1.0");

            parameter.put("ACCT_TYPE","001");
            parameter.put("ACCT_CUR","CNY");
            parameter.put("EXT1","EXT1");
            parameter.put("EXT2","EXT1");
            chinaPNRTest test = new chinaPNRTest();
            String requestXml = test.transferToXML(parameter, parameter.get("TRXTYPE").toString());
            System.out.println(requestXml);

            Document doc = XMLUtil.str2Doc(requestXml,"utf-8");

            String merchantAcctId = parameter.get("MERCHANTID").toString();
            String envType = "stage2";
            String password = "123456";
            String aliasName = "test-alias";
            System.out.println("doc="+doc.toString());
            System.out.println(merchantAcctId);
            System.out.println(envType);
            System.out.println(password);
            System.out.println(aliasName);
            try {
                SignatureUtil.xmlSignature(doc, envType, merchantAcctId.substring(0,merchantAcctId.length()-2),
                        password, aliasName,chinapnrPfxUrl,chinapnrPfx);
            } catch (Exception e) {
                e.printStackTrace();
            }

            requestXml = XMLUtil.doc2Str(doc,"utf-8");
            System.out.println("requestXml:" + requestXml);

            HttpRequestContext context = new HttpRequestContext();
            context.setUrl(postUrl);
            context.setHttpMethod(HttpRequestContext.POST_METHOD);
            context.setResponseCharset("utf-8");
            context.setRequestCharset("utf-8");
            context.setXml(requestXml);
            HttpSendResult result = null;
            HttpClientServiceImpl httpClient = new HttpClientServiceImpl();
            SimpleHttpsClientImpl shci = new SimpleHttpsClientImpl();
            httpClient.setHttpsClient(shci);
            try {
                result = httpClient.sendRequest(context);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

            String respTxt = null;
            if (null ==  result) {
                respTxt = "网关系统异常------";
            }else{
                System.out.println("result:" + result.getResponseBody());


                if(result.getStatus() == 200){
                    respTxt = result.getResponseBody();
                }else{
                    respTxt = "网关系统异常,状态码[" + result.getStatus() + "]";
                }
            }

            Document resDoc = null;
            try{
                DOMParser parser = new DOMParser();
                parser.parse(new InputSource(new ByteArrayInputStream(respTxt.getBytes("UTF-8"))));
                // 解析XML文档
                resDoc = parser.getDocument();

            }catch (Exception e){

            }
            boolean falg = false;
            try{
                falg = XMLSecurityProcess.veryfySignature(resDoc,chinapnrCer);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            if (falg){
                System.out.println("返回结果验签成功");
            }else{
                System.out.println("返回结果验签失败");
            }

            String nodePath = "/RESPONSE/PARAMS/STATUS";
            String nodeValue = ChinaPNRCommons.getNodeValue(resDoc, nodePath);
            System.out.println(nodeValue);

    }

}
