package com.js.pay.service.impl;

import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiJsPaySupplierPayeeService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPaySupplierInfoReq;
import com.js.common.model.vo.JsPayStationOrganInfoVO;
import com.js.common.model.vo.JsPaySupplierRcvVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySupplierPayeeMapper;
import com.js.dal.dao.model.JsPaySupplierPayee;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPaySupplierPayeeServiceImpl extends IBaseServiceImpl<JsPaySupplierPayee> implements ApiJsPaySupplierPayeeService {
    @Autowired
    JsPaySupplierPayeeMapper jsPaySupplierPayeeMapper;

    @Override
    public ResponseMessage inserPaySupplierPayee(JsPaySupplierInfoReq jsPaySupplierInfoReq) {
        try{
            JsPaySupplierPayee jsPaySupplierPayee = new JsPaySupplierPayee();
            jsPaySupplierPayee.setBeneficiaryId(jsPaySupplierInfoReq.getBeneficiaryId());
            jsPaySupplierPayee.setKycNaturalId(jsPaySupplierInfoReq.getKycNaturalId());
            jsPaySupplierPayee.setSupplierId(jsPaySupplierInfoReq.getId());
            jsPaySupplierPayee.setCreateId(jsPaySupplierInfoReq.getKycNaturalId());
            iBaseMapper.insertSelective(jsPaySupplierPayee);
        }catch(Exception e){
            return ResultUtil.error(ResultEnum.SAVE_ERROR);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage queryRcvList(String kycNaturalId) {
        List<JsPaySupplierRcvVO> list = jsPaySupplierPayeeMapper.queryRcvList(kycNaturalId);
        PageInfo<JsPaySupplierRcvVO> pageInfo = new PageInfo<>(list);
        return ResultUtil.success(list,ResultEnum.SUCCESS);
    }

    @Override
    public String queryRcvByRMB(String kycNaturalId) {

        return null;
    }
}
