package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiJsLoanApplyInfoService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPaySunrateBankTradeInReq;
import com.js.common.model.vo.JsLoanApplyInfoVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.KycSunrateStoreMapper;
import com.js.dal.dao.model.*;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Optional;

/**
 * @Description: 客户贷款申请表交互具体实现
 * @Author: liuh
 * @Create: 2019-06-17
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiJsLoanApplyInfoServiceImpl extends IBaseServiceImpl<JsLoanApplyInfo> implements ApiJsLoanApplyInfoService {
    @Autowired
    KycSunrateStoreMapper kycSunrateStoreMapper;

    @Override
    public ResponseMessage findLoanApplyInfo(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq) {
        KycSunrateStore kycSunrateStoreQuery = new KycSunrateStore();
        kycSunrateStoreQuery.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        kycSunrateStoreQuery.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        KycSunrateStore kycSunrateStore = kycSunrateStoreMapper.selectOne(kycSunrateStoreQuery);
        if(null == kycSunrateStore){
            log.error("未查询到寻汇店铺信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        JsLoanApplyInfo jsLoanApplyInfoQuery = new JsLoanApplyInfo();
        jsLoanApplyInfoQuery.setKycNaturalId(kycSunrateStore.getKycNaturalId());
        JsLoanApplyInfo jsLoanApplyInfo = iBaseMapper.selectOne(jsLoanApplyInfoQuery);
        if(null == jsLoanApplyInfo){
            log.info("未查询到贷款信息:{}",kycSunrateStore.getKycNaturalId());
            return ResultUtil.success(ResultEnum.SUCCESS);
        }
        JsLoanApplyInfoVO jsLoanApplyInfoVO = new JsLoanApplyInfoVO();
        BeanUtils.copyProperties(jsLoanApplyInfo,jsLoanApplyInfoVO);
        return ResultUtil.success(jsLoanApplyInfoVO);
    }


}
