package com.js.pay.service.chinapnr.example.pay;

import com.js.common.constant.CommonConstant;
import com.js.common.model.req.ChinaPNRSubstituteDetails;
import com.js.common.model.req.ChinaPNRSubstituteQueryReq;
import com.js.common.model.req.ChinaPNRSubstituteReq;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import com.js.pay.service.chinapnr.example.ChinaPnrConfigure;
import com.js.pay.service.chinapnr.example.DateUtils;
import com.js.pay.service.chinapnr.example.otherutils.HttpSendResult;
import com.js.pay.service.chinapnr.example.otherutils.SignTool;
import com.js.pay.service.chinapnr.example.otherutils.SimpleHttpsClient;
import com.js.pay.service.chinapnr.example.otherutils.XMLSecurityProcess;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 汇付国际完成 New 代发  客户提现
 */
@Slf4j
@Component
public class ChinaPNRNewSubstitute {


    /**
     * 汇付配置文件
     */
     @Autowired
     private  ChinaPnrConfigure chinaPnrConfigure ;

    /**
     * 代发
     * @param req
     * @return
     */
    public Map<String,String> substitute(ChinaPNRSubstituteReq req){

        Map<String,String> resMap = new HashMap<>();
        Map<String, String> parameter = new HashMap<>();
        //接口版本
        parameter.put("version", chinaPnrConfigure.getNewVersion());
        parameter.put("signType", chinaPnrConfigure.getSigntype());
        parameter.put("requestTime", DateUtils.LONG_DATE_FORMAT_SSS.format(new Date()));
        parameter.put("requestId",req.getRequestId());
        //商户号
        parameter.put("merchantAcctId", chinaPnrConfigure.getMerchantid());
        //终端号
        parameter.put("terminalId", chinaPnrConfigure.getTerminalid());
        parameter.put("batchNo",req.getBatchNo());
        parameter.put("payCur", req.getPayCur());
        parameter.put("payTCnt", req.getPayTCnt() + "");
        parameter.put("payTAmt", req.getPayTAmt().toPlainString());
        parameter.put("remitType",req.getRemitType());
        parameter.put("ignoreFlag","1");
        //parameter.put("purpose","代发");
        parameter.put("ext1","");
        parameter.put("ext2","");
        parameter.put("noticeUrl", chinaPnrConfigure.getNewResultUrl());
        //parameter.put("realTimeNoticeUrl","");

        StringBuilder detailsStr = new StringBuilder();
        List<ChinaPNRSubstituteDetails> detailsList = req.getDetailsList();
        int detailSize = detailsList.size(); //大小
        //明细
        for(int i = 0 ; i < detailSize ; i++){

            ChinaPNRSubstituteDetails details = detailsList.get(i);
            detailsStr.append(details.getSubstituteDetailId())
                    .append("|")
                    .append(details.getSubstituteDetailAmt())
                    .append("|")
                    .append(details.getReceivablesBankCode())
                    .append("|")
                    .append(details.getReceivablesAccType())
                    .append("|")
                    .append("1") //到账时效 文档没有该字段，联调中渠道方让加的
                    .append("|")
                    .append(details.getAccountNumbe())
                    .append("|")
                    .append(details.getAccountName())
                    .append("|")
                    .append(details.getDocumentType())
                    .append("|")
                    .append(details.getIdentificationNumber())
                    .append("|")
                    .append(details.getProvince())
                    .append("|")
                    .append(details.getRegion())
                    .append("|")
                    .append(details.getBranchName())
                    .append("|")
                    .append(details.getPurpose())
                    .append("|")
                    .append("T" + chinaPnrConfigure.getTrxtypeDf())
                    .append("|")
                    .append("ext1")
                    .append("|")
                    .append("ext2")
                    .append("|")
                    .append(details.getPaymentOutName())
                    .append("|")
                    .append(details.getPaymentBank());
            if(detailSize > i + 1){
                detailsStr.append(";");
            }
        }
        parameter.put("details",detailsStr.toString());

        Map<String,String> signMsgValMap = new HashMap<>();
        signMsgValMap.put("batchNo", parameter.get("batchNo"));
        signMsgValMap.put("ignoreFlag", parameter.get("ignoreFlag"));
        signMsgValMap.put("merchantAcctId", parameter.get("merchantAcctId"));
        signMsgValMap.put("noticeUrl", parameter.get("noticeUrl"));
        signMsgValMap.put("payCur", parameter.get("payCur"));
        signMsgValMap.put("payTAmt", parameter.get("payTAmt"));
        signMsgValMap.put("payTCnt", parameter.get("payTCnt"));
        signMsgValMap.put("requestId", parameter.get("requestId"));
        signMsgValMap.put("requestTime", parameter.get("requestTime"));
        signMsgValMap.put("signType", parameter.get("signType"));
        signMsgValMap.put("terminalId", parameter.get("terminalId"));
        signMsgValMap.put("version", parameter.get("version"));

        String signMsgVal = ChinaPNRCommons.createLinkString(signMsgValMap);
        log.info("汇付代发签名：" + signMsgVal);
        SignTool pki = new SignTool(chinaPnrConfigure.getMerchantid().substring(0,
                                    chinaPnrConfigure.getMerchantid().length() - 2),
                "", chinaPnrConfigure.getPassword(), chinaPnrConfigure.getAliasname());
        String signMsg = pki.signMsg(signMsgVal,chinaPnrConfigure.getChinapnrPfxUrl());
        parameter.put("signMsg", signMsg);

        SimpleHttpsClient httpClient = new SimpleHttpsClient();

        HttpSendResult result = null;
        log.info("map=" + parameter);
        try {
            result = httpClient.postRequest(chinaPnrConfigure.getNewPosturl(),
                    parameter, 30000);
        } catch (Exception e) {
            log.error("请求代发功能请求异常");
            resMap.put("code", CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","理代发功能请求异常");
            return resMap;
        }
        log.info("汇付代发请求返回结果:" + result.getResponseBody());
        if (null ==  result) {
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付代发网关系统异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付代发网关系统异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }
        Map<String,String> callbackMap = ChinaPNRCommons.getCallbackMap(result.getResponseBody());
        String callbackSignMsgVal = ChinaPNRCommons.createLinkString(callbackMap);

        log.info("汇付代发返回参数验签=" + callbackSignMsgVal);
        String callbackSignMsg = callbackMap.get("signMsg");

        boolean veryfyResult=false;
        try {
            //BG通知未转义，需要先转义
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, URLDecoder.decode(callbackSignMsg),chinaPnrConfigure.getChinapnrCer());
        } catch (Exception e) {
            log.error("汇付代发返回信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付代发返回信息验签异常");
            return resMap;
        }
        if(!veryfyResult){
            log.info("汇付代发返回信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付代发返回信息验签失败");
            return resMap;
        }
        //返回错误
        if(!callbackMap.get("errorCode").equals("000000")){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg",callbackMap.get("errorMsg"));
            return resMap;
        }
        resMap.put("reqText",parameter.toString());
        resMap.put("resText",result.getResponseBody());

        if(!callbackMap.get("status").equals("1")){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付代发失败 汇付状态status不为1");
            return resMap;
        }
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        resMap.put("msg","汇付代发成功");
        return resMap;
    }

    /**
     * 代发回调
     * @param map
     * @return
     */
    public Map<String,String> substituteCallback(Map<String,String> map){

        Map<String,String> resMap = new HashMap<>();
        Map<String,String> signMsgValMap = new HashMap<>();
        signMsgValMap.put("version", map.get("version"));
        signMsgValMap.put("terminalId", map.get("terminalId"));
        signMsgValMap.put("signType", map.get("signType"));
        signMsgValMap.put("batchNo", map.get("batchNo"));
        signMsgValMap.put("requestTime", map.get("requestTime"));
        signMsgValMap.put("merchantAcctId", map.get("merchantAcctId"));
        signMsgValMap.put("payTAmt", map.get("payTAmt"));
        signMsgValMap.put("payTCnt", map.get("payTCnt"));
        signMsgValMap.put("payCur", map.get("payCur"));
        signMsgValMap.put("noticeUrl", map.get("noticeUrl"));

        //Map排序
        String callbackSignMsgVal = ChinaPNRCommons.createLinkString(signMsgValMap);
        log.info("汇付代发回调参数验签=" + callbackSignMsgVal);
        String callbackSignMsg = map.get("signMsg");

        boolean veryfyResult=false;
        try {
            //BG通知未转义，需要先转义
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, URLDecoder.decode(callbackSignMsg),chinaPnrConfigure.getChinapnrCer());
        } catch (Exception e) {
            log.error("汇付代发回调信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付代发返回信息验签异常");
            return resMap;
        }
        if(!veryfyResult){
            log.info("汇付代发回调息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付代发回调信息验签失败");
            return resMap;
        }
        resMap.put("resText",map.toString());
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        resMap.put("msg","汇付回调代发成功");
        return resMap;
    }

    /**
     * 处理汇付代发报文
     * @return
     */
    public Map<String,String> substituteQuery(ChinaPNRSubstituteQueryReq reqQuery){

        Map<String,String> resMap = new HashMap<>();
        Map<String, String> parameter = new HashMap<>();
        parameter.put("signType", chinaPnrConfigure.getSigntype());
        parameter.put("requestId",reqQuery.getRequestId());
        parameter.put("requestTime", DateUtils.LONG_DATE_FORMAT_SSS.format(new Date()));
        //接口版本
        parameter.put("version", chinaPnrConfigure.getNewVersion());
        //商户号
        parameter.put("merchantAcctId",chinaPnrConfigure.getMerchantid());
        //终端号
        parameter.put("terminalId", chinaPnrConfigure.getTerminalid());
        parameter.put("batchNo",reqQuery.getBatchNo());
        parameter.put("remitNo",reqQuery.getRemitNo());
        parameter.put("applyDate",reqQuery.getApplyDate());

        Map<String,String> signMsgValMap = new HashMap<>();
        signMsgValMap.put("requestId", parameter.get("requestId"));
        signMsgValMap.put("requestTime", parameter.get("requestTime"));
        signMsgValMap.put("merchantAcctId", parameter.get("merchantAcctId"));
        signMsgValMap.put("signType", parameter.get("signType"));
        signMsgValMap.put("version", parameter.get("version"));
        signMsgValMap.put("terminalId", parameter.get("terminalId"));
        signMsgValMap.put("batchNo", parameter.get("batchNo"));
        signMsgValMap.put("remitNo", parameter.get("remitNo"));
        signMsgValMap.put("applyDate", parameter.get("applyDate"));

        String signMsgVal = ChinaPNRCommons.createLinkString(signMsgValMap);
        log.info("汇付代发单笔查询签名：" + signMsgVal);
        String merchantId = chinaPnrConfigure.getMerchantid();
        SignTool pki = new SignTool(merchantId.substring(0, merchantId.length() - 2),
                "", chinaPnrConfigure.getPassword(), chinaPnrConfigure.getAliasname());
        String signMsg = pki.signMsg(signMsgVal,chinaPnrConfigure.getChinapnrPfxUrl());
        parameter.put("signMsg", signMsg);
        log.info("汇付单笔查询签名结果signMsg = " + signMsg);
        SimpleHttpsClient httpClient = new SimpleHttpsClient();
        HttpSendResult result = null;
        log.info("汇付单笔查询请求参数map=" + parameter);
        try {
            result = httpClient.postRequest(chinaPnrConfigure.getNewQueryurl(),
                    parameter, 30000);
        } catch (Exception e) {
            log.error("汇付查询功能请求异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","理代发功能请求异常");
            return resMap;
        }
        log.info("汇付查询请求返回结果:" + result.getResponseBody());
        if (null ==  result) {
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付查询网关系统异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付查询网关系统异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }
        Map<String,String> callbackMap = ChinaPNRCommons.getCallbackMap(result.getResponseBody());
        String callbackSignMsgVal = ChinaPNRCommons.createLinkString(callbackMap);

        log.info("汇付代发查询返回参数验签=" + callbackSignMsgVal);
        String callbackSignMsg = callbackMap.get("signMsg");

        boolean veryfyResult=false;
        try {
            //BG通知未转义，需要先转义
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, URLDecoder.decode(callbackSignMsg),chinaPnrConfigure.getChinapnrCer());
        } catch (Exception e) {
            log.error("汇付代发查询返回信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付代发查询返回信息验签异常");
            return resMap;
        }
        if(!veryfyResult){
            log.info("汇付代发查询返回信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付代发查询返回信息验签失败");
            return resMap;
        }
        //返回错误
        if(!callbackMap.get("errorCode").equals("")){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg",resMap.get("errorMsg"));
            return resMap;
        }
        resMap.put("status",callbackMap.get("status"));
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        resMap.put("msg",callbackMap.get("errorMsg"));
        resMap.put("amt",callbackMap.get("amt"));
        return resMap;
    }
}
