package com.js.pay.service.chinapnr.example.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;


public class StringEncrypt {
	/**
	 * 对字符串加密,加密算法使用MD5,SHA-1,SHA-256,默认使用SHA-256
	 * 
	 * @param strSrc
	 *            要加密的字符串
	 * @param encName
	 *            加密类型
	 * @return
	 */
	public static String Encrypt(String strSrc, String encName) {
		MessageDigest md = null;
		String strDes = null;

		byte[] bt = strSrc.getBytes();
		try {
			if (encName == null || encName.equals("")) {
				encName = "SHA-256";
			}
			md = MessageDigest.getInstance(encName);
			md.update(bt);
			strDes = bytes2Hex(md.digest()); // to HexString
		} catch (NoSuchAlgorithmException e) {
			return null;
		}
		return strDes;
	}

	public static String bytes2Hex(byte[] bts) {
		String des = "";
		String tmp = null;
		for (int i = 0; i < bts.length; i++) {
			tmp = (Integer.toHexString(bts[i] & 0xFF));
			if (tmp.length() == 1) {
				des += "0";
			}
			des += tmp;
		}
		return des;
	}


	public static void main(String args[]) {
		String yw="CompanyId=JWP_TEST&OrderId=ff49c0edd1bb464ca2e90243";
		String key = "123456";
		String ycmw = StringEncrypt.Encrypt(yw, "");
		System.out.println("原文：" + yw);
		System.out.println("一次签名：" + ycmw);
		System.out.println(ycmw.length());
		System.out.println("秘钥：" + key);
		String ecmw = StringEncrypt.Encrypt(ycmw + key, "");
		System.out.println("二次签名：" + ecmw);
		System.out.println(ecmw.length());
	}
	
}