package com.js.pay.service.chinapnr.example;

import com.js.pay.service.chinapnr.example.otherutils.HttpSendResult;
import com.js.pay.service.chinapnr.example.otherutils.SignTool;
import com.js.pay.service.chinapnr.example.otherutils.SimpleHttpsClient;
import com.js.pay.service.chinapnr.example.otherutils.XMLSecurityProcess;
import sun.misc.BASE64Encoder;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.*;

public class PersonalOpenAccount {

    private static String chinapnrPfxUrl = "d:/prod/";
    private static String chinapnrPfx = "d:/prod/30219080336.pfx";
    private static String chinapnrCer = "D:/prod/ChinaPnR.rsa.cer";

    public static void main(String[] args) {

        Map<String, String> parameter = new HashMap<>();


        //接口版本
        parameter.put("version", "1");
        parameter.put("signType", "4");

        //商户号
        parameter.put("merchantAcctId", "3021908033601");
        parameter.put("requestTime", "20190815150801");

        parameter.put("requestId", "R20190815150805");
        //用户平台ID
        parameter.put("platformUserId", "JS000000000000004");
        parameter.put("platformRegTime", "0190815150801");
        parameter.put("name", "杜沛");
        parameter.put("certType", "00");
        parameter.put("certId", "11010619880729152X");
        parameter.put("certExpDateStart", ""); //证件失效日期
        parameter.put("certExpDateEnd", "20360507"); //证件失效日期
        parameter.put("mobileNumber", "13910408928"); //
        parameter.put("address", "北京市丰台区"); //
        parameter.put("email", "dupei@jishiyupay.com"); //
        parameter.put("bankCode", "CMB"); //
        parameter.put("acctType", "2"); //
        parameter.put("bankAcct", "6214850118263653"); //
        parameter.put("acctName", "杜沛"); //
        parameter.put("province", ""); //
        parameter.put("area", ""); //
        parameter.put("bankBranch", ""); //
        parameter.put("uniteBankCode", ""); //
        parameter.put("certPhotoCopyF", getImageStr("d:/kaihu/20190815154834.jpg")); //证件影印件正面
        parameter.put("certPhotoCopyB", getImageStr("d:/kaihu/20190815154857.jpg")); //证件影印件反面
        parameter.put("asyncNoticeFlag", "1"); //
        parameter.put("noticeUrl", "http://114.55.171.170:9010/api/v1/anon/opendAccount/personal"); //
        //parameter.put("signMsg","2"); //

//        version={version}&signType={signType}&requestId={requestId}
//        &requestTime={requestTime}&merchantAcctId={merchantAcctId}&
//        platformUserId={platformUserId}&platformRegTime={platformRegTime}
//        &name={name}&certType={certType}&certId={certId}&certExpDate={certExpDate}
//        &mobileNumber={mobileNumber}&address={address}&email={email}&bankCode={bankCode}
//        &acctType={acctType}&bankAcct={bankAcct}&acctName={acctName}&province={province}
//        &area={area}&bankBranch={bankBranch}&uniteBankCode={uniteBankCode}&
//        noticeUrl={noticeUrl}

        Map<String,String> signMsgValMap = new HashMap<>();
        signMsgValMap.put("version", parameter.get("version").toString());
        signMsgValMap.put( "signType", parameter.get("signType").toString());
        signMsgValMap.put( "requestId", parameter.get("requestId").toString());
        signMsgValMap.put( "requestTime", parameter.get("requestTime").toString());
        signMsgValMap.put("merchantAcctId", parameter.get("merchantAcctId").toString());
        signMsgValMap.put( "platformUserId", parameter.get("platformUserId").toString());
        signMsgValMap.put("platformRegTime", parameter.get("platformRegTime").toString());
        signMsgValMap.put("name", parameter.get("name").toString());
        signMsgValMap.put( "certType", parameter.get("certType").toString());
        signMsgValMap.put( "certId", parameter.get("certId").toString());
//        signMsgValMap.put( "certExpDate", parameter.get("certExpDateEnd").toString());
        signMsgValMap.put( "mobileNumber", parameter.get("mobileNumber").toString());
        signMsgValMap.put( "address", parameter.get("address").toString());
        signMsgValMap.put("email", parameter.get("email").toString());
        signMsgValMap.put( "bankCode", parameter.get("bankCode").toString());
        signMsgValMap.put( "acctType", parameter.get("acctType").toString());
        signMsgValMap.put( "bankAcct", parameter.get("bankAcct").toString());
        signMsgValMap.put( "acctName", parameter.get("acctName").toString());
//        signMsgValMap.put( "province", parameter.get("province").toString());
//        signMsgValMap.put( "area", parameter.get("area").toString());
//        signMsgValMap.put( "bankBranch", parameter.get("bankBranch").toString());
//        signMsgValMap.put( "uniteBankCode", parameter.get("uniteBankCode").toString());
        signMsgValMap.put( "noticeUrl", parameter.get("noticeUrl").toString());

        String signMsgVal = createLinkString(signMsgValMap);
        System.out.println("签名：" + signMsgVal);
        //商户会员号，不可空。
        String merchantAcctId = parameter.get("merchantAcctId").toString();
        //String memberCode = "10006050001";
        //1001215986901
        // String merchantAcctId = memberCode + "01";
        //证书密码,不可空。
        String keyPass = "123456";
        //证书名
        String aliasName = "prod-alias";
        SignTool pki = new SignTool(merchantAcctId.substring(0, merchantAcctId.length() - 2), "", keyPass, aliasName);
        String signMsg = pki.signMsg(signMsgVal,chinapnrPfxUrl);
        parameter.put("signMsg", signMsg);

        SimpleHttpsClient httpClient = new SimpleHttpsClient();
        //String postUrl = "https://hfgj.chinapnr.com/mcs/individualReg.htm";
        String postUrl = "https://global.chinapnr.com/mcs/individualReg.htm";
        HttpSendResult result = null;
        //System.out.println("map=" + parameter);
        try {
            result = httpClient.postRequest(postUrl,
                    parameter, 30000);
        } catch (Exception e) {
            // TODO Auto-generated catch block
        }
        System.out.println("result:" + result.getResponseBody());

        Map<String,String> callbackMap = ChinaPNRCommons.getCallbackMap(result.getResponseBody());
        String callbackSignMsgVal = ChinaPNRCommons.createLinkString(callbackMap);

        System.out.println("signMsgVal2=" + callbackSignMsgVal);
        String signMsg2 = callbackMap.get("signMsg");

        boolean veryfyResult=false;
        try {
            //BG通知未转义，需要先转义
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, URLDecoder.decode(signMsg2),chinapnrCer);
        } catch (Exception e) {
            e.printStackTrace();
        }

        System.out.println("签署结果返回= " + veryfyResult);

    }

    /**
     * @return
     * @Description: 根据图片地址转换为base64编码字符串
     * @Author:
     * @CreateTime:
     */
    public static String getImageStr(String imgFile) {
        InputStream inputStream = null;
        byte[] data = null;
        try {
            inputStream = new FileInputStream(imgFile);
            data = new byte[inputStream.available()];
            inputStream.read(data);
            inputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        // 加密
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }

    public static String appendParam(String returns, String paramId, String paramValue) {
        if (returns != "") {
            if (paramValue != "") {

                returns += "&" + paramId + "=" + paramValue;
            }

        } else {

            if (paramValue != "") {
                returns = paramId + "=" + paramValue;
            }
        }

        return returns;
    }


    /**
     * 把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
     *
     * @param params 需要排序并参与字符拼接的参数组
     * @return 拼接后字符串
     */
    public static String createLinkString(Map<String, String> params) {

        List<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); i++) {
            String key = keys.get(i);
            String value = params.get(key);
//            if(key.equals("signMsg")){
//                continue;
//            }
            if (i == keys.size() - 1) {// 拼接时，不包括最后一个&字符
                prestr = prestr + key + "=" + value;
            } else {
                prestr = prestr + key + "=" + value + "&";
            }
        }
        return prestr;
    }

    public static Map<String,String> getCallbackMap(String dataReceived){
        Map<String,String> map = new HashMap();
        String[] param =  dataReceived.split("&");
        for(String keyvalue:param){
            String[] pair = keyvalue.split("=");
            if(pair.length==2){
                map.put(pair[0], pair[1]);
            }
        }
        return map;
    }
}















