package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiJsBankService;
import com.js.common.constant.Constant;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.JsBank;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: 开户行码值操作接口
 * @Author: liuh
 * @Create: 2019-06-28
 */
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiJsBankServiceImpl extends IBaseServiceImpl<JsBank> implements ApiJsBankService {


    @Override
    public ResponseMessage findJsBankList(String bankCode) {
        JsBank jsBank = new JsBank();
        jsBank.setDelFlag(false);
        if(StringUtils.isNotBlank(bankCode)){
            jsBank.setBankCode(bankCode);
        }
        List<JsBank> jsBanks = iBaseMapper.select(jsBank);
        List<JsBank> resultList = jsBanks.stream().sorted(Comparator.comparing(JsBank :: getSort)).collect(Collectors.toList());
        return ResultUtil.success(resultList);
    }
}
