package com.js.pay.service.chinapnr.impl;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiJsPaySunrateTradeLockPriceService;
import com.js.api.jspay.service.ApiKycBankService;
import com.js.api.jspay.service.chinapnr.ChinaPNRTransactionDetailsService;
import com.js.common.constant.Constant;
import com.js.common.enums.AmazonEndpointEnum;
import com.js.common.enums.ChinaPNRTransEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.ChinaPNRTransactionDetailsReq;
import com.js.common.model.vo.JsPaySunrateTradeLockPriceVO;
import com.js.common.model.vo.KycBankVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.ChinaPNRTransactionMapper;
import com.js.dal.dao.mapper.ChinaPnrTransactionDetailMapper;
import com.js.dal.dao.mapper.JsSyncAmazonFinancialEventGroupMapper;
import com.js.dal.dao.mapper.JsSyncAmazonSettlementReportMapper;
import com.js.dal.dao.model.*;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import com.js.pay.service.chinapnr.example.ChinaPnrConfigure;
import com.js.pay.service.chinapnr.example.hack.HttpClientServiceImpl;
import com.js.pay.service.chinapnr.example.hack.SimpleHttpsClientImpl;
import com.js.pay.service.chinapnr.example.utils.SignatureUtil;
import com.js.pay.service.chinapnr.example.utils.XMLUtil;
import common.util.httpclient.HttpRequestContext;
import common.util.httpclient.HttpSendResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import tk.mybatis.mapper.entity.Example;

import javax.xml.xpath.XPathConstants;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 汇付天下交易明细备案
 *
 * @author: liutianyu
 **/
@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ChinaPNRTransactionDetailsServiceImpl implements ChinaPNRTransactionDetailsService {

    @Autowired
    JsSyncAmazonSettlementReportMapper jsSyncAmazonSettlementReportMapper;
    @Autowired
    ChinaPnrTransactionDetailMapper chinaPnrTransactionDetailMapper;
    @Autowired
    ChinaPNRTransactionMapper chinaPNRTransactionMapper;
    @Autowired
    private JsSyncAmazonFinancialEventGroupMapper jsSyncAmazonFinancialEventGroupMapper;
    @Autowired
    private ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Value("${js.xuhui.dispatcherDates}")
    private String dispatcherDates;
    @Autowired
    private ApiKycBankService apiKycBankService;
    /**
     * 汇付配置文件
     */
    @Autowired
    private ChinaPnrConfigure chinaPnrConfigure ;


    @Override
    public ResponseMessage saveChinaPNRTransactionDetail(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq){
        log.info("预处理订单还原操作开始:{}", JSON.toJSONString(chinaPNRTransactionDetailsReq));
        Date tradeDate = chinaPNRTransactionDetailsReq.getDispaterDate();
        List<ChinaPnrTransactionDetail> insertDetailList = new ArrayList<>();
        // 计算订单明细
        BigDecimal result = calTransactionDetails(chinaPNRTransactionDetailsReq, tradeDate, insertDetailList);
        if(result == null){
            log.error("订单还原预处理失败，报告无记录，暂无可使用资金。");
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_REPORT_ERROR );
        }
        if (result.compareTo(new BigDecimal("0")) != 0) {
            log.error("订单还原预处理添加失败");
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_CONTRAST_ERROR );
        }

        log.error("订单还原预处理添加成功");
        chinaPnrTransactionDetailMapper.insertListWithKey(insertDetailList);
        return ResultUtil.success(ResultEnum.CHINA_PNR_TRANSACTION_CONTRAST_SUCCESS );
    }

    @Override
    public ResponseMessage submitTransactionDetails() throws Exception {
        Date end = null;
        Date start = null;
        try {
            log.info("dispatcherDates = {}",dispatcherDates);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String date = sdf.format(new Date())+" " + dispatcherDates;
            SimpleDateFormat smf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            end = smf.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(end);
            calendar.add(Calendar.DATE, -1);
            start = calendar.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }

        // 取结算报告,从交易时间起向前取三个月
        Date tradeDate = new Date();
        List<ChinaPnrTransactionDetail> insertDetailList = getChinaPnrTransactionDetailsByBatchNo(start,end);
        if(insertDetailList == null || insertDetailList.size() == 0 ){
            log.error("总批次号为0," + ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR.getMsg());
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR);
        }
        // 锁汇到寻汇 总金额
        ResponseMessage responseMessage = apiJsPaySunrateTradeLockPriceService.getLockPriceByDate(start,end);
        String total = responseMessage.getData().toString();
        BigDecimal totalAmt = new BigDecimal(total);
//                jsPayLockPriceList.stream()
//                // 将 JsPaySunrateTradeLockPriceVO 对象的 getBuyAmt 取出来map为Bigdecimal
//                .map(JsPaySunrateTradeLockPriceVO::getBuyAmt)
//                // 使用reduce聚合函数,实现累加器
//                .reduce(BigDecimal.ZERO,BigDecimal::add);
        String currencyCode = "CNY";

        int  size =  insertDetailList.size();
//        int batchLength = ( size - 1 ) / 45000 +1 ;
//        for( int j = 0 ; j < batchLength; j++ ){

            List<ChinaPNRTransaction> insertTransactionList = new ArrayList<>();
            // 根据汇付要求，大于 5000 需要分批进行备案
            int batchNum = 5000;
            // 计算需要的批次
            int sumbatch = size / batchNum + 1;
                if (sumbatch > 9) {
                log.error("总批次号大于 9，超过接口最大支持45000。明细总数量：{}", size);
                return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR );
            }
            // 当前批次
            int batch = 1;
            int sendStatus = 1;
            String batchNo = IdUtil.simpleUUID();
            log.info("订单还原发汇付交易批次号：{}，start：",batchNo );
            ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq = new ChinaPNRTransactionDetailsReq();
            chinaPNRTransactionDetailsReq.setBatchNo(batchNo);
            chinaPNRTransactionDetailsReq.setTargetAmount(totalAmt);
            chinaPNRTransactionDetailsReq.setCurrencyCode(currencyCode);

            for (int i = 1; i <= size; i++) {
                if (i % batchNum == 0) {
                    List<ChinaPnrTransactionDetail> partDetails = insertDetailList.subList(i - batchNum, i);
                    sendStatus = sentDetailsRestoreReqeust(chinaPNRTransactionDetailsReq, tradeDate,
                            insertTransactionList, insertDetailList, sumbatch, batch, partDetails);
                    batch++;
                }
                // 代表这是最后一批，直接把剩下的全发出去。
                if (sumbatch == batch ) {
                    List<ChinaPnrTransactionDetail> details = insertDetailList.subList((sumbatch - 1) * batchNum, size);
                    sendStatus = sentDetailsRestoreReqeust(chinaPNRTransactionDetailsReq, tradeDate, insertTransactionList,
                            insertDetailList, sumbatch, batch, details);
                    batch++;
                }
                if (sendStatus == 0) {
                    break;
                }
            }
            // 如果全部发送成功或有部分已经发送成功,则保存。部分未成功的需要人工重推。
            if (batch > 2 || sendStatus == 1) {
                chinaPNRTransactionMapper.insertListWithKey(insertTransactionList);
//            chinaPnrTransactionDetailMapper.updateCHNPnrTransactionDtlSttToOver(batchNo);
                updateByExampleSelective(tradeDate, batchNo);
                log.info("明细备案成功，备案数量：{}, 明细数量: {}", insertTransactionList.size(), size);
                return ResultUtil.success(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_SUCCESS);
            } else {
                log.error("明细备案失败，批次号：{}", chinaPNRTransactionDetailsReq.getBatchNo());
                return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR);
            }
//        }
//        return null;
    }

    @Override
    public ResponseMessage submitTransactionDetailsTest(int amount) throws Exception {
        Date end = null;
        Date start = null;
        try {
            log.info("dispatcherDates = {}",dispatcherDates);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String date = sdf.format(new Date())+" " + dispatcherDates;
            SimpleDateFormat smf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            end = smf.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(end);
            calendar.add(Calendar.DATE, amount);
            start = calendar.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }

        // 取结算报告,从交易时间起向前取三个月
        Date tradeDate = new Date();
        List<ChinaPnrTransactionDetail> insertDetailList = getChinaPnrTransactionDetailsByBatchNo(start,end);
        if(insertDetailList == null || insertDetailList.size() == 0 ){
            log.error("总批次号为0," + ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR.getMsg());
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR);
        }
        // 锁汇到寻汇 总金额
        ResponseMessage responseMessage = apiJsPaySunrateTradeLockPriceService.getLockPriceByDate(start,end);
        String total = responseMessage.getData().toString();
        BigDecimal totalAmt = new BigDecimal(total);
//                jsPayLockPriceList.stream()
//                // 将 JsPaySunrateTradeLockPriceVO 对象的 getBuyAmt 取出来map为Bigdecimal
//                .map(JsPaySunrateTradeLockPriceVO::getBuyAmt)
//                // 使用reduce聚合函数,实现累加器
//                .reduce(BigDecimal.ZERO,BigDecimal::add);
        String currencyCode = "CNY";

        int  size =  insertDetailList.size();
//        int batchLength = ( size - 1 ) / 45000 +1 ;
//        for( int j = 0 ; j < batchLength; j++ ){

        List<ChinaPNRTransaction> insertTransactionList = new ArrayList<>();
        // 根据汇付要求，大于 5000 需要分批进行备案
        int batchNum = 5000;
        // 计算需要的批次
        int sumbatch = size / batchNum + 1;
        if (sumbatch > 9) {
            log.error("总批次号大于 9，超过接口最大支持45000。明细总数量：{}", size);
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR );
        }
        // 当前批次
        int batch = 1;
        int sendStatus = 1;
        String batchNo = IdUtil.simpleUUID();
        log.info("订单还原发汇付交易批次号：{}，start：",batchNo );
        ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq = new ChinaPNRTransactionDetailsReq();
        chinaPNRTransactionDetailsReq.setBatchNo(batchNo);
        chinaPNRTransactionDetailsReq.setTargetAmount(totalAmt);
        chinaPNRTransactionDetailsReq.setCurrencyCode(currencyCode);

        for (int i = 1; i <= size; i++) {
            if (i % batchNum == 0) {
                List<ChinaPnrTransactionDetail> partDetails = insertDetailList.subList(i - batchNum, i);
                sendStatus = sentDetailsRestoreReqeust(chinaPNRTransactionDetailsReq, tradeDate,
                        insertTransactionList, insertDetailList, sumbatch, batch, partDetails);
                batch++;
            }
            // 代表这是最后一批，直接把剩下的全发出去。
            if (sumbatch == batch ) {
                List<ChinaPnrTransactionDetail> details = insertDetailList.subList((sumbatch - 1) * batchNum, size);
                sendStatus = sentDetailsRestoreReqeust(chinaPNRTransactionDetailsReq, tradeDate, insertTransactionList,
                        insertDetailList, sumbatch, batch, details);
                batch++;
            }
            if (sendStatus == 0) {
                break;
            }
        }
        // 如果全部发送成功或有部分已经发送成功,则保存。部分未成功的需要人工重推。
        if (batch > 2 || sendStatus == 1) {
            chinaPNRTransactionMapper.insertListWithKey(insertTransactionList);
//            chinaPnrTransactionDetailMapper.updateCHNPnrTransactionDtlSttToOver(batchNo);
            updateByExampleSelective(tradeDate, batchNo);
            log.info("明细备案成功，备案数量：{}, 明细数量: {}", insertTransactionList.size(), size);
            return ResultUtil.success(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_SUCCESS);
        } else {
            log.error("明细备案失败，批次号：{}", chinaPNRTransactionDetailsReq.getBatchNo());
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_ERROR);
        }
//        }
//        return null;
    }



    private int updateByExampleSelective(Date tradeDate,String batchNo){
        Date end = null;
        Date start = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String date = sdf.format(new Date())+" " + dispatcherDates;
            SimpleDateFormat smf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            end = smf.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(end);
            calendar.add(Calendar.DATE, -1);
            start = calendar.getTime();
        } catch (Exception e) {
            e.printStackTrace();
        }
        Example example = new Example(ChinaPnrTransactionDetail.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status", "TODO");
        criteria.andGreaterThanOrEqualTo("tradeDate",start);
        criteria.andLessThan("tradeDate", end);

        ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
        chinaPnrTransactionDetail.setStatus("OVER");
        chinaPnrTransactionDetail.setBatchNo(batchNo);
        int i = chinaPnrTransactionDetailMapper.updateByExampleSelective(chinaPnrTransactionDetail, example);
        return i;
    }

    @Override
    public ResponseMessage reSubmitTransactionDetailsByBatchNo(String batchNo) throws Exception {
        return null;
    }
    @Override
    public ResponseMessage reSubmitTransactionDetails() throws Exception {
        List<JsPaySunrateTradeLockPriceVO> jsPaySunrateTradeLockPricelist = apiJsPaySunrateTradeLockPriceService.getLockPriceForChinaPNR();
        for(JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO : jsPaySunrateTradeLockPricelist){
            ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq = new ChinaPNRTransactionDetailsReq();
            chinaPNRTransactionDetailsReq.setKycNaturalId(jsPaySunrateTradeLockPriceVO.getKycNaturalId());
            chinaPNRTransactionDetailsReq.setDispaterDate(jsPaySunrateTradeLockPriceVO.getTxnDatetime());
            chinaPNRTransactionDetailsReq.setCurrencyCode(jsPaySunrateTradeLockPriceVO.getBuyCur());
            chinaPNRTransactionDetailsReq.setTargetAmount(jsPaySunrateTradeLockPriceVO.getBuyAmt());
            chinaPNRTransactionDetailsReq.setKycBankId(jsPaySunrateTradeLockPriceVO.getKycBankId());
            chinaPNRTransactionDetailsReq.setExchangeRate(jsPaySunrateTradeLockPriceVO.getFinRate());
//            chinaPNRTransactionDetailsReq.setAmazonEndpointEnum(jsPaySunrateTradeMarketOrderReq.getStoreTheSite().getAmazonEndpointEnum());
            saveChinaPNRTransactionDetail(chinaPNRTransactionDetailsReq);
        }
        // 发汇付 订单还原明细数据
//        submitTransactionDetails();
       return null;
    }

    @Override
    public ResponseMessage transactionDetailsCallback(String responseStr) {
        Document document = XmlUtil.parseXml(responseStr);
        // 1、成功 2、失败
        String status = (String) XmlUtil.getByXPath("/NOTIFY/PARAMS/STATUS", document, XPathConstants.STRING);
        String code = (String) XmlUtil.getByXPath("/NOTIFY/PARAMS/ERRERCODE", document, XPathConstants.STRING);
        String msg = (String) XmlUtil.getByXPath("/NOTIFY/PARAMS/ERRERMSG2", document, XPathConstants.STRING);

        // 更新响应报文
        String batchNo = (String) XmlUtil.getByXPath("/NOTIFY/PARAMS/BATCH_NO", document, XPathConstants.STRING);
        String ordNum = (String) XmlUtil.getByXPath("/NOTIFY/PARAMS/ORD_NUM", document, XPathConstants.STRING);
        Example example = new Example(ChinaPNRTransaction.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("batchNo", batchNo);
        criteria.andEqualTo("ordNum", ordNum);
        // 只更新最后一个的报告，因为分批备案的情况下回调也只会回调一次，显示的序号是最后一个次的
        List<ChinaPNRTransaction> chinaPNRTransactions = chinaPNRTransactionMapper.selectByExample(example);
        ChinaPNRTransaction chinaPNRTransaction;
        if (chinaPNRTransactions.size() == 1) {
            chinaPNRTransaction = chinaPNRTransactions.get(0);
            chinaPNRTransaction.setResponseMessage(responseStr);
            chinaPNRTransaction.setUpdateId("sys");
            chinaPNRTransaction.setUpdateName("sys");
            chinaPNRTransaction.setUpdateDts(new Date());
        } else {
            log.error("交易明细备案数据错误 批次号: {}, 序号：{}", batchNo, ordNum);
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_CALLBACK_ERROR);
        }

        if ("1".equals(status)) {
            chinaPNRTransaction.setStatus(ChinaPNRTransEnum.RECEIVE_SUCCESS.ordinal());
            chinaPNRTransactionMapper.updateByPrimaryKeySelective(chinaPNRTransaction);

            // 回调成功
            Map<String , Object> parameter = new HashMap<>();
            initParameterHeader(parameter);
            // 回调成功
            parameter.put("RESULT", "000000");
            String requestXml = ChinaPNRCommons.transferToXML(parameter, chinaPnrConfigure.getTrxtypeBa(),chinaPnrConfigure.getChinapnrrXml());
            return ResultUtil.success(requestXml, ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_CALLBACK_SUCCESS);
        } else {
            // 回调失败
            chinaPNRTransaction.setStatus(ChinaPNRTransEnum.REQEUSET_FAILURE.ordinal());
            chinaPNRTransactionMapper.updateByPrimaryKeySelective(chinaPNRTransaction);
            log.error("交易明细备案，汇付回调审核失败。code: {}, msg: {}", code, msg);
            return ResultUtil.error(ResultEnum.CHINA_PNR_TRANSACTION_DETAIL_CALLBACK_ERROR);
        }
    }

    private void initParameterHeader(Map<String, Object> parameter) {
        //商户号
        parameter.put("MERCHANTID", chinaPnrConfigure.getMerchantid());
        //终端号
        parameter.put("TERMINALID",chinaPnrConfigure.getTerminalid());
        //交易类别
        parameter.put("TRXTYPE", chinaPnrConfigure.getTrxtypeBa());
        //产品类型
        parameter.put("PRODUCTTYPE", chinaPnrConfigure.getProducttype());
        //接口版本
        parameter.put("VERSION",chinaPnrConfigure.getVersion());
    }
    private BigDecimal getAmazonExchangeRate(String settlementId) {
        Example example = new Example(JsSyncAmazonSettlementReport.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("settlementId", settlementId);
        criteria.andIsNotNull("totalAmount");
        JsSyncAmazonSettlementReport settlementReport = jsSyncAmazonSettlementReportMapper.selectOneByExample(example);

        Example example1 = new Example(JsSyncAmazonFinancialEventGroup.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("storeId", settlementReport.getStoreId());
        criteria1.andEqualTo("originalTotal", settlementReport.getTotalAmount());
        criteria1.andEqualTo("originalTotalCode", settlementReport.getCurrency());
        criteria1.andEqualTo("financialEventGroupStart", settlementReport.getSettlementStartDate());
        JsSyncAmazonFinancialEventGroup jsSyncAmazonFinancialEventGroup = jsSyncAmazonFinancialEventGroupMapper.selectOneByExample(example1);
        BigDecimal convertedTotal = jsSyncAmazonFinancialEventGroup.getConvertedTotal();
        if (convertedTotal == null) {
            return BigDecimal.ONE;
        } else {
            return convertedTotal.divide(jsSyncAmazonFinancialEventGroup.getOriginalTotal(), 4, RoundingMode.HALF_UP);
        }
    }
    /**
     * 如果返回值是 0 证明还原成功。
     *
     * @param chinaPNRTransactionDetailsReq
     * @param tradeDate
     * @param insertDetailList
     * @return
     */
    private BigDecimal calTransactionDetails(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,
                                             Date tradeDate, List<ChinaPnrTransactionDetail> insertDetailList) {
        Date nowDate = new Date();
        // 通过汇率转换成源币种，为了足额还原，除不尽会向上取一位。
        BigDecimal targetSourceAmount = chinaPNRTransactionDetailsReq.getTargetAmount()
                .divide(chinaPNRTransactionDetailsReq.getExchangeRate(), 2, RoundingMode.UP);
        ZonedDateTime end = ZonedDateTime.ofInstant(nowDate.toInstant(), ZoneId.systemDefault());
        ZonedDateTime start = end.minusMonths(3);
        String marketplaceName = chinaPNRTransactionDetailsReq.getAmazonEndpointEnum().getMarketplaceName();

        List<JsSyncAmazonSettlementReport> settlementDatas = getSettlementDatas(chinaPNRTransactionDetailsReq.getKycNaturalId(),marketplaceName, start, end);
        if(settlementDatas == null || settlementDatas.size()==0){
            return null;
        }
        List<String> settlementDataIds = settlementDatas.stream()
                .map(JsSyncAmazonSettlementReport::getSettlementId)
                .collect(Collectors.toList());
        // 取订单还原记录
        List<ChinaPnrTransactionDetail> transactionDetails = getChinaPnrTransactionDetails(chinaPNRTransactionDetailsReq.getKycNaturalId(), start, end);
        // 计算已经使用过的订单
        List<String> usedSettlementIds = transactionDetails.stream()
                .map(ChinaPnrTransactionDetail::getSettlementId)
                .distinct()
                .collect(Collectors.toList());
        // 计算出完全没有使用过的结算报告
        List<String> canUseSettlementIds = settlementDataIds.stream()
                .filter(e -> !usedSettlementIds.contains(e))
                .collect(Collectors.toList());
        // 计算出上次没用完的订单明细
        ChinaPnrTransactionDetail lastTransactionDetail = getLastTransactionDetails(transactionDetails, start);

        // 获取全部可用的结算报告
        List<JsSyncAmazonSettlementReport> canUseSettlementReports =
                getCanUseSettlementReports(chinaPNRTransactionDetailsReq.getKycNaturalId(), canUseSettlementIds,
                        lastTransactionDetail == null ? null : lastTransactionDetail.getSettlementId());

        // 以订单明细进行分组。总金额单分一组。没有订单明细的分到 other 组
        Map<String, Map<String, List<JsSyncAmazonSettlementReport>>> groupMap = canUseSettlementReports.stream()
                .collect(Collectors.groupingBy(JsSyncAmazonSettlementReport::getSettlementId,
                        Collectors.groupingBy(e -> {
                            if (e.getTotalAmount() != null) {
                                return "settlementData";
                            } else if (e.getOrderItemCode() == null || e.getOrderItemCode().equals("")) {
                                return "other";
                            } else {
                                return e.getOrderItemCode();
                            }
                        })));
        // 如果存在上次的还原记录，则接续上次的
        if (lastTransactionDetail != null) {
            // 计算上次结尾的结算报告用了哪些订单
            List<ChinaPnrTransactionDetail> chinaPnrTransactionDetails = transactionDetails.stream()
                    .filter(e -> e.getSettlementId().equals(lastTransactionDetail.getSettlementId()))
                    .collect(Collectors.toList());
            // 优先使用上次未用完的订单进行还原
            Map<String, List<JsSyncAmazonSettlementReport>> lastSettlementReport = groupMap.get(lastTransactionDetail.getSettlementId());
            // 将结算报告的数据进行整合。
            List<JsSyncAmazonSettlementReport> sumReportList = getSumReportList(lastSettlementReport);
            // 先加上上次尾订单剩下的钱，因为存在一笔订单多次拆分，所以需要遍历计算
            BigDecimal usedTotal = transactionDetails.stream()
                    .filter(e -> e.getSettlementId().equals(lastTransactionDetail.getSettlementId()))
                    .filter(e -> e.getOrderItemCode().equals(lastTransactionDetail.getOrderItemCode()))
                    .filter(ChinaPnrTransactionDetail::getSplitFlag)
                    .map(ChinaPnrTransactionDetail::getSplitSourceAmount)
                    .reduce(new BigDecimal(0), BigDecimal::add);
            // 计算当前订单还剩多少钱
            BigDecimal remain = lastTransactionDetail.getOrderPriceTotal().subtract(usedTotal);
            ///////////////////// TODO 针对加元直换美元，汇差计算 getAmazonExchangeRate
            if(AmazonEndpointEnum.CANADA.getMarketplaceName().equals(chinaPNRTransactionDetailsReq.getAmazonEndpointEnum().getMarketplaceName()) ){
                String settlementId = lastTransactionDetail.getSettlementId();
                BigDecimal lastTransactionDetailExchangeRate = getAmazonExchangeRate(settlementId);
                targetSourceAmount = targetSourceAmount.divide(lastTransactionDetailExchangeRate,2, RoundingMode.UP);
                BigDecimal reqExchangeRate= chinaPNRTransactionDetailsReq.getExchangeRate().divide(lastTransactionDetailExchangeRate,2, RoundingMode.UP);
                chinaPNRTransactionDetailsReq.setExchangeRate(reqExchangeRate);
            }
            ////////////////////
//           转成目标币种对应的金额，只留两位小数，四舍五入
//            BigDecimal convertRemain = remain.multiply(chinaPNRTransactionDetailsReq.getExchangeRate()).setScale(2, RoundingMode.HALF_UP);
            if (targetSourceAmount.compareTo(remain) > 0) {
                // 还不足目标金额，需继续计算
                // 先记录本条记录
                useOldDetailRestore(lastTransactionDetail, remain, chinaPNRTransactionDetailsReq, tradeDate, insertDetailList);
                // 更新还需要的目标金额
                targetSourceAmount = targetSourceAmount.subtract(remain);
                // 查看当前结算报告还有没有可以使用的商品明细
                List<String> usedItemCode = chinaPnrTransactionDetails.stream()
                        .map(ChinaPnrTransactionDetail::getOrderItemCode)
                        .collect(Collectors.toList());
                List<JsSyncAmazonSettlementReport> remainItem = sumReportList.stream()
                        .filter(e -> !usedItemCode.contains(e.getOrderItemCode()))
                        .collect(Collectors.toList());
                if (remainItem.size() > 0) {
                    // 继续使用该结算报告进行订单还原。
                    targetSourceAmount = orderRestoration(chinaPNRTransactionDetailsReq, targetSourceAmount, tradeDate, remainItem, insertDetailList);
                }
            } else {
                // 已经达到目标金额，拆分订单
                useOldDetailRestore(lastTransactionDetail, targetSourceAmount, chinaPNRTransactionDetailsReq, tradeDate, insertDetailList);
                targetSourceAmount = new BigDecimal(0);
            }
        }



        if (targetSourceAmount.compareTo(new BigDecimal(0)) > 0) {
            return useNewSettlementReportRestore(chinaPNRTransactionDetailsReq, targetSourceAmount, tradeDate, settlementDatas, canUseSettlementIds, groupMap, insertDetailList);
        } else {
            return targetSourceAmount;
        }
    }

    /**
     * 把源币种通过汇率真转换成目标币种。保留两位小数，四舍五入。
     *
     * @param source
     * @param exchangeRate
     * @return
     */
    private BigDecimal convertToTargetCurrency(BigDecimal source, BigDecimal exchangeRate) {
        return source.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
    }

    /**
     * 使用上次没完的订单进行订单还原并记录。
     * @param lastTransactionDetail
     * @param remain 订单上还剩的钱。为源币种。
     * @param chinaPNRTransactionDetailsReq
     * @param tradeDate
     * @param insertDetailList
     */
    private void useOldDetailRestore(ChinaPnrTransactionDetail lastTransactionDetail, BigDecimal remain, ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq, Date tradeDate, List<ChinaPnrTransactionDetail> insertDetailList) {
        ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
        BeanUtil.copyProperties(lastTransactionDetail, chinaPnrTransactionDetail);
        chinaPnrTransactionDetail.setId(IdUtil.simpleUUID());
        chinaPnrTransactionDetail.setKycNaturalId(chinaPNRTransactionDetailsReq.getKycNaturalId());
        chinaPnrTransactionDetail.setBatchNo(chinaPNRTransactionDetailsReq.getBatchNo());
        chinaPnrTransactionDetail.setExchangeRate(chinaPNRTransactionDetailsReq.getExchangeRate());
        chinaPnrTransactionDetail.setSplitSourceAmount(remain);
        chinaPnrTransactionDetail.setSplitAmount(convertToTargetCurrency(remain, chinaPNRTransactionDetailsReq.getExchangeRate()));
        chinaPnrTransactionDetail.setSplitFlag(true);
        chinaPnrTransactionDetail.setTradeDate(tradeDate);
        chinaPnrTransactionDetail.setStatus("TODO");
        chinaPnrTransactionDetail.setCreateId("sys");
        chinaPnrTransactionDetail.setCreateName("sys");
        chinaPnrTransactionDetail.setCreateDts(new Date());
        insertDetailList.add(chinaPnrTransactionDetail);
    }

    /**
     * 成功直接返回本次成功的批次号，失败的话返回 0
     *
     * @param chinaPNRTransactionDetailsReq
     * @param tradeDate
     * @param insertTransactionList 本次交易备案
     * @param insertDetailList 全部订单明细
     * @param sumbatch 总批次
     * @param batch 当前批次
     * @param details 本批次要使用的明细
     * @return
     */
    private int sentDetailsRestoreReqeust(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq, Date tradeDate,
                                          List<ChinaPNRTransaction> insertTransactionList,
                                          List<ChinaPnrTransactionDetail> insertDetailList, int sumbatch, int batch,
                                          List<ChinaPnrTransactionDetail> details) throws Exception {
        Map<String , Object> parameter = new HashMap<>();
        initParameterHeader(parameter);
        BigDecimal reduce = details.stream()
                .map(ChinaPnrTransactionDetail::getSplitAmount)
                .reduce(new BigDecimal(0), BigDecimal::add);
        List<ChinaPnrTransactionDetail> details2 = details;
        Map<String,ChinaPnrTransactionDetail> map = getDetailLength(details2);
        parameter.put("RECEIPT_ID", "");
        parameter.put("BATCH_NO", chinaPNRTransactionDetailsReq.getBatchNo());
        parameter.put("ORD_NUM", batch + "/" + sumbatch);
        parameter.put("REQTIME", DateUtil.format(tradeDate, "yyyyMMddHHmmss"));
        parameter.put("PAY_CUR", "CNY");
        parameter.put("SUM_CNT", map.size() + "");
        parameter.put("SUM_AMT", (chinaPNRTransactionDetailsReq.getTargetAmount().multiply(new BigDecimal(100))).intValue() + "");
        parameter.put("PAY_TCNT",map.size() + "");
        parameter.put("PAY_TAMT",(reduce.multiply(new BigDecimal(100))).intValue() + "");
//        parameter.put("EXT1",);
//        parameter.put("EXT2",);
        parameter.put("REVIEW_URL", chinaPnrConfigure.getTransactionDetailResultUrl());
        // 已废弃，随便传一个值即可。
        parameter.put("RESULT_URL", "xxxxxxx");
        StringBuilder detailsStr = getDetailStr(map);
        parameter.put("DETAILS", detailsStr.toString());

        HttpResult httpResult = new HttpResult(parameter).invoke();
        String requestXml = httpResult.getRequestXml();
        HttpSendResult result = httpResult.getResult();

        if (null == result) {
            log.info("网关系统异常------");
            return 0;
        } else {
            if (result.getStatus() == 200) {
                String respTxt = result.getResponseBody();
                // JSONObject jsonObject = JSONUtil.parseFromXml(respTxt);
                Document document = XmlUtil.parseXml(respTxt);
                //XmlUtil.getElement(document.getDocumentElement(), "STATUS");
                Node params = (Node) XmlUtil.getByXPath("/RESPONSE/PARAMS", document, XPathConstants.NODE);
                String status = (String) XmlUtil.getByXPath("STATUS", params, XPathConstants.STRING);
                // String code = (String) XmlUtil.getByXPath("ERRERCODE", params, XPathConstants.STRING);
                // String msg = (String) XmlUtil.getByXPath("ERRERMSG", params, XPathConstants.STRING);
                // 生成备案明细对象
                ChinaPNRTransaction chinaPNRTransaction = new ChinaPNRTransaction();
                chinaPNRTransaction.setId(IdUtil.simpleUUID());
                chinaPNRTransaction.setKycNaturalId(chinaPNRTransactionDetailsReq.getKycNaturalId());
                // TODO
                // chinaPNRTransaction.setReceiptId("");
                chinaPNRTransaction.setBatchNo(chinaPNRTransactionDetailsReq.getBatchNo());
                chinaPNRTransaction.setOrdNum(batch + "/" + sumbatch);
                chinaPNRTransaction.setReqtime(tradeDate);
                chinaPNRTransaction.setPayCur(chinaPNRTransactionDetailsReq.getCurrencyCode());
                chinaPNRTransaction.setSumCnt(new BigDecimal(insertDetailList.size()));
                chinaPNRTransaction.setSumAmt(chinaPNRTransactionDetailsReq.getTargetAmount().multiply(new BigDecimal(100)));
                chinaPNRTransaction.setPayTcnt(new BigDecimal(details.size()));
                chinaPNRTransaction.setPayTamt(reduce.multiply(new BigDecimal(100)));
                chinaPNRTransaction.setExt1("");
                chinaPNRTransaction.setExt2("");
                chinaPNRTransaction.setResultUrl("");
                chinaPNRTransaction.setResultUrl("");
                chinaPNRTransaction.setRequestMessage(requestXml);
                chinaPNRTransaction.setResponseMessage(respTxt);
                chinaPNRTransaction.setCreateId("sys");
                chinaPNRTransaction.setCreateName("sys");
                chinaPNRTransaction.setCreateDts(new Date());
                chinaPNRTransaction.setDelFlag(false);
                chinaPNRTransaction.setJsRemark("");
                insertTransactionList.add(chinaPNRTransaction);
                // 给相关的明细增加关联
                for (ChinaPnrTransactionDetail detail : details) {
                    detail.setTransactionId(chinaPNRTransaction.getId());
                }
                if (status.equals("1")) {
                    // 备案成功直接返回本次的批次号
                    chinaPNRTransaction.setStatus(ChinaPNRTransEnum.REQUESET_SUCCESS.ordinal());
                    return batch;
                } else {
                    chinaPNRTransaction.setStatus(ChinaPNRTransEnum.REQEUSET_FAILURE.ordinal());
                    log.error(respTxt);
                    return 0;
                }
            } else {
                log.info("网关系统异常,状态码[" + result.getStatus() + "]");
                return 0;
            }
        }
    }

    /**
     * 使用新的结算报告进行还原
     *
     * @param chinaPNRTransactionDetailsReq
     * @param targetSourceAmount
     * @param tradeDate
     * @param settlementDatas
     * @param canUseSettlementIds
     * @param groupMap
     * @param insertDetailList
     */
    private BigDecimal useNewSettlementReportRestore(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,
                                                     BigDecimal targetSourceAmount,
                                                     Date tradeDate, List<JsSyncAmazonSettlementReport> settlementDatas,
                                                     List<String> canUseSettlementIds,
                                                     Map<String, Map<String, List<JsSyncAmazonSettlementReport>>> groupMap,
                                                     List<ChinaPnrTransactionDetail> insertDetailList) {
        // 按时间升序排列，优先使用较早的订单
        List<String> newCanUseSettlementIds = settlementDatas.stream()
                .filter(e -> canUseSettlementIds.contains(e.getSettlementId()))
                .sorted((a, b) -> {
                    if (a.getDepositDate().getTime() > b.getDepositDate().getTime()) {
                        return 1;
                    } else if (a.getDepositDate().getTime() == b.getDepositDate().getTime()) {
                        return 0;
                    } else {
                        return -1;
                    }
                }).map(JsSyncAmazonSettlementReport::getSettlementId)
                .collect(Collectors.toList());
        return calOrderRestoration(chinaPNRTransactionDetailsReq, targetSourceAmount, tradeDate, groupMap, insertDetailList, newCanUseSettlementIds);
    }

    /**
     * 递归计算订单还原
     *
     * @param chinaPNRTransactionDetailsReq
     * @param targetSourceAmount
     * @param tradeDate
     * @param groupMap
     * @param insertDetailList
     * @param newCanUseSettlementIds
     */
    private BigDecimal calOrderRestoration(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,
                                           BigDecimal targetSourceAmount, Date tradeDate,
                                           Map<String, Map<String, List<JsSyncAmazonSettlementReport>>> groupMap,
                                           List<ChinaPnrTransactionDetail> insertDetailList, List<String> newCanUseSettlementIds) {
        if (newCanUseSettlementIds.size() > 0) {
            // 还有可以使用的新结算报告，继续计算
            String settlementId = newCanUseSettlementIds.remove(0);
            ///////////////////// TODO 针对加元直换美元，汇差计算 getAmazonExchangeRate
            if(AmazonEndpointEnum.CANADA.getMarketplaceName().equals(chinaPNRTransactionDetailsReq.getAmazonEndpointEnum().getMarketplaceName()) ){
                BigDecimal lastTransactionDetailExchangeRate = getAmazonExchangeRate(settlementId);
                targetSourceAmount = targetSourceAmount.divide(lastTransactionDetailExchangeRate,2, RoundingMode.UP);
                BigDecimal reqExchangeRate= chinaPNRTransactionDetailsReq.getExchangeRate().divide(lastTransactionDetailExchangeRate,2, RoundingMode.UP);
                chinaPNRTransactionDetailsReq.setExchangeRate(reqExchangeRate);
            }
            ////////////////////
            Map<String, List<JsSyncAmazonSettlementReport>> stringListMap = groupMap.get(settlementId);
            List<JsSyncAmazonSettlementReport> sumReportList1 = getSumReportList(stringListMap);
            List<JsSyncAmazonSettlementReport> items = sumReportList1.stream()
                    .filter(e -> e.getTotalAmount() == null)
                    .collect(Collectors.toList());
            targetSourceAmount = orderRestoration(chinaPNRTransactionDetailsReq, targetSourceAmount, tradeDate, items, insertDetailList);
            if (targetSourceAmount.compareTo(new BigDecimal(0)) == 0) {
                // 结束本次计算
                log.info("订单还原计算成功");
                return targetSourceAmount;
            } else {
                // 递归，使用一个新的结算报告
                return calOrderRestoration(chinaPNRTransactionDetailsReq, targetSourceAmount, tradeDate, groupMap, insertDetailList, newCanUseSettlementIds);
            }
        } else {
            // 剩下的结算报告不够了。打印日志，抛异常
            log.error("结算报告不足以进行订单还原。当前用户: {}", chinaPNRTransactionDetailsReq.getKycNaturalId());
            insertDetailList.clear();
            return targetSourceAmount;
        }
    }

    private BigDecimal orderRestoration(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,
                                        BigDecimal targetSourceAmount, Date tradeDate,
                                        List<JsSyncAmazonSettlementReport> remainItem, List<ChinaPnrTransactionDetail> insertDetailList) {
        // 排序，负值在前正值在后,防止还原订单时金额超出订单总金额
        remainItem = remainItem.stream()
                .sorted(Comparator.comparing(JsSyncAmazonSettlementReport::getPriceAmount))
                .collect(Collectors.toList());
        BigDecimal targetSourceAmountTemp ;
        for (JsSyncAmazonSettlementReport settlementReport : remainItem) {
            if(targetSourceAmount.compareTo(settlementReport.getPriceAmount()) > 0) {
                // 订单金额不足目标金额
                targetSourceAmount = targetSourceAmount.subtract(settlementReport.getPriceAmount());
                ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
                setChinaPnrTransactionDetailProperties(chinaPnrTransactionDetail,
                        chinaPNRTransactionDetailsReq, settlementReport, tradeDate);
                chinaPnrTransactionDetail.setSplitFlag(false);
                chinaPnrTransactionDetail.setStatus("TODO");
                chinaPnrTransactionDetail.setSplitSourceAmount(settlementReport.getPriceAmount());
                chinaPnrTransactionDetail.setSplitAmount(convertToTargetCurrency(settlementReport.getPriceAmount(),
                        chinaPNRTransactionDetailsReq.getExchangeRate()));
                insertDetailList.add(chinaPnrTransactionDetail);
            } else {
                // 订单金额足够，开始拆分账单
                ChinaPnrTransactionDetail chinaPnrTransactionDetail = new ChinaPnrTransactionDetail();
                setChinaPnrTransactionDetailProperties(chinaPnrTransactionDetail,
                        chinaPNRTransactionDetailsReq, settlementReport, tradeDate);
                chinaPnrTransactionDetail.setSplitFlag(true);
                chinaPnrTransactionDetail.setStatus("TODO");
                chinaPnrTransactionDetail.setSplitSourceAmount(targetSourceAmount);
                chinaPnrTransactionDetail.setSplitAmount(convertToTargetCurrency(targetSourceAmount,
                        chinaPNRTransactionDetailsReq.getExchangeRate()));
                targetSourceAmount = new BigDecimal(0);
                insertDetailList.add(chinaPnrTransactionDetail);
                return targetSourceAmount;
            }
        }
        return targetSourceAmount;
    }

    private void setChinaPnrTransactionDetailProperties(ChinaPnrTransactionDetail chinaPnrTransactionDetail,
                                                        ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq,
                                                        JsSyncAmazonSettlementReport settlementReport, Date tradeDate) {
        chinaPnrTransactionDetail.setId(IdUtil.simpleUUID());
        chinaPnrTransactionDetail.setKycNaturalId(chinaPNRTransactionDetailsReq.getKycNaturalId());
        chinaPnrTransactionDetail.setStoreId(settlementReport.getStoreId());
        chinaPnrTransactionDetail.setKycBankId(chinaPNRTransactionDetailsReq.getKycBankId());
        chinaPnrTransactionDetail.setBatchNo(chinaPNRTransactionDetailsReq.getBatchNo());
        chinaPnrTransactionDetail.setSku(settlementReport.getSku());
        chinaPnrTransactionDetail.setTransactionType(settlementReport.getTransactionType());
        chinaPnrTransactionDetail.setSettlementId(settlementReport.getSettlementId());
        chinaPnrTransactionDetail.setOrderItemCode(settlementReport.getOrderItemCode());
        chinaPnrTransactionDetail.setCurrencyCode(chinaPNRTransactionDetailsReq.getAmazonEndpointEnum().getCurrencyCode());
        chinaPnrTransactionDetail.setOrderPriceTotal(settlementReport.getPriceAmount());
        chinaPnrTransactionDetail.setExchangeRate(chinaPNRTransactionDetailsReq.getExchangeRate());
        chinaPnrTransactionDetail.setPostedDate(settlementReport.getPostedDate());
        chinaPnrTransactionDetail.setTradeDate(tradeDate);
        chinaPnrTransactionDetail.setCreateId("sys");
        chinaPnrTransactionDetail.setCreateName("sys");
        chinaPnrTransactionDetail.setCreateDts(new Date());
        chinaPnrTransactionDetail.setDelFlag(false);
    }

    private List<JsSyncAmazonSettlementReport> getSumReportList(Map<String, List<JsSyncAmazonSettlementReport>> lastSettlementReport) {
        List<JsSyncAmazonSettlementReport> sumReportList = new ArrayList<>();
        for (Map.Entry<String, List<JsSyncAmazonSettlementReport>> stringListEntry : lastSettlementReport.entrySet()) {
            if (!stringListEntry.getKey().equals("settlementData")) {
                List<JsSyncAmazonSettlementReport> value = stringListEntry.getValue();
                JsSyncAmazonSettlementReport sumReport = getSumReport(value);
                if (stringListEntry.getKey().equals("other")) {
                    sumReport.setOrderItemCode("other");
                    sumReport.setTransactionType("other");
                    sumReport.setSku("other");
                }
                sumReportList.add(sumReport);
            }
        }
        return sumReportList;
    }

    private List<JsSyncAmazonSettlementReport> getCanUseSettlementReports(String kycNaturalId, List<String> canUseSettlementIds, String lastSettlementId) {
        Example example = new Example(JsSyncAmazonSettlementReport.class);
        Example.Criteria criteria = example.createCriteria();
        List<String> condition = new ArrayList<>();
        condition.addAll(canUseSettlementIds);
        if (lastSettlementId != null) {
            condition.add(lastSettlementId);
        }
        criteria.andIn("settlementId", condition);
        criteria.andEqualTo("kycNaturalId", kycNaturalId);
        return jsSyncAmazonSettlementReportMapper.selectByExample(example);
    }

    private List<ChinaPnrTransactionDetail> getChinaPnrTransactionDetails(String kycNaturalId, ZonedDateTime start, ZonedDateTime end) {
        Example example = new Example(ChinaPnrTransactionDetail.class);
        example.setOrderByClause("trade_date desc");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId", kycNaturalId);
        criteria.andGreaterThanOrEqualTo("tradeDate", Date.from(start.toInstant()));
        criteria.andLessThanOrEqualTo("tradeDate", Date.from(end.toInstant()));
        return chinaPnrTransactionDetailMapper.selectByExample(example);
    }

    private List<ChinaPnrTransactionDetail> getChinaPnrTransactionDetailsByBatchNo(Date start, Date end) {

        Example example = new Example(ChinaPnrTransactionDetail.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status", "TODO");
        criteria.andGreaterThanOrEqualTo("tradeDate",start);
        criteria.andLessThan("tradeDate", end);
        return chinaPnrTransactionDetailMapper.selectByExample(example);
    }

    private List<JsSyncAmazonSettlementReport> getSettlementDatas(String kycNaturalId,String marketplaceName, ZonedDateTime start, ZonedDateTime end) {
        Example example = new Example(JsSyncAmazonSettlementReport.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("marketplaceName", marketplaceName);
        criteria.andEqualTo("kycNaturalId", kycNaturalId);
        criteria.andGreaterThanOrEqualTo("depositDate", Date.from(start.toInstant()));
        criteria.andLessThanOrEqualTo("depositDate", Date.from(end.toInstant()));
        // 这个查出来的应该都是结算汇总的那条记录。
        return jsSyncAmazonSettlementReportMapper.selectByExample(example);
    }

    /**
     * 计算上次订单还原后还未用完的明细 code
     *
     * @param transactionDetails 订单还原明细
     * @param start 订单还原明细开始时间
     * @return
     */
    private ChinaPnrTransactionDetail getLastTransactionDetails(List<ChinaPnrTransactionDetail> transactionDetails, ZonedDateTime start) {
        // 获取全部被拆分的明细,按时间降序排列
        List<ChinaPnrTransactionDetail> detailList = transactionDetails.stream()
                .filter(ChinaPnrTransactionDetail::getSplitFlag)
                .sorted((a, b) -> {
                    if (a.getTradeDate().getTime() - b.getTradeDate().getTime() > 0) {
                        return -1;
                    } else if (a.getTradeDate().getTime() - b.getTradeDate().getTime() == 0) {
                        return 0;
                    } else {
                        return 1;
                    }
                })
                .collect(Collectors.toList());
        if (detailList.size() == 0) {
            // 没有订单还原过，或者间两次还原间隔时间超过三个月了。。
            return null;
        } else {
            return detailList.get(0);
        }
    }

    private void filterUsedSettlementId(Map<String, List<ChinaPnrTransactionDetail>> listMap, ZonedDateTime start) {
        Example example = new Example(ChinaPnrTransactionDetail.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andLessThan("tradeDate", Date.from(start.toInstant()));
        ArrayList ids = new ArrayList(listMap.keySet());
        criteria.andIn("settlementId", ids);
        List<ChinaPnrTransactionDetail> chinaPnrTransactionDetails = chinaPnrTransactionDetailMapper.selectByExample(example);
        for (ChinaPnrTransactionDetail chinaPnrTransactionDetail : chinaPnrTransactionDetails) {
            if(ids.contains(chinaPnrTransactionDetail.getSettlementId())) {
                listMap.remove(ids);
            }
        }
    }
    private Map<String,ChinaPnrTransactionDetail> getDetailLength(List<ChinaPnrTransactionDetail> details) {
        Map<String,ChinaPnrTransactionDetail> map = new HashMap<>();
        for (ChinaPnrTransactionDetail detail : details) {
            if (map.containsKey(detail.getOrderItemCode())) {
                detail.setSplitAmount(map.get(detail.getOrderItemCode()).getSplitAmount().add(detail.getSplitAmount()));
                map.put(detail.getOrderItemCode(),detail);
            }else{
                map.put(detail.getOrderItemCode(),detail);
            }
        }
        return map;
    }
    private StringBuilder getDetailStr(Map<String,ChinaPnrTransactionDetail> map) throws Exception {
        StringBuilder detailsStr = new StringBuilder();
        Map<String, KycBankVO> kycMap = new HashMap<>();
        for (ChinaPnrTransactionDetail detail : map.values()) {
            KycBankVO kycBankVO = null;
            if(kycMap.containsKey(detail.getKycBankId())){
                kycBankVO = kycMap.get(detail.getKycBankId());
            }else{
                ResponseMessage responseMessage = apiKycBankService.getBankCard(detail.getKycBankId());
                if(responseMessage.isSuccess()){
                    kycBankVO = (KycBankVO)responseMessage.getData();
                    kycMap.put(detail.getKycBankId(),kycBankVO);
                }else{
                    log.error("KYC用户银行ID查询失败");
                    throw new Exception("KYC用户银行ID查询失败");
                }
            }
            // 明细流水号
            detailsStr.append(detail.getId()).append("|");
            // 订单编号
            detailsStr.append(detail.getOrderItemCode()).append("|");
            // 业务日期
            detailsStr.append(DateUtil.format(detail.getPostedDate(), "yyyyMMddHHmmss")).append("|");
            // 收款方类型
            detailsStr.append("P").append("|"); // 硬编码
            // 收款人证件类别
            detailsStr.append("00").append("|"); // 硬编码
            // 收款人证件号
            detailsStr.append(kycBankVO.getIdNo()).append("|"); // TODO 需要拿用户身份证号
            // 收款人名称
            detailsStr.append(kycBankVO.getAccountName()).append("|");
            // 收款人帐号
            detailsStr.append(kycBankVO.getAccountNo()).append("|");
            // 收款银行代码或名称
            detailsStr.append(kycBankVO.getBankCode()).append("|");
            // 付款币种
            detailsStr.append(detail.getCurrencyCode()).append("|");
            // 付款金额
            detailsStr.append(detail.getSplitAmount().multiply(new BigDecimal(100)).intValue()).append("|");
            // 商品描述
            detailsStr.append(detail.getSku()).append("|");
            // 备注
            detailsStr.append("note").append("\n");
        }
        if (detailsStr.length() > 0) {
            detailsStr.deleteCharAt(detailsStr.length()-1);
        }
        return detailsStr;
    }

    private StringBuilder rsGetDetailStr(List<ChinaPnrTransactionDetail> details, ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq) throws Exception {
        StringBuilder detailsStr = new StringBuilder();
        Map<String, KycBankVO> kycMap = new HashMap<>();
        for (ChinaPnrTransactionDetail detail : details) {
            KycBankVO kycBankVO = null;
            if(kycMap.containsKey(detail.getKycBankId())){
                kycBankVO = kycMap.get(detail.getKycBankId());
            }else{
                ResponseMessage responseMessage = apiKycBankService.getBankCard(detail.getKycBankId());
                if(responseMessage.isSuccess()){
                    kycBankVO = (KycBankVO)responseMessage.getData();
                    kycMap.put(detail.getKycBankId(),kycBankVO);
                }else{
                    log.error("KYC用户银行ID查询失败");
                    throw new Exception("KYC用户银行ID查询失败");
                }
            }
            // 明细流水号
            detailsStr.append(detail.getId()).append("|");
            // 订单编号
            detailsStr.append(detail.getOrderItemCode()).append("|");
            // 业务日期
            detailsStr.append(DateUtil.format(detail.getPostedDate(), "yyyyMMddHHmmss")).append("|");
            // 收款方类型
            detailsStr.append("P").append("|"); // 硬编码
            // 收款人证件类别
            detailsStr.append("01").append("|"); // 硬编码
            // 收款人证件号
            detailsStr.append(kycBankVO.getIdNo()).append("|"); // TODO 需要拿用户身份证号
            // 收款人名称
            detailsStr.append(kycBankVO.getAccountName()).append("|");
            // 收款人帐号
            detailsStr.append(kycBankVO.getAccountNo()).append("|");
            // 收款银行代码或名称
            detailsStr.append(kycBankVO.getBankCode()).append("|");
            // 付款币种
            detailsStr.append(chinaPNRTransactionDetailsReq.getCurrencyCode()).append("|");
            // 付款金额
            detailsStr.append((detail.getSplitAmount().multiply(new BigDecimal(100)).intValue())).append("|");
            // 商品描述
            detailsStr.append(detail.getSku()).append("|");
            // 备注
            detailsStr.append("note").append("\n");
        }
        if (detailsStr.length() > 0) {
            detailsStr.deleteCharAt(detailsStr.length()-1);
        }
        return detailsStr;
    }

    private JsSyncAmazonSettlementReport getSumReport(List<JsSyncAmazonSettlementReport> value) {
        // 合并商品对象。将所有价格统一到 priceAmount 字段上。
        JsSyncAmazonSettlementReport sumReport = new JsSyncAmazonSettlementReport();
        sumReport.setPriceAmount(new BigDecimal(0));
        for (JsSyncAmazonSettlementReport settlementReport : value) {
            sumReport.setId(settlementReport.getId());
            sumReport.setOrderItemCode(settlementReport.getOrderItemCode());
            sumReport.setReportId(settlementReport.getReportId());
            sumReport.setSettlementId(settlementReport.getSettlementId());
            sumReport.setMarketplaceName(settlementReport.getMarketplaceName());
            sumReport.setTransactionType(settlementReport.getTransactionType());
            sumReport.setSku(settlementReport.getSku());
            sumReport.setPostedDate(settlementReport.getPostedDate());
            if (ObjectUtil.isNotEmpty(settlementReport.getShipmentFeeAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getShipmentFeeAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getOrderFeeAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getOrderFeeAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getPriceAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getPriceAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getItemRelatedFeeAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getItemRelatedFeeAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getMiscFeeAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getMiscFeeAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getOtherFeeAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getOtherFeeAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getDirectPaymentAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getDirectPaymentAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getOtherAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getOtherAmount()));
            }
            if (ObjectUtil.isNotEmpty(settlementReport.getPromotionAmount())) {
                sumReport.setPriceAmount(sumReport.getPriceAmount().add(settlementReport.getPromotionAmount()));
            }
        }
        return sumReport;
    }

    private class HttpResult {
        private Map<String, Object> parameter;
        private String requestXml;
        private HttpSendResult result;

        public HttpResult(Map<String, Object> parameter) {
            this.parameter = parameter;
        }

        public String getRequestXml() {
            return requestXml;
        }

        public HttpSendResult getResult() {
            return result;
        }

        public HttpResult invoke() {
            HttpClientServiceImpl httpClient = new HttpClientServiceImpl();
            SimpleHttpsClientImpl shci = new SimpleHttpsClientImpl();
            httpClient.setHttpsClient(shci);

            requestXml = ChinaPNRCommons.transferToXML(parameter,chinaPnrConfigure.getTrxtypeBa(),chinaPnrConfigure.getChinapnrrXml());

            Document doc = XMLUtil.str2Doc(requestXml,"utf-8");
            try {
                SignatureUtil.xmlSignature(doc,
                        chinaPnrConfigure.getEnvtype(),
                        chinaPnrConfigure.getMerchantid()
                                .substring(0, chinaPnrConfigure.getMerchantid().length()-2),
                        chinaPnrConfigure.getPassword(),
                        chinaPnrConfigure.getAliasname(),chinaPnrConfigure.getChinapnrPfxUrl(),chinaPnrConfigure.getChinapnrPfx());
            } catch (Exception e) {
                e.printStackTrace();
            }
            requestXml = XMLUtil.doc2Str(doc,"utf-8");
            String postUrl = chinaPnrConfigure.getPosturl();
            HttpRequestContext context = new HttpRequestContext();
            context.setUrl(postUrl);
            context.setHttpMethod(HttpRequestContext.POST_METHOD);
            context.setResponseCharset("utf-8");
            context.setRequestCharset("utf-8");
            context.setXml(requestXml);

            result = null;
            try {
                result = httpClient.sendRequest(context);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }
    }
}
