package com.js.pay.service.chinapnr.example.pay;

import com.alibaba.fastjson.JSON;
import com.js.common.constant.CommonConstant;
import com.js.common.model.req.ChinaPNREnterpriseOpenAccountReq;
import com.js.common.model.req.ChinaPNRPersonalOpenAccountReq;
import com.js.common.model.req.ChinaPNRQueryOpenAccountReq;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import com.js.pay.service.chinapnr.example.ChinaPnrConfigure;
import com.js.pay.service.chinapnr.example.DateUtils;
import com.js.pay.service.chinapnr.example.otherutils.HttpSendResult;
import com.js.pay.service.chinapnr.example.otherutils.SignTool;
import com.js.pay.service.chinapnr.example.otherutils.SimpleHttpsClient;
import com.js.pay.service.chinapnr.example.otherutils.XMLSecurityProcess;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 汇付国际 个人开户 ，企业开户 修改开户信息  查询等功能
 */
@Slf4j
@Component
public class ChinaPNROpenAccount {

    /**
     * 汇付配置文件
     */
    @Autowired
    private ChinaPnrConfigure chinaPnrConfigure ;

    /**
     * 个人信息开户
     * @param chinaPNROpenAccountReq
     * @return
     */
    public Map<String,String> personalOpenAccount(ChinaPNRPersonalOpenAccountReq chinaPNROpenAccountReq){

        Map<String,String> resMap = new HashMap<>();
        Map<String, String> parameter = new HashMap<>();

        //接口版本
        parameter.put("version", chinaPnrConfigure.getNewVersion());
        parameter.put("signType", chinaPnrConfigure.getSigntype());

        //商户号
        parameter.put("merchantAcctId", chinaPnrConfigure.getMerchantid());
        parameter.put("requestTime", DateUtils.LONG_DATE_FORMAT_SSS.format(new Date()));

        parameter.put("requestId", chinaPNROpenAccountReq.getRequestId());
        //用户平台ID
        parameter.put("platformUserId", chinaPNROpenAccountReq.getJsOpenAccountNo());
        parameter.put("platformRegTime", chinaPNROpenAccountReq.getPlatformRegTime());
        parameter.put("name", chinaPNROpenAccountReq.getName());
        parameter.put("certType", chinaPNROpenAccountReq.getCertType());
        parameter.put("certId", chinaPNROpenAccountReq.getCertId());
        parameter.put("certExpDateStart", ""); //证件失效日期
        parameter.put("certExpDateEnd", chinaPNROpenAccountReq.getCertExpDateEnd()); //证件失效日期
        parameter.put("mobileNumber", chinaPNROpenAccountReq.getMobileNumber());
        parameter.put("address", chinaPNROpenAccountReq.getAddress());
        parameter.put("email", chinaPNROpenAccountReq.getEmail());
        parameter.put("bankCode", chinaPNROpenAccountReq.getBankCode());
        parameter.put("acctType", "2"); //1-对公 2-对私。仅支持对私
        parameter.put("bankAcct", chinaPNROpenAccountReq.getBankAcct());
        parameter.put("acctName", chinaPNROpenAccountReq.getAcctName());
        parameter.put("province", "");
        parameter.put("area", "");
        parameter.put("bankBranch", "");
        parameter.put("uniteBankCode", "");
        parameter.put("certPhotoCopyF", chinaPNROpenAccountReq.getCertPhotoCopyF()); //证件影印件正面
        parameter.put("certPhotoCopyB", chinaPNROpenAccountReq.getCertPhotoCopyB()); //证件影印件反面
        parameter.put("asyncNoticeFlag", "1"); //
        parameter.put("noticeUrl", chinaPnrConfigure.getOpentAccountPersonallResultUrl());

        Map<String,String> signMsgValMap = new HashMap<>();
        signMsgValMap.put( "requestTime", parameter.get("requestTime"));
        signMsgValMap.put("version", parameter.get("version"));
        signMsgValMap.put( "platformUserId", parameter.get("platformUserId"));
        signMsgValMap.put( "signType", parameter.get("signType"));
        signMsgValMap.put( "requestId", parameter.get("requestId"));
        signMsgValMap.put("merchantAcctId", parameter.get("merchantAcctId"));
        signMsgValMap.put("platformRegTime", parameter.get("platformRegTime"));
        signMsgValMap.put("name", parameter.get("name"));
        signMsgValMap.put( "certType", parameter.get("certType"));
        signMsgValMap.put( "certId", parameter.get("certId"));
        signMsgValMap.put( "mobileNumber", parameter.get("mobileNumber"));
        signMsgValMap.put( "address", parameter.get("address"));
        signMsgValMap.put("email", parameter.get("email"));
        signMsgValMap.put( "bankCode", parameter.get("bankCode"));
        signMsgValMap.put( "acctName", parameter.get("acctName"));
        signMsgValMap.put( "acctType", parameter.get("acctType"));
        signMsgValMap.put( "bankAcct", parameter.get("bankAcct"));
        signMsgValMap.put( "noticeUrl", parameter.get("noticeUrl"));

        String signMsgVal = ChinaPNRCommons.createLinkString(signMsgValMap);
        log.info("个人开户签名：" + signMsgVal);
        //商户会员号，不可空。
        String merchantAcctId = parameter.get("merchantAcctId");

        SignTool pki = new SignTool(merchantAcctId.substring(0, merchantAcctId.length() - 2), "",
                chinaPnrConfigure.getPassword(),
                chinaPnrConfigure.getAliasname());
        String signMsg = pki.signMsg(signMsgVal,chinaPnrConfigure.getChinapnrPfxUrl());
        parameter.put("signMsg", signMsg);

        SimpleHttpsClient httpClient = new SimpleHttpsClient();

        HttpSendResult result = null;
        try {
            result = httpClient.postRequest(chinaPnrConfigure.getOpentAccountPersonallPosturl(),
                    parameter, 30000);
            log.info("请求汇付开对私户返回结果:{}", JSON.toJSONString(result));
        } catch (Exception e) {
            log.error("请求处理个人开户信息异常",e);
            resMap.put("code", CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","请求处理个人开户信息异常");
            return resMap;
        }
        log.info("result:" + result.getResponseBody());

        if (null ==  result) {
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付个人开户网关系统异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付个人开户网关系统异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }
        Map<String,String> callbackMap = ChinaPNRCommons.getCallbackMap(result.getResponseBody());
        String callbackSignMsgVal = ChinaPNRCommons.createLinkString(callbackMap);

        log.info("个人信息开户返回参数验签=" + callbackSignMsgVal);
        String callbackSignMsg = callbackMap.get("signMsg");

        boolean veryfyResult=false;
        try {
            //BG通知未转义，需要先转义
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, URLDecoder.decode(callbackSignMsg),chinaPnrConfigure.getChinapnrCer());
        } catch (Exception e) {
            log.error("请求个人开户返回信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","个人开户返回信息验签异常");
            return resMap;
        }
        if(!veryfyResult){
            log.info("个人开户返回信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","个人开户返回信息验签失败");
            return resMap;
        }
        resMap.put("reqText",signMsgVal);
        resMap.put("resText",result.getResponseBody());
        //返回错误
        if(null !=callbackMap.get("errorCode") && !callbackMap.get("errorCode").equals("")){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg",resMap.get("errorMsg"));
            return resMap;
        }
        if(callbackMap.get("result").equals("02")){//失败
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","个人用户开户开户失败");
        } else if(callbackMap.get("result").equals("01")){//审核中
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING);
            resMap.put("msg","个人用户开户审核中");
            resMap.put("chinaPNRUserId",callbackMap.get("userId"));
        } else if(callbackMap.get("result").equals("00")){//开户成功
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS);
            resMap.put("msg","个人用户开户成功");
            resMap.put("chinaPNRUserId",callbackMap.get("userId"));
        }else{//其他特殊原因
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","其他特殊原因开户失败");
        }
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        return resMap;
    }

    /**
     * 个人信息开户修改
     * @param chinaPNROpenAccountReq
     * @returnu
     */
    public Map<String,String> updatePersonalOpenAccount(ChinaPNRPersonalOpenAccountReq chinaPNROpenAccountReq){

        return null;
    }

    /**
     * 企业信息开户
     * @param chinaPNROpenAccountReq
     * @return
     */
    public Map<String,String> enterpriseOpenAccount(ChinaPNREnterpriseOpenAccountReq chinaPNROpenAccountReq){
        Map<String,String> resMap = new HashMap<>();
        Map<String, String> parameter = new HashMap<>();

        parameter.put("signType", chinaPnrConfigure.getSigntype());
        //接口版本
        parameter.put("version", chinaPnrConfigure.getNewVersion());
        parameter.put("requestTime", DateUtils.LONG_DATE_FORMAT_SSS.format(new Date()));
        //商户号
        parameter.put("merchantAcctId", chinaPnrConfigure.getMerchantid());
        parameter.put("requestId", chinaPNROpenAccountReq.getRequestId());
        //用户平台ID
        parameter.put("platformUserId", chinaPNROpenAccountReq.getJsOpenAccountNo());
        parameter.put("platformRegTime", chinaPNROpenAccountReq.getPlatformRegTime());
        parameter.put("name", chinaPNROpenAccountReq.getName());
        parameter.put("type", chinaPNROpenAccountReq.getType()); //企业类型 1-个体工商户 2-企业
        parameter.put("legalPerson", chinaPNROpenAccountReq.getLegalPerson()); //法人姓名
        parameter.put("legalCertType", chinaPNROpenAccountReq.getLegalCertType()); //法人证件类型
        parameter.put("legalCertId", chinaPNROpenAccountReq.getLegalCertId()); //法人证件号
        parameter.put("legalCertExpDateEnd", chinaPNROpenAccountReq.getLegalCertExpDateEnd()); //法人证件时效日期
        parameter.put("contactCertExpDateEnd", chinaPNROpenAccountReq.getContactCertExpDateEnd()); //联系人证件失效日期
        parameter.put("address", chinaPNROpenAccountReq.getAddress());//企业地址
        parameter.put("phone", chinaPNROpenAccountReq.getPhone()); //企业电话
        parameter.put("orgCode", chinaPNROpenAccountReq.getOrgCode()); //组织机构代码
        parameter.put("orgExpDateEnd", chinaPNROpenAccountReq.getOrgExpDateEnd()); //组织机构代码失效日期
        parameter.put("bizLicenseCode", chinaPNROpenAccountReq.getBizLicenseCode()); //营业执照号
        parameter.put("bizLicenseExpDateEnd", chinaPNROpenAccountReq.getBizLicenseExpDateEnd()); //营业执照失效日期
        parameter.put("taxRegCode", chinaPNROpenAccountReq.getTaxRegCode()); //税务登记号
        parameter.put("taxRegExpDateEnd", chinaPNROpenAccountReq.getTaxRegExpDateEnd());//税务登记证失效日期
        parameter.put("bankCode", chinaPNROpenAccountReq.getBankCode()); //开户银行
        parameter.put("acctType", chinaPNROpenAccountReq.getAcctType());//账户类型 1-对公 2-对私
        parameter.put("bankAcct", chinaPNROpenAccountReq.getBankAcct());//账号
        parameter.put("acctName", chinaPNROpenAccountReq.getAcctName());//户名
        parameter.put("province", chinaPNROpenAccountReq.getProvince());//省份
        parameter.put("area", chinaPNROpenAccountReq.getArea());//地区
        parameter.put("bankBranch", chinaPNROpenAccountReq.getBankBranch());//支行名称
        parameter.put("uniteBankCode", chinaPNROpenAccountReq.getUniteBankCode());//收款行联行号
        parameter.put("legalCertPhotoCopyF", chinaPNROpenAccountReq.getLegalCertPhotoCopyF());  //法人证件的影印件正面
        parameter.put("legalCertPhotoCopyB", chinaPNROpenAccountReq.getLegalCertPhotoCopyB()); //法人证件的影印件反面
        parameter.put("bizLicensePhotoCopy", chinaPNROpenAccountReq.getBizLicensePhotoCopy()); //营业执照影印件
        parameter.put("asyncNoticeFlag", "1"); //是否接收异步通知
        parameter.put("noticeUrl", chinaPnrConfigure.getOpentAccountEnterpriseResultUrl()); //后台通知地址

        parameter.put("orgPhotoCopy", chinaPNROpenAccountReq.getOrgPhotoCopy()); //组织机构代码证影印件
        parameter.put("taxRegPhotoCopy", chinaPNROpenAccountReq.getTaxRegPhotoCopy());//税务登记证影印件
        parameter.put("openLicensePhotoCopy", chinaPNROpenAccountReq.getOpenLicensePhotoCopy());//开户许可证影印件

        Map<String,String> signMsgValMap = new HashMap<>();

        signMsgValMap.put("signType", parameter.get("signType"));
        signMsgValMap.put("requestTime", parameter.get("requestTime"));
        signMsgValMap.put("merchantAcctId", parameter.get("merchantAcctId"));
        signMsgValMap.put("platformUserId", parameter.get("platformUserId"));
        signMsgValMap.put("requestId", parameter.get("requestId"));
        signMsgValMap.put("platformRegTime", parameter.get("platformRegTime"));
        signMsgValMap.put("version", parameter.get("version"));
        signMsgValMap.put("name", parameter.get("name"));
        signMsgValMap.put("bankAcct", parameter.get("bankAcct"));
        signMsgValMap.put("legalPerson", parameter.get("legalPerson"));
        signMsgValMap.put("legalCertType", parameter.get("legalCertType"));
        signMsgValMap.put("type", parameter.get("type"));
        signMsgValMap.put("taxRegCode", parameter.get("taxRegCode"));
        signMsgValMap.put("legalCertId", parameter.get("legalCertId"));
        signMsgValMap.put("address", parameter.get("address"));
        signMsgValMap.put("orgCode", parameter.get("orgCode"));
        signMsgValMap.put("phone", parameter.get("phone"));
        signMsgValMap.put("bizLicenseCode", parameter.get("bizLicenseCode"));
        signMsgValMap.put("bankCode", parameter.get("bankCode"));
        signMsgValMap.put("area", parameter.get("area"));
        signMsgValMap.put("acctName", parameter.get("acctName"));
        signMsgValMap.put("province", parameter.get("province"));

        signMsgValMap.put("acctType", parameter.get("acctType"));
        signMsgValMap.put("bankBranch", parameter.get("bankBranch"));
        signMsgValMap.put("uniteBankCode", parameter.get("uniteBankCode"));

        String signMsgVal = ChinaPNRCommons.createLinkString(signMsgValMap);
        log.info("企业开户签名：" + signMsgVal);

        SignTool pki = new SignTool(chinaPnrConfigure.getMerchantid().substring(0, chinaPnrConfigure.getMerchantid().length() - 2), "",
                chinaPnrConfigure.getPassword(),
                chinaPnrConfigure.getAliasname());
        String signMsg = pki.signMsg(signMsgVal,chinaPnrConfigure.getChinapnrPfxUrl());
        parameter.put("signMsg", signMsg);

        SimpleHttpsClient httpClient = new SimpleHttpsClient();
        HttpSendResult result = null;
        try {
            result = httpClient.postRequest(chinaPnrConfigure.getOpentAccountEnterprisePosturl(),
                    parameter, 30000);
        } catch (Exception e) {
            log.error("请求处理企业开户信息异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","请求处理企业开户信息异常");
            return resMap;
        }
        log.info("企业开户返回结果result:" + result.getResponseBody());

        if (null ==  result) {
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付企业开户网关系统异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付企业开户网关系统异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }
        Map<String,String> callbackMap = ChinaPNRCommons.getCallbackMap(result.getResponseBody());
        String callbackSignMsgVal = ChinaPNRCommons.createLinkString(callbackMap);

        log.info("企业信息开户返回参数验签=" + callbackSignMsgVal);
        String callbackSignMsg = callbackMap.get("signMsg");

        boolean veryfyResult=false;
        try {
            //BG通知未转义，需要先转义
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, URLDecoder.decode(callbackSignMsg),chinaPnrConfigure.getChinapnrCer());
        } catch (Exception e) {
            log.error("请求企业开户返回信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","企业开户返回信息验签异常");
            return resMap;
        }
        if(!veryfyResult){
            log.info("企业开户返回信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","企业开户返回信息验签失败");
            return resMap;
        }
        resMap.put("reqText",signMsgVal);
        resMap.put("resText",result.getResponseBody());
        //返回错误
        if(null !=callbackMap.get("errorCode") && !"".equals(callbackMap.get("errorCode"))){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg",resMap.get("errorMsg"));
            return resMap;
        }
        if(callbackMap.get("result").equals("02")){//失败
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","企业用户开户开户失败");
        }else if(callbackMap.get("result").equals("01")){//审核中
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING);
            resMap.put("msg","企业用户开户审核中");
            resMap.put("chinaPNRUserId",callbackMap.get("userId"));
        }else if(callbackMap.get("result").equals("00")){//开户成功
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS);
            resMap.put("msg","企业用户开户成功");
            resMap.put("chinaPNRUserId",callbackMap.get("userId"));
        }else{//其他特殊原因
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","其他特殊原因开户失败");
        }
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        return resMap;
    }

    /**
     * 企业信息开户修改
     * @param chinaPNRQueryOpenAccountReq
     * @returnu
     */
    public Map<String,String> updateEnterpriseOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq){

        return null;
    }

    /**
     * 个人开户 回调
     * @param map
     * @return
     */
    public Map<String,String> callbackPersonalOpenAccount(Map<String,String> map){

        Map<String,String> resMap = new HashMap<>();
        //验签
        String callbackSignMsgVal = ChinaPNRCommons.createLinkString(map);
        log.info("个人开户回调参数验签=" + callbackSignMsgVal);
        //String callbackSignMsg = map.get("signMsg");
        String callbackSignMsg = map.get("signMsg");

        boolean veryfyResult=false;
        try {
            //BG通知未转义，需要先转义
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, URLDecoder.decode(callbackSignMsg),chinaPnrConfigure.getChinapnrCer());
            //veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, callbackSignMsg);
        } catch (Exception e) {
            log.error("个人开户回调信息验签异常");
            resMap.put("code","0001");
            resMap.put("msg","个人开户回调信息验签异常");
            return resMap;
        }
        if(!veryfyResult){
            log.info("个人开户回调信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","个人开户回调信息验签失败");
            return resMap;
        }
        resMap.put("resText",map.toString());
        //返回错误
        if(null !=map.get("errorCode") && !"".equals(map.get("errorCode"))){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","个人开户回调错误信息=" + resMap.get("errorMsg"));
            return resMap;
        }
        if(map.get("result").equals("02")){//失败
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","个人开户回调开户失败");
        }else if(map.get("result").equals("01")){//审核中
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING);
            resMap.put("msg","个人开户回调审核中");
        }else if(map.get("result").equals("00")){//开户成功
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS);
            resMap.put("msg","个人开户回调开户成功");
            resMap.put("chinaPNRUserId",map.get("userId"));
        }else{//其他特殊原因
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","其他特殊原因开户失败");
        }
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        return resMap;
    }

    /**
     * 企业开户 回调
     * @param map
     * @return
     */
    public Map<String,String> callbackEnterpriseOpenAccount(Map<String,String> map){

        Map<String,String> resMap = new HashMap<>();
        //验签
        String callbackSignMsgVal = ChinaPNRCommons.createLinkString(map);
        log.info("企业开户回调参数验签=" + callbackSignMsgVal);
        String callbackSignMsg = map.get("signMsg");

        boolean veryfyResult=false;
        try {
            //BG通知未转义，需要先转义
            //veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, callbackSignMsg);
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, URLDecoder.decode(callbackSignMsg),chinaPnrConfigure.getChinapnrCer());
        } catch (Exception e) {
            log.error("企业开户回调信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","企业开户回调信息验签异常");
            return resMap;
        }
        if(!veryfyResult){
            log.info("企业开户回调信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","企业开户回调信息验签失败");
            return resMap;
        }
        resMap.put("resText",map.toString());
        //返回错误
        if(null !=map.get("errorCode") && !"".equals(map.get("errorCode"))){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","企业开户回调错误信息=" + resMap.get("errorMsg"));
            return resMap;
        }
        if(map.get("result").equals("02")){//失败
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","企业开户回调开户失败");
        }else if(map.get("result").equals("01")){//审核中
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING);
            resMap.put("msg","企业开户回调审核中");
        }else if(map.get("result").equals("00")){//开户成功
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS);
            resMap.put("msg","企业开户回调开户成功");
            resMap.put("chinaPNRUserId",map.get("userId"));
        }else{//其他特殊原因
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","其他特殊原因开户失败");
        }
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        return resMap;
    }


    /**
     * 个人开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @returnu
     */
    public Map<String,String> queryPersonalOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq){
        Map<String,String> resMap = new HashMap<>();
        Map<String, String> parameter = new HashMap<>();

        //接口版本
        parameter.put("signType", chinaPnrConfigure.getSigntype());
        parameter.put("requestTime", DateUtils.LONG_DATE_FORMAT_SSS.format(new Date()));
        parameter.put("requestId", chinaPNRQueryOpenAccountReq.getRequestId());
        parameter.put("version", chinaPnrConfigure.getNewVersion());
        //商户号
        parameter.put("merchantAcctId", chinaPnrConfigure.getMerchantid());
        //用户平台ID
        parameter.put("platformUserId", chinaPNRQueryOpenAccountReq.getJsOpenAccountNo());

        Map<String,String> signMsgValMap = new HashMap<>();
        signMsgValMap.put( "signType", parameter.get("signType"));
        signMsgValMap.put( "requestTime", parameter.get("requestTime"));
        signMsgValMap.put( "requestId", parameter.get("requestId"));
        signMsgValMap.put("version", parameter.get("version"));
        signMsgValMap.put("merchantAcctId", parameter.get("merchantAcctId"));
        signMsgValMap.put( "platformUserId", parameter.get("platformUserId"));
        String signMsgVal = ChinaPNRCommons.createLinkString(signMsgValMap);
        log.info("查询签名：" + signMsgVal);
        //商户会员号，不可空。
        SimpleHttpsClient httpClient = new SimpleHttpsClient();
        String merchantAcctId = parameter.get("merchantAcctId");

        SignTool pki = new SignTool(merchantAcctId.substring(0, merchantAcctId.length() - 2), "",
                chinaPnrConfigure.getPassword(),
                chinaPnrConfigure.getAliasname());
        String signMsg = pki.signMsg(signMsgVal,chinaPnrConfigure.getChinapnrPfxUrl());
        parameter.put("signMsg", signMsg);

        HttpSendResult result = null;
        log.info("map=" + parameter);
        try {
            result = httpClient.postRequest(chinaPnrConfigure.getOpentAccountPersonallQueryurl(),
                    parameter, 30000);
        } catch (Exception e) {
            log.error("请求查询个人开户请求信息失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","请求查询个人开户请求信息失败");
            return resMap;
        }
        log.info("请求回调信息result:" + result.getResponseBody());
        if (null ==  result) {
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付个人开户查询网关系统异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付个人开户查询网关系统异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }

        Map<String,String> callbackMap = ChinaPNRCommons.getCallbackMap(result.getResponseBody());
        String callbackSignMsgVal = ChinaPNRCommons.createQueryLinkString(callbackMap);

        log.info("个人信息查询返回参数验签=" + callbackSignMsgVal);
        String callbackSignMsg = callbackMap.get("signMsg");

        boolean veryfyResult=false;
        try {
            //BG通知未转义，需要先转义
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, URLDecoder.decode(callbackSignMsg),chinaPnrConfigure.getChinapnrCer());
        } catch (Exception e) {
            log.error("查询个人开户返回信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","查询个人开户返回信息验签异常");
            return resMap;
        }
        if(!veryfyResult){
            log.info("查询个人开户返回信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","查询个人开户返回信息验签失败");
            return resMap;
        }
        //返回错误
        if(null !=callbackMap.get("errorCode") && !callbackMap.get("errorCode").equals("")){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","查询错误结果=" + resMap.get("errorMsg"));
            return resMap;
        }
        if(callbackMap.get("result").equals("02")){//失败
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","查询个人用户开户开户失败");
        }else if(callbackMap.get("result").equals("01")){//审核中
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING);
            resMap.put("msg","查询个人用户开户审核中");
        }else if(callbackMap.get("result").equals("00")){//开户成功
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS);
            resMap.put("msg","查询个人用户开户成功");
            resMap.put("chinaPNRUserId",callbackMap.get("userId"));
        }else{//其他特殊原因
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","其他特殊原因开户失败");
        }
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        return resMap;

    }

    /**
     * 企业开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @returnu
     */
    public Map<String,String> queryEnterpriseOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq){
        Map<String,String> resMap = new HashMap<>();
        Map<String, String> parameter = new HashMap<>();
        //用户平台ID
        parameter.put("platformUserId", chinaPNRQueryOpenAccountReq.getJsOpenAccountNo());
        parameter.put("signType", chinaPnrConfigure.getSigntype());
        parameter.put("requestId", chinaPNRQueryOpenAccountReq.getRequestId());
        //接口版本
        parameter.put("version", chinaPnrConfigure.getNewVersion());
        parameter.put("requestTime", DateUtils.LONG_DATE_FORMAT_SSS.format(new Date()));

        //商户号
        parameter.put("merchantAcctId", chinaPnrConfigure.getMerchantid());


        Map<String,String> signMsgValMap = new HashMap<>();
        signMsgValMap.put( "requestTime", parameter.get("requestTime"));
        signMsgValMap.put( "platformUserId", parameter.get("platformUserId"));
        signMsgValMap.put("version", parameter.get("version"));
        signMsgValMap.put( "signType", parameter.get("signType"));
        signMsgValMap.put( "requestId", parameter.get("requestId"));
        signMsgValMap.put("merchantAcctId", parameter.get("merchantAcctId"));

        String signMsgVal = ChinaPNRCommons.createLinkString(signMsgValMap);
        log.info("企业开户查询签名：" + signMsgVal);

        SimpleHttpsClient httpClient = new SimpleHttpsClient();
        SignTool pki = new SignTool(chinaPnrConfigure.getMerchantid().substring(0,
                chinaPnrConfigure.getMerchantid().length() - 2), "",
                chinaPnrConfigure.getPassword(),
                chinaPnrConfigure.getAliasname());
        String signMsg = pki.signMsg(signMsgVal,chinaPnrConfigure.getChinapnrPfxUrl());
        parameter.put("signMsg", signMsg);

        HttpSendResult result = null;
        log.info("企业开户查询结果map=" + parameter);
        try {
            result = httpClient.postRequest(chinaPnrConfigure.getOpentAccountEnterpriseQueryurl(),
                    parameter, 30000);
        } catch (Exception e) {
            log.error("请求查询企业开户请求信息失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","请求查询企业开户请求信息失败");
            return resMap;
        }
        log.info("请求企业开户回调信息result:" + result.getResponseBody());
        if (null ==  result) {
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付企业开户查询网关系统异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","汇付企业开户查询网关系统异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }

        Map<String,String> callbackMap = ChinaPNRCommons.getCallbackMap(result.getResponseBody());
        String callbackSignMsgVal = ChinaPNRCommons.createQueryLinkString(callbackMap);

        log.info("企业信息查询返回参数验签=" + callbackSignMsgVal);
        String callbackSignMsg = callbackMap.get("signMsg");

        boolean veryfyResult=false;
        try {
            //BG通知未转义，需要先转义
            veryfyResult = XMLSecurityProcess.veryfySignature(callbackSignMsgVal, URLDecoder.decode(callbackSignMsg),chinaPnrConfigure.getChinapnrCer());
        } catch (Exception e) {
            log.error("查询企业开户返回信息验签异常");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","查询企业开户返回信息验签异常");
            return resMap;
        }
        if(!veryfyResult){
            log.info("查询企业开户返回信息验签失败");
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","查询企业开户返回信息验签失败");
            return resMap;
        }
        //返回错误
        if(null !=callbackMap.get("errorCode") && !callbackMap.get("errorCode").equals("")){
            resMap.put("code",CommonConstant.CHINA_RESULT_ERROR);
            resMap.put("msg","查询企业错误结果=" + resMap.get("errorMsg"));
            return resMap;
        }
        if(callbackMap.get("result").equals("02")){//失败
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","查询企业用户开户开户失败");
        }else if(callbackMap.get("result").equals("01")){//审核中
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_VERIFYING);
            resMap.put("msg","查询企业用户开户审核中");
        }else if(callbackMap.get("result").equals("00")){//开户成功
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_SUCCESS);
            resMap.put("msg","查询企业用户开户成功");
            resMap.put("chinaPNRUserId",callbackMap.get("userId"));
        }else{//其他特殊原因
            resMap.put("result",CommonConstant.CHINA_ACCOUNT_STATUS_ERROR);
            resMap.put("msg","其他特殊原因开户失败");
        }
        resMap.put("code",CommonConstant.CHINA_RESULT_SUCCESS);
        return resMap;

    }

}
