package com.js.pay.mq;

import com.js.api.jspay.service.ApiSunrateBeneficiaryService;
import com.js.common.model.vo.KycNaturalVO;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Author liuh
 * @Description 监听 mq 接收消息
 * @Date 2019/3/1 14:51
 * @Param
 * @return
 **/
@Component
@Slf4j
public class RabbitMQNoticeBeneficiaryReceiver {
    @Resource
    ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;

    @RabbitListener(
            bindings = @QueueBinding(
                value = @Queue(value = "${spring.rabbitmq.queueBeneficiary}", durable = "true"),
                exchange = @Exchange(value = "${spring.rabbitmq.exchange}", type = ExchangeTypes.TOPIC),
                key = "${spring.rabbitmq.queueNoticeBeneficiary}"
            )
    )
    @RabbitHandler
    public void noticeToAddBeneficiary(@Payload KycNaturalVO kycNaturalVO,
                              @Headers Map<String,Object> headers,
                              Channel channel) {
        log.info("MQ通知添加受益人 kycNaturalVO:{}, headers:{}, channel:{}", kycNaturalVO, headers, channel);
        apiSunrateBeneficiaryService.beneficiaryCreateMQ(kycNaturalVO);
    }
}
