package com.js.pay.service.impl;

import com.aliyun.oss.OSSClient;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.FileMngForOSSUtil;
import com.js.pay.properties.JswebOSSPropertie;
import com.js.pay.service.JsFileForOSSSerivce;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.InputStream;

/**
 * @Author yjzhao
 * @Description 文件服务实现类
 * @Date 2019/5/17 16:50
 * @Param
 * @return
 **/
@Service("fileForOSSService")
public class JsFileForOSSServiceImpl implements JsFileForOSSSerivce {
    @Autowired
    JswebOSSPropertie jswebOSSPropertie;

    @Autowired
    OSSClient oSSClient;

    /**
     * @Author yjzhao
     * @Description 根据OSS 文件存储路径获取文件流
     * @Date 2019/5/18 20:28
     * @Param [fileUrl]
     * @return java.io.InputStream
     **/
    @Override
    public InputStream findFile(String fileUrl) {
        FileMngForOSSUtil fileUploadForOSSUtil = new FileMngForOSSUtil(jswebOSSPropertie.getBucket(), null, oSSClient);
        return fileUploadForOSSUtil.findFile(fileUrl);
    }

    @Override
    public ResponseMessage deleteFile(String fileUrl) {
        FileMngForOSSUtil fileUploadForOSSUtil = new FileMngForOSSUtil(jswebOSSPropertie.getBucket(), null, oSSClient);
        return fileUploadForOSSUtil.deleteFile(fileUrl);
    }
}
