package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiJsPayStationOrganInfoService;
import com.js.api.jspay.service.ApiSunrateBeneficiaryService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.req.KycSunrateBeneficiaryReq;
import com.js.common.model.req.SunrateMarketRateTradeReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPayStationOrganInfoMapper;
import com.js.dal.dao.model.JsPayStationOrganInfo;
import com.js.dal.dao.model.KycSunrateBeneficiary;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiJsPayStationOrganInfoServiceImpl extends IBaseServiceImpl<JsPayStationOrganInfo> implements ApiJsPayStationOrganInfoService {

    @Autowired
    JsPayStationOrganInfoMapper jsPayStationOrganInfoMapper;
    @Autowired
    KycSunrateService kycSunrateService;
//    @Autowired
//    ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;



    @Override
    public ResponseMessage insertVatStationInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq) {
        JsPayStationOrganInfo jsPayStationOrganInfo = new JsPayStationOrganInfo();
        BeanUtils.copyProperties(jsPayVatPaymentInfoReq,jsPayStationOrganInfo);
//        jsPayStationOrganInfo.setId(IdUtil.simpleUUID());
//        jsPayStationOrganInfo.setTaxStationId(jsPayStationOrganInfo.getTaxStationId());
//        jsPayStationOrganInfo.setCreateId(jsPayVatPaymentInfoReq.getCreateId());
//        jsPayStationOrganInfo.setCreateName(jsPayVatPaymentInfoReq.getCreateName());
        jsPayStationOrganInfo.setCreateDts(new Date());
        insertSelective(jsPayStationOrganInfo);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }


    @Override
    public ResponseMessage sunrateMarketRateTrade(SunrateMarketRateTradeReq sunrateMarketRateTradeReq){
        if(StringUtils.isBlank(sunrateMarketRateTradeReq.getBeneficiaryId())){
            ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
        }
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(sunrateMarketRateTradeReq));
        jsonObjectReq.remove("browserIP");
        Map<String,String> mapParams = (Map)jsonObjectReq;
        ResponseMessage responseMessage =  kycSunrateService.sendInfoToXh(sunrateMarketRateTradeReq.getBrowserIP(),"beneficiary.create","beneficiary/create/",mapParams);
        if(responseMessage.isSuccess()){

           // operationBeneficiary(sunrateMarketRateTradeReq,responseMessage);
        }
        return responseMessage;
    }

//    public void operationBeneficiary(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq, ResponseMessage responseMessage){
//        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
//        if(StringUtils.isBlank(kycSunrateBeneficiaryReq.getBeneficiaryId())){
//            KycSunrateBeneficiary kycSunrateBeneficiary = new KycSunrateBeneficiary();
//            BeanUtils.copyProperties(kycSunrateBeneficiaryReq,kycSunrateBeneficiary);
//            kycSunrateBeneficiary.setId(IdUtil.simpleUUID());
//            kycSunrateBeneficiary.setBeneficiaryId(jsonObject.getString("beneficiaryId"));
//            kycSunrateBeneficiary.setBeneficiaryStatus(jsonObject.getString("beneficiaryStatus"));
//            super.insertSelective(kycSunrateBeneficiary);
//        }else{
//            KycSunrateBeneficiary kycSunrateBeneficiary = iBaseMapper.selectByPrimaryKey(kycSunrateBeneficiaryReq.getBeneficiaryId());
//            kycSunrateBeneficiary.setBeneficiaryId(jsonObject.getString("beneficiaryId"));
//            kycSunrateBeneficiary.setBeneficiaryStatus(jsonObject.getString("beneficiaryStatus"));
//            iBaseMapper.updateByPrimaryKeySelective(kycSunrateBeneficiary);
//        }
//    }
}
