package com.js.pay.service.chinapnr.example;

import com.js.pay.service.chinapnr.example.utils.SignatureUtil;
import com.js.pay.service.chinapnr.example.utils.XMLUtil;
import common.util.httpclient.HttpRequestContext;
import common.util.httpclient.HttpSendResult;
import common.util.httpclient.impl.HttpClientServiceImpl;
import common.util.httpclient.impl.SimpleHttpsClientImpl;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import lombok.extern.slf4j.Slf4j;
import org.w3c.dom.Document;
import sun.misc.BASE64Encoder;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;

@Slf4j
public class ChinaPNRCommons {

    /**
     * 模版文件
     */
    private final static String tempaltefile = "request_sell_";
    //private final static String directorySignatureUrl = ChinaPNRCommons.getPropertiesParam("CHINA_PNRR_XML");

    /**
     * 模版文件配置
     */
    private static Configuration cfg = new Configuration();

    public static  String transferToXML(Map params, String TRXTYPE,String chinapnrrXml) {
        Template template = null;
        try {
            cfg.setObjectWrapper(new DefaultObjectWrapper());
            cfg.setDefaultEncoding("UTF-8");
            cfg.setTemplateUpdateDelay(0);
            cfg.setCacheStorage(new freemarker.cache.MruCacheStorage(5, 5));;
            cfg.setDirectoryForTemplateLoading(new File(chinapnrrXml));

            template = cfg.getTemplate(tempaltefile + TRXTYPE + ".ftl");
            StringWriter result = new StringWriter();
            template.process(params, result);

            return result.toString();

        } catch (Exception e) {
            log.error("transferToXML异常", e);
            return null;
        }

    }

    /**
     * 获取xml 文档
     * @param strs
     * @return
     */
    public static Document StringTOXml(String strs) {
        StringBuilder xml = new StringBuilder();
        xml.append(strs);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            InputStream is = new ByteArrayInputStream(xml.toString().getBytes("utf-8"));
            doc = dbf.newDocumentBuilder().parse(is);
            is.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    /**
     *
     * @param document
     * @return 某个节点的值 前提是需要知道xml格式，知道需要取的节点相对根节点所在位置
     */
    public static String getNodeValue(Document document, String nodePaht) {
        XPathFactory xpfactory = XPathFactory.newInstance();
        XPath path = xpfactory.newXPath();
        String servInitrBrch = "";
        try {
            servInitrBrch = path.evaluate(nodePaht, document);
        } catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return servInitrBrch;
    }

    /**
     * @return
     * @Description: 根据图片地址转换为base64编码字符串
     * @Author:
     * @CreateTime:
     */
    public static String getImageStr(String imgFile) {
        System.out.println("imgFile路径是：" + imgFile);
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        byte[] buffer = null;
        try {
            // 创建URL
            URL url = new URL(imgFile);
            // 创建链接
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            inputStream = conn.getInputStream();
            outputStream = new ByteArrayOutputStream();
            // 将内容读取内存中
            buffer = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
            buffer = outputStream.toByteArray();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (inputStream != null) {
                try {
                    // 关闭inputStream流
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    // 关闭outputStream流
                    outputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        // 对字节数组Base64编码
        return new BASE64Encoder().encode(buffer);
    }

    public static void main(String [] args){
        System.out.println(getImageStr("http://img3.cache.netease.com/photo/0001/2006-06-28/2KN0CGDJ00J60001.jpg"));
    }

    public static String appendParam(String returns, String paramId, String paramValue) {
        if (returns != "") {
            if (paramValue != "") {

                returns += "&" + paramId + "=" + paramValue;
            }

        } else {

            if (paramValue != "") {
                returns = paramId + "=" + paramValue;
            }
        }

        return returns;
    }


    /**
     * 把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
     *
     * @param params 需要排序并参与字符拼接的参数组
     * @return 拼接后字符串
     */
    public static String createLinkString(Map<String, String> params) {

        List<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); i++) {
            String key = keys.get(i);
            String value = params.get(key);
            if(key.equals("signMsg")){
                continue;
            }
            if (i == keys.size() - 1) {// 拼接时，不包括最后一个&字符
                prestr = prestr + key + "=" + value;
            } else {
                prestr = prestr + key + "=" + value + "&";
            }
        }
        return prestr;
    }

    /**
     * 把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
     *
     * @param params 需要排序并参与字符拼接的参数组
     * @return 拼接后字符串
     */
    public static String createQueryLinkString(Map<String, String> params) {

        List<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); i++) {
            String key = keys.get(i);
            String value = params.get(key);
            if(key.equals("signMsg")){
                continue;
            }
            if(key.equals("userId")){
                continue;
            }
            if (i == keys.size() - 1) {// 拼接时，不包括最后一个&字符
                prestr = prestr + key + "=" + value;
            } else {
                prestr = prestr + key + "=" + value + "&";
            }
        }
        return prestr;
    }

    /**
     * 解析responseBody
     * @param respTxt
     * @param targetKey
     * @return
     */
    public static  String getRespParam(String respTxt, String targetKey) {
        String[] splipArr = respTxt.split("&");
        try {
            for (String sep : splipArr) {
                String[] entryArr = sep.split("=");
                if (entryArr[0].equals(targetKey)) {
                    return entryArr[1];
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    /**
     * 回调参数转换Map
     * @param dataReceived
     * @return
     */
    public static Map<String,String> getCallbackMap(String dataReceived){
        Map<String,String> map = new HashMap();
        String[] param =  dataReceived.split("&");
        for(String keyvalue:param){
            String[] pair = keyvalue.split("=");
            if(pair.length==2){
                if(pair[0].equals("signMsg")){
                    String last = keyvalue.substring(keyvalue.length()-1,keyvalue.length());
                    if(last.equals("=")){
                        pair[1] = pair[1] + "=";
                    }
                }
                map.put(pair[0], pair[1]);
            }
        }
        return map;
    }

    /**
     * 获取汇付配置文件中配置信息
     * @param key
     * @return
     */
    public static String getPropertiesParam(String key){

        Properties properties = new Properties();
        // 使用ClassLoader加载properties配置文件生成对应的输入流
        InputStream in = ChinaPNRCommons.class.getClassLoader().getResourceAsStream("pay_config.properties");
        String value = null;
        try {
            // 使用properties对象加载输入流
            properties.load(in);
            //获取key对应的value值
            value = properties.getProperty(key).trim();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return value;
    }

    /**
     * 获取表头
     */
    public static Map<String,String> getTable(ChinaPnrConfigure chinaPnrConfigure){
        Map<String , String>  parameter = new HashMap<>();
        parameter.put("MERCHANTID", chinaPnrConfigure.getMerchantid());//商户号
        parameter.put("TERMINALID", chinaPnrConfigure.getTerminalid()); //终端号
        parameter.put("PRODUCTTYPE", chinaPnrConfigure.getProducttype());//产品类型
        parameter.put("VERSION",chinaPnrConfigure.getVersion());//接口版本
        return parameter;
    }

    /**
     * 处理汇付代发报文
     * @return
     */
    public static HttpSendResult getSubstituteXml(Map<String ,String> parameter, String url, String trxtype,ChinaPnrConfigure chinaPnrConfigure){
        HttpSendResult result = null;
        try {
            String requestXml = transferToXML(parameter, trxtype,chinaPnrConfigure.getChinapnrrXml());
            Document doc = XMLUtil.str2Doc(requestXml,"utf-8");
            SignatureUtil.xmlSignature(doc, chinaPnrConfigure.getEnvtype(), chinaPnrConfigure.getMerchantid()
                            .substring(0, chinaPnrConfigure.getMerchantid().length()-2),
                     chinaPnrConfigure.getPassword(),
                     chinaPnrConfigure.getAliasname(),chinaPnrConfigure.getChinapnrPfxUrl(),chinaPnrConfigure.getChinapnrPfx());
            requestXml = XMLUtil.doc2Str(doc,"utf-8");
            log.info("加密结果：" + requestXml);
            //创建context
            HttpRequestContext context = new HttpRequestContext();
            context.setUrl(url);
            context.setHttpMethod(HttpRequestContext.POST_METHOD);
            context.setRequestCharset("utf-8");
            context.setResponseCharset("utf-8");
            context.setXml(requestXml);
            HttpClientServiceImpl httpClient = new HttpClientServiceImpl();
            SimpleHttpsClientImpl shcic = new SimpleHttpsClientImpl();
            httpClient.setHttpsClient(shcic);
            result = httpClient.sendRequest(context);
            log.info("汇付代发请求返回信息:{}",result.getResponseBody());
        } catch (Exception e) {
            log.error("汇付代发请求异常",e);
        }
        return result;
    }

    /**
     * 回调成功后返回通知成功结果
     * DFHD:代发回调，JHHD：结汇回调
     * @return
     */
    public static String resultXml(String type,ChinaPnrConfigure chinaPnrConfigure){
        Map<String , String>  parameter = ChinaPNRCommons.getTable(chinaPnrConfigure);
        if(type.equals("DFHD")){
            parameter.put("TRXTYPE", chinaPnrConfigure.getTrxtypeDfhd()); //交易类别
        }else if(type.equals("JHHD")){
            parameter.put("TRXTYPE",chinaPnrConfigure.getTrxtypeJhhd()); //交易类别
        }
        parameter.put("RESULT", "000000");//接口版本

        String requestXml = transferToXML(parameter, chinaPnrConfigure.getTrxtypeDfhd(),chinaPnrConfigure.getChinapnrrXml());
        return requestXml;
    }

}
