package com.js.pay.mq;

import com.js.common.model.vo.KycNaturalVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;


/**
 * @Author yjzhao
 * @Description mq 发送
 * @Date 2019/3/1 14:39
 * @Param
 * @return
 **/
@Component
@Slf4j
public class RabbitMQSender {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Value("${spring.rabbitmq.exchange}")
    private String topicExchange;

    @Value("${spring.rabbitmq.routeKeyPay}")
    private String routeKeyPay;

    @Value("${spring.rabbitmq.routeKeyLoan}")
    private String routeKeyLoan;

    @Value("${spring.rabbitmq.queueNoticeBeneficiary}")
    private String queueNoticeBeneficiary;

    /**
     * @Author yjzhao
     * @Description mq test
     * @Date 2019/5/15 16:53
     * @Param [bidId]
     * @return void
     **/
    public void testSender(String testId, String test2Id) {
        log.info("com.js.loan.mq.RabbitMQSender.senderTest testId:{}, test2Id:{}", testId, test2Id);

        this.rabbitTemplate.convertAndSend(topicExchange,
                routeKeyPay,
                testId,
                new CorrelationData());

        this.rabbitTemplate.convertAndSend(topicExchange,
                routeKeyLoan,
                test2Id,
                new CorrelationData());
    }

    /**
     * @Author liuh
     * @Description 通知添加受益人信息
     * @Date 2019/7/14
     * topicExchange:交换机名称,
     * queueNoticeBeneficiary:路由关键字
     **/
    public void noticeToAddBeneficiary(KycNaturalVO kycNaturalVO) {
        log.info("推送rabbit通知添加受益人操作：{}", kycNaturalVO);
        this.rabbitTemplate.convertAndSend(topicExchange,
                queueNoticeBeneficiary,
                kycNaturalVO,
                new CorrelationData());
    }
}
