package com.js.pay.config;

import com.js.api.jspay.service.chinapnr.ChinaPNRTransactionDetailsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

/**
 * 定时任务配置
 */
@Slf4j
@Configuration
@EnableScheduling
public class TaskJobConfig {

    @Autowired
    private ChinaPNRTransactionDetailsService chinaPNRTransactionDetailsService;

    @Scheduled(cron = "0 30 14 * * ?")
    public void submitTransactionDetails() {
        log.info("submitTransactionDetails 一天一次start");
        try {
            chinaPNRTransactionDetailsService.submitTransactionDetails();
        }catch (Exception e){
            log.error(e.getMessage());
        }
//        log.info("submitTransactionDetails 一天一次");
    }

}
