package com.js.pay.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiKycSunrateService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ReqNoUtil;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.*;
import com.js.dal.dao.model.*;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.config.SunrateRasSignConfig;
import com.js.pay.config.SunrateSftpConfig;
import com.js.pay.service.JsFileForOSSSerivce;
import com.js.pay.service.KycSunrateService;
import com.js.pay.utils.SFTPUtil;
import com.js.pay.utils.SignatureUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.*;

/**
 * @Description: 与寻汇交互的具体实现
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiKycSunrateServiceImpl extends IBaseServiceImpl<KycSunrateRegister> implements ApiKycSunrateService, KycSunrateService {
    @Autowired
    SunrateSftpConfig sunrateSftpConfig;
    @Autowired
    SunrateRasSignConfig sunrateRasSignConfig;
    @Autowired
    KycCertiLinkFileMapper kycCertiLinkFileMapper;
    @Autowired
    JsFileForOSSSerivce jsFileForOSSSerivce;
    @Autowired
    KycSunrateStoreMapper kycSunrateStoreMapper;

    /**
     * @Description: 请求寻汇公共方法
     */
    @Override
    public ResponseMessage sendInfoToXh(String browserIP, String requestMethodO, String requestMethodT, Map<String,String> mapParams){
        HttpEntity entity = null;
        try {
            Map<String, String> mapRequest = new LinkedHashMap<>();
            mapRequest.put("apiUser", sunrateRasSignConfig.getApiuser());
            mapRequest.put("method", requestMethodO);
            mapRequest.put("reqSysId", sunrateRasSignConfig.getReqsysid());
            mapRequest.put("reqSysJnlNo", ReqNoUtil.getReqNo());
            mapRequest.put("ip", browserIP);
            mapRequest.put("version", sunrateRasSignConfig.getVersion());
            mapRequest.put("timestamp", DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss.SSS"));
            mapRequest.put("signType", sunrateRasSignConfig.getSigntype());
            mapRequest.put("reqBody", JSON.toJSONString(mapParams));
            //签名
            String sign = SignatureUtil.rsaSign(mapRequest, sunrateRasSignConfig.getPrivatekey());
            log.info("签名信息：{}",sign);
            HttpClient httpclient = HttpClientBuilder.create().build();
            URI uri = new URI(  sunrateRasSignConfig.getRequestpath() + requestMethodT);
            HttpPost httpPost = new HttpPost(uri);
            List<NameValuePair> list = new LinkedList<>();
            Set<String> keySet = mapRequest.keySet();
            for(String key : keySet){
                list.add(new BasicNameValuePair(key, mapRequest.get(key)));
            }
            list.add(new BasicNameValuePair("sign", sign));
            log.info("调用寻汇接口入参：{}",JSON.toJSONString(list));
            httpPost.setEntity(new UrlEncodedFormEntity(list,"UTF-8"));
            HttpResponse response = httpclient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            log.info("调用寻汇响应状态：{}" , statusCode);
            //获取返回
            entity = response.getEntity();
            BufferedReader in = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            log.info("调用寻汇响应结果：{}", buffer);
            JSONObject jsonObjectResult = JSON.parseObject(buffer.toString());
            String repCode = jsonObjectResult.getString("rspCode");
            if("000000".equals(repCode)){
                return ResultUtil.success(jsonObjectResult.get("rspBody"));
            }else{
               return ResultUtil.error(ResultEnum.ERROR.getCode(),jsonObjectResult.getString("rspInfo"));
            }
        }catch (Exception ex){
            log.error("请求寻汇接口异常", ex);
            return ResultUtil.success(ResultEnum.ERROR.getCode(),ResultEnum.ERROR.getMsg());
        }finally {
            try{
                EntityUtils.consume(entity);
            }catch (IOException ioe){
                log.error("关闭响应流异常", ioe);
                return ResultUtil.success(ResultEnum.ERROR.getCode(),ResultEnum.ERROR.getMsg());
            }
        }
    }

    /**
     * @author:liuh
     * @Descripiton:上传文件到寻汇sftp服务器上
     */
    @Override
    public ResponseMessage uploadFileToXH(String priId){
        log.info("调用寻汇sftp上传文件开始");
        String remotePath = "/INPUT/JSTRANSFER/" + DateUtil.format(new Date(), "yyyyMMdd") + "/";
        InputStream inputStream = null;
        try {
            KycCertiLinkFile kycCertiLinkFileQuery = new KycCertiLinkFile();
            kycCertiLinkFileQuery.setPriId(priId);
            kycCertiLinkFileQuery.setDelFlag(false);
            List<KycCertiLinkFile> kycCertiLinkFileList = kycCertiLinkFileMapper.select(kycCertiLinkFileQuery);

            SFTPUtil sftpUtil = new SFTPUtil(sunrateSftpConfig.getSftphost(), sunrateSftpConfig.getSftpport(), sunrateSftpConfig.getSftpusername(), sunrateSftpConfig.getSftppassword());
            for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
                if(null != kycCertiLinkFile.getUploadSftpFlag() && kycCertiLinkFile.getUploadSftpFlag()){
                    continue;
                }
                inputStream = jsFileForOSSSerivce.findFile(kycCertiLinkFile.getFileSavePath());
                sftpUtil.putSingle(inputStream,remotePath,kycCertiLinkFile.getFileSaveName());
//                sftpUtil.putSingle("C:\\Users\\EDZ\\Desktop\\微信图片_20190525160609.png",remotePath,kycCertiLinkFile.getFileSaveName());
                IOUtils.closeQuietly(inputStream);
                log.info("已上传文件名：{}",kycCertiLinkFile.getFileSaveName());
                kycCertiLinkFile.setUploadSftpFlag(true);
                kycCertiLinkFile.setUploadDirc(remotePath);
                kycCertiLinkFileMapper.updateByPrimaryKey(kycCertiLinkFile);
            }
            sftpUtil.releaseConnection();
        }catch (Exception ex){
            log.error("上传sftp服务器异常", ex);
            ResultUtil.error(ResultEnum.ERROR.getCode(), ResultEnum.ERROR.getMsg());
        }finally {
            IOUtils.closeQuietly(inputStream);
        }
        log.info("调用寻汇sftp上传文件结束存储路径：{}",remotePath);
        return ResultUtil.success(remotePath);
    }
}
