package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.ApiKycHolderPersonalService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycHolderPersonalReq;
import com.js.common.model.vo.KycHolderVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.KycCertiLinkFileMapper;
import com.js.dal.dao.mapper.KycHolderPersonalMapper;
import com.js.dal.dao.model.KycHolderPersonal;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycCertiLinkFileService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:持有人（大陆个人，香港个人）操作服务接口
 * @Author: liuh
 * @Create: 2019-05-23
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiKycHolderPersonalServiceImpl extends IBaseServiceImpl<KycHolderPersonal> implements ApiKycHolderPersonalService {
    @Autowired
    KycHolderPersonalMapper kycHolderPersonalMapper;
    @Autowired
    KycCertiLinkFileMapper kycCertiLinkFileMapper;
    @Autowired
    KycCertiLinkFileService kycCertiLinkFileService;

    @Override
    public List<KycHolderVO> holderPersonalList(String holderName,KycNaturalVO kycNaturalVO) {
        log.info("持有人-个人查询开始 -> 当前登录用户ID：{}",kycNaturalVO.getId());
        KycHolderPersonal kycHolderPersonalQuery = new KycHolderPersonal();
        kycHolderPersonalQuery.setCreateId(kycNaturalVO.getId());
        if(StringUtils.isNotBlank(holderName)){
            kycHolderPersonalQuery.setCusName(holderName);
        }
        List<KycHolderPersonal> kycHolderPersonalList = kycHolderPersonalMapper.select(kycHolderPersonalQuery);
        List<KycHolderVO> kycHolderVOList = new ArrayList<>();
        for(KycHolderPersonal kycHolderPersonal : kycHolderPersonalList){
            kycHolderVOList.add(ConvertToKycHolderVO(kycHolderPersonal));
        }
        log.info("持有人-个人查询结束");
        return kycHolderVOList;
    }

    @Override
    public ResponseMessage holderPersonalAdd(KycHolderPersonalReq kycHolderPersonalReq, KycNaturalVO kycNaturalVO) {
        KycHolderPersonal kycHolderPersonal = new KycHolderPersonal();
        BeanUtils.copyProperties(kycHolderPersonalReq,kycHolderPersonal);

        kycHolderPersonal.setId(IdUtil.simpleUUID());
        kycHolderPersonal.setKycNaturalId(kycNaturalVO.getId());
        kycHolderPersonal.setCreateId(kycNaturalVO.getId());
        kycHolderPersonal.setCreateName(kycNaturalVO.getCertificationName());

//        kycCertiLinkFileMapper.insertList(kycCertiLinkFileService.ConvertToKycCertiLinkFile(kycHolderPersonal.getId(),kycNaturalVO,kycHolderPersonalReq.getFileReqList()));
        kycHolderPersonalMapper.insertSelective(kycHolderPersonal);
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }

    private KycHolderVO ConvertToKycHolderVO(KycHolderPersonal kycHolderPersonal) {
        KycHolderVO kycHolderVO = new KycHolderVO();
        kycHolderVO.setHolderId(kycHolderPersonal.getId());
        kycHolderVO.setHolderName(kycHolderPersonal.getCusName());
        kycHolderVO.setHolderType(kycHolderPersonal.getHolderType());
        return kycHolderVO;
    }
}
