package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiJsUserTreatyService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.JsUserTreaty;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiJsUserTreatyServiceImpl extends IBaseServiceImpl<JsUserTreaty> implements ApiJsUserTreatyService {

    @Override
    public ResponseMessage queryTreaty(String kycNaturalId, String tradeSubType) {
        boolean showStatus = false;
        Example example = new Example(JsUserTreaty.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId", kycNaturalId);
        criteria.andEqualTo("tradeSubType",tradeSubType);
        List<JsUserTreaty> jsUserTreatys = iBaseMapper.selectByExample(example);
        if (jsUserTreatys.size() == 0) {
            showStatus = true;
        }
        return ResultUtil.success(showStatus,ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage submitTreaty(String kycNaturalId, String tradeSubType) {
        log.info("协议展示修改为下次不展示，kycNaturalId="+kycNaturalId +",业务类型为："+ tradeSubType);
        try{
            JsUserTreaty jsUserTreaty = new JsUserTreaty();
            jsUserTreaty.setKycNaturalId(kycNaturalId);
            jsUserTreaty.setTradeSubType(tradeSubType);
            iBaseMapper.insertSelective(jsUserTreaty);
        }catch (Exception  e){
            log.error(kycNaturalId + "协议展示修改失败："+ e.getMessage());
            return ResultUtil.error(ResultEnum.SAVE_ERROR);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
