package com.js.pay.service.chinapnr.example;

import com.js.pay.service.chinapnr.example.utils.SignatureUtil;
import com.js.pay.service.chinapnr.example.utils.XMLSecurityProcess;
import com.js.pay.service.chinapnr.example.utils.XMLUtil;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import common.util.httpclient.HttpRequestContext;
import common.util.httpclient.HttpSendResult;
import common.util.httpclient.impl.HttpClientServiceImpl;
import common.util.httpclient.impl.SimpleHttpsClientImpl;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class chinaPNRTest {

    /**
     * 模版文件
     */
    private static String tempaltefile = "request_sell_";

    private static String chinapnrPfxUrl = "d:/fct/";
    private static String chinapnrPfx = "d:/fct/10006050001.pfx";
    private static String chinapnrCer = "D:/fct/ChinaPnR.rsa.cer";

    /**
     * 模版文件配置
     */
    private static Configuration cfg = new Configuration();
    //测试环境
    private static String postUrl = "https://hfgj.chinapnr.com/pay/receivesell.htm";

    public static  void main(String [] args){

        Map<String, String> parameter = new HashMap<>();

        //商户号
        parameter.put("MERCHANTID","1000605000101");
        //终端号
        parameter.put("TERMINALID","0010001");
        //产品类型
        parameter.put("PRODUCTTYPE","JH");
        //接口版本
        parameter.put("VERSION","1.0");
        //交易类别
        parameter.put("TRXTYPE","100040");

        parameter.put("BATCH_NO","61204022399");
        parameter.put("REQTIME","20190612154301");
        parameter.put("PAY_CUR","CNY");
        parameter.put("PAY_TCNT", "1");
        parameter.put("PAY_TAMT","1000");

        parameter.put("PURPOSE","test");
        parameter.put("EXT1","EXT1");
        parameter.put("EXT2","EXT1");
        parameter.put("RESULT_URL","http://114.55.171.170:9010/api/v1/anon/substitute/oldCallback");
        //parameter.put("DETAILS","e36278f8745d476e88def76a923da321|20||H|30000142|朱义伟|00|321281199302133913|上海|上海市|上海市支行|用途|T100040|ext1|ext2\r\n92acd36aacbf4f2c54e5202aa49f90b1|1||H|30000142|朱义伟|00|321281199302133913|上海|上海市|上海市支行|用途|T100040|ext1|ext2\r\n8a75a4ebb3cd429a55397de8635da2f1|6||H|30000142|朱义伟|00|321281199302133913|上海|上海市|上海市支行|用途|T100040|ext1|ext2");
//       parameter.put("DETAILS","2ec4a35a334f455a94e9a58e71082107|46||H|30000165|王文斌|00|321281199302133913|上海|上海市|上海市支行|用途|T100040|ext1|ext2\n" +
//               "2383ec60bfad49bdbf0f525346f44ab4|111||H|30000165|王文斌|00|321281199302133913|上海|上海市|上海市支行|用途|T100040|ext1|ext2\n" +
//               "2ea7232b826f4c5f81c5b1835040e314|15712|CMB|C|4682037906128888|王文斌|00|411081199004235955|上海|上海市|上海市支行|用途|T100040|ext1|ext2");
  //      parameter.put("DETAILS","9475a4ebb3cd429a95396re56358a3fw|1000|CMB|P|6465767887999|张三|00|342501198888434344|上海|上海市|上海市支行|用途|T100040|ext1|ext2");
        parameter.put("DETAILS","9479a4ebb3cw429a95396re56358a333|1000|CMB|P|4682037906128888|王文斌|00|411081199004235955|上海|上海市|上海市支行|用途|T100040|ext1|ext2");

        chinaPNRTest test = new chinaPNRTest();
        String requestXml = test.transferToXML(parameter, parameter.get("TRXTYPE").toString());
        System.out.println(requestXml);

        Document doc = XMLUtil.str2Doc(requestXml,"utf-8");

        String merchantAcctId = parameter.get("MERCHANTID").toString();
        String envType = "stage2";
        String password = "123456";
        String aliasName = "test-alias";
        System.out.println("doc="+doc.toString());
        System.out.println(merchantAcctId);
        System.out.println(envType);
        System.out.println(password);
        System.out.println(aliasName);
        try {
            SignatureUtil.xmlSignature(doc, envType, merchantAcctId.substring(0,merchantAcctId.length()-2),
                    password, aliasName,chinapnrPfxUrl,chinapnrPfx);
        } catch (Exception e) {
            e.printStackTrace();
        }

        requestXml = XMLUtil.doc2Str(doc,"utf-8");
        System.out.println("requestXml:" + requestXml);

        HttpRequestContext context = new HttpRequestContext();
        context.setUrl(postUrl);
        context.setHttpMethod(HttpRequestContext.POST_METHOD);
        context.setResponseCharset("utf-8");
        context.setRequestCharset("utf-8");
        context.setXml(requestXml);
        HttpSendResult result = null;
        HttpClientServiceImpl httpClient = new HttpClientServiceImpl();
        SimpleHttpsClientImpl shci = new SimpleHttpsClientImpl();
        httpClient.setHttpsClient(shci);
        try {
            result = httpClient.sendRequest(context);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        String respTxt = null;
        if (null ==  result) {
            respTxt = "网关系统异常------";
        }else{
            System.out.println("result:" + result.getResponseBody());


            if(result.getStatus() == 200){
                respTxt = result.getResponseBody();
            }else{
                respTxt = "网关系统异常,状态码[" + result.getStatus() + "]";
            }
        }

        Document resDoc = null;
        try{
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(respTxt.getBytes("UTF-8"))));
            // 解析XML文档
            resDoc = parser.getDocument();

        }catch (Exception e){

        }

//        Document resDoc = StringTOXml(respTxt);


        boolean falg = false;
        try{
            falg = XMLSecurityProcess.veryfySignature(resDoc,chinapnrCer);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        if (falg){
            System.out.println("返回结果验签成功");
        }else{
            System.out.println("返回结果验签失败");
        }
        String nodePath = "/RESPONSE/PARAMS/STATUS";
        String nodePath2 = "/RESPONSE/PARAMS/STATUS2";
        String nodeValue = getNodeValue(resDoc, nodePath);
        String nodeValue2 = getNodeValue(resDoc, nodePath2);
        System.out.println("nodeValue= " + nodeValue);
        System.out.println("nodeValue2= " + nodeValue2);

//        HttpSendResult result = ChinaPNRCommons.getSubstituteXml(parameter,
//                ChinaPNRCommons.getPropertiesParam("CHINA_PNR_POSTURL"),
//                ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TRXTYPE_DF"));
//
//        System.out.println(result.getResponseBody());

    }

    public  String transferToXML(Map params, String TRXTYPE) {
        Template template = null;
        try {
            cfg.setObjectWrapper(new DefaultObjectWrapper());
            cfg.setDefaultEncoding( "UTF-8" );
            cfg.setTemplateUpdateDelay(0);
            cfg.setCacheStorage(new freemarker.cache.MruCacheStorage(5, 5));
            //cfg.setTemplateLoader(new ClassTemplateLoader(
                   // RequestHppController.class, "/ftl"));
            cfg.setDirectoryForTemplateLoading(new File("d:/ftl"));

            template = cfg.getTemplate(tempaltefile + TRXTYPE + ".ftl");
            StringWriter result = new StringWriter();
            template.process(params, result);


            return result.toString();

        } catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }

    }

    public static Document StringTOXml(String str) {

        StringBuilder sXML = new StringBuilder();
        sXML.append(str);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            InputStream is = new ByteArrayInputStream(sXML.toString().getBytes("utf-8"));
            doc = dbf.newDocumentBuilder().parse(is);
            is.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    /**
     *
     * @param document
     * @return 某个节点的值 前提是需要知道xml格式，知道需要取的节点相对根节点所在位置
     */
    public static String getNodeValue(Document document, String nodePaht) {
        XPathFactory xpfactory = XPathFactory.newInstance();
        XPath path = xpfactory.newXPath();
        String servInitrBrch = "";
        try {
            servInitrBrch = path.evaluate(nodePaht, document);
        } catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return servInitrBrch;
    }
}
