package com.js.pay.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiKycCertiLinkFileService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiKycSunrateService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycCertiLinkFileVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycPasswordVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.RandomUtil;
import com.js.common.util.RedisUtil;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.KycPasswordMapper;
import com.js.dal.dao.model.*;
import com.js.dal.dao.plugin.PageModel;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.mq.RabbitMQSender;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName: ApiKycNaturalServiceImpl
 * @Description: KycNaturalService具体实现
 * @Author: yjzhao
 * @Create: 2019-05-16  10:19
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiKycNaturalServiceImpl extends IBaseServiceImpl<KycNatural> implements ApiKycNaturalService {
    @Autowired
    KycPasswordMapper kycPasswordMapper;
    @Autowired
    APIKycPassWordServiceImpl apiKycPassWordServiceImpl;
    @Autowired
    RabbitMQSender rabbitMQSender;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    ApiKycCertiMainLandCompanyServiceImpl apiKycCertiMainLandCompanyServiceImpl;
    @Autowired
    ApiKycCertiMainLandPersonalServiceImpl apiKycCertiMainLandPersonalServiceImpl;
    @Autowired
    ApiKycCertiHKPersonalServiceImpl apiKycCertiHKPersonalServiceImpl;
    @Autowired
    ApiKycCertiHKCompanyServiceImpl apiKycCertiHKCompanyServiceImpl;
    @Autowired
    ApiKycCertiLinkFileService apiKycCertiLinkFileService;
    @Autowired
    ApiKycSunrateService apiKycSunrateService;
    @Autowired
    ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    ApiSunrateRegisterServiceImpl apiSunrateRegisterServiceImpl;

    @Override
    public Integer verifyEmailExists(String email) {
        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("email",email);
        criteria.andEqualTo("delFlag", false);
        return iBaseMapper.selectCountByExample(example);
    }

    @Override
    public Integer verifyMobileExists(String phoneNo) {
        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("phoneNo",phoneNo);
        criteria.andEqualTo("delFlag", false);
        return iBaseMapper.selectCountByExample(example);

    }

    @Override
    public ResponseMessage register(RegiserKycNaturalReq regiserKycNaturalReq) {
        //注册用户
        KycNatural kycNatural = new KycNatural();
        kycNatural.setEmail(regiserKycNaturalReq.getEmail());
        kycNatural.setPhoneNo(regiserKycNaturalReq.getPhoneNo());
        if(StringUtils.isNotBlank(regiserKycNaturalReq.getInviteCode())){
            kycNatural.setInviteCode(regiserKycNaturalReq.getInviteCode());
        }
        this.insertSelective(kycNatural);
        
        System.out.println("-----------sys.out.println-----------kycNatural.getId()值=" + kycNatural.getId() + "," + "当前类=ApiKycNaturalServiceImpl.register()");
        
        KycPassword kycPassword = new KycPassword();
        kycPassword.setKycNaturalId(kycNatural.getId());
        kycPassword.setPasswordLogin(regiserKycNaturalReq.getPassword());
        apiKycPassWordServiceImpl.insertSelective(kycPassword);
        return ResultUtil.success(ResultEnum.REGISTE_SUCCESS.getCode(), ResultEnum.REGISTE_SUCCESS.getMsg());
    }

    @Override
    public KycNaturalVO findKycNaturalVOByPhoneNo(String phoneNo) {
        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("phoneNo",phoneNo);
        criteria.andEqualTo("delFlag", false);
        List<KycNatural> kycNaturalList = iBaseMapper.selectByExample(example);
        if (kycNaturalList.size() != 1) {
            //如果大于1条则通知
            return null;
        }

        KycNatural kycNatural = kycNaturalList.get(0);

        return ConvertToKycNaturalVO(kycNatural);
    }

    @Override
    public KycNaturalVO findKycNaturalVOByEmail(String email) {

        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("email",email);
        criteria.andEqualTo("delFlag", false);
        List<KycNatural> kycNaturalList = iBaseMapper.selectByExample(example);

        if (kycNaturalList.size() != 1) {
            //如果大于1条则通知
            return null;
        }

        KycNatural kycNatural = kycNaturalList.get(0);
        return ConvertToKycNaturalVO(kycNatural);
    }

    @Override
    public KycPasswordVO findKycPwdVOByPhoneNo(String phoneNo) {
        KycPassword kycPassword = kycPasswordMapper.selectByPhoneNo(phoneNo);
        if (kycPassword != null) {
            return ConvertToKycPasswordVO(kycPassword);
        }
        return null;
    }

    @Override
    public KycPasswordVO findKycPwdVOByEmail(String email) {
        KycPassword kycPassword = kycPasswordMapper.selectByEmail(email);
        if (kycPassword != null) {
            return ConvertToKycPasswordVO(kycPassword);
        }
        return null;
    }

    @Override
    public ResponseMessage findKycNaturalVOForLogin(String phoneNo, String password) {
        //判断是邮箱还是手机号的正则表达式
        KycPasswordVO kycPasswordVO= null;
        if(Validator.isMobile(phoneNo)){
            kycPasswordVO = this.findKycPwdVOByPhoneNo(phoneNo);
        } else if (Validator.isEmail(phoneNo)){
            kycPasswordVO = this.findKycPwdVOByEmail(phoneNo);
        } else {
            //暂不支持其他类型登陆
            return ResultUtil.error(ResultEnum.LOGIN_ERROR.getCode(), ResultEnum.LOGIN_ERROR.getMsg() + ", 请确认登陆账号正确.");
        }
        //根据手机号码获取用户信息
        if (kycPasswordVO == null) {
            return ResultUtil.error(ResultEnum.LOGIN_ERROR.getCode(), ResultEnum.LOGIN_ERROR.getMsg() + ", 请确认登陆账号正确.");
        }
        //查找当前用户登入前登录错误次数，如果超过最大次数则锁定一小时
        String userErrorCountString = redisUtil.get(Constant.REDIS_JS_WEB_USER + phoneNo);
        int userErrorCountInteger = StringUtils.isBlank(userErrorCountString) ? 0 : Integer.valueOf(userErrorCountString);
        if(userErrorCountInteger >= Constant.ERROR_MAX_COUNT){
            Long ttlTime = redisUtil.ttl(Constant.REDIS_JS_WEB_USER + phoneNo,Constant.REDIS_DATABASE);
            return ResultUtil.error(ResultEnum.USER_DISABLE.getCode(), ResultEnum.USER_DISABLE.getMsg() + ", 请 " + ttlTime/60 + " 分钟后重新登录.");
        }
        //校验密码是否正确
        //校验密码
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        if (!encoder.matches(password, kycPasswordVO.getPasswordLogin())) {
            userErrorCountInteger = userErrorCountInteger + 1;
            if(userErrorCountInteger == Constant.ERROR_MAX_COUNT){
                redisUtil.setex(Constant.REDIS_JS_WEB_USER + phoneNo,Constant.LOGIN_TIMEOUT,String.valueOf(userErrorCountInteger));
                return ResultUtil.error(ResultEnum.USER_DISABLE.getCode(), ResultEnum.USER_DISABLE.getMsg() + ", 请在一小时后重新登录.");
            }else{
                redisUtil.set(Constant.REDIS_JS_WEB_USER + phoneNo,String.valueOf(userErrorCountInteger),Constant.REDIS_DATABASE);
                return ResultUtil.error(ResultEnum.LOGIN_ERROR.getCode(),ResultEnum.LOGIN_ERROR.getMsg() + ", 请确认登陆密码正确.");
            }
        }

        //获取用户信息
        KycNaturalVO kycNaturalVO = null;
        if(Validator.isMobile(phoneNo)){
            kycNaturalVO = this.findKycNaturalVOByPhoneNo(phoneNo);
        } else if (Validator.isEmail(phoneNo)){
            kycNaturalVO = this.findKycNaturalVOByEmail(phoneNo);
        }
        if (kycNaturalVO == null) {
            return ResultUtil.error(ResultEnum.LOGIN_ERROR.getCode(),ResultEnum.LOGIN_ERROR.getMsg() + ", 请确认登陆账号有效.");
        }
        //如果登录成功，则删除登录错误次数计数
        redisUtil.del(Constant.REDIS_JS_WEB_USER + phoneNo);
        return ResultUtil.success(kycNaturalVO, ResultEnum.LOGIN_SUCCESS);
    }

    @Override
    public ResponseMessage changePwd(ChPwdReq chPwdReq) {
        return apiKycPassWordServiceImpl.changePwd(chPwdReq);
    }

    @Override
    public int updateKycNatural(KycNaturalReq kycNaturalReq) {
        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", kycNaturalReq.getId());
        criteria.andEqualTo("delFlag", false);

        KycNatural kycNatural = new KycNatural();
        if (kycNaturalReq.getEmailActiveFlag() != null) {
            kycNatural.setEmailActiveFlag(kycNaturalReq.getEmailActiveFlag());
        }
        if (StringUtils.isNotBlank(kycNaturalReq.getEmail())) {
            kycNatural.setEmail(kycNaturalReq.getEmail());
        }
        if(null != kycNaturalReq.getCertificationStatus()){
            kycNatural.setCertificationStatus(kycNaturalReq.getCertificationStatus());
        }
        if(null != kycNaturalReq.getRegisterType()){
            kycNatural.setRegisterType(kycNaturalReq.getRegisterType().name());
        }
        if(StringUtils.isNotBlank(kycNaturalReq.getCertificationName())){
            kycNatural.setCertificationName(kycNaturalReq.getCertificationName());
        }
        if (ObjectUtil.isNotEmpty(kycNaturalReq.getRecordFlag())) {
            kycNatural.setRecordFlag(kycNaturalReq.getRecordFlag());
        }
        if (ObjectUtil.isNotEmpty(kycNaturalReq.getPhoneNo())) {
            kycNatural.setPhoneNo(kycNaturalReq.getPhoneNo());
        }
        if (ObjectUtil.isNotEmpty(kycNaturalReq.getInviteCode())) {
            kycNatural.setInviteCode(kycNaturalReq.getInviteCode());
        }
        if(ObjectUtil.isNotEmpty(kycNaturalReq.getIdNo())){
            kycNatural.setIdNo(kycNaturalReq.getIdNo());
        }
        if(ObjectUtil.isNotEmpty(kycNaturalReq.getJsRemark())){
            kycNatural.setJsRemark(kycNaturalReq.getJsRemark());
        }
        if(ObjectUtil.isNotEmpty(kycNaturalReq.getSex())){
            kycNatural.setSex(kycNaturalReq.getSex());
        }
        int updateCount = updateByExampleSelective(kycNatural, example);
        log.info("更新用户信息条数：{}",updateCount);

        Long ttlTime = redisUtil.ttl(Constant.REDIS_JS_WEB_USER + kycNaturalReq.getId(),Constant.REDIS_DATABASE);
        log.info("用户失效剩余时间：{} 秒",ttlTime);
        if(ttlTime > 0){
            KycNatural kycNaturalSel = iBaseMapper.selectByPrimaryKey(kycNaturalReq.getId());
            KycNaturalVO kycNaturalVO = ConvertToKycNaturalVO(kycNaturalSel);
            String kycNaturalVOStr =  JSON.toJSONString(kycNaturalVO);
            redisUtil.setex(Constant.REDIS_JS_WEB_USER + kycNaturalVO.getId(), Integer.parseInt(ttlTime.toString()), kycNaturalVOStr);
        }
        return updateCount;
    }

    private KycPasswordVO ConvertToKycPasswordVO(KycPassword kycPassword) {
        KycPasswordVO kycPasswordVO = new KycPasswordVO();
        kycPasswordVO.setPasswordLogin(kycPassword.getPasswordLogin());
        kycPasswordVO.setPasswordPay(kycPassword.getPasswordPay());
        return  kycPasswordVO;
    }

    private KycNaturalVO ConvertToKycNaturalVO(KycNatural kycNatural) {
        KycNaturalVO kycNaturalVO = new KycNaturalVO();
        kycNaturalVO.setId(kycNatural.getId());
        kycNaturalVO.setCertificationName(kycNatural.getCertificationName());
        kycNaturalVO.setIdNo(kycNatural.getIdNo());
        kycNaturalVO.setCreateDts(kycNatural.getCreateDts());
        kycNaturalVO.setCreateId(kycNatural.getCreateId());
        kycNaturalVO.setEmail(kycNatural.getEmail());
        kycNaturalVO.setCertificationStatus(kycNatural.getCertificationStatus());
        kycNaturalVO.setEmailActiveFlag(kycNatural.getEmailActiveFlag());
        kycNaturalVO.setInviteCode(kycNatural.getInviteCode());
        kycNaturalVO.setJsRemark(kycNatural.getJsRemark());
        kycNaturalVO.setPhoneNo(kycNatural.getPhoneNo());
        kycNaturalVO.setRegisterType(RegisterType.valueOf(kycNatural.getRegisterType()));
        kycNaturalVO.setUpdateDts(kycNatural.getUpdateDts());
        kycNaturalVO.setUpdateId(kycNatural.getUpdateId());
        kycNaturalVO.setRecordFlag(kycNatural.getRecordFlag());
        return kycNaturalVO;
    }

    @Override
    public String getKycNaturalList(KycNaturalListReq kycNaturalListReq) {
        PageModel pageModel = new PageModel();
        Example example = new Example(KycNatural.class);
        example.setOrderByClause("update_dts desc");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        if (ObjectUtil.isNotEmpty(kycNaturalListReq.getCertificationName())) {
            criteria.andLike("certificationName", "%" + kycNaturalListReq.getCertificationName() + "%");
        }
        if (ObjectUtil.isNotEmpty(kycNaturalListReq.getPhoneNo())) {
            criteria.andLike("phoneNo", "%" + kycNaturalListReq.getPhoneNo() + "%");
        }
        if (ObjectUtil.isNotEmpty(kycNaturalListReq.getCertificationStatus())) {
            criteria.andEqualTo("certificationStatus", kycNaturalListReq.getCertificationStatus().name());
        }
        PageHelper.startPage(kycNaturalListReq.getPageIndex(), kycNaturalListReq.getPageSize());
        List<KycNatural> kycNaturals = iBaseMapper.selectByExample(example);
        PageInfo<KycNatural> pageInfo = new PageInfo<>(kycNaturals);

        long count = pageInfo.getTotal();
        if(count <= 0) {
            pageModel.setMsg("暂无数据");
            return JSON.toJSONString(pageModel);
        }
        if(!ObjectUtil.isEmpty(kycNaturals)) {
            JSONArray array = new JSONArray();
            for(KycNatural kycNatural : kycNaturals) {
                JSONObject object = (JSONObject) JSONObject.toJSON(kycNatural);
                object.put("createTime", DateUtil.format(kycNatural.getCreateDts(), "yyyy-MM-dd HH:mm:ss"));
                object.put("certificationStatusDesc",kycNatural.getCertificationStatus().getDoDesc() + "-" + kycNatural.getCertificationStatus().getToDesc());
                array.add(object);
            }
            pageModel.setList(array);
        }
        pageModel.setCount(new Integer((int)count));
        pageModel.setMsg("ok");
        pageModel.setRel(true);
        return JSON.toJSONString(pageModel);
    }

    @Override
    public KycNaturalVO getKycNaturaById(String id) {
        if (ObjectUtil.isEmpty(id)) {
            return null;
        } else {
            KycNaturalVO kycNaturalVO = new KycNaturalVO();
            KycNatural kycNatural = iBaseMapper.selectByPrimaryKey(id);
            BeanUtil.copyProperties(kycNatural, kycNaturalVO);
            return kycNaturalVO;
        }
    }

    @Override
    public int deleteKycNaturaById(String id) {
        KycNatural kycNatural = new KycNatural();
        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", id);
        kycNatural.setDelFlag(true);
        return updateByExampleSelective(kycNatural, example);
    }

    @Override
    public ResponseMessage auditKycNatural(KycNaturalReq kycNaturalReq) {
        String priId = "";
        KycSunrateRegisterReq kycSunrateRegisterReq = null;
        RegisterType registerType = kycNaturalReq.getRegisterType();
        String registerTypeDesc = registerType.getEnumName();
        log.info("注册类型：{},{}",registerType,registerTypeDesc);
        if(RegisterType.MAINLAND_PERSONAL.equals(registerType)){
            KycCertiMainLandPersonal kycCertiMainLandPersonalQuery = new KycCertiMainLandPersonal();
            kycCertiMainLandPersonalQuery.setKycNaturalId(kycNaturalReq.getId());
            kycCertiMainLandPersonalQuery.setDelFlag(false);
            KycCertiMainLandPersonal kycCertiMainLandPersonal = apiKycCertiMainLandPersonalServiceImpl.getiBaseMapper().selectOne(kycCertiMainLandPersonalQuery);
            if(null == kycCertiMainLandPersonal){
                log.error("未查询到大陆个人实名信息：{}",JSON.toJSONString(kycCertiMainLandPersonalQuery));
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            priId = kycCertiMainLandPersonal.getId();
            kycSunrateRegisterReq = convertByKycCertiMainLandPersonal(kycCertiMainLandPersonal);
        }else if(RegisterType.MAINLAND_COMPANY.equals(registerType)){
            KycCertiMainLandCompany kycCertiMainLandCompanyQuery = new KycCertiMainLandCompany();
            kycCertiMainLandCompanyQuery.setKycNaturalId(kycNaturalReq.getId());
            kycCertiMainLandCompanyQuery.setDelFlag(false);
            KycCertiMainLandCompany kycCertiMainLandCompany = apiKycCertiMainLandCompanyServiceImpl.getiBaseMapper().selectOne(kycCertiMainLandCompanyQuery);
            if(null == kycCertiMainLandCompany){
                log.error("未查询到大陆企业实名信息：{}",JSON.toJSONString(kycCertiMainLandCompanyQuery));
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            priId = kycCertiMainLandCompany.getId();
            kycSunrateRegisterReq = convertByKycCertiMainLandCompany(kycCertiMainLandCompany);
        }else if(RegisterType.HK_PERSONAL.equals(registerType)){
            KycCertiHKPersonal kycCertiHKPersonalQuery = new KycCertiHKPersonal();
            kycCertiHKPersonalQuery.setKycNaturalId(kycNaturalReq.getId());
            kycCertiHKPersonalQuery.setDelFlag(false);
            KycCertiHKPersonal kycCertiHKPersonal = apiKycCertiHKPersonalServiceImpl.getiBaseMapper().selectOne(kycCertiHKPersonalQuery);
            if(null == kycCertiHKPersonal){
                log.error("未查询到香港个人实名信息：{}",JSON.toJSONString(kycCertiHKPersonal));
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            priId = kycCertiHKPersonal.getId();
            kycSunrateRegisterReq = convertByKycCertiHKPersonal(kycCertiHKPersonal);
        }else if(RegisterType.HK_COMPANY.equals(registerType)){
            KycCertiHKCompany kycCertiHKCompanyQuery = new KycCertiHKCompany();
            kycCertiHKCompanyQuery.setKycNaturalId(kycNaturalReq.getId());
            kycCertiHKCompanyQuery.setDelFlag(false);
            KycCertiHKCompany kycCertiHKCompany = apiKycCertiHKCompanyServiceImpl.getiBaseMapper().selectOne(kycCertiHKCompanyQuery);
            if(null == kycCertiHKCompany){
                log.error("未查询到香港企业实名信息：{}",JSON.toJSONString(kycCertiHKCompany));
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            priId = kycCertiHKCompany.getId();
            kycSunrateRegisterReq = convertByKycCertiHKCompany(kycCertiHKCompany);
        }else{
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
        List<KycCertiLinkFileVO> certiFileList = apiKycCertiLinkFileService.findCertiFileList(priId);
        if(CollectionUtils.isEmpty(certiFileList)){
            log.error("附件不存在：{}",priId);
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST.getCode(),ResultEnum.MESSAGE_NOT_EXIST.getMsg() + ",附件不存在请确认");
        }
        KycNatural kycNaturalSel = iBaseMapper.selectByPrimaryKey(kycNaturalReq.getId());
        String randomPhone = "";
        try {
            randomPhone =  kycNaturalSel.getPhoneNo().substring(0, 3) + RandomUtil.createID(8);
        }catch (Exception ex){
            randomPhone = kycNaturalSel.getPhoneNo();
            log.error("随机生成8位数异常", ex);
        }
        kycSunrateRegisterReq.setRegisterEmail(kycNaturalSel.getEmail());
        kycSunrateRegisterReq.setRegisterMobile(randomPhone);
        KycSunrateRegister kycSunrateRegisterQuery = new KycSunrateRegister();
        kycSunrateRegisterQuery.setOrgCode(kycSunrateRegisterReq.getOrgCode());
        KycSunrateRegister kycSunrateRegister = apiSunrateRegisterServiceImpl.getiBaseMapper().selectOne(kycSunrateRegisterQuery);
        if(null != kycSunrateRegister){
            log.error("该用户已在寻汇注册orgCode：{}",kycSunrateRegisterReq.getOrgCode());
            return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(),ResultEnum.MESSAGE_EXIST.getMsg() + ",该用户寻汇已注册过,请确认");
        }
        KycSunrateRegister kycSunrateRegisterQueryPhone = new KycSunrateRegister();
        kycSunrateRegisterQueryPhone.setOrgCode(kycSunrateRegisterReq.getOrgCode());
        kycSunrateRegisterQueryPhone.setRegisterMobile(randomPhone);
        KycSunrateRegister kycSunrateRegisterExist = apiSunrateRegisterServiceImpl.getiBaseMapper().selectOne(kycSunrateRegisterQueryPhone);
        if(null != kycSunrateRegisterExist){
            log.error("该用户已在寻汇注册orgCode：{}",kycSunrateRegisterQueryPhone.getOrgCode());
            return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(),ResultEnum.MESSAGE_EXIST.getMsg() + ",该用户寻汇已注册过,请确认");
        }
        if(CertiStatusEnum.FIRST_TRIAL_FAILURE.equals(kycNaturalReq.getCertificationStatus())){
            int updateKycNaturalCount = updateKycNatural(kycNaturalReq);
            log.info("更新注册表信息条数：{}",updateKycNaturalCount);
            return ResultUtil.success(ResultEnum.SUCCESS);
        }
        List<String> fileIdList = new ArrayList<>();
        for(KycCertiLinkFileVO kycCertiLinkFileVO : certiFileList){
            fileIdList.add(kycCertiLinkFileVO.getFileSaveName());
        }
        kycSunrateRegisterReq.setFileIdList(fileIdList);
        log.info("{}上传附件到寻汇-开始",registerTypeDesc);
        ResponseMessage uploadFileToXhResponseMessage = apiKycSunrateService.uploadFileToXH(priId);
        log.info("{}上传附件到寻汇-结束结束-返回结果:{},描述信息:{}",registerTypeDesc, uploadFileToXhResponseMessage.isSuccess(), uploadFileToXhResponseMessage.getMsg());
        if (!uploadFileToXhResponseMessage.isSuccess()) {
            return uploadFileToXhResponseMessage;
        }
        log.info("{}调用寻汇公共请求接口-开始",registerTypeDesc);
        String uploadRemotePath = uploadFileToXhResponseMessage.getData().toString();
        kycSunrateRegisterReq.setDirPath(uploadRemotePath);
        KycNaturalVO kycNaturalVO = new KycNaturalVO();
        BeanUtils.copyProperties(kycNaturalSel,kycNaturalVO);
        ResponseMessage sendInfoToXhResponseMessage = apiSunrateRegisterService.sendRegisterInfoToXh("127.0.0.1", priId, kycSunrateRegisterReq, kycNaturalVO);
        log.info("{}调用寻汇公共请求接口-结束-返回结果:{},描述信息:{}",registerTypeDesc, sendInfoToXhResponseMessage.isSuccess(), sendInfoToXhResponseMessage.getMsg());
        if (!sendInfoToXhResponseMessage.isSuccess()) {
            return sendInfoToXhResponseMessage;
        }
        int updateKycNaturalCount = updateKycNatural(kycNaturalReq);
        log.info("更新注册表信息条数：{}",updateKycNaturalCount);
        log.info("{}推送寻汇添加受益人MQ请求-开始",registerTypeDesc);
        kycNaturalVO.setOrgCode(kycSunrateRegisterReq.getOrgCode());
        kycNaturalVO.setBrowserIP("127.0.0.1");
        rabbitMQSender.noticeToAddBeneficiary(kycNaturalVO);
        log.info("{}推送寻汇添加受益人MQ请求-结束",registerTypeDesc);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private KycSunrateRegisterReq convertByKycCertiMainLandPersonal(KycCertiMainLandPersonal kycCertiMainLandPersonal){
        KycSunrateRegisterReq kycSunrateRegisterReq = new KycSunrateRegisterReq();
        kycSunrateRegisterReq.setRegisterName(kycCertiMainLandPersonal.getCusName());
        kycSunrateRegisterReq.setRegisterType(1);
        kycSunrateRegisterReq.setName(kycCertiMainLandPersonal.getCusName());
        kycSunrateRegisterReq.setOrgCode(kycCertiMainLandPersonal.getIdNo());
        kycSunrateRegisterReq.setIdentityType(1);// 1-法定代表人
        kycSunrateRegisterReq.setOpenAddress(kycCertiMainLandPersonal.getLiveAddress());
        kycSunrateRegisterReq.setRemark("大陆个人-注册");
        return kycSunrateRegisterReq;
    }

    private KycSunrateRegisterReq convertByKycCertiMainLandCompany(KycCertiMainLandCompany kycCertiMainLandCompany){
        KycSunrateRegisterReq kycSunrateRegisterReq = new KycSunrateRegisterReq();
        kycSunrateRegisterReq.setRegisterName(kycCertiMainLandCompany.getCompanyName());
        kycSunrateRegisterReq.setRegisterType(2);
        kycSunrateRegisterReq.setName(kycCertiMainLandCompany.getLegalRepresentativeName());
        kycSunrateRegisterReq.setOrgCode(kycCertiMainLandCompany.getUnifiedSocialCreditCode());
        kycSunrateRegisterReq.setIdentityType(1);// 1-法定代表人
        kycSunrateRegisterReq.setOpenAddress(kycCertiMainLandCompany.getLegalRepresentativeAddress());
        kycSunrateRegisterReq.setRemark("大陆企业-注册");
        return kycSunrateRegisterReq;
    }

    private KycSunrateRegisterReq convertByKycCertiHKPersonal(KycCertiHKPersonal kycCertiHKPersonal){
        KycSunrateRegisterReq kycSunrateRegisterReq = new KycSunrateRegisterReq();
        kycSunrateRegisterReq.setRegisterName(kycCertiHKPersonal.getCusName());
        kycSunrateRegisterReq.setRegisterType(1);
        kycSunrateRegisterReq.setName(kycCertiHKPersonal.getCusName());
        kycSunrateRegisterReq.setOrgCode(kycCertiHKPersonal.getCertificateNo());
        kycSunrateRegisterReq.setIdentityType(1);// 1-法定代表人
        kycSunrateRegisterReq.setOpenAddress(kycCertiHKPersonal.getAddress());
        kycSunrateRegisterReq.setRemark("香港个人-注册");
        return kycSunrateRegisterReq;
    }

    private KycSunrateRegisterReq convertByKycCertiHKCompany(KycCertiHKCompany kycCertiHKCompany){
        KycSunrateRegisterReq kycSunrateRegisterReq = new KycSunrateRegisterReq();
        kycSunrateRegisterReq.setRegisterName(kycCertiHKCompany.getCompanyName());
        kycSunrateRegisterReq.setRegisterType(2);
        kycSunrateRegisterReq.setName(kycCertiHKCompany.getDirectorName());
        kycSunrateRegisterReq.setOrgCode(kycCertiHKCompany.getCompanyRegisteredCertificateNo());
        kycSunrateRegisterReq.setIdentityType(1);// 1-法定代表人
        kycSunrateRegisterReq.setOpenAddress(kycCertiHKCompany.getCompanyAddress());
        kycSunrateRegisterReq.setRemark("香港企业-注册");
        return kycSunrateRegisterReq;
    }
}
