package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiJsTradeService;
import com.js.common.constant.Constant;
import com.js.common.model.vo.JsTradeVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsTradeMapper;
import com.js.dal.dao.model.JsTrade;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiJsTradeServiceImpl extends IBaseServiceImpl<JsTrade> implements ApiJsTradeService {

//    @Autowired
//    private JsTradeMapper jsTradeMapper;

    @Override
    public ResponseMessage addTradeRecord(JsTradeVO jsTradeVO) {
        JsTrade jsTrade = new JsTrade();
        BeanUtils.copyProperties(jsTradeVO,jsTrade);
        iBaseMapper.insertSelective(jsTrade);
        return ResultUtil.success(jsTrade.getId());
    }
}
