package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.ApiJsPayUserStationInfoService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.vo.JsPayUserStationInfoVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPayUserStationInfoMapper;
import com.js.dal.dao.model.JsPayUserStationInfo;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiJsPayUserStationInfoServiceImpl extends IBaseServiceImpl<JsPayUserStationInfo>  implements ApiJsPayUserStationInfoService {

    @Autowired
    private JsPayUserStationInfoMapper jsPayUserStationInfoMapper;
    @Override
    public String queryVatStationStatus(String taxStationId) {
        return jsPayUserStationInfoMapper.queryVatStationStatus(taxStationId);
    }

    @Override
    public String queryVatStationInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq) {
        return jsPayUserStationInfoMapper.queryVatStationInfo(jsPayVatPaymentInfoReq);
    }
    @Override
    public ResponseMessage addPayUserStationInfo(JsPayUserStationInfoVO jsPayUserStationInfoVO) {
        JsPayUserStationInfo JsPayUserStationInfo = new JsPayUserStationInfo();
        BeanUtils.copyProperties(jsPayUserStationInfoVO,JsPayUserStationInfo);
        JsPayUserStationInfo.setId(IdUtil.simpleUUID());
        JsPayUserStationInfo.setCreateId(jsPayUserStationInfoVO.getCreateId());
        JsPayUserStationInfo.setCreateName(jsPayUserStationInfoVO.getCertificationName());
        super.insertSelective(JsPayUserStationInfo);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
