package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.ApiJsPaySysAcctService;
import com.js.api.jspay.service.ApiJsPayTradeService;
import com.js.common.constant.Constant;
import com.js.common.enums.JsPaySysAcctTypeEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPayTradeReq;
import com.js.common.model.vo.JsPaySysAcctVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySysAcctMapper;
import com.js.dal.dao.model.JsPaySysAcct;
import com.js.dal.dao.model.JsPayTrade;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Description: 平台第三方账户操作接口具体实现
 * @Author: liuh
 * @Create: 2019-06-30
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
public class ApiJsPaySysAcctServiceImpl extends IBaseServiceImpl<JsPaySysAcct> implements ApiJsPaySysAcctService {
    @Autowired
    private JsPaySysAcctMapper jsPaySysAcctMapper;

    @Override
    public List<JsPaySysAcctVO> findJsPaySysAcctVOList(){
        JsPaySysAcct jsPaySysAcctQuery = new JsPaySysAcct();
        jsPaySysAcctQuery.setDelFlag(false);
        List<JsPaySysAcct> jsPaySysAccts = iBaseMapper.select(jsPaySysAcctQuery);
        List<JsPaySysAcctVO> jsPaySysAcctVOList = new ArrayList<>();
        jsPaySysAccts.stream().forEach(jsPaySysAcct -> {
            JsPaySysAcctVO jsPaySysAcctVO = new JsPaySysAcctVO();
            BeanUtils.copyProperties(jsPaySysAcct,jsPaySysAcctVO);
            jsPaySysAcctVOList.add(jsPaySysAcctVO);
        });
        return jsPaySysAcctVOList;
    }

    @Override
    public JsPaySysAcctVO queryBeneficiaryRmbList() {
        return  jsPaySysAcctMapper.queryBeneficiaryRmbList();
    }

    public List<JsPaySysAcct> findJsPaySysAcctList(JsPaySysAcctTypeEnum acctType){
        JsPaySysAcct jsPaySysAcctQuery = new JsPaySysAcct();
        jsPaySysAcctQuery.setAcctType(acctType);
        jsPaySysAcctQuery.setDelFlag(false);
        List<JsPaySysAcct> jsPaySysAccts = iBaseMapper.select(jsPaySysAcctQuery);
        return jsPaySysAccts;
    }
}
