package com.js.pay.service.chinapnr.impl;

import com.js.api.jspay.service.chinapnr.JsTradePossessService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsTradeReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsTradeMapper;
import com.js.dal.dao.model.JsTrade;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @Description:资金明细记账
 * @Author: zhouyongsheng
 * @Create: 2019-06-10
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class JsTradePossessServiceImpl implements JsTradePossessService {

    @Autowired
    private JsTradeMapper jsTradeMapper;
    /**
     * 记账
     * @param jsTradeReq
     * @return
     */
    @Override
    public ResponseMessage record(JsTradeReq jsTradeReq) {

        //主体A记账
        JsTrade jsTradeA = new JsTrade();
        jsTradeA.setKycNaturalId(jsTradeReq.getKycNaturalIdA());
        jsTradeA.setTradeNo(jsTradeReq.getTradeNo());
        jsTradeA.setAccType(jsTradeReq.getAccType());
        jsTradeA.setTradeType("0"); //主体方式记账  A必须为入账，B为出账
        jsTradeA.setInAcct(jsTradeReq.getAcctA());
        jsTradeA.setInAcctName(jsTradeReq.getAcctNameA());
        jsTradeA.setOutAcct(jsTradeReq.getAcctB());
        jsTradeA.setOutAcctName(jsTradeReq.getAcctNameB());
        jsTradeA.setTradeSubType(jsTradeReq.getTradeSubType());
        jsTradeA.setCurId(jsTradeReq.getCurId());
        jsTradeA.setTradeAmt(jsTradeReq.getTradeAmt());
        jsTradeA.setInAmt(jsTradeReq.getTradeAmt());
        //jsTradeA.setOutAmt(jsTradeReq.getTradeAmt());
        jsTradeA.setTradeDts(jsTradeReq.getTradeDts());
        jsTradeA.setCreateDts(new Date());
        jsTradeA.setUpdateDts(new Date());

        //主体B记账
        JsTrade jsTradeB = new JsTrade();
        jsTradeB.setKycNaturalId(jsTradeReq.getKycNaturalIdB());
        jsTradeB.setTradeNo(jsTradeReq.getTradeNo());
        jsTradeB.setAccType(jsTradeReq.getAccType());
        jsTradeB.setTradeType("1"); //主体方式记账  A必须为入账，B为出账
        jsTradeB.setInAcct(jsTradeReq.getAcctA());
        jsTradeB.setInAcctName(jsTradeReq.getAcctNameA());
        jsTradeB.setOutAcct(jsTradeReq.getAcctB());
        jsTradeB.setTradeSubType(jsTradeReq.getTradeSubType());
        jsTradeB.setOutAcctName(jsTradeReq.getAcctNameB());
        jsTradeB.setCurId(jsTradeReq.getCurId());
        jsTradeB.setTradeAmt(jsTradeReq.getTradeAmt());
        //jsTradeB.setInAmt(jsTradeReq.getTradeAmt());
        jsTradeB.setOutAmt(jsTradeReq.getTradeAmt());
        jsTradeB.setTradeDts(jsTradeReq.getTradeDts());
        jsTradeB.setCreateDts(new Date());
        jsTradeB.setUpdateDts(new Date());

        jsTradeMapper.insertSelective(jsTradeA);
        jsTradeMapper.insertSelective(jsTradeB);

        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}









