package com.js.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.common.constant.Constant;
import com.js.common.enums.RegisterType;
import com.js.common.model.req.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.dal.dao.mapper.KycStoreMapper;
import com.js.dal.dao.model.KycCertiHKCompany;
import com.js.dal.dao.model.KycCertiHKPersonal;
import com.js.dal.dao.model.KycCertiMainLandCompany;
import com.js.dal.dao.model.KycCertiMainLandPersonal;
import com.js.pay.service.KycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * @Description: 与寻汇询价交互具体实现
 * @Author: liuh
 * @Create: 2019-05-29
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiSunrateTradePriceServiceImpl implements ApiSunrateTradePriceService {
    @Autowired
    KycSunrateService kycSunrateService;
    @Autowired
    KycStoreMapper kycStoreMapper;
    @Autowired
    ApiKycCertiMainLandPersonalServiceImpl apiKycCertiMainLandPersonalServiceimpl;
    @Autowired
    ApiKycCertiMainLandCompanyServiceImpl apiKycCertiMainLandCompanyServiceimpl;
    @Autowired
    ApiKycCertiHKPersonalServiceImpl apiKycCertiHKPersonalServiceimpl;
    @Autowired
    ApiKycCertiHKCompanyServiceImpl apiKycCertiHKCompanyServiceimpl;

    /**
     * @Description: 寻汇-询价
     */
    public ResponseMessage xhTradeQueryPrice(SunrateTradePriceReq sunrateTradePriceReq){
        sunrateTradePriceReq.setQueryNo("quantg" + kycSunrateService.getReqNo());
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(sunrateTradePriceReq));
        jsonObjectReq.remove("browserIP");
        Map<String,String> mapParams = (Map)jsonObjectReq;
        return kycSunrateService.sendInfoToXh(sunrateTradePriceReq.getBrowserIP(),"trade.queryPrice","trade/queryPrice/",mapParams);
    }

    @Override
    public List<Map> findSiteByNaturalId(String kycNaturalId) {
        return kycStoreMapper.findSiteByNaturalId(kycNaturalId);
    }

    @Override
    public String findOrgCode(String kycNaturalId,RegisterType registerType){
        String orgCode = "";
        if(registerType == RegisterType.MAINLAND_PERSONAL){
            KycCertiMainLandPersonal kycCertiMainLandPersonalQuery = new KycCertiMainLandPersonal();
            kycCertiMainLandPersonalQuery.setKycNaturalId(kycNaturalId);
            KycCertiMainLandPersonal kycCertiMainLandPersonal = apiKycCertiMainLandPersonalServiceimpl.getiBaseMapper().selectOne(kycCertiMainLandPersonalQuery);
            orgCode = kycCertiMainLandPersonal.getIdNo();
        }else if(registerType == RegisterType.MAINLAND_COMPANY){
            KycCertiMainLandCompany kycCertiMainLandCompanyQuery = new KycCertiMainLandCompany();
            kycCertiMainLandCompanyQuery.setKycNaturalId(kycNaturalId);
            KycCertiMainLandCompany kycCertiMainLandCompany = apiKycCertiMainLandCompanyServiceimpl.getiBaseMapper().selectOne(kycCertiMainLandCompanyQuery);
            orgCode = kycCertiMainLandCompany.getUnifiedSocialCreditCode();
        }else if(registerType == RegisterType.HK_PERSONAL){
            KycCertiHKPersonal kycCertiHKPersonalQuery = new KycCertiHKPersonal();
            kycCertiHKPersonalQuery.setKycNaturalId(kycNaturalId);
            KycCertiHKPersonal kycCertiHKPersonal = apiKycCertiHKPersonalServiceimpl.getiBaseMapper().selectOne(kycCertiHKPersonalQuery);
            orgCode = kycCertiHKPersonal.getCertificateNo();
        }else if(registerType == RegisterType.HK_COMPANY){
            KycCertiHKCompany kycCertiHKCompanyQuery = new KycCertiHKCompany();
            kycCertiHKCompanyQuery.setKycNaturalId(kycNaturalId);
            KycCertiHKCompany kycCertiHKCompany = apiKycCertiHKCompanyServiceimpl.getiBaseMapper().selectOne(kycCertiHKCompanyQuery);
            orgCode = kycCertiHKCompany.getCompanyRegisteredCertificateNo();
        }
        return orgCode;
    }

    @Override
    public Object findCertiInfo(String kycNaturalId,RegisterType registerType){
        if(registerType == RegisterType.MAINLAND_PERSONAL){
            KycCertiMainLandPersonal kycCertiMainLandPersonalQuery = new KycCertiMainLandPersonal();
            kycCertiMainLandPersonalQuery.setKycNaturalId(kycNaturalId);
            return apiKycCertiMainLandPersonalServiceimpl.getiBaseMapper().selectOne(kycCertiMainLandPersonalQuery);
        }else if(registerType == RegisterType.MAINLAND_COMPANY){
            KycCertiMainLandCompany kycCertiMainLandCompanyQuery = new KycCertiMainLandCompany();
            kycCertiMainLandCompanyQuery.setKycNaturalId(kycNaturalId);
            return apiKycCertiMainLandCompanyServiceimpl.getiBaseMapper().selectOne(kycCertiMainLandCompanyQuery);
        }else if(registerType == RegisterType.HK_PERSONAL){
            KycCertiHKPersonal kycCertiHKPersonalQuery = new KycCertiHKPersonal();
            kycCertiHKPersonalQuery.setKycNaturalId(kycNaturalId);
            return apiKycCertiHKPersonalServiceimpl.getiBaseMapper().selectOne(kycCertiHKPersonalQuery);
        }else if(registerType == RegisterType.HK_COMPANY){
            KycCertiHKCompany kycCertiHKCompanyQuery = new KycCertiHKCompany();
            kycCertiHKCompanyQuery.setKycNaturalId(kycNaturalId);
            return apiKycCertiHKCompanyServiceimpl.getiBaseMapper().selectOne(kycCertiHKCompanyQuery);
        }
        return null;
    }
}
