package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiSunrateBeneficiaryService;
import com.js.common.constant.Constant;
import com.js.common.constant.JsBeneficiaryConstant;
import com.js.common.enums.BeneficiaryTypeEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycSunrateBeneficiaryReq;
import com.js.common.model.req.SunrateBeneficiaryAuditReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycSunrateBeneficiaryVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.KycSunrateBeneficiary;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * @Description: 寻汇-受益人交互具体实现
 * @Author: liuh
 * @Create: 2019-05-30
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiSunrateBeneficiaryServiceImpl extends IBaseServiceImpl<KycSunrateBeneficiary> implements ApiSunrateBeneficiaryService {
    @Autowired
    KycSunrateService kycSunrateService;

    /**
     * @Description: 4.1添加受益人（单个）（合作方 -> 寻汇）
     */
    @Override
    public ResponseMessage beneficiaryCreate(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq,KycNaturalVO kycNaturalVO){
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(kycSunrateBeneficiaryReq));
        jsonObjectReq.remove("browserIP");
        Map<String,String> mapParams = (Map)jsonObjectReq;
        ResponseMessage responseMessage =  kycSunrateService.sendInfoToXh(kycSunrateBeneficiaryReq.getBrowserIP(),"beneficiary.create","beneficiary/create/",mapParams);
        if(responseMessage.isSuccess()){
            operationBeneficiary(kycSunrateBeneficiaryReq,responseMessage,kycNaturalVO);
        }
        return responseMessage;
    }

    @Override
    public ResponseMessage beneficiaryModify(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq,KycNaturalVO kycNaturalVO) {
        if(StringUtils.isBlank(kycSunrateBeneficiaryReq.getBeneficiaryId())){
            ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
        }
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(kycSunrateBeneficiaryReq));
        jsonObjectReq.remove("browserIP");
        Map<String,String> mapParams = (Map)jsonObjectReq;
        ResponseMessage responseMessage =  kycSunrateService.sendInfoToXh(kycSunrateBeneficiaryReq.getBrowserIP(),"beneficiary.modify","beneficiary/modify/",mapParams);
        if(responseMessage.isSuccess()){
            operationBeneficiary(kycSunrateBeneficiaryReq,responseMessage,kycNaturalVO);
        }
        return responseMessage;
    }

    @Override
    public ResponseMessage beneficiaryList(String orgCode,String browserIP) {
        Map<String,String> mapParams = new HashMap<>();
        mapParams.put("orgCode", orgCode);
        return kycSunrateService.sendInfoToXh(browserIP,"beneficiary.list","beneficiary/list/",mapParams);
    }

    @Override
    public ResponseMessage beneficiayAuditNotice(SunrateBeneficiaryAuditReq sunrateStoreAuditReq) {
        KycSunrateBeneficiary kycSunrateBeneficiaryQuery = new KycSunrateBeneficiary();
        kycSunrateBeneficiaryQuery.setBeneficiaryId(sunrateStoreAuditReq.getBeneficiaryId());
        kycSunrateBeneficiaryQuery.setOrgCode(sunrateStoreAuditReq.getOrgCode());
        KycSunrateBeneficiary kycSunrateBeneficiary = iBaseMapper.selectOne(kycSunrateBeneficiaryQuery);
        if(null == kycSunrateBeneficiary){
            log.error("根据寻汇受益人审核通知入参查找数据信息不存在");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        kycSunrateBeneficiary.setBeneficiaryStatus(sunrateStoreAuditReq.getBeneficiaryStatus());
        kycSunrateBeneficiary.setAuditRemark(sunrateStoreAuditReq.getRemark());
        iBaseMapper.updateByPrimaryKeySelective(kycSunrateBeneficiary);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage beneficiaryCreate(String orgCode, String browserIP, KycNaturalVO kycNaturalVO) {
        log.info("添加受益人信息开始:{},ip:{}",orgCode,browserIP);
        KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq = new KycSunrateBeneficiaryReq();
        kycSunrateBeneficiaryReq.setOrgCode(orgCode);
        kycSunrateBeneficiaryReq.setBrowserIP(browserIP);
        kycSunrateBeneficiaryReq.setBeneficiaryType(BeneficiaryTypeEnum.PLATEFORM_SELF);
        kycSunrateBeneficiaryReq.setCountryCode(JsBeneficiaryConstant.JS_BENEFICIARY_COUNTRY_CODE);//国家代码
        kycSunrateBeneficiaryReq.setBankName(JsBeneficiaryConstant.JS_BENEFICIARY_BANK_NAME);//银行名称
        kycSunrateBeneficiaryReq.setRouteType(JsBeneficiaryConstant.JS_BENEFICIARY_ROUTE_TYPE);//路由类型
        kycSunrateBeneficiaryReq.setAba(JsBeneficiaryConstant.JS_BENEFICIARY_ABA);//ABA
        kycSunrateBeneficiaryReq.setIban(JsBeneficiaryConstant.JS_BENEFICIARY_IBAN);//IBAN
        kycSunrateBeneficiaryReq.setSwiftcode(JsBeneficiaryConstant.JS_BENEFICIARY_SWIFT_CODE);//SWIFTCODE
        kycSunrateBeneficiaryReq.setBeneficiaryName(JsBeneficiaryConstant.JS_BENEFICIARY_NAME);//受益人名称
        kycSunrateBeneficiaryReq.setBeneficiaryAcctNo(JsBeneficiaryConstant.JS_BENEFICIARY_ACCT_NO);//受益人银行账号，iban 包含账号，此处也需要
        kycSunrateBeneficiaryReq.setCur(JsBeneficiaryConstant.JS_BENEFICIARY_CUR);//币种
        kycSunrateBeneficiaryReq.setBeneficiaryAddr(JsBeneficiaryConstant.JS_BENEFICIARY_ADDR);//受益人地址
        kycSunrateBeneficiaryReq.setRemark(JsBeneficiaryConstant.JS_BENEFICIARY_REMARK);//备注
        ResponseMessage responseMessage = this.beneficiaryCreate(kycSunrateBeneficiaryReq,kycNaturalVO);
        log.info("添加受益人信息结束:{}",responseMessage.isSuccess());
        return responseMessage;
    }

    @Override
    public List<KycSunrateBeneficiaryVO> beneficiaryListByOrgCode(String orgCode, BeneficiaryTypeEnum beneficiaryTypeEnum) {
        log.info("根据入参查询受益人信息-开始:{},{}",orgCode,beneficiaryTypeEnum);
        KycSunrateBeneficiary kycSunrateBeneficiaryQuery = new KycSunrateBeneficiary();
        kycSunrateBeneficiaryQuery.setOrgCode(orgCode);
        kycSunrateBeneficiaryQuery.setBeneficiaryType(beneficiaryTypeEnum);
        List<KycSunrateBeneficiary> list = iBaseMapper.select(kycSunrateBeneficiaryQuery);
        List<KycSunrateBeneficiaryVO> resultList = new ArrayList<>();
        list.stream().forEach(kycSunrateBeneficiary -> {
            KycSunrateBeneficiaryVO kycSunrateBeneficiaryVO = new KycSunrateBeneficiaryVO();
            BeanUtils.copyProperties(kycSunrateBeneficiary,kycSunrateBeneficiaryVO);
            resultList.add(kycSunrateBeneficiaryVO);
        });
        log.info("根据入参查询受益人信息结束:size{}",resultList.size());
        return resultList;
    }

    public void operationBeneficiary(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq,ResponseMessage responseMessage,KycNaturalVO kycNaturalVO){
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
        if(StringUtils.isBlank(kycSunrateBeneficiaryReq.getBeneficiaryId())){
            KycSunrateBeneficiary kycSunrateBeneficiary = new KycSunrateBeneficiary();
            BeanUtils.copyProperties(kycSunrateBeneficiaryReq,kycSunrateBeneficiary);
            kycSunrateBeneficiary.setId(IdUtil.simpleUUID());
            if(null != kycNaturalVO){
                kycSunrateBeneficiary.setCreateId(kycNaturalVO.getId());
                kycSunrateBeneficiary.setCreateName(kycNaturalVO.getCertificationName());
                kycSunrateBeneficiary.setKycNaturalId(kycNaturalVO.getId());
            }
            kycSunrateBeneficiary.setCreateDts(new Date());
            kycSunrateBeneficiary.setBeneficiaryId(jsonObject.getString("beneficiaryId"));
            kycSunrateBeneficiary.setBeneficiaryStatus(jsonObject.getString("beneficiaryStatus"));
            super.insertSelective(kycSunrateBeneficiary);
        }else{
            KycSunrateBeneficiary kycSunrateBeneficiary = iBaseMapper.selectByPrimaryKey(kycSunrateBeneficiaryReq.getBeneficiaryId());
            kycSunrateBeneficiary.setBeneficiaryId(jsonObject.getString("beneficiaryId"));
            kycSunrateBeneficiary.setBeneficiaryStatus(jsonObject.getString("beneficiaryStatus"));
            iBaseMapper.updateByPrimaryKeySelective(kycSunrateBeneficiary);
        }

    }
}
