package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiKycSunrateStoreService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycSunrateStoreReq;
import com.js.common.model.req.SunrateStoreAuditReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycSunrateStoreVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.KycSunrateStoreMapper;
import com.js.dal.dao.model.KycSunrateStore;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.Valid;
import java.util.*;

/**
 * @Description: 寻汇店铺操作接口具体实现
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiKycSunrateStoreServiceImpl extends IBaseServiceImpl<KycSunrateStore> implements ApiKycSunrateStoreService {
    @Autowired
    KycSunrateStoreMapper kycSunrateStoreMapper;
    @Autowired
    KycSunrateService kycSunrateService;

    @Override
    public ResponseMessage sendSunrateStoreInfoToXh(String browserIP, @Valid KycSunrateStoreReq kycSunrateStoreReq) {
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(kycSunrateStoreReq));
        jsonObjectReq.remove("kycStoreId");
        jsonObjectReq.remove("subAcctNo");
        Map<String,String> mapParams = (Map)jsonObjectReq;
        return kycSunrateService.sendInfoToXh(browserIP,"store.create","store/create/",mapParams);
    }

    @Override
    public ResponseMessage addSunrateStore(KycSunrateStoreReq kycSunrateStoreReq, KycNaturalVO kycNaturalVO) {
        KycSunrateStore kycSunrateStore = new KycSunrateStore();
        BeanUtils.copyProperties(kycSunrateStoreReq,kycSunrateStore);
        kycSunrateStore.setId(IdUtil.simpleUUID());
        kycSunrateStore.setKycNaturalId(kycNaturalVO.getId());
        kycSunrateStore.setCreateId(kycNaturalVO.getId());
        kycSunrateStore.setCreateName(kycNaturalVO.getCertificationName());
        super.insertSelective(kycSunrateStore);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage storeAuditNotice(SunrateStoreAuditReq sunrateStoreAuditReq) {
        KycSunrateStore kycSunrateStoreQuery = new KycSunrateStore();
        kycSunrateStoreQuery.setOrgCode(sunrateStoreAuditReq.getOrgCode());
        kycSunrateStoreQuery.setSubAcctNo(sunrateStoreAuditReq.getSubAcctNo());
        KycSunrateStore kycSunrateStore = iBaseMapper.selectOne(kycSunrateStoreQuery);
        if(null == kycSunrateStore){
            log.error("根据寻汇审核店铺通知入参查找数据信息不存在");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        if(0 != kycSunrateStore.getAuditStatus()){
            log.info("查询到店铺审核状态已经变更为：{}",kycSunrateStore.getAuditStatus());
            return ResultUtil.error(ResultEnum.SEND_ALREADY);
        }
        kycSunrateStore.setAuditStatus(Integer.valueOf(sunrateStoreAuditReq.getStatus()));
        kycSunrateStore.setAuditRemark(sunrateStoreAuditReq.getRemark());
        kycSunrateStore.setAuditDts(new Date());//赋值审核日期
        iBaseMapper.updateByPrimaryKeySelective(kycSunrateStore);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage sunrateStoreList(String orgCode,String browserIP) {
        Map<String,String> mapParams = new HashMap<>();
        mapParams.put("orgCode",orgCode);
        return kycSunrateService.sendInfoToXh(browserIP,"store.list","store/list/",mapParams);
    }

    @Override
    public KycSunrateStoreVO findSunrateStoreInfo(String kycStoreId,KycNaturalVO kycNaturalVO) {
        KycSunrateStore kycSunrateStoreQuery = new KycSunrateStore();
        kycSunrateStoreQuery.setKycStoreId(kycStoreId);
        kycSunrateStoreQuery.setKycNaturalId(kycNaturalVO.getId());
        KycSunrateStore kycSunrateStore = iBaseMapper.selectOne(kycSunrateStoreQuery);
        if(null == kycSunrateStore){
            log.info("为查询到已添加到寻汇的店铺信息");
            return null;
        }
        KycSunrateStoreVO kycSunrateStoreVO = new KycSunrateStoreVO();
        BeanUtils.copyProperties(kycSunrateStore,kycSunrateStoreVO);
        return kycSunrateStoreVO;
    }
}
