package com.js.pay.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.ChPwdReq;
import com.js.common.model.req.KycNaturalListReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.req.RegiserKycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycPasswordVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.RedisUtil;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.KycPasswordMapper;
import com.js.dal.dao.model.KycNatural;
import com.js.dal.dao.model.KycPassword;
import com.js.dal.dao.plugin.PageModel;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.mq.RabbitMQSender;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * @ClassName: ApiKycNaturalServiceImpl
 * @Description: KycNaturalService具体实现
 * @Author: yjzhao
 * @Create: 2019-05-16  10:19
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiKycNaturalServiceImpl extends IBaseServiceImpl<KycNatural> implements ApiKycNaturalService {

    @Autowired
    KycPasswordMapper kycPasswordMapper;

    @Autowired
    APIKycPassWordServiceImpl apiKycPassWordServiceImpl;

    @Autowired
    RabbitMQSender rabbitMQSender;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public Integer verifyEmailExists(String email) {
        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("email",email);
        criteria.andEqualTo("delFlag", false);
        return iBaseMapper.selectCountByExample(example);
    }

    @Override
    public Integer verifyMobileExists(String phoneNo) {
        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("phoneNo",phoneNo);
        criteria.andEqualTo("delFlag", false);
        return iBaseMapper.selectCountByExample(example);

    }

    @Override
    public ResponseMessage register(RegiserKycNaturalReq regiserKycNaturalReq) {
        //注册用户
        KycNatural kycNatural = new KycNatural();
        kycNatural.setEmail(regiserKycNaturalReq.getEmail());
        kycNatural.setPhoneNo(regiserKycNaturalReq.getPhoneNo());
        this.insertSelective(kycNatural);
        
        System.out.println("-----------sys.out.println-----------kycNatural.getId()值=" + kycNatural.getId() + "," + "当前类=ApiKycNaturalServiceImpl.register()");
        
        KycPassword kycPassword = new KycPassword();
        kycPassword.setKycNaturalId(kycNatural.getId());
        kycPassword.setPasswordLogin(regiserKycNaturalReq.getPassword());
        apiKycPassWordServiceImpl.insertSelective(kycPassword);
        return ResultUtil.success(ResultEnum.REGISTE_SUCCESS.getCode(), ResultEnum.REGISTE_SUCCESS.getMsg());
    }

    @Override
    public KycNaturalVO findKycNaturalVOByPhoneNo(String phoneNo) {
        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("phoneNo",phoneNo);
        criteria.andEqualTo("delFlag", false);
        List<KycNatural> kycNaturalList = iBaseMapper.selectByExample(example);
        if (kycNaturalList.size() != 1) {
            //如果大于1条则通知
            return null;
        }

        KycNatural kycNatural = kycNaturalList.get(0);

        return ConvertToKycNaturalVO(kycNatural);
    }

    @Override
    public KycNaturalVO findKycNaturalVOByEmail(String email) {

        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("email",email);
        criteria.andEqualTo("delFlag", false);
        List<KycNatural> kycNaturalList = iBaseMapper.selectByExample(example);

        if (kycNaturalList.size() != 1) {
            //如果大于1条则通知
            return null;
        }

        KycNatural kycNatural = kycNaturalList.get(0);
        return ConvertToKycNaturalVO(kycNatural);
    }

    @Override
    public KycPasswordVO findKycPwdVOByPhoneNo(String phoneNo) {
        KycPassword kycPassword = kycPasswordMapper.selectByPhoneNo(phoneNo);
        if (kycPassword != null) {
            return ConvertToKycPasswordVO(kycPassword);
        }
        return null;
    }

    @Override
    public KycPasswordVO findKycPwdVOByEmail(String email) {
        KycPassword kycPassword = kycPasswordMapper.selectByEmail(email);
        if (kycPassword != null) {
            return ConvertToKycPasswordVO(kycPassword);
        }
        return null;
    }

    @Override
    public ResponseMessage findKycNaturalVOForLogin(String phoneNo, String password) {
        //判断是邮箱还是手机号的正则表达式
        KycPasswordVO kycPasswordVO= null;
        if(Validator.isMobile(phoneNo)){
            kycPasswordVO = this.findKycPwdVOByPhoneNo(phoneNo);
        } else if (Validator.isEmail(phoneNo)){
            kycPasswordVO = this.findKycPwdVOByEmail(phoneNo);
        } else {
            //暂不支持其他类型登陆
            return ResultUtil.error(ResultEnum.LOGIN_ERROR.getCode(), ResultEnum.LOGIN_ERROR.getMsg() + ", 请确认登陆账号正确.");
        }
        //根据手机号码获取用户信息
        if (kycPasswordVO == null) {
            return ResultUtil.error(ResultEnum.LOGIN_ERROR.getCode(), ResultEnum.LOGIN_ERROR.getMsg() + ", 请确认登陆账号正确.");
        }
        //查找当前用户登入前登录错误次数，如果超过最大次数则锁定一小时
        String userErrorCountString = redisUtil.get(Constant.REDIS_JS_WEB_USER + phoneNo);
        int userErrorCountInteger = StringUtils.isBlank(userErrorCountString) ? 0 : Integer.valueOf(userErrorCountString);
        if(userErrorCountInteger >= Constant.ERROR_MAX_COUNT){
            Long ttlTime = redisUtil.ttl(Constant.REDIS_JS_WEB_USER + phoneNo,Constant.REDIS_DATABASE);
            return ResultUtil.error(ResultEnum.USER_DISABLE.getCode(), ResultEnum.USER_DISABLE.getMsg() + ", 请 " + ttlTime/60 + " 分钟后重新登录.");
        }
        //校验密码是否正确
        //校验密码
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        if (!encoder.matches(password, kycPasswordVO.getPasswordLogin())) {
            userErrorCountInteger = userErrorCountInteger + 1;
            if(userErrorCountInteger == Constant.ERROR_MAX_COUNT){
                redisUtil.setex(Constant.REDIS_JS_WEB_USER + phoneNo,Constant.LOGIN_TIMEOUT,String.valueOf(userErrorCountInteger));
                return ResultUtil.error(ResultEnum.USER_DISABLE.getCode(), ResultEnum.USER_DISABLE.getMsg() + ", 请在一小时后重新登录.");
            }else{
                redisUtil.set(Constant.REDIS_JS_WEB_USER + phoneNo,String.valueOf(userErrorCountInteger),Constant.REDIS_DATABASE);
                return ResultUtil.error(ResultEnum.LOGIN_ERROR.getCode(),ResultEnum.LOGIN_ERROR.getMsg() + ", 请确认登陆密码正确.");
            }
        }

        //获取用户信息
        KycNaturalVO kycNaturalVO = null;
        if(Validator.isMobile(phoneNo)){
            kycNaturalVO = this.findKycNaturalVOByPhoneNo(phoneNo);
        } else if (Validator.isEmail(phoneNo)){
            kycNaturalVO = this.findKycNaturalVOByEmail(phoneNo);
        }
        if (kycNaturalVO == null) {
            return ResultUtil.error(ResultEnum.LOGIN_ERROR.getCode(),ResultEnum.LOGIN_ERROR.getMsg() + ", 请确认登陆账号有效.");
        }
        //如果登录成功，则删除登录错误次数计数
        redisUtil.del(Constant.REDIS_JS_WEB_USER + phoneNo);
        return ResultUtil.success(kycNaturalVO, ResultEnum.LOGIN_SUCCESS);
    }

    @Override
    public ResponseMessage changePwd(ChPwdReq chPwdReq) {
        return apiKycPassWordServiceImpl.changePwd(chPwdReq);
    }

    @Override
    public int updateKycNatural(KycNaturalReq kycNaturalReq) {
        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", kycNaturalReq.getId());
        criteria.andEqualTo("delFlag", false);

        KycNatural kycNatural = new KycNatural();
        if (kycNaturalReq.getEmailActiveFlag() != null) {
            kycNatural.setEmailActiveFlag(kycNaturalReq.getEmailActiveFlag());
        }
        if(null != kycNaturalReq.getCertificationStatus()){
            kycNatural.setCertificationStatus(kycNaturalReq.getCertificationStatus().name());
        }
        if(null != kycNaturalReq.getRegisterType()){
            kycNatural.setRegisterType(kycNaturalReq.getRegisterType().name());
        }
        if(StringUtils.isNotBlank(kycNaturalReq.getCertificationName())){
            kycNatural.setCertificationName(kycNaturalReq.getCertificationName());
        }
        if (ObjectUtil.isNotEmpty(kycNaturalReq.getRecordFlag())) {
            kycNatural.setRecordFlag(kycNaturalReq.getRecordFlag());
        }
        if (ObjectUtil.isNotEmpty(kycNaturalReq.getPhoneNo())) {
            kycNatural.setPhoneNo(kycNaturalReq.getPhoneNo());
        }
        if (ObjectUtil.isNotEmpty(kycNaturalReq.getInviteCode())) {
            kycNatural.setInviteCode(kycNaturalReq.getInviteCode());
        }
        return updateByExampleSelective(kycNatural, example);
    }

    private KycPasswordVO ConvertToKycPasswordVO(KycPassword kycPassword) {
        KycPasswordVO kycPasswordVO = new KycPasswordVO();
        kycPasswordVO.setPasswordLogin(kycPassword.getPasswordLogin());
        kycPasswordVO.setPasswordPay(kycPassword.getPasswordPay());
        return  kycPasswordVO;
    }

    private KycNaturalVO ConvertToKycNaturalVO(KycNatural kycNatural) {
        KycNaturalVO kycNaturalVO = new KycNaturalVO();
        kycNaturalVO.setId(kycNatural.getId());
        kycNaturalVO.setCertificationName(kycNatural.getCertificationName());
        kycNaturalVO.setCreateDts(kycNatural.getCreateDts());
        kycNaturalVO.setCreateId(kycNatural.getCreateId());
        kycNaturalVO.setEmail(kycNatural.getEmail());
        kycNaturalVO.setCertificationStatus(CertiStatusEnum.valueOf(kycNatural.getCertificationStatus()));
        kycNaturalVO.setEmailActiveFlag(kycNatural.getEmailActiveFlag());
        kycNaturalVO.setInviteCode(kycNatural.getInviteCode());
        kycNaturalVO.setJsRemark(kycNatural.getJsRemark());
        kycNaturalVO.setPhoneNo(kycNatural.getPhoneNo());
        kycNaturalVO.setRegisterType(RegisterType.valueOf(kycNatural.getRegisterType()));
        kycNaturalVO.setUpdateDts(kycNatural.getUpdateDts());
        kycNaturalVO.setUpdateId(kycNatural.getUpdateId());
        kycNaturalVO.setRecordFlag(kycNatural.getRecordFlag());
        return kycNaturalVO;
    }

    @Override
    public String getKycNaturalList(KycNaturalListReq kycNaturalListReq) {
        PageModel pageModel = new PageModel();
        Example example = new Example(KycNatural.class);
        example.setOrderByClause("update_dts desc");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("delFlag", false);
        if (ObjectUtil.isNotEmpty(kycNaturalListReq.getCertificationName())) {
            criteria.andLike("certificationName", "%" + kycNaturalListReq.getCertificationName() + "%");
        }
        if (ObjectUtil.isNotEmpty(kycNaturalListReq.getPhoneNo())) {
            criteria.andLike("phoneNo", "%" + kycNaturalListReq.getPhoneNo() + "%");
        }
        if (ObjectUtil.isNotEmpty(kycNaturalListReq.getCertificationStatus())) {
            criteria.andEqualTo("certificationStatus", kycNaturalListReq.getCertificationStatus().name());
        }
        PageHelper.startPage(kycNaturalListReq.getPageIndex(), kycNaturalListReq.getPageSize());
        List<KycNatural> kycNaturals = iBaseMapper.selectByExample(example);
        PageInfo<KycNatural> pageInfo = new PageInfo<>(kycNaturals);

        long count = pageInfo.getTotal();
        if(count <= 0) {
            pageModel.setMsg("暂无数据");
            return JSON.toJSONString(pageModel);
        }
        if(!ObjectUtil.isEmpty(kycNaturals)) {
            JSONArray array = new JSONArray();
            for(KycNatural kycBank : kycNaturals) {
                JSONObject object = (JSONObject) JSONObject.toJSON(kycBank);
                object.put("createTime", DateUtil.format(kycBank.getCreateDts(), "yyyyMMdd HH:mm:ss"));
                array.add(object);
            }
            pageModel.setList(array);
        }
        pageModel.setCount(new Integer((int)count));
        pageModel.setMsg("ok");
        pageModel.setRel(true);
        return JSON.toJSONString(pageModel);
    }

    @Override
    public KycNaturalVO getKycNaturaById(String id) {
        if (ObjectUtil.isEmpty(id)) {
            return null;
        } else {
            KycNaturalVO kycNaturalVO = new KycNaturalVO();
            KycNatural kycNatural = iBaseMapper.selectByPrimaryKey(id);
            BeanUtil.copyProperties(kycNatural, kycNaturalVO);
            return kycNaturalVO;
        }
    }

    @Override
    public int deleteKycNaturaById(String id) {
        KycNatural kycNatural = new KycNatural();
        Example example = new Example(KycNatural.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", id);
        kycNatural.setDelFlag(true);
        return updateByExampleSelective(kycNatural, example);
    }
}
