package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiKycDictionaryService;
import com.js.common.constant.Constant;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.KycDictionaryMapper;
import com.js.dal.dao.model.KycDictionary;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * @ClassName: ApiKycDictionaryServiceImpl
 * @Description: 字典表具体实现
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiKycDictionaryServiceImpl extends IBaseServiceImpl<KycDictionary> implements ApiKycDictionaryService {
    @Override
    public ResponseMessage findDictionary(String type,String code) {
        log.info("查詢字典表入參type ：{},字典编码：{}",type,code);
        Example example = new Example(KycDictionary.class);
        Example.Criteria criteria = example.createCriteria();
        if(StringUtils.isNotBlank(type)){
            criteria.andEqualTo("type",type);
        }
        if(StringUtils.isNotBlank(code)){
            criteria.andEqualTo("code",code);
        }
        criteria.andEqualTo("availableFlag", true);
        criteria.andEqualTo("delFlag", false);
        example.setOrderByClause("type,sort");
        List<KycDictionary> kycDictionaries = iBaseMapper.selectByExample(example);
        log.info("字典表根据条件查找到信息条数：{}" , kycDictionaries.size());
        return ResultUtil.success(kycDictionaries);
    }
}
