package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiMainLandPersonalService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.JsException.LogicException;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.CertiMainLandPersonalReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.KycCertiMainLandPersonalMapper;
import com.js.dal.dao.model.KycCertiLinkFile;
import com.js.dal.dao.model.KycCertiMainLandPersonal;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycCertiLinkFileService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;


/**
 * @Description: KycCertiMainLandPersonal具体实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiKycCertiMainLandPersonalServiceImpl extends IBaseServiceImpl<KycCertiMainLandPersonal> implements ApiKycCertiMainLandPersonalService {
    @Autowired
    KycCertiLinkFileService kycCertiLinkFileService;
    @Autowired
    ApiKycNaturalService apiKycNaturalService;
    @Autowired
    ApiSunrateRegisterService apiSunrateRegisterService;

    @Override
    public ResponseMessage certiMainLandPersonalAdd(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO){
        log.info("大陆个人-实名认证提交处理开始:{}", JSON.toJSONString(certiMainLandPersonalReq));
        KycCertiMainLandPersonal kycCertiMainLandPersonal = new KycCertiMainLandPersonal();
        BeanUtils.copyProperties(certiMainLandPersonalReq,kycCertiMainLandPersonal);

        kycCertiMainLandPersonal.setId(IdUtil.simpleUUID());
        kycCertiMainLandPersonal.setIdType(certiMainLandPersonalReq.getCertiCardType().name());
        kycCertiMainLandPersonal.setIdTypeName(certiMainLandPersonalReq.getCertiCardType().getEnumName());
        kycCertiMainLandPersonal.setKycNaturalId(kycNaturalVO.getId());
        kycCertiMainLandPersonal.setCreateId(kycNaturalVO.getId());
        kycCertiMainLandPersonal.setCreateName(kycNaturalVO.getCertificationName());
        kycCertiMainLandPersonal.setStatus(CertiStatusEnum.SUBMIT_WATING.getCode());

        super.insertSelective(kycCertiMainLandPersonal);
        List<KycCertiLinkFile> kycCertiLinkFileList = kycCertiLinkFileService.ConvertToKycCertiLinkFile(kycCertiMainLandPersonal.getId(), kycNaturalVO, certiMainLandPersonalReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            kycCertiLinkFileService.insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-大陆个人实名认证信息完成");

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.SUBMIT_WATING);
        kycNaturalReq.setRegisterType(RegisterType.MAINLAND_PERSONAL);
        kycNaturalReq.setCertificationName(certiMainLandPersonalReq.getCusName());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);

        log.info("大陆个人-保存寻汇用户信息-开始");
        certiMainLandPersonalReq.setKycCertiId(kycCertiMainLandPersonal.getId());
        ResponseMessage responseMessage = apiSunrateRegisterService.xhRegister(certiMainLandPersonalReq,kycNaturalVO);
        log.info("大陆个人-保存寻汇用户信息-结束-返回结果:{},描述信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
        return ResultUtil.success(kycCertiMainLandPersonal.getId());
    }

    @Override
    public boolean verifyCertiMainLandPersonExists(String idNo) {
        KycCertiMainLandPersonal kycCertiMainLandPersonalQuery = new KycCertiMainLandPersonal();
        kycCertiMainLandPersonalQuery.setIdNo(idNo);
        KycCertiMainLandPersonal kycCertiMainLandPersonal = iBaseMapper.selectOne(kycCertiMainLandPersonalQuery);
        return null == kycCertiMainLandPersonal ? false : true;
    }
}
