package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiMainLandCompanyService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.JsException.LogicException;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.CertiMainLandCompanyReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.KycCertiLinkFileMapper;
import com.js.dal.dao.mapper.KycCertiMainLandCompanyMapper;
import com.js.dal.dao.model.KycCertiLinkFile;
import com.js.dal.dao.model.KycCertiMainLandCompany;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycCertiLinkFileService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiKycCertiMainLandCompanyServiceImpl extends IBaseServiceImpl<KycCertiMainLandCompany> implements ApiKycCertiMainLandCompanyService {
    @Autowired
    KycCertiLinkFileService kycCertiLinkFileService;
    @Autowired
    ApiKycNaturalService apiKycNaturalService;
    @Autowired
    ApiSunrateRegisterService apiSunrateRegisterService;

    @Override
    public ResponseMessage certiMainLandCompanyAdd(CertiMainLandCompanyReq certiMainLandCompanyReq, KycNaturalVO kycNaturalVO) {
        log.info("大陆企业-实名认证提交处理开始:{}", JSON.toJSONString(certiMainLandCompanyReq));
        KycCertiMainLandCompany kycCertiMainLandCompany = new KycCertiMainLandCompany();
        BeanUtils.copyProperties(certiMainLandCompanyReq,kycCertiMainLandCompany);
        kycCertiMainLandCompany.setId(IdUtil.simpleUUID());
        kycCertiMainLandCompany.setLegalRepresentativeIdType(certiMainLandCompanyReq.getCertiCardType().name());
        kycCertiMainLandCompany.setLegalRepresentativeIdTypeName(certiMainLandCompanyReq.getCertiCardType().getEnumName());
        kycCertiMainLandCompany.setKycNaturalId(kycNaturalVO.getId());
        kycCertiMainLandCompany.setCreateId(kycNaturalVO.getId());
        kycCertiMainLandCompany.setCreateName(kycNaturalVO.getCertificationName());

        super.insertSelective(kycCertiMainLandCompany);
        List<KycCertiLinkFile> kycCertiLinkFileList = kycCertiLinkFileService.ConvertToKycCertiLinkFile(kycCertiMainLandCompany.getId(), kycNaturalVO, certiMainLandCompanyReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            kycCertiLinkFileService.insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-大陆企业实名认证信息完成");

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.SUBMIT_WATING);
        kycNaturalReq.setRegisterType(RegisterType.MAINLAND_COMPANY);
        kycNaturalReq.setCertificationName(certiMainLandCompanyReq.getCompanyName());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);

        log.info("大陆企业-保存寻汇用户信息-开始");
        certiMainLandCompanyReq.setKycCertiId(kycCertiMainLandCompany.getId());
        ResponseMessage responseMessage = apiSunrateRegisterService.xhRegister(certiMainLandCompanyReq,kycNaturalVO);
        log.info("大陆企业-保存寻汇用户信息-结束-返回结果:{},描述信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
        return ResultUtil.success(kycCertiMainLandCompany.getId());
    }

    @Override
    public boolean verifyCertiMainLandComapnyExists(String unifiedSocialCreditCode) {
        KycCertiMainLandCompany kycCertiMainLandCompanyQuery = new KycCertiMainLandCompany();
        kycCertiMainLandCompanyQuery.setUnifiedSocialCreditCode(unifiedSocialCreditCode);
        KycCertiMainLandCompany kycCertiMainLandCompany = iBaseMapper.selectOne(kycCertiMainLandCompanyQuery);
        return null == kycCertiMainLandCompany ? false : true;
    }
}
