package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.ApiKycCertiLinkFileService;
import com.js.common.constant.Constant;
import com.js.common.model.req.KycCertiLinkFileReq;
import com.js.common.model.vo.KycCertiLinkFileVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.dal.dao.model.KycCertiLinkFile;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycCertiLinkFileService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 实名认证与文件关联中间表具体实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiKycCertiLinkFilelServiceImpl extends IBaseServiceImpl<KycCertiLinkFile> implements ApiKycCertiLinkFileService,KycCertiLinkFileService {

    @Override
    public List<KycCertiLinkFile> ConvertToKycCertiLinkFile(String priId, KycNaturalVO kycNaturalVO, List<KycCertiLinkFileReq> kycCertiLinkFileReqList) {
        List<KycCertiLinkFile> kycCertiLinkFileList = new ArrayList<>();
        for(KycCertiLinkFileReq kycCertiLinkFileReq : kycCertiLinkFileReqList){
            KycCertiLinkFile kycCertiLinkFile = new KycCertiLinkFile();
            kycCertiLinkFile.setId(IdUtil.simpleUUID());
            kycCertiLinkFile.setKycNaturalId(kycNaturalVO.getId());
            //实名认证表主键Id
            kycCertiLinkFile.setPriId(priId);
            kycCertiLinkFile.setCommFileId(kycCertiLinkFileReq.getId());
            kycCertiLinkFile.setFileSavePath(kycCertiLinkFileReq.getFileSavePath());
            kycCertiLinkFile.setFileShowPath(kycCertiLinkFileReq.getFileShowPath());
            kycCertiLinkFile.setFileShowName(kycCertiLinkFileReq.getFileShowName());
            kycCertiLinkFile.setFileSaveName(kycCertiLinkFileReq.getFileSaveName());
            kycCertiLinkFile.setFileThumbnailPath(kycCertiLinkFileReq.getFileThumbnailPath());
            kycCertiLinkFile.setFileExt(kycCertiLinkFileReq.getFileExt());
            kycCertiLinkFile.setFileGroup("");//暂时为空
            kycCertiLinkFile.setFileType(kycCertiLinkFileReq.getCertiFileType());
            kycCertiLinkFile.setCreateId(kycNaturalVO.getId());
            kycCertiLinkFile.setCreateName(kycNaturalVO.getCertificationName());
            kycCertiLinkFileList.add(kycCertiLinkFile);
        }
        return kycCertiLinkFileList;
    }

    @Override
    public List<KycCertiLinkFileVO> findCertiFileList(String priKey) {
        KycCertiLinkFile kycCertiLinkFileQuery = new KycCertiLinkFile();
        kycCertiLinkFileQuery.setPriId(priKey);
        List<KycCertiLinkFile> linkFiles = iBaseMapper.select(kycCertiLinkFileQuery);
        if(CollectionUtils.isEmpty(linkFiles)){
            return null;
        }
        List<KycCertiLinkFileVO> resultList = new ArrayList<>();
        linkFiles.stream().forEach(kycCertiLinkFile -> {
            KycCertiLinkFileVO kycCertiLinkFileVO = new KycCertiLinkFileVO();
            BeanUtils.copyProperties(kycCertiLinkFile,kycCertiLinkFileVO);
            resultList.add(kycCertiLinkFileVO);
        });
        return resultList;
    }
}
